/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import xtc.Constants;
import xtc.tree.Location;

public final class Utilities {
    private static final int BUFFER_SIZE = 4096;
    private static char[] charBuffer = null;
    public static final Pattern SPACE_NEWLINE_SPACE = Pattern.compile("[ \t\f]*(?:\r\n|\r|\n)[ \t\f]*");
    public static final Pattern COMMENT_NEWLINE = Pattern.compile("[ \t\f]*(?:\r\n|\r|\n)[ \t\f]*\\**[ \t\f]*");
    public static final int ESCAPE_BELL_VT = 1;
    public static final int ESCAPE_DOUBLE = 2;
    public static final int ESCAPE_REGEX = 4;
    public static final int ESCAPE_UNICODE = 8;
    public static final int ESCAPE_HTML = 16;
    public static final int C_ESCAPES = 9;
    public static final int JAVA_ESCAPES = 8;
    public static final int JAVA_HTML_ESCAPES = 24;
    public static final int FULL_ESCAPES = 12;
    public static final int FULL_HTML_ESCAPES = 28;

    private Utilities() {
    }

    public static boolean isQualified(String string) {
        return -1 != string.indexOf(46);
    }

    public static String getQualifier(String string) {
        int n = string.lastIndexOf(46);
        return -1 == n ? null : string.substring(0, n);
    }

    public static String getName(String string) {
        int n = string.lastIndexOf(46);
        return -1 == n ? string : string.substring(n + 1);
    }

    public static String qualify(String string, String string2) {
        return string + '.' + string2;
    }

    public static String toIdentifier(String string) {
        return string.replace('.', '$');
    }

    public static String toPath(String string) {
        return string.replace('.', File.separatorChar);
    }

    public static String toPath(String string, String string2) {
        return string.replace('.', File.separatorChar) + "." + string2;
    }

    public static File locate(List list, String string) throws FileNotFoundException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            File file = new File((File)iterator.next(), string);
            if (!file.exists() || !file.isFile()) continue;
            return file;
        }
        throw new FileNotFoundException(string + " not found");
    }

    public static void pump(Reader reader, Writer writer) throws IOException {
        if (null == charBuffer) {
            charBuffer = new char[4096];
        }
        int n = reader.read(charBuffer);
        while (-1 != n) {
            writer.write(charBuffer, 0, n);
            n = reader.read(charBuffer);
        }
    }

    public static boolean useBellVTEscapes(int n) {
        return 0 != (1 & n);
    }

    public static boolean useDoubleEscapes(int n) {
        return 0 != (2 & n);
    }

    public static boolean useRegexEscapes(int n) {
        return 0 != (4 & n);
    }

    public static boolean useUnicodeEscapes(int n) {
        return 0 != (8 & n);
    }

    public static boolean useHTMLEscapes(int n) {
        return 0 != (0x10 & n);
    }

    public static void escape(char c, StringBuffer stringBuffer, int n) {
        switch (c) {
            case '\u0007': {
                if (!Utilities.useBellVTEscapes(n)) break;
                if (Utilities.useDoubleEscapes(n)) {
                    stringBuffer.append("\\\\a");
                    break;
                }
                stringBuffer.append("\\a");
                break;
            }
            case '\b': {
                if (Utilities.useDoubleEscapes(n)) {
                    stringBuffer.append("\\\\b");
                } else {
                    stringBuffer.append("\\b");
                }
                return;
            }
            case '\t': {
                if (Utilities.useDoubleEscapes(n)) {
                    stringBuffer.append("\\\\t");
                } else {
                    stringBuffer.append("\\t");
                }
                return;
            }
            case '\n': {
                if (Utilities.useDoubleEscapes(n)) {
                    stringBuffer.append("\\\\n");
                } else {
                    stringBuffer.append("\\n");
                }
                return;
            }
            case '\u000b': {
                if (!Utilities.useBellVTEscapes(n)) break;
                if (Utilities.useDoubleEscapes(n)) {
                    stringBuffer.append("\\\\v");
                    break;
                }
                stringBuffer.append("\\v");
                break;
            }
            case '\f': {
                if (Utilities.useDoubleEscapes(n)) {
                    stringBuffer.append("\\\\f");
                } else {
                    stringBuffer.append("\\f");
                }
                return;
            }
            case '\r': {
                if (Utilities.useDoubleEscapes(n)) {
                    stringBuffer.append("\\\\r");
                } else {
                    stringBuffer.append("\\r");
                }
                return;
            }
            case '\"': {
                if (Utilities.useDoubleEscapes(n)) {
                    stringBuffer.append("\\\\\\\"");
                } else {
                    stringBuffer.append("\\\"");
                }
                return;
            }
            case '\'': {
                if (Utilities.useDoubleEscapes(n)) {
                    stringBuffer.append("\\\\\\'");
                } else {
                    stringBuffer.append("\\'");
                }
                return;
            }
            case '-': {
                if (Utilities.useRegexEscapes(n)) {
                    if (Utilities.useDoubleEscapes(n)) {
                        stringBuffer.append("\\\\-");
                    } else {
                        stringBuffer.append("\\-");
                    }
                } else {
                    stringBuffer.append('-');
                }
                return;
            }
            case '<': {
                if (Utilities.useHTMLEscapes(n)) {
                    stringBuffer.append("&lt;");
                } else {
                    stringBuffer.append('<');
                }
                return;
            }
            case '>': {
                if (Utilities.useHTMLEscapes(n)) {
                    stringBuffer.append("&gt;");
                } else {
                    stringBuffer.append('>');
                }
                return;
            }
            case '[': {
                if (Utilities.useRegexEscapes(n)) {
                    if (Utilities.useDoubleEscapes(n)) {
                        stringBuffer.append("\\\\[");
                    } else {
                        stringBuffer.append("\\[");
                    }
                } else {
                    stringBuffer.append('[');
                }
                return;
            }
            case '\\': {
                if (Utilities.useDoubleEscapes(n)) {
                    stringBuffer.append("\\\\\\\\");
                } else {
                    stringBuffer.append("\\\\");
                }
                return;
            }
            case ']': {
                if (Utilities.useRegexEscapes(n)) {
                    if (Utilities.useDoubleEscapes(n)) {
                        stringBuffer.append("\\\\]");
                    } else {
                        stringBuffer.append("\\]");
                    }
                } else {
                    stringBuffer.append(']');
                }
                return;
            }
        }
        if (Utilities.useUnicodeEscapes(n) && (' ' > c || '~' < c)) {
            String string;
            String string2 = Integer.toHexString(c);
            switch (string2.length()) {
                case 1: {
                    string = "000";
                    break;
                }
                case 2: {
                    string = "00";
                    break;
                }
                case 3: {
                    string = "0";
                    break;
                }
                default: {
                    string = "";
                }
            }
            if (Utilities.useDoubleEscapes(n)) {
                stringBuffer.append("\\\\");
            } else {
                stringBuffer.append("\\");
            }
            stringBuffer.append('u');
            stringBuffer.append(string);
            stringBuffer.append(string2);
        } else {
            stringBuffer.append(c);
        }
    }

    public static void escape(String string, StringBuffer stringBuffer, int n) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            Utilities.escape(string.charAt(i), stringBuffer, n);
        }
    }

    public static String escape(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer(1);
        Utilities.escape(c, stringBuffer, n);
        return stringBuffer.toString();
    }

    public static String escape(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        Utilities.escape(string, stringBuffer, n);
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        if (-1 == string.indexOf(92)) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block19: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ('\\' != c) {
                stringBuffer.append(c);
                continue;
            }
            c = string.charAt(++i);
            switch (c) {
                case '\"': {
                    stringBuffer.append('\"');
                    continue block19;
                }
                case '\'': {
                    stringBuffer.append('\'');
                    continue block19;
                }
                case '-': {
                    stringBuffer.append('-');
                    continue block19;
                }
                case '?': {
                    stringBuffer.append('?');
                    continue block19;
                }
                case '[': {
                    stringBuffer.append('[');
                    continue block19;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    continue block19;
                }
                case ']': {
                    stringBuffer.append(']');
                    continue block19;
                }
                case 'a': {
                    stringBuffer.append('\u0007');
                    continue block19;
                }
                case 'b': {
                    stringBuffer.append('\b');
                    continue block19;
                }
                case 'f': {
                    stringBuffer.append('\f');
                    continue block19;
                }
                case 'n': {
                    stringBuffer.append('\n');
                    continue block19;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    continue block19;
                }
                case 't': {
                    stringBuffer.append('\t');
                    continue block19;
                }
                case 'u': {
                    int n2;
                    i += 4;
                    try {
                        n2 = Integer.parseInt(string.substring(i - 3, i + 1), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Illegal Unicode escape ('\\u" + string.substring(i - 3, i + 1) + "')");
                    }
                    stringBuffer.append((char)n2);
                    continue block19;
                }
                case 'v': {
                    stringBuffer.append('\u000b');
                    continue block19;
                }
                default: {
                    throw new IllegalArgumentException("Illegal escaped character ('\\" + c + "')");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String format(List list) {
        int n = list.size();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (1 < n && !iterator.hasNext()) {
                stringBuffer.append("and ");
            }
            stringBuffer.append(string);
            if (2 == n && iterator.hasNext()) {
                stringBuffer.append(' ');
                continue;
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public static String toDescription(String string) {
        int n = string.indexOf(36);
        if (-1 != n) {
            string = string.substring(0, n);
        }
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            ++n3;
        }
        if (0 == n3 || n2 == n3) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2 + n3);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                if (0 != i) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(Character.toLowerCase(c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String fmt(String string, Location location, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != location && -1 < location.line) {
            stringBuffer.append(location.file);
            stringBuffer.append(':');
            stringBuffer.append(location.line);
            stringBuffer.append(':');
            stringBuffer.append(location.column);
            stringBuffer.append(": ");
        } else if (null != string2) {
            stringBuffer.append(string2);
            stringBuffer.append(": ");
        }
        stringBuffer.append(string);
        stringBuffer.append(Constants.LINE_SEPARATOR);
        if (null != location && -1 < location.line && -1 < location.column && null != string3) {
            stringBuffer.append(string3);
            stringBuffer.append(Constants.LINE_SEPARATOR);
            for (int i = 0; i < location.column; ++i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('^');
            stringBuffer.append(Constants.LINE_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    public static void msg(String string, Location location, String string2, String string3) {
        if (null != location && -1 < location.line) {
            System.err.print(location.file);
            System.err.print(':');
            System.err.print(location.line);
            System.err.print(':');
            System.err.print(location.column);
            System.err.print(": ");
        } else if (null != string2) {
            System.err.print(string2);
            System.err.print(": ");
        }
        System.err.println(string);
        if (null != location && -1 < location.line && -1 < location.column && null != string3) {
            System.err.println(string3);
            for (int i = 0; i < location.column; ++i) {
                System.err.print(' ');
            }
            System.err.println('^');
        }
    }
}

