/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.EventListener;
import java.util.LinkedList;

public class NestedReader
extends Reader {
    protected boolean closed = false;
    protected Reader reader;
    protected EOFListener listener;
    protected LinkedList readerStack;
    protected LinkedList listenerStack;

    public NestedReader(Reader reader) {
        this.reader = reader;
        this.listener = null;
        this.readerStack = new LinkedList();
        this.listenerStack = new LinkedList();
    }

    public Reader open(String string) throws IOException {
        return new BufferedReader(new FileReader(string));
    }

    public void insert(Reader reader) throws IOException {
        this.insert(reader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Reader reader, EOFListener eOFListener) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Nested reader closed");
            }
            this.readerStack.addFirst(this.reader);
            this.listenerStack.addFirst(this.listener);
            this.reader = reader;
            this.listener = eOFListener;
        }
    }

    private void restore() throws IOException {
        if (null != this.listener) {
            this.listener.consumed();
        }
        this.reader.close();
        this.reader = (Reader)this.readerStack.removeFirst();
        this.listener = (EOFListener)this.listenerStack.removeFirst();
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                int n;
                if (-1 != (n = this.reader.read()) || this.readerStack.isEmpty()) {
                    return n;
                }
                this.restore();
            }
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                int n3;
                if (-1 != (n3 = this.reader.read(cArray, n, n2)) || this.readerStack.isEmpty()) {
                    return n3;
                }
                this.restore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            IOException iOException = null;
            try {
                this.reader.close();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            while (!this.readerStack.isEmpty()) {
                this.reader = (Reader)this.readerStack.removeFirst();
                try {
                    this.reader.close();
                }
                catch (IOException iOException3) {
                    iOException = iOException3;
                }
                this.listenerStack.removeFirst();
            }
            if (null != iOException) {
                throw iOException;
            }
        }
    }

    public static interface EOFListener
    extends EventListener {
        public void consumed();
    }
}

