/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Utility;
import xtc.util.Utilities;

public class Printer
extends Utility {
    protected PrintWriter out;
    protected PrintWriter directOut;
    protected StringWriter bufferedOut = null;
    protected int buffering = 0;
    protected int indent = 0;
    protected int column = 0;
    protected long line = 0L;

    public Printer(OutputStream outputStream) {
        this(new PrintWriter(outputStream, false));
    }

    public Printer(Writer writer) {
        this(new PrintWriter(writer, false));
    }

    public Printer(PrintWriter printWriter) {
        this.out = printWriter;
        this.directOut = printWriter;
    }

    public Printer reset() {
        this.stopBuffering();
        this.indent = 0;
        this.column = 0;
        this.line = 0L;
        return this;
    }

    public int column() {
        return this.column;
    }

    public Printer column(int n) {
        this.column = n;
        return this;
    }

    public long line() {
        return this.line;
    }

    public Printer buffer() {
        if (0 == this.buffering) {
            this.bufferedOut = new StringWriter();
            this.out = new PrintWriter((Writer)this.bufferedOut, false);
        }
        ++this.buffering;
        return this;
    }

    protected String stopBuffering() {
        if (null != this.directOut) {
            this.out.flush();
            String string = this.bufferedOut.toString();
            this.out = this.directOut;
            this.bufferedOut = null;
            this.buffering = 0;
            return string;
        }
        return "";
    }

    public Printer fit() {
        if (1 == this.buffering) {
            String string = this.stopBuffering();
            if (78 < this.column) {
                this.out.println();
                this.column = 0;
                ++this.line;
                this.indent().p(string);
            } else {
                this.out.print(string);
            }
        } else if (1 < this.buffering) {
            --this.buffering;
        }
        return this;
    }

    public Printer fit(String string) {
        if (1 == this.buffering) {
            String string2 = this.stopBuffering();
            if (78 < this.column) {
                this.out.println();
                this.column = 0;
                ++this.line;
                this.indent().p(string).p(string2);
            } else {
                this.out.print(string2);
            }
        } else if (1 < this.buffering) {
            --this.buffering;
        }
        return this;
    }

    public Printer fitMore() {
        if (1 == this.buffering) {
            String string = this.stopBuffering();
            if (78 < this.column) {
                this.out.println();
                this.column = 0;
                ++this.line;
                this.indentMore().p(string);
            } else {
                this.out.print(string);
            }
        } else if (1 < this.buffering) {
            --this.buffering;
        }
        return this;
    }

    public Printer unbuffer() {
        if (0 < this.buffering) {
            String string = this.stopBuffering();
            this.out.write(string);
        }
        return this;
    }

    public Printer align(int n) {
        int n2 = n - this.column;
        if (0 >= n2) {
            n2 = 1;
        }
        for (int i = 0; i < n2; ++i) {
            this.out.write(32);
        }
        this.column += n2;
        return this;
    }

    public int level() {
        return this.indent / 2;
    }

    public Printer setLevel(int n) {
        if (0 > n) {
            throw new IllegalArgumentException("Negative indentation level");
        }
        this.indent = n * 2;
        return this;
    }

    public Printer incr() {
        this.indent += 2;
        return this;
    }

    public Printer decr() {
        this.indent -= 2;
        return this;
    }

    public Printer indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.print(' ');
        }
        this.column += this.indent;
        return this;
    }

    public Printer indentLess() {
        int n = this.indent - 2;
        if (0 > n) {
            n = 0;
        }
        for (int i = 0; i < n; ++i) {
            this.out.print(' ');
        }
        this.column += n;
        return this;
    }

    public Printer indentMore() {
        int n = this.indent + 2;
        for (int i = 0; i < n; ++i) {
            this.out.print(' ');
        }
        this.column += n;
        return this;
    }

    public Printer p(char c) {
        this.out.print(c);
        ++this.column;
        return this;
    }

    public Printer p(int n) {
        return this.p(Integer.toString(n));
    }

    public Printer p(long l) {
        return this.p(Long.toString(l));
    }

    public Printer p(String string) {
        this.out.print(string);
        this.column += string.length();
        return this;
    }

    public Printer pln(char c) {
        this.unbuffer();
        this.out.println(c);
        this.column = 0;
        ++this.line;
        return this;
    }

    public Printer pln(int n) {
        return this.pln(Integer.toString(n));
    }

    public Printer pln(long l) {
        return this.pln(Long.toString(l));
    }

    public Printer pln(String string) {
        this.unbuffer();
        this.out.println(string);
        this.column = 0;
        ++this.line;
        return this;
    }

    public Printer pln() {
        this.unbuffer();
        this.out.println();
        this.column = 0;
        ++this.line;
        return this;
    }

    public Printer escape(char c, int n) {
        return this.p(Utilities.escape(c, n));
    }

    public Printer escape(String string, int n) {
        return this.p(Utilities.escape(string, n));
    }

    public Printer sep() {
        this.unbuffer();
        this.indent().p("// ");
        int n = 78 - this.indent - 3;
        for (int i = 0; i < n; ++i) {
            this.out.print('=');
        }
        this.out.println();
        this.column = 0;
        ++this.line;
        return this;
    }

    public Printer p(Node node) {
        this.visitor.dispatch(node);
        return this;
    }

    public Printer format(GNode gNode) {
        this.format(gNode, false);
        return this;
    }

    private void format(Object object, boolean bl) {
        if (!bl) {
            this.indent();
        }
        if (object instanceof Node) {
            object = ((Node)object).strip();
        }
        if (null == object) {
            this.p("null");
        } else if (object instanceof GNode) {
            GNode gNode = (GNode)object;
            this.p(gNode.getName()).p('<');
            if (!gNode.hasChildren()) {
                this.p('>');
            } else {
                boolean bl2 = bl = bl ? true : this.isSimple(gNode.children());
                if (!bl) {
                    this.pln().incr();
                }
                Iterator iterator = gNode.children();
                while (iterator.hasNext()) {
                    this.format(iterator.next(), bl);
                    if (iterator.hasNext()) {
                        if (bl) {
                            this.p(", ");
                            continue;
                        }
                        this.pln(',');
                        continue;
                    }
                    if (bl) continue;
                    this.pln();
                }
                if (bl) {
                    this.p('>');
                } else {
                    this.decr().indent().p('>');
                }
            }
        } else {
            this.p('\"').escape(object.toString(), 9).p('\"');
        }
    }

    private boolean isSimple(Object object) {
        if (object instanceof Node) {
            return false;
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                if (this.isSimple(iterator.next())) continue;
                return false;
            }
        }
        return true;
    }

    public Printer loc(Node node) {
        if (null == node.location) {
            return this;
        }
        return this.p(node.location.file).p(':').p(node.location.line).p(',').p(node.location.column);
    }

    public Printer flush() {
        this.out.flush();
        return this;
    }
}

