/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import xtc.tree.Node;
import xtc.util.Pair;

public class GNode
extends Node {
    private static final int FLAG_ZERO = 0;
    private static final int FLAG_ONE = 1;
    private static final int FLAG_MANY = 2;
    private final String name;
    private int flag;
    private Object children;

    public GNode(String string) {
        this(string, new ArrayList());
    }

    public GNode(String string, int n) {
        if (0 > n) {
            throw new IllegalArgumentException("Negative capacity");
        }
        this.name = string;
        if (2 > n) {
            this.flag = 0;
        } else {
            this.flag = 2;
            this.children = new ArrayList(n);
        }
    }

    public GNode(String string, Object object) {
        this.name = string;
        this.flag = 1;
        this.children = object;
    }

    public GNode(String string, List list) {
        this.name = string;
        this.flag = 2;
        this.children = list;
    }

    private void checkList() {
        if (2 != this.flag) {
            Object object = this.children;
            this.children = new ArrayList(this.flag);
            if (1 == this.flag) {
                ((List)this.children).add(object);
            }
            this.flag = 2;
        }
    }

    private void checkRange(int n) {
        if (0 > n || n >= this.flag) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.flag);
        }
    }

    public int hashCode() {
        this.checkList();
        return 37 * this.name.hashCode() + this.children.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GNode)) {
            return false;
        }
        GNode gNode = (GNode)object;
        this.checkList();
        gNode.checkList();
        if (!this.name.equals(gNode.name)) {
            return false;
        }
        return this.children.equals(gNode.children);
    }

    public final boolean isGeneric() {
        return true;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean hasName(String string) {
        return this.name.equals(string);
    }

    public GNode add(Object object) {
        switch (this.flag) {
            case 0: {
                this.flag = 1;
                this.children = object;
                break;
            }
            case 1: {
                this.checkList();
            }
            default: {
                ((List)this.children).add(object);
            }
        }
        return this;
    }

    public GNode add(int n, Object object) {
        switch (this.flag) {
            case 0: {
                if (0 != n) {
                    throw new IndexOutOfBoundsException("Invalid index " + n);
                }
                this.flag = 1;
                this.children = object;
                break;
            }
            case 1: {
                this.checkList();
            }
            default: {
                ((List)this.children).add(n, object);
            }
        }
        return this;
    }

    public GNode addAll(Pair pair) {
        this.checkList();
        pair.addTo((List)this.children);
        return this;
    }

    public GNode addAll(int n, Pair pair) {
        this.checkList();
        pair.addTo(((List)this.children).subList(0, n));
        return this;
    }

    public GNode addAll(Collection collection) {
        this.checkList();
        ((List)this.children).addAll(collection);
        return this;
    }

    public GNode addAll(int n, Collection collection) {
        this.checkList();
        ((List)this.children).addAll(n, collection);
        return this;
    }

    public boolean hasChildren() {
        if (2 == this.flag) {
            return !((List)this.children).isEmpty();
        }
        return 0 != this.flag;
    }

    public Iterator children() {
        switch (this.flag) {
            case 0: {
                return new Iterator(){

                    public boolean hasNext() {
                        return false;
                    }

                    public Object next() {
                        throw new NoSuchElementException();
                    }

                    public void remove() {
                        throw new IllegalStateException();
                    }
                };
            }
            case 1: {
                return new Iterator(){
                    boolean accessed = false;

                    public boolean hasNext() {
                        return !this.accessed;
                    }

                    public Object next() {
                        if (this.accessed) {
                            throw new NoSuchElementException();
                        }
                        this.accessed = true;
                        return GNode.this.children;
                    }

                    public void remove() {
                        if (!this.accessed || 1 != GNode.this.flag) {
                            throw new IllegalStateException();
                        }
                        GNode.this.flag = 0;
                        GNode.this.children = null;
                    }
                };
            }
        }
        return ((List)this.children).iterator();
    }

    public int size() {
        if (2 == this.flag) {
            return ((List)this.children).size();
        }
        return this.flag;
    }

    public Object get(int n) {
        if (2 == this.flag) {
            return ((List)this.children).get(n);
        }
        this.checkRange(n);
        return this.children;
    }

    public String getString(int n) {
        return (String)this.get(n);
    }

    public Node getNode(int n) {
        return (Node)this.get(n);
    }

    public GNode getGeneric(int n) {
        Node node = (Node)this.get(n);
        return null == node ? null : (GNode)node.strip();
    }

    public Object set(int n, Object object) {
        if (2 == this.flag) {
            return ((List)this.children).set(n, object);
        }
        this.checkRange(n);
        Object object2 = this.children;
        this.children = object;
        return object2;
    }

    public Object remove(int n) {
        if (2 == this.flag) {
            return ((List)this.children).remove(n);
        }
        this.checkRange(n);
        this.flag = 0;
        Object object = this.children;
        this.children = null;
        return object;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GNode(");
        stringBuffer.append(this.name);
        stringBuffer.append(", ..");
        if (2 == this.flag) {
            stringBuffer.append(((List)this.children).size());
        } else {
            stringBuffer.append(this.flag);
        }
        stringBuffer.append("..)");
        return stringBuffer.toString();
    }

    public static GNode cast(Object object) {
        Node node = (Node)object;
        return null == node ? null : (GNode)node.strip();
    }
}

