/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharTerminal;
import xtc.parser.Element;
import xtc.parser.NonTerminal;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.VoidedElement;

public class Type {
    public static final int TYPE_NODE = 1;
    public static final int TYPE_NOT_A_NODE = 2;
    public static final int TYPE_MAYBE_A_NODE = 3;
    private static final Set PRIMITIVE;
    private static final List importedPackages;
    private static final Map importedClasses;
    private static final Map resolvedTypes;
    private static final Object UNKNOWN;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$xtc$tree$Node;

    private Type() {
    }

    public static void init() {
        importedPackages.clear();
        importedPackages.add("java.lang.");
        importedClasses.clear();
        resolvedTypes.clear();
        resolvedTypes.put("void", Void.TYPE);
    }

    public static void importT(String string) {
        if (string.endsWith(".*")) {
            if (2 >= string.length()) {
                throw new IllegalArgumentException("Malformed package name: " + string);
            }
            importedPackages.add(string.substring(0, string.length() - 1));
        } else {
            int n = string.lastIndexOf(46);
            if (-1 == n || n == string.length() - 1) {
                throw new IllegalArgumentException("Malformed type name: " + string);
            }
            importedClasses.put(string.substring(n + 1), string);
        }
    }

    public static String voidT() {
        return "void";
    }

    public static boolean isVoidT(String string) {
        return Type.voidT().equals(string);
    }

    public static String booleanT() {
        return "boolean";
    }

    public static String charT() {
        return "char";
    }

    public static String intT() {
        return "int";
    }

    public static String indexT() {
        return "int";
    }

    public static String rootT() {
        return "Object";
    }

    public static boolean isRootT(String string) {
        return Type.rootT().equals(string) || "java.lang.Object".equals(string);
    }

    public static String voidRefT() {
        return "Void";
    }

    public static String charRefT() {
        return "Character";
    }

    public static String stringT() {
        return "String";
    }

    public static boolean isStringT(String string) {
        return Type.stringT().equals(string) || "java.lang.String".equals(string);
    }

    public static String listT() {
        return "Pair";
    }

    public static boolean isListT(String string) {
        return Type.listT().equals(string) || "xtc.util.Pair".equals(string);
    }

    public static String genericNodeT() {
        return "GNode";
    }

    public static boolean isGenericNodeT(String string) {
        return Type.genericNodeT().equals(string) || "xtc.tree.GNode".equals(string);
    }

    public static String genericT() {
        return "generic";
    }

    public static boolean isGenericT(String string) {
        return Type.genericT().equals(string);
    }

    public static String actionT() {
        return "Action";
    }

    public static boolean isPrimitive(String string) {
        return PRIMITIVE.contains(string);
    }

    public static int classify(String string) {
        Object object = resolvedTypes.get(string);
        if (null == object) {
            String string2 = (String)importedClasses.get(string);
            if (null != string2 && null == (object = Type.forName(string2))) {
                object = UNKNOWN;
            }
            if (null == object) {
                object = Type.forName(string);
            }
            if (null == object) {
                Iterator iterator = importedPackages.iterator();
                while (iterator.hasNext() && null == (object = Type.forName((String)iterator.next() + string))) {
                }
            }
            if (null == object) {
                object = UNKNOWN;
            }
            resolvedTypes.put(string, object);
        }
        if (UNKNOWN == object || (class$java$lang$Object == null ? (class$java$lang$Object = Type.class$("java.lang.Object")) : class$java$lang$Object).equals(object)) {
            return 3;
        }
        if ((class$xtc$tree$Node == null ? (class$xtc$tree$Node = Type.class$("xtc.tree.Node")) : class$xtc$tree$Node).isAssignableFrom((Class)object)) {
            return 1;
        }
        return 2;
    }

    private static Class forName(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static String type(Element element, Analyzer analyzer) {
        if (element instanceof OrderedChoice || element instanceof Sequence) {
            return Type.rootT();
        }
        if (element instanceof Repetition) {
            return Type.listT();
        }
        if (element instanceof Option) {
            Binding binding = analyzer.getBinding(Sequence.ensure(((Option)element).element));
            if (null == binding) {
                return Type.rootT();
            }
            return Type.type(binding.element, analyzer);
        }
        if (element instanceof VoidedElement) {
            return Type.voidT();
        }
        if (element instanceof NonTerminal) {
            return analyzer.lookup((NonTerminal)((NonTerminal)element)).type;
        }
        if (element instanceof StringLiteral) {
            return Type.stringT();
        }
        if (element instanceof CharTerminal) {
            return Type.charRefT();
        }
        if (element instanceof StringMatch) {
            return Type.stringT();
        }
        throw new IllegalArgumentException(element.toString() + " cannot be typed");
    }

    public static String unify(String string, String string2) {
        if (null == string) {
            if (null == string2) {
                return Type.rootT();
            }
            return string2;
        }
        if (null == string2) {
            return string;
        }
        if (string.equals(string2)) {
            return string;
        }
        return Type.rootT();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        UNKNOWN = new Object();
        PRIMITIVE = new HashSet();
        PRIMITIVE.add("byte");
        PRIMITIVE.add("short");
        PRIMITIVE.add("int");
        PRIMITIVE.add("long");
        PRIMITIVE.add("float");
        PRIMITIVE.add("double");
        PRIMITIVE.add("char");
        PRIMITIVE.add("boolean");
        importedPackages = new ArrayList();
        importedClasses = new HashMap();
        resolvedTypes = new HashMap();
        Type.init();
    }
}

