/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.Iterator;
import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.Rats;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.Terminal;
import xtc.parser.Type;
import xtc.parser.UnaryOperator;
import xtc.parser.VoidedElement;
import xtc.tree.Visitor;

public class TextTester
extends Visitor {
    public static final String TEXT_ONLY = "xtc.parser.TextTester.TextOnly";
    protected final Analyzer analyzer;
    protected boolean isTextOnly;

    public TextTester(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void visit(Grammar grammar) {
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        Iterator iterator = grammar.modules.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            this.analyzer.process(module);
            Iterator iterator2 = module.productions.iterator();
            while (iterator2.hasNext()) {
                Production production = (Production)iterator2.next();
                if (!production.isFull() || this.analyzer.isProcessed(production.qName)) continue;
                if (!Type.isStringT(production.type)) {
                    this.analyzer.processed(production.qName);
                    continue;
                }
                this.isTextOnly = true;
                this.analyzer.process(production);
                if (this.isTextOnly) {
                    Iterator iterator3 = this.analyzer.working().iterator();
                    while (iterator3.hasNext()) {
                        FullProduction fullProduction = this.analyzer.lookupGlobally((NonTerminal)iterator3.next());
                        TextTester.markTextOnly(fullProduction);
                        this.analyzer.processed(fullProduction.qName);
                    }
                    continue;
                }
                this.analyzer.processed(production.qName);
            }
        }
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        Iterator iterator = module.productions.iterator();
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            if (this.analyzer.isProcessed(production.qName)) continue;
            if (!Type.isStringT(production.type)) {
                this.analyzer.processed(production.qName);
                continue;
            }
            this.isTextOnly = true;
            this.analyzer.process(production);
            if (this.isTextOnly) {
                Iterator iterator2 = this.analyzer.working().iterator();
                while (iterator2.hasNext()) {
                    FullProduction fullProduction = this.analyzer.lookup((NonTerminal)iterator2.next());
                    TextTester.markTextOnly(fullProduction);
                    this.analyzer.processed(fullProduction.qName);
                }
                continue;
            }
            this.analyzer.processed(production.qName);
        }
    }

    public void visit(Production production) {
        Object object = this.analyzer.enter(production);
        this.analyzer.workingOn(production.qName);
        this.dispatch(production.element);
        this.analyzer.exit(object);
    }

    public void visit(OrderedChoice orderedChoice) {
        Iterator iterator = orderedChoice.alternatives.iterator();
        while (iterator.hasNext()) {
            this.dispatch((Element)iterator.next());
            if (this.isTextOnly) continue;
            return;
        }
    }

    public void visit(Sequence sequence) {
        Iterator iterator = sequence.iterator();
        while (iterator.hasNext()) {
            this.dispatch((Element)iterator.next());
            if (this.isTextOnly) continue;
            return;
        }
    }

    public void visit(SemanticPredicate semanticPredicate) {
    }

    public void visit(VoidedElement voidedElement) {
        this.isTextOnly = false;
    }

    public void visit(Binding binding) {
        if ("yyValue".equals(binding.name)) {
            this.isTextOnly = false;
        } else {
            this.dispatch(binding.element);
        }
    }

    public void visit(NonTerminal nonTerminal) {
        FullProduction fullProduction;
        try {
            fullProduction = this.analyzer.lookup(nonTerminal);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTextOnly = false;
            return;
        }
        if (null == fullProduction) {
            this.isTextOnly = false;
        } else if (this.analyzer.isProcessed(fullProduction.qName)) {
            if (!TextTester.isTextOnly(fullProduction)) {
                this.isTextOnly = false;
            }
        } else if (!this.analyzer.isBeingWorkedOn(fullProduction.qName)) {
            if (Type.isStringT(fullProduction.type)) {
                this.dispatch(fullProduction);
            } else {
                this.isTextOnly = false;
            }
        }
    }

    public void visit(CharCase charCase) {
        this.dispatch(charCase.element);
    }

    public void visit(CharSwitch charSwitch) {
        Iterator iterator = charSwitch.cases.iterator();
        while (iterator.hasNext()) {
            this.dispatch((CharCase)iterator.next());
            if (this.isTextOnly) continue;
            return;
        }
        this.dispatch(charSwitch.base);
    }

    public void visit(Terminal terminal) {
    }

    public void visit(UnaryOperator unaryOperator) {
        this.dispatch(unaryOperator.element);
    }

    public void visit(Action action) {
        Iterator iterator = action.code.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (-1 == string.indexOf("yyValue")) continue;
            this.isTextOnly = false;
            return;
        }
    }

    public void visit(ParserAction parserAction) {
        this.isTextOnly = false;
    }

    public void visit(Element element) {
        this.isTextOnly = false;
    }

    public static void markTextOnly(Production production) {
        if (Rats.optionVerbose) {
            System.err.println("[Recognizing " + production.qName + " as text-only]");
        }
        production.setProperty(TEXT_ONLY, Boolean.TRUE);
    }

    public static boolean isTextOnly(Production production) {
        return production.getBooleanProperty(TEXT_ONLY);
    }
}

