/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.AlternativeAddition;
import xtc.parser.AlternativeRemoval;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharClass;
import xtc.parser.CharRange;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.HtmlPrinter;
import xtc.parser.InternalElement;
import xtc.parser.LeftRecurser;
import xtc.parser.Module;
import xtc.parser.ModuleDependency;
import xtc.parser.ModuleImport;
import xtc.parser.ModuleMap;
import xtc.parser.ModuleModification;
import xtc.parser.ModuleName;
import xtc.parser.NonTerminal;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParseException;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.PrettyPrinter;
import xtc.parser.Production;
import xtc.parser.ProductionOverride;
import xtc.parser.Rats;
import xtc.parser.Renamer;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.SequenceName;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.TextTester;
import xtc.parser.Type;
import xtc.parser.VoidedElement;
import xtc.tree.Attribute;
import xtc.tree.AttributeList;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.util.Utilities;

public class Resolver
extends Visitor {
    protected final Analyzer analyzer;
    protected final List roots;
    protected boolean error;
    protected int phase;
    protected Map badNTs;
    protected boolean hasState;
    protected boolean isMofunctor;
    protected boolean isPredicate;
    protected Set sequenceNames;

    public Resolver(Analyzer analyzer, List list) {
        this.analyzer = analyzer;
        this.roots = list;
        this.badNTs = new IdentityHashMap();
        this.sequenceNames = new HashSet();
    }

    protected void error(String string, Node node) {
        if (node.hasProperty("xtc.Constants.Original")) {
            Utilities.msg(string, ((Node)node.getProperty((String)"xtc.Constants.Original")).location, null, null);
        } else {
            Utilities.msg(string, node.location, null, null);
        }
        Rats.error();
        this.error = true;
    }

    protected void warning(String string, Node node) {
        System.err.println();
        if (node.hasProperty("xtc.Constants.Original")) {
            Utilities.msg("warning: " + string, ((Node)node.getProperty((String)"xtc.Constants.Original")).location, null, null);
        } else {
            Utilities.msg("warning: " + string, node.location, null, null);
        }
    }

    protected void signature(Module module) {
        Iterator iterator;
        System.out.print("module ");
        System.out.print(module.name.name);
        if (module.name.hasProperty("xtc.Constants.Original") || null != module.parameters) {
            System.out.print(" = ");
            iterator = module.name.hasProperty("xtc.Constants.Original") ? (ModuleName)module.name.getProperty("xtc.Constants.Original") : module.name;
            System.out.print(((ModuleName)((Object)iterator)).name);
            if (null == module.parameters) {
                System.out.print("()");
            } else {
                System.out.print(module.parameters.toString());
            }
        }
        if (null != module.dependencies) {
            iterator = module.dependencies.iterator();
            while (iterator.hasNext()) {
                ModuleDependency moduleDependency = (ModuleDependency)iterator.next();
                if (!moduleDependency.isModification()) continue;
                System.out.println();
                System.out.print("       modifies ");
                System.out.print(moduleDependency.visibleName().name);
                break;
            }
            boolean bl = true;
            iterator = module.dependencies.iterator();
            while (iterator.hasNext()) {
                ModuleDependency moduleDependency = (ModuleDependency)iterator.next();
                if (!moduleDependency.isImport()) continue;
                if (bl) {
                    System.out.println();
                    System.out.print("       imports ");
                    bl = false;
                } else {
                    System.out.println(',');
                    System.out.print("               ");
                }
                System.out.print(moduleDependency.visibleName().name);
            }
        }
        System.out.println(';');
    }

    protected void rename(Module module, ModuleMap moduleMap) {
        Object object;
        module.name = module.name.rename(moduleMap);
        if (null != module.parameters) {
            module.parameters.rename(moduleMap);
        }
        if (null != module.dependencies) {
            object = module.dependencies.iterator();
            while (object.hasNext()) {
                ((ModuleDependency)object.next()).rename(moduleMap);
            }
        }
        object = new Renamer(this.analyzer, moduleMap);
        Iterator iterator = module.productions.iterator();
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            if (null != production.qName) {
                production.qName = production.qName.rename(moduleMap);
            }
            ((Visitor)object).dispatch(production);
        }
    }

    protected Production strip(Production production) {
        if (null != production && null != production.element) {
            production.element = this.analyzer.stripChoices((OrderedChoice)production.element);
        }
        return production;
    }

    protected void apply(AlternativeAddition alternativeAddition, FullProduction fullProduction) {
        OrderedChoice orderedChoice = (OrderedChoice)alternativeAddition.element;
        OrderedChoice orderedChoice2 = (OrderedChoice)fullProduction.element;
        int n = orderedChoice2.alternatives.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (!alternativeAddition.sequence.equals(((Sequence)orderedChoice2.alternatives.get((int)i)).name)) continue;
            n2 = i;
            break;
        }
        if (-1 == n2) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("unable to add new alternative");
            if (1 != orderedChoice.alternatives.size()) {
                stringBuffer.append('s');
            }
            if (alternativeAddition.isBefore) {
                stringBuffer.append(" before ");
            } else {
                stringBuffer.append(" after ");
            }
            stringBuffer.append("non-existent alternative ");
            stringBuffer.append(alternativeAddition.sequence.name);
            this.error(stringBuffer.toString(), alternativeAddition.sequence);
        } else {
            if (!alternativeAddition.isBefore) {
                ++n2;
            }
            orderedChoice2.alternatives.addAll(n2, orderedChoice.alternatives);
        }
    }

    protected void apply(AlternativeRemoval alternativeRemoval, FullProduction fullProduction) {
        Iterator iterator = alternativeRemoval.sequences.iterator();
        while (iterator.hasNext()) {
            SequenceName sequenceName = (SequenceName)iterator.next();
            boolean bl = false;
            Iterator iterator2 = ((OrderedChoice)fullProduction.element).alternatives.iterator();
            while (iterator2.hasNext()) {
                if (!sequenceName.equals(((Sequence)iterator2.next()).name)) continue;
                iterator2.remove();
                bl = true;
                break;
            }
            if (bl) continue;
            this.error("unable to remove non-existent alternative " + sequenceName, sequenceName);
        }
    }

    protected void apply(ProductionOverride productionOverride, FullProduction fullProduction) {
        if (null != productionOverride.attributes) {
            fullProduction.attributes = productionOverride.attributes;
        }
        if (null != productionOverride.element) {
            if (productionOverride.isComplete) {
                fullProduction.element = productionOverride.element;
            } else {
                Iterator iterator = ((OrderedChoice)productionOverride.element).alternatives.iterator();
                while (iterator.hasNext()) {
                    Sequence sequence = (Sequence)iterator.next();
                    if (null == sequence.name) {
                        this.error("overriding sequence without name", sequence);
                        continue;
                    }
                    OrderedChoice orderedChoice = (OrderedChoice)fullProduction.element;
                    int n = orderedChoice.alternatives.size();
                    boolean bl = false;
                    for (int i = 0; i < n; ++i) {
                        Sequence sequence2 = (Sequence)orderedChoice.alternatives.get(i);
                        if (!sequence.name.equals(sequence2.name)) continue;
                        orderedChoice.alternatives.set(i, sequence);
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    this.error("unable to override non-existent alternative " + sequence.name, sequence);
                }
            }
        }
    }

    protected Grammar load(Module module) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (null != module.parameters && 0 < module.parameters.length()) {
            this.error("parameterized top-level module " + module.name.name, module.name);
            return null;
        }
        PrettyPrinter prettyPrinter = null;
        if (Rats.optionLoaded) {
            object4 = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
            prettyPrinter = new PrettyPrinter(new Printer((PrintWriter)object4));
            prettyPrinter.dispatch(module);
            prettyPrinter.flush();
        }
        object4 = new ArrayList();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<ModuleName, Object> hashMap2 = new HashMap<ModuleName, Object>();
        IdentityHashMap<Object, Boolean> identityHashMap = new IdentityHashMap<Object, Boolean>();
        object4.add(module);
        hashMap.put(module.name.name, module);
        hashMap2.put(module.name, new ModuleImport(module.name));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (null != module.dependencies) {
            object3 = module.dependencies.iterator();
            while (object3.hasNext()) {
                object2 = (ModuleDependency)object3.next();
                if (((ModuleDependency)object2).isModification()) {
                    boolean bl = true;
                    if (null != module.modification) {
                        this.error("duplicate modifies declaration", (Node)object2);
                        bl = false;
                    }
                    if (((ModuleDependency)object2).visibleName().equals(module.name)) {
                        this.error("module " + module.name + " modifies itself", (Node)object2);
                        bl = false;
                    }
                    if (!bl) continue;
                    module.modification = (ModuleModification)object2;
                    arrayList.add(object2);
                    continue;
                }
                arrayList.add(object2);
            }
        }
        if (Rats.optionDependencies) {
            this.signature(module);
        }
        while (!arrayList.isEmpty()) {
            int n;
            int n2;
            int n3;
            object3 = (ModuleDependency)arrayList.remove(0);
            if (hashMap2.containsKey(((ModuleDependency)object3).visibleName())) {
                object2 = (ModuleDependency)hashMap2.get(((ModuleDependency)object3).visibleName());
                if (((ModuleDependency)object3).isConsistentWith((ModuleDependency)object2)) continue;
                if (!identityHashMap.containsKey(object2)) {
                    identityHashMap.put(object2, Boolean.TRUE);
                    this.error("inconsistent instantiation of module " + ((ModuleDependency)object2).module + ((ModuleDependency)object2).arguments + " as " + ((ModuleDependency)object2).visibleName(), (Node)object2);
                }
                this.error("inconsistent instantiation of module " + ((ModuleDependency)object3).module + ((ModuleDependency)object3).arguments + " as " + ((ModuleDependency)object3).visibleName(), (Node)object3);
                continue;
            }
            if (Rats.optionVerbose) {
                object2 = Utilities.toPath(((ModuleDependency)object3).module.name, "rats");
                File file = null;
                try {
                    file = Utilities.locate(this.roots, (String)object2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (null == file) {
                    System.err.println("[Loading module " + ((ModuleDependency)object3).module + "]");
                } else {
                    System.err.println("[Loading module " + ((ModuleDependency)object3).module + " from " + file + "]");
                }
            }
            object2 = null;
            try {
                object2 = Module.load(this.roots, ((ModuleDependency)object3).module.name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error(illegalArgumentException.getMessage(), (Node)object3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error(fileNotFoundException.getMessage(), (Node)object3);
            }
            catch (IOException iOException) {
                if (null == iOException.getMessage()) {
                    this.error("I/O error while accessing corresponding file", (Node)object3);
                } else {
                    this.error(iOException.getMessage(), (Node)object3);
                }
            }
            catch (ParseException parseException) {
                System.err.println();
                System.err.print(parseException.getMessage());
                this.error = true;
            }
            hashMap2.put(((ModuleDependency)object3).visibleName(), object3);
            if (null == object2) continue;
            if (Rats.optionLoaded) {
                prettyPrinter.dispatch((Node)object2);
                prettyPrinter.flush();
            }
            boolean bl = false;
            if (!((ModuleDependency)object3).module.equals(((Module)object2).name)) {
                String string = Utilities.toPath(((ModuleDependency)object3).module.name, "rats");
                File file = null;
                try {
                    file = Utilities.locate(this.roots, string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (null == file) {
                    this.error("module name " + ((Module)object2).name + " inconsistent with file path", ((Module)object2).name);
                    bl = true;
                } else {
                    this.error("module name " + ((Module)object2).name + " inconsistent with file path " + file, ((Module)object2).name);
                    bl = true;
                }
            }
            if (null != ((Module)object2).parameters && 0 != (n3 = ((Module)object2).parameters.length())) {
                block11: for (int i = 0; i < n3; ++i) {
                    object = ((Module)object2).parameters.get(i);
                    if (((Module)object2).name.equals(object)) {
                        this.error("module parameter " + object + " same as module name", (Node)object);
                        bl = true;
                    }
                    for (n2 = 0; n2 < i; ++n2) {
                        if (!((ModuleName)object).equals(((Module)object2).parameters.get(n2))) continue;
                        this.error("duplicate module parameter " + object, (Node)object);
                        continue block11;
                    }
                }
            }
            int n4 = ((ModuleDependency)object3).arguments.length();
            int n5 = n = null != ((Module)object2).parameters ? ((Module)object2).parameters.length() : 0;
            if (n4 != n) {
                object = new StringBuffer();
                ((StringBuffer)object).append(n4);
                ((StringBuffer)object).append(" argument");
                if (1 != n4) {
                    ((StringBuffer)object).append('s');
                }
                ((StringBuffer)object).append(" for module ");
                ((StringBuffer)object).append(((Module)object2).name.name);
                ((StringBuffer)object).append(" with ");
                ((StringBuffer)object).append(n);
                ((StringBuffer)object).append(" parameter");
                if (1 != n) {
                    ((StringBuffer)object).append('s');
                }
                this.error(((StringBuffer)object).toString(), (Node)object3);
                bl = true;
            }
            if (bl) continue;
            if (0 != n4 || !((ModuleDependency)object3).module.equals(((ModuleDependency)object3).visibleName())) {
                if (Rats.optionVerbose) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("[Instantiating module ");
                    ((StringBuffer)object).append(((Module)object2).name);
                    ((StringBuffer)object).append('(');
                    for (n2 = 0; n2 < n4; ++n2) {
                        ((StringBuffer)object).append(((ModuleDependency)object3).arguments.get((int)n2).name);
                        ((StringBuffer)object).append('/');
                        ((StringBuffer)object).append(((Module)object2).parameters.get((int)n2).name);
                        if (n2 + 1 >= n4) continue;
                        ((StringBuffer)object).append(", ");
                    }
                    ((StringBuffer)object).append(") as ");
                    ((StringBuffer)object).append(((ModuleDependency)object3).visibleName().name);
                    ((StringBuffer)object).append(']');
                    System.err.println(((StringBuffer)object).toString());
                }
                object = 0 != n4 ? new ModuleMap(((Module)object2).parameters, ((ModuleDependency)object3).arguments) : new ModuleMap();
                if (!((ModuleDependency)object3).module.equals(((ModuleDependency)object3).visibleName())) {
                    ((ModuleMap)object).put(((ModuleDependency)object3).module, ((ModuleDependency)object3).visibleName());
                }
                this.rename((Module)object2, (ModuleMap)object);
            }
            object4.add(object2);
            hashMap.put(((Module)object2).name.name, object2);
            if (null != ((Module)object2).dependencies) {
                object = ((Module)object2).dependencies.iterator();
                while (object.hasNext()) {
                    ModuleDependency moduleDependency = (ModuleDependency)object.next();
                    if (moduleDependency.isModification()) {
                        boolean bl2 = true;
                        if (null != ((Module)object2).modification) {
                            this.error("duplicate modifies declaration", moduleDependency);
                            bl2 = false;
                        }
                        if (moduleDependency.visibleName().equals(((Module)object2).name)) {
                            this.error("module " + ((Module)object2).name + " modifies itself", moduleDependency);
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        ((Module)object2).modification = (ModuleModification)moduleDependency;
                        arrayList.add(moduleDependency);
                        continue;
                    }
                    arrayList.add(moduleDependency);
                }
            }
            if (Rats.optionDependencies) {
                this.signature((Module)object2);
            }
            if (null == ((Module)object2).parameters) continue;
            ((Node)object2).setProperty("xtc.Constants.Arguments", ((Module)object2).parameters);
            ((Module)object2).parameters = null;
        }
        object3 = new HashMap();
        object2 = new HashSet();
        Iterator iterator = object4.iterator();
        while (iterator.hasNext()) {
            Module module2 = (Module)iterator.next();
            if (object2.contains(module2.name)) continue;
            object3.clear();
            do {
                if (object3.containsKey(module2.name)) {
                    boolean bl = (Boolean)object3.get(module2.name);
                    if (bl) break;
                    object3.put(module2.name, Boolean.TRUE);
                    continue;
                }
                object3.put(module2.name, Boolean.FALSE);
            } while (null != module2.modification && null != (module2 = (Module)hashMap.get(module2.modification.visibleName().name)));
            Iterator iterator2 = object4.iterator();
            while (iterator2.hasNext()) {
                object = (Module)iterator2.next();
                if (!object3.containsKey(((Module)object).name)) continue;
                object2.add(((Module)object).name);
                if (!((Boolean)object3.get(((Module)object).name)).booleanValue()) continue;
                this.error("circular modifies dependency", ((Module)object).modification);
            }
        }
        Grammar grammar = new Grammar((List)object4);
        if (Rats.optionInstantiated) {
            if (Rats.optionHtml) {
                new HtmlPrinter(this.analyzer, Rats.dirOut).dispatch(grammar);
            } else {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
                prettyPrinter = new PrettyPrinter(new Printer(printWriter));
                prettyPrinter.dispatch(grammar);
                prettyPrinter.flush();
            }
        }
        return this.error ? null : grammar;
    }

    protected AttributeList check(Grammar grammar) {
        Node node;
        Object object;
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        this.phase = 1;
        Module module = (Module)grammar.modules.get(0);
        AttributeList attributeList = new AttributeList();
        String string = null;
        boolean bl = false;
        Iterator iterator = grammar.modules.iterator();
        while (iterator.hasNext()) {
            Object object2;
            object = (Module)iterator.next();
            if (((Module)object).hasAttribute(Constants.ATT_STATEFUL.name)) {
                object2 = ((Module)object).attributes.get(Constants.ATT_STATEFUL.name);
                if (null != ((Attribute)object2).value && ((Attribute)object2).value instanceof String && !((String)((Attribute)object2).value).startsWith("\"")) {
                    if (null == string) {
                        attributeList.add(object2);
                        string = (String)((Attribute)object2).value;
                    }
                    if (!string.equals(((Attribute)object2).value)) {
                        bl = true;
                    }
                }
            }
            if (!((Module)object).hasAttribute(Constants.ATT_RESERVED.name) && !((Module)object).hasAttribute(Constants.ATT_FLAG.name)) continue;
            object2 = ((Module)object).attributes.iterator();
            while (object2.hasNext()) {
                node = (Attribute)object2.next();
                if (!Constants.ATT_RESERVED.name.equals(((Attribute)node).name) && !Constants.ATT_FLAG.name.equals(((Attribute)node).name) || attributeList.contains(node)) continue;
                attributeList.add(node);
            }
        }
        object = new HashSet();
        boolean bl2 = false;
        iterator = grammar.modules.iterator();
        while (iterator.hasNext()) {
            node = (Module)iterator.next();
            this.analyzer.process((Module)node);
            this.hasState = false;
            boolean bl3 = this.isMofunctor = null != ((Module)node).modification;
            if (null != ((Module)node).attributes) {
                int n = ((Module)node).attributes.size();
                for (int i = 0; i < n; ++i) {
                    Node node2;
                    Attribute attribute = (Attribute)((Module)node).attributes.get(i);
                    if (!(Constants.ATT_WITH_LOCATION.equals(attribute) || Constants.ATT_CONSTANT.equals(attribute) || Constants.ATT_VERBOSE.equals(attribute) || Constants.ATT_IGNORING_CASE.equals(attribute) || Constants.ATT_STATEFUL.name.equals(attribute.name) || Constants.ATT_PARSER.name.equals(attribute.name) || Constants.ATT_MAIN.name.equals(attribute.name) || Constants.ATT_PRINTER.name.equals(attribute.name) || Constants.ATT_RESERVED.equals(attribute) || Constants.ATT_VISIBILITY.name.equals(attribute.name) || Constants.ATT_FLAG.name.equals(attribute.name) || Constants.ATT_DUMP.equals(attribute))) {
                        this.error("unrecognized grammar-wide attribute " + attribute, attribute);
                    } else {
                        for (int j = 0; j < i; ++j) {
                            node2 = (Attribute)((Module)node).attributes.get(j);
                            if (attribute.name.equals(Constants.ATT_FLAG.name)) {
                                if (!attribute.equals(node2)) continue;
                                this.error("duplicate attribute " + attribute, attribute);
                                break;
                            }
                            if (!attribute.name.equals(((Attribute)node2).name)) continue;
                            this.error("duplicate attribute " + attribute.name, attribute);
                            break;
                        }
                    }
                    if (Constants.ATT_STATEFUL.name.equals(attribute.name)) {
                        if (null == attribute.value) {
                            this.error("stateful attribute without class name", attribute);
                        } else if (!(attribute.value instanceof String)) {
                            this.error("stateful attribute with invalid value", attribute);
                        } else if (((String)attribute.value).startsWith("\"")) {
                            this.error("stateful attribute with invalid value", attribute);
                        } else if (bl) {
                            this.error("inconsistent state class across modules", attribute);
                        }
                        this.hasState = true;
                        continue;
                    }
                    if (Constants.ATT_PARSER.name.equals(attribute.name)) {
                        if (null == attribute.value) {
                            this.error("parser attribute without class name", attribute);
                            continue;
                        }
                        if (!(attribute.value instanceof String)) {
                            this.error("parser attribute with invalid value", attribute);
                            continue;
                        }
                        if (!((String)attribute.value).startsWith("\"")) continue;
                        this.error("parser attribute with invalid value", attribute);
                        continue;
                    }
                    if (Constants.ATT_MAIN.name.equals(attribute.name)) {
                        if (null == attribute.value) {
                            this.error("main attribute without nonterminal value", attribute);
                            continue;
                        }
                        if (!(attribute.value instanceof String)) {
                            this.error("main attribute with invalid value", attribute);
                            continue;
                        }
                        if (((String)attribute.value).startsWith("\"")) {
                            this.error("main attribute with invalid value", attribute);
                            continue;
                        }
                        NonTerminal nonTerminal = new NonTerminal((String)attribute.value);
                        node2 = null;
                        boolean bl4 = false;
                        try {
                            node2 = this.analyzer.lookup(nonTerminal);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.error("main attribute with ambiguous nonterminal " + nonTerminal, attribute);
                            bl4 = true;
                        }
                        if (bl4) continue;
                        if (null == node2) {
                            this.error("main attribute with undefined nonterminal " + nonTerminal, attribute);
                            continue;
                        }
                        if (!this.analyzer.isDefined((Production)node2, (Module)node)) {
                            this.error("main attribute with another module's nonterminal " + nonTerminal, attribute);
                            continue;
                        }
                        if (((Production)node2).hasAttribute(Constants.ATT_PUBLIC)) continue;
                        this.error("main attribute with non-public nonterminal " + nonTerminal, attribute);
                        continue;
                    }
                    if (Constants.ATT_PRINTER.name.equals(attribute.name)) {
                        if (null == attribute.value) {
                            this.error("printer attribute without class name", attribute);
                        } else if (!(attribute.value instanceof String)) {
                            this.error("printer attribute with invalid value", attribute);
                        } else if (((String)attribute.value).startsWith("\"")) {
                            this.error("printer attribute with invalid value", attribute);
                        }
                        if (((Module)node).hasAttribute(Constants.ATT_MAIN.name)) continue;
                        this.error("printer attribute without main attribute", attribute);
                        continue;
                    }
                    if (Constants.ATT_VISIBILITY.name.equals(attribute.name)) {
                        if (null == attribute.value) {
                            this.error("visibility attribute without value", attribute);
                            continue;
                        }
                        if (Constants.ATT_PUBLIC.name.equals(attribute.value) || Constants.ATT_PACKAGE_PRIVATE.name.equals(attribute.value)) continue;
                        this.error("visibility attribute with invalid value", attribute);
                        continue;
                    }
                    if (!Constants.ATT_FLAG.name.equals(attribute.name)) continue;
                    if (null == attribute.value) {
                        this.error("flag attribute without flag value", attribute);
                        continue;
                    }
                    if (!(attribute.value instanceof String)) {
                        this.error("flag attribute with invalid value", attribute);
                        continue;
                    }
                    if (!((String)attribute.value).startsWith("\"")) continue;
                    this.error("flag attribute with invalid value", attribute);
                }
            }
            if (!this.hasState) {
                this.hasState = this.analyzer.hasAttribute((Module)node, Constants.ATT_STATEFUL.name, (Set)object);
                object.clear();
            }
            Iterator iterator2 = ((Module)node).productions.iterator();
            while (iterator2.hasNext()) {
                Production production = (Production)iterator2.next();
                this.sequenceNames.clear();
                this.analyzer.process(production);
                if (!production.isPartial() && production != this.analyzer.lookup(production.name)) {
                    this.error("duplicate definition for nonterminal " + production.name, production);
                }
                if (!production.hasAttribute(Constants.ATT_PUBLIC)) continue;
                if (this.analyzer.isDefined(production, module)) {
                    bl2 = true;
                    continue;
                }
                production.attributes.remove(Constants.ATT_PUBLIC);
            }
        }
        if (!bl2) {
            this.error("no public nonterminal", (Production)((Module)grammar.modules.get((int)0)).productions.get(0));
        }
        return attributeList;
    }

    protected void applyModifications(Grammar grammar) {
        Object object;
        Object object2;
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        this.phase = 2;
        Module module = (Module)grammar.modules.get(0);
        HashSet<ModuleName> hashSet = new HashSet<ModuleName>();
        HashMap hashMap = new HashMap();
        hashSet.add(module.name);
        this.analyzer.trace(module, hashSet, hashMap);
        Iterator iterator = grammar.modules.iterator();
        while (iterator.hasNext()) {
            object2 = (Module)iterator.next();
            if (hashSet.contains(((Module)object2).name) || hashMap.containsKey(((Module)object2).name)) continue;
            if (Rats.optionVerbose) {
                System.err.println("[Unloading unused module " + ((Module)object2).name + "]");
            }
            this.analyzer.remove((Module)object2);
            iterator.remove();
        }
        if (0 != hashMap.size()) {
            Object object3;
            object2 = new ArrayList();
            HashSet<Object> hashSet2 = new HashSet<Object>();
            HashSet<Object> hashSet3 = new HashSet<Object>();
            HashMap<NonTerminal, Node> hashMap2 = new HashMap<NonTerminal, Node>();
            HashMap<NonTerminal, Node> hashMap3 = new HashMap<NonTerminal, Node>();
            while (true) {
                object2.clear();
                object = null;
                iterator = grammar.modules.iterator();
                while (iterator.hasNext()) {
                    object3 = (Module)iterator.next();
                    if (null == ((Module)object3).modification || hashSet2.contains(object3)) continue;
                    do {
                        object2.add(object3);
                        object3 = this.analyzer.lookup(((Module)object3).modification.visibleName());
                    } while (null != ((Module)object3).modification);
                    object = object3;
                    if (!hashSet2.contains(object)) break;
                    hashSet2.addAll((Collection<Object>)object2);
                    object = null;
                    break;
                }
                if (null == object) break;
                object3 = object;
                for (int i = object2.size() - 1; i >= 0; --i) {
                    Object object4;
                    Node node;
                    Module module2 = (Module)object2.get(i);
                    if (Rats.optionVerbose) {
                        System.err.println("[Applying module " + module2.name + " to module " + ((Module)object3).name + "]");
                    }
                    if (((Boolean)hashMap.get(((Module)object3).name)).booleanValue() || hashMap.containsKey(((Module)object3).name) && hashSet.contains(((Module)object3).name)) {
                        if (Rats.optionVerbose) {
                            System.err.println("[Copying modified module " + ((Module)object3).name + "]");
                        }
                        object3 = this.analyzer.copy((Module)object3);
                    } else {
                        if (Rats.optionVerbose) {
                            System.err.println("[Removing modified module " + ((Module)object3).name + "]");
                        }
                        this.analyzer.remove((Module)object3);
                        grammar.remove((Module)object3);
                    }
                    if (Rats.optionVerbose) {
                        System.err.println("[Removing modifying module " + module2.name + "]");
                    }
                    this.analyzer.remove(module2);
                    grammar.replace(module2, (Module)object3);
                    this.rename((Module)object3, new ModuleMap(((Module)object3).name, module2.name));
                    ((Module)object3).documentation = module2.documentation;
                    ((Module)object3).name = module2.name;
                    ((Node)object3).removeProperty("xtc.Constants.Arguments");
                    if (module2.hasProperty("xtc.Constants.Arguments")) {
                        ((Node)object3).setProperty("xtc.Constants.Arguments", module2.getProperty("xtc.Constants.Arguments"));
                    }
                    Iterator iterator2 = module2.dependencies.iterator();
                    while (iterator2.hasNext()) {
                        if (!((ModuleDependency)iterator2.next()).isModification()) continue;
                        iterator2.remove();
                    }
                    if (null == ((Module)object3).dependencies) {
                        ((Module)object3).dependencies = module2.dependencies;
                    } else {
                        ((Module)object3).dependencies.addAll(module2.dependencies);
                    }
                    if (null != module2.header) {
                        if (null == ((Module)object3).header) {
                            ((Module)object3).header = module2.header;
                        } else {
                            ((Module)object3).header.add(module2.header);
                        }
                    }
                    if (null != module2.body) {
                        if (null == ((Module)object3).body) {
                            ((Module)object3).body = module2.body;
                        } else {
                            ((Module)object3).body.add(module2.body);
                        }
                    }
                    if (null != module2.footer) {
                        if (null == ((Module)object3).footer) {
                            ((Module)object3).footer = module2.footer;
                        } else {
                            ((Module)object3).footer.add(module2.footer);
                        }
                    }
                    if (null != ((Module)object3).attributes) {
                        if (((Module)object3).hasAttribute(Constants.ATT_STATEFUL.name)) {
                            if (null == module2.attributes) {
                                module2.attributes = new AttributeList();
                            }
                            if (!module2.hasAttribute(Constants.ATT_STATEFUL.name)) {
                                module2.attributes.add(((Module)object3).attributes.get(Constants.ATT_STATEFUL.name));
                            }
                        }
                        if (((Module)object3).hasAttribute(Constants.ATT_RESERVED.name) || ((Module)object3).hasAttribute(Constants.ATT_FLAG.name)) {
                            if (null == module2.attributes) {
                                module2.attributes = new AttributeList();
                            }
                            iterator2 = ((Module)object3).attributes.iterator();
                            while (iterator2.hasNext()) {
                                node = (Attribute)iterator2.next();
                                if (!Constants.ATT_RESERVED.name.equals(((Attribute)node).name) && !Constants.ATT_FLAG.name.equals(((Attribute)node).name) || module2.attributes.contains(node)) continue;
                                module2.attributes.add(node);
                            }
                        }
                    }
                    ((Module)object3).attributes = module2.attributes;
                    hashMap2.clear();
                    hashMap3.clear();
                    iterator2 = ((Module)object3).productions.iterator();
                    while (iterator2.hasNext()) {
                        node = this.strip((Production)iterator2.next());
                        if (!((Production)node).isFull() || hashMap3.containsKey(((Production)node).name)) continue;
                        hashMap2.put(((Production)node).name, node);
                        hashMap3.put(((Production)node).name, node);
                    }
                    iterator2 = module2.productions.iterator();
                    while (iterator2.hasNext()) {
                        node = this.strip((Production)iterator2.next());
                        if (!((Production)node).isFull() || hashMap3.containsKey(((Production)node).name)) continue;
                        hashMap3.put(((Production)node).name, node);
                    }
                    boolean bl = this.error;
                    this.error = false;
                    iterator2 = module2.productions.iterator();
                    while (iterator2.hasNext()) {
                        object4 = (Production)iterator2.next();
                        FullProduction fullProduction = (FullProduction)hashMap3.get(((Production)object4).name);
                        if (((Production)object4).isFull()) {
                            if (hashMap2.containsKey(((Production)object4).name)) continue;
                            ((Module)object3).productions.add(object4);
                            hashMap2.put(((Production)object4).name, (Node)object4);
                            continue;
                        }
                        if (null == fullProduction) continue;
                        if (((Production)object4).isAddition()) {
                            this.apply((AlternativeAddition)object4, fullProduction);
                            continue;
                        }
                        if (((Production)object4).isRemoval()) {
                            this.apply((AlternativeRemoval)object4, fullProduction);
                            continue;
                        }
                        if (((Production)object4).isOverride()) {
                            this.apply((ProductionOverride)object4, fullProduction);
                            continue;
                        }
                        throw new AssertionError((Object)("Unrecognized production " + object4));
                    }
                    if (Rats.optionVerbose) {
                        System.err.println("[Adding resulting module " + ((Module)object3).name + "]");
                    }
                    this.analyzer.add((Module)object3);
                    hashSet3.add(object3);
                    this.analyzer.process((Module)object3);
                    iterator2 = ((Module)object3).productions.iterator();
                    while (iterator2.hasNext()) {
                        this.sequenceNames.clear();
                        this.analyzer.process((Production)iterator2.next());
                    }
                    if (this.error) {
                        hashSet2.add(object3);
                        object4 = object2.subList(0, i);
                        hashSet2.addAll((Collection<Object>)object4);
                        hashSet3.addAll((Collection<Object>)object4);
                    }
                    this.error = this.error || bl;
                }
                module = (Module)grammar.modules.get(0);
                hashSet.clear();
                hashMap.clear();
                hashSet.add(module.name);
                this.analyzer.trace(module, hashSet, hashMap);
            }
            this.phase = 3;
            iterator = grammar.modules.iterator();
            while (iterator.hasNext()) {
                object3 = (Module)iterator.next();
                if (hashSet3.contains(object3)) continue;
                this.analyzer.process((Module)object3);
                Iterator iterator3 = ((Module)object3).productions.iterator();
                while (iterator3.hasNext()) {
                    this.analyzer.process((Production)iterator3.next());
                }
            }
        }
        if (Rats.optionApplied) {
            if (Rats.optionHtml) {
                new HtmlPrinter(this.analyzer, Rats.dirOut).dispatch(grammar);
            } else {
                object2 = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
                object = new PrettyPrinter(new Printer((PrintWriter)object2));
                ((Visitor)object).dispatch(grammar);
                ((PrettyPrinter)object).flush();
            }
        }
    }

    protected void checkRecursions(Grammar grammar) {
        new TextTester(this.analyzer).dispatch(grammar);
        LeftRecurser leftRecurser = new LeftRecurser(this.analyzer);
        leftRecurser.dispatch(grammar);
        Set set = leftRecurser.recursive();
        Iterator iterator = grammar.modules.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            Iterator iterator2 = module.productions.iterator();
            while (iterator2.hasNext()) {
                Production production = (Production)iterator2.next();
                if (!set.contains(production.qName)) continue;
                this.error("left-recursive definition for nonterminal " + production.name, production);
            }
        }
    }

    protected Module combine(Grammar grammar, AttributeList attributeList) {
        Module module;
        Object object;
        Object object2;
        Module module2 = (Module)grammar.modules.get(0);
        module2.dependencies = null;
        module2.modification = null;
        if (0 < attributeList.size()) {
            if (null == module2.attributes) {
                module2.attributes = attributeList;
            } else {
                object2 = attributeList.iterator();
                while (object2.hasNext()) {
                    object = (Attribute)object2.next();
                    if (module2.attributes.contains(object)) continue;
                    module2.attributes.add(object);
                }
            }
        }
        object2 = new ArrayList();
        object = new ArrayList();
        ArrayList<Action> arrayList = new ArrayList<Action>();
        Iterator iterator = grammar.modules.iterator();
        while (iterator.hasNext()) {
            module = (Module)iterator.next();
            if (null != module.header && !object2.contains(module.header)) {
                object2.add(module.header);
            }
            if (null != module.body && !object.contains(module.body)) {
                object.add(module.body);
            }
            if (null == module.footer || arrayList.contains(module.footer)) continue;
            arrayList.add(module.footer);
        }
        module2.header = null;
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            if (null == module2.header) {
                module2.header = (Action)iterator.next();
                continue;
            }
            module2.header.add((Action)iterator.next());
        }
        module2.body = null;
        iterator = object.iterator();
        while (iterator.hasNext()) {
            if (null == module2.body) {
                module2.body = (Action)iterator.next();
                continue;
            }
            module2.body.add((Action)iterator.next());
        }
        module2.footer = null;
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (null == module2.footer) {
                module2.footer = (Action)iterator.next();
                continue;
            }
            module2.footer.add((Action)iterator.next());
        }
        iterator = grammar.modules.iterator();
        while (iterator.hasNext()) {
            module = (Module)iterator.next();
            if (module2 == module) continue;
            module2.productions.addAll(module.productions);
        }
        return module2;
    }

    public Object visit(Module module) {
        this.error = false;
        this.badNTs.clear();
        Grammar grammar = this.load(module);
        if (this.error || Rats.optionLoaded || Rats.optionInstantiated) {
            return null;
        }
        AttributeList attributeList = this.check(grammar);
        this.applyModifications(grammar);
        if (Rats.optionApplied) {
            return null;
        }
        this.checkRecursions(grammar);
        if (this.error) {
            return null;
        }
        this.analyzer.uniquify();
        return this.combine(grammar, attributeList);
    }

    public void visit(Production production) {
        if (1 == this.phase) {
            if (Type.isPrimitive(production.type)) {
                this.error("primitive type " + production.type + " for production " + production.name, production);
            } else if (Constants.ATT_PUBLIC.name.equals(production.type) || Constants.ATT_PROTECTED.name.equals(production.type) || Constants.ATT_PRIVATE.name.equals(production.type) || Constants.ATT_TRANSIENT.name.equals(production.type)) {
                this.error("attribute " + production.type + " as type for production " + production.name, production);
            } else if ((Constants.ATT_WITH_LOCATION.name.equals(production.type) || Constants.ATT_CONSTANT.name.equals(production.type) || Constants.ATT_VERBOSE.name.equals(production.type) || Constants.ATT_IGNORING_CASE.name.equals(production.type) || Constants.ATT_STATEFUL.name.equals(production.type) || Constants.ATT_RESETTING.name.equals(production.type)) && !production.isPartial()) {
                this.warning("attribute " + production.type + " as type for production " + production.name, production);
            }
            if (production.isPartial()) {
                if (!this.isMofunctor) {
                    this.error("production modification " + production.name + " without modifies " + "declaration", production);
                } else {
                    FullProduction fullProduction = null;
                    try {
                        fullProduction = this.analyzer.lookup(production.name);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (null == fullProduction || !this.analyzer.isDefined(fullProduction, this.analyzer.currentModule())) {
                        this.error("production modification " + production.name + " without full production", production);
                    } else if (!production.type.equals(fullProduction.type)) {
                        this.error("production modification " + production.name + "'s type " + production.type + " does not match full production's type " + fullProduction.type, production);
                    }
                }
            }
            if (null != production.attributes) {
                int n = production.attributes.size();
                block2: for (int i = 0; i < n; ++i) {
                    Attribute attribute = (Attribute)production.attributes.get(i);
                    if (!(Constants.ATT_PUBLIC.equals(attribute) || Constants.ATT_PROTECTED.equals(attribute) || Constants.ATT_PRIVATE.equals(attribute) || Constants.ATT_TRANSIENT.equals(attribute) || Constants.ATT_WITH_LOCATION.equals(attribute) || Constants.ATT_CONSTANT.equals(attribute) || Constants.ATT_VERBOSE.equals(attribute) || Constants.ATT_IGNORING_CASE.equals(attribute) || Constants.ATT_STATEFUL.equals(attribute) || Constants.ATT_RESETTING.equals(attribute))) {
                        this.error("unrecognized per-production attribute " + attribute, attribute);
                        continue;
                    }
                    if (!this.hasState && Constants.ATT_STATEFUL.equals(attribute)) {
                        this.error("stateful attribute without grammar-wide stateful attribute", attribute);
                        continue;
                    }
                    if (!this.hasState && Constants.ATT_RESETTING.equals(attribute)) {
                        this.error("resetting attribute without grammar-wide stateful attribute", attribute);
                        continue;
                    }
                    for (int j = 0; j < i; ++j) {
                        if (!attribute.equals(production.attributes.get(j))) continue;
                        this.error("duplicate attribute " + attribute.name, attribute);
                        continue block2;
                    }
                }
            }
        }
        this.dispatch(production.element);
    }

    public void visit(OrderedChoice orderedChoice) {
        Iterator iterator = orderedChoice.alternatives.iterator();
        while (iterator.hasNext()) {
            this.dispatch((Element)iterator.next());
        }
    }

    public void visit(Repetition repetition) {
        if (1 == this.phase && Analyzer.strip(repetition.element) instanceof Action) {
            this.error("repeated action", repetition);
        }
        this.dispatch(repetition.element);
    }

    public void visit(Option option) {
        if (1 == this.phase && Analyzer.strip(option.element) instanceof Action) {
            this.error("optional action", option);
        }
        this.dispatch(option.element);
    }

    public void visit(Sequence sequence) {
        if ((1 == this.phase || 2 == this.phase) && null != sequence.name) {
            if (this.sequenceNames.contains(sequence.name)) {
                this.error("duplicate sequence name " + sequence.name, sequence);
            } else {
                this.sequenceNames.add(sequence.name);
            }
        }
        Iterator iterator = sequence.iterator();
        while (iterator.hasNext()) {
            this.dispatch((Element)iterator.next());
        }
    }

    public void visit(Predicate predicate) {
        if (1 == this.phase && this.isPredicate) {
            this.error("syntactic predicate within syntactic predicate", predicate);
        }
        boolean bl = this.isPredicate;
        this.isPredicate = true;
        this.dispatch(predicate.element);
        this.isPredicate = bl;
    }

    public void visit(SemanticPredicate semanticPredicate) {
        if (1 == this.phase) {
            if (!(semanticPredicate.element instanceof Action)) {
                this.error("malformed semantic predicate", semanticPredicate);
            } else {
                Action action = (Action)semanticPredicate.element;
                if (null == action.code || 0 >= action.code.size()) {
                    this.error("empty test for semantic predicate", semanticPredicate);
                }
            }
        }
        this.dispatch(semanticPredicate.element);
    }

    public void visit(VoidedElement voidedElement) {
        if (1 == this.phase) {
            Element element = Analyzer.strip(voidedElement.element);
            if (element instanceof Binding) {
                this.error("voided binding", voidedElement);
            } else if (element instanceof Action) {
                this.error("voided action", voidedElement);
            } else if (element instanceof ParserAction) {
                this.error("voided parser action", voidedElement);
            }
        }
        this.dispatch(voidedElement.element);
    }

    public void visit(Binding binding) {
        if (1 == this.phase) {
            Element element = Analyzer.strip(binding.element);
            if (element instanceof VoidedElement) {
                this.error("binding for voided element", binding);
            } else if (element instanceof NonTerminal) {
                NonTerminal nonTerminal = (NonTerminal)element;
                FullProduction fullProduction = null;
                try {
                    fullProduction = this.analyzer.lookup(nonTerminal);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (null != fullProduction && Type.isVoidT(fullProduction.type)) {
                    this.error("binding for void nonterminal " + nonTerminal, binding);
                }
            } else if (element instanceof Action) {
                this.error("binding for action", binding);
            } else if (element instanceof ParserAction) {
                this.error("binding for parser action", binding);
            }
        }
        this.dispatch(binding.element);
    }

    public void visit(StringMatch stringMatch) {
        if (1 == this.phase) {
            Element element = Analyzer.strip(stringMatch.element);
            if (element instanceof Sequence) {
                this.error("match for sequence", stringMatch);
            } else if (element instanceof VoidedElement) {
                this.error("match for voided element", stringMatch);
            } else if (element instanceof NonTerminal) {
                NonTerminal nonTerminal = (NonTerminal)element;
                FullProduction fullProduction = null;
                try {
                    fullProduction = this.analyzer.lookup(nonTerminal);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (null != fullProduction && Type.isVoidT(fullProduction.type)) {
                    this.error("match for void nonterminal " + nonTerminal, stringMatch);
                }
            } else if (element instanceof Terminal) {
                this.error("match for terminal", stringMatch);
            } else if (element instanceof Action) {
                this.error("match for action", stringMatch);
            } else if (element instanceof ParserAction) {
                this.error("match for parser action", stringMatch);
            }
        }
        this.dispatch(stringMatch.element);
    }

    public void visit(NonTerminal nonTerminal) {
        FullProduction fullProduction = null;
        try {
            fullProduction = this.analyzer.lookup(nonTerminal);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (nonTerminal.hasProperty("xtc.Constants.Original")) {
                if (!this.badNTs.containsKey(nonTerminal)) {
                    this.error("ambiguous renamed nonterminal " + nonTerminal, nonTerminal);
                    this.badNTs.put(nonTerminal, nonTerminal);
                }
            } else if (!this.badNTs.containsKey(nonTerminal)) {
                this.error("ambiguous nonterminal " + nonTerminal, nonTerminal);
                this.badNTs.put(nonTerminal, nonTerminal);
            }
            return;
        }
        if (null == fullProduction) {
            if (nonTerminal.hasProperty("xtc.Constants.Original")) {
                if (!this.badNTs.containsKey(nonTerminal)) {
                    this.error("undefined renamed nonterminal " + nonTerminal, nonTerminal);
                    this.badNTs.put(nonTerminal, nonTerminal);
                }
            } else if (!this.badNTs.containsKey(nonTerminal)) {
                this.error("undefined nonterminal " + nonTerminal, nonTerminal);
                this.badNTs.put(nonTerminal, nonTerminal);
            }
        }
    }

    public void visit(Terminal terminal) {
    }

    public void visit(StringLiteral stringLiteral) {
        if (1 == this.phase && 0 == stringLiteral.text.length()) {
            this.error("empty string literal", stringLiteral);
        }
    }

    public void visit(CharClass charClass) {
        if (1 != this.phase) {
            return;
        }
        int n = charClass.ranges.size();
        if (0 >= n) {
            this.error("empty character class", charClass);
        } else {
            ArrayList arrayList = new ArrayList(charClass.ranges);
            Collections.sort(arrayList);
            for (int i = 0; i < n - 1; ++i) {
                boolean bl;
                CharRange charRange = (CharRange)arrayList.get(i);
                CharRange charRange2 = (CharRange)arrayList.get(i + 1);
                if (charRange.last < charRange2.first) continue;
                boolean bl2 = charRange.first == charRange.last;
                boolean bl3 = bl = charRange2.first == charRange2.last;
                if (bl2) {
                    if (bl) {
                        this.error("duplicate character '" + Utilities.escape(charRange.last, 12) + "' in character class", charClass);
                        continue;
                    }
                    this.error("character '" + Utilities.escape(charRange.last, 12) + "' already contained in range " + Utilities.escape(charRange2.first, 12) + "-" + Utilities.escape(charRange2.last, 12), charClass);
                    continue;
                }
                if (bl) {
                    this.error("character '" + Utilities.escape(charRange2.first, 12) + "' already contained in range " + Utilities.escape(charRange.first, 12) + "-" + Utilities.escape(charRange.last, 12), charClass);
                    continue;
                }
                this.error("ranges " + Utilities.escape(charRange.first, 12) + "-" + Utilities.escape(charRange.last, 12) + " and " + Utilities.escape(charRange2.first, 12) + "-" + Utilities.escape(charRange2.last, 12) + " overlap", charClass);
            }
        }
    }

    public void visit(Action action) {
    }

    public void visit(ParserAction parserAction) {
        if (1 == this.phase) {
            if (!(parserAction.element instanceof Action)) {
                this.error("malformed parser action", parserAction);
            }
            if (this.isPredicate) {
                this.error("parser action within syntactic predicate", parserAction);
            }
        }
        this.dispatch(parserAction.element);
    }

    public void visit(InternalElement internalElement) {
        if (1 == this.phase) {
            this.error("internal element", (Element)((Object)internalElement));
        }
    }
}

