/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.Rats;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.UnaryOperator;
import xtc.parser.VoidedElement;
import xtc.tree.Visitor;

public class LeftRecurser
extends Visitor {
    protected final Analyzer analyzer;
    protected Iterator elementIter;
    protected boolean terminated;

    public LeftRecurser(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Set recursive() {
        return new HashSet(this.analyzer.marked());
    }

    public void visit(Grammar grammar) {
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        Iterator iterator = grammar.modules.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            this.analyzer.process(module);
            Iterator iterator2 = module.productions.iterator();
            while (iterator2.hasNext()) {
                Production production = (Production)iterator2.next();
                if (!production.isFull() || this.analyzer.isProcessed(production.qName)) continue;
                this.terminated = false;
                this.analyzer.process(production);
            }
        }
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        Iterator iterator = module.productions.iterator();
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            if (this.analyzer.isProcessed(production.qName)) continue;
            this.terminated = false;
            this.analyzer.process(production);
        }
    }

    public void visit(FullProduction fullProduction) {
        Object object = this.analyzer.enter(fullProduction);
        this.analyzer.workingOn(fullProduction.qName);
        if ((Rats.optimizeLeftRecursions || Rats.optimizeLeftIterations) && DirectLeftRecurser.isTransformable(fullProduction)) {
            Iterator iterator = ((OrderedChoice)fullProduction.element).alternatives.iterator();
            while (iterator.hasNext()) {
                Sequence sequence = (Sequence)iterator.next();
                if (!DirectLeftRecurser.isBase(sequence, fullProduction)) continue;
                this.dispatch(sequence);
            }
        } else {
            this.dispatch(fullProduction.element);
        }
        this.analyzer.notWorkingOn(fullProduction.qName);
        this.analyzer.processed(fullProduction.qName);
        this.analyzer.exit(object);
    }

    public void visit(OrderedChoice orderedChoice) {
        boolean bl = false;
        Iterator iterator = orderedChoice.alternatives.iterator();
        while (iterator.hasNext()) {
            this.terminated = false;
            this.dispatch((Element)iterator.next());
            if (this.terminated) continue;
            bl = true;
        }
        if (bl) {
            this.terminated = false;
        }
    }

    public void visit(Repetition repetition) {
        this.dispatch(repetition.element);
        if (!repetition.once) {
            this.terminated = false;
        }
    }

    public void visit(Sequence sequence) {
        Iterator iterator = sequence.iterator();
        while (iterator.hasNext()) {
            this.dispatch((Element)iterator.next());
            if (!this.terminated) continue;
            break;
        }
    }

    public void visit(VoidedElement voidedElement) {
        this.dispatch(voidedElement.element);
    }

    public void visit(Binding binding) {
        this.dispatch(binding.element);
    }

    public void visit(StringMatch stringMatch) {
        this.dispatch(stringMatch.element);
    }

    public void visit(NonTerminal nonTerminal) {
        FullProduction fullProduction;
        try {
            fullProduction = this.analyzer.lookup(nonTerminal);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.terminated = true;
            return;
        }
        if (null != fullProduction) {
            if (this.analyzer.isProcessed(fullProduction.qName)) {
                this.terminated = true;
            } else if (this.analyzer.isBeingWorkedOn(fullProduction.qName)) {
                this.analyzer.mark(fullProduction.qName);
                this.terminated = true;
            } else {
                this.dispatch(fullProduction);
            }
        } else {
            this.terminated = true;
        }
    }

    public void visit(Terminal terminal) {
        this.terminated = true;
    }

    public void visit(UnaryOperator unaryOperator) {
        this.dispatch(unaryOperator.element);
        this.terminated = false;
    }

    public void visit(ParserAction parserAction) {
        this.dispatch(parserAction.element);
        this.terminated = true;
    }

    public void visit(Element element) {
    }
}

