/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.ModuleDependency;
import xtc.parser.ModuleName;
import xtc.parser.NonTerminal;
import xtc.parser.PrettyPrinter;
import xtc.parser.Production;
import xtc.parser.SequenceName;
import xtc.tree.Attribute;
import xtc.tree.Comment;
import xtc.tree.Printer;
import xtc.tree.VisitingException;

public class HtmlPrinter
extends PrettyPrinter {
    protected final Analyzer analyzer;
    protected final File dirOut;
    protected boolean isGrammar;
    protected int pNumber = -1;

    public HtmlPrinter(Analyzer analyzer, File file) {
        this.analyzer = analyzer;
        this.dirOut = file;
    }

    protected int stringEscapes() {
        return 24;
    }

    protected int regexEscapes() {
        return 28;
    }

    protected void open(String string) throws IOException {
        this.printer = new Printer(new PrintWriter(new BufferedWriter(new FileWriter(new File(this.dirOut, string)))));
    }

    protected void printDocumentation(Module module) {
        Comment comment = module.documentation;
        if (null == comment || 0 == comment.text.size()) {
            return;
        }
        this.printer.indent().pln("<div class=\"module-documentation\">");
        ArrayList<String> arrayList = null;
        String string = null;
        Iterator iterator = comment.text.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.startsWith("@")) {
                if (string2.startsWith("@author ")) {
                    if (null == arrayList) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(string2.substring(8));
                    continue;
                }
                if (!string2.startsWith("@version ")) continue;
                string = string2.substring(9);
                continue;
            }
            this.printer.indent().pln(string2);
        }
        if (null != arrayList || null != string) {
            this.printer.indent().pln("<dl>");
            if (null != arrayList) {
                if (1 == arrayList.size()) {
                    this.printer.indent().pln("<dt>Author:</dt>").incr();
                } else {
                    this.printer.indent().pln("<dt>Authors:</dt>").incr();
                }
                this.printer.indent().p("<dd>");
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    this.printer.p((String)iterator.next());
                    if (!iterator.hasNext()) continue;
                    this.printer.p(", ");
                }
                this.printer.pln("</dd>").decr();
            }
            if (null != string) {
                this.printer.indent().pln("<dt>Version:</dt>").incr();
                this.printer.indent().p("<dd>").p(string).pln("</dd>").decr();
            }
            this.printer.indent().pln("</dl>");
        }
        this.printer.indent().pln("</div>");
    }

    protected void printOption(Module module) {
        if (null != module.attributes && 0 < module.attributes.size()) {
            this.printer.pln().indent().p("option ");
            boolean bl = true;
            Iterator iterator = module.attributes.iterator();
            while (iterator.hasNext()) {
                int n;
                boolean bl2;
                Attribute attribute = (Attribute)iterator.next();
                String string = attribute.toString();
                boolean bl3 = bl2 = this.analyzer.isTopLevel(module) || Constants.ATT_STATEFUL.name.equals(attribute.name) || Constants.ATT_RESERVED.name.equals(attribute.name) || Constants.ATT_FLAG.name.equals(attribute.name);
                if (bl) {
                    bl = false;
                } else if (this.printer.column() + string.length() + 1 > 78) {
                    this.printer.pln().indentMore();
                }
                if (bl2) {
                    n = this.printer.column();
                    this.printer.p("<span class=\"highlight\">").column(n);
                }
                this.printer.p(string);
                if (bl2) {
                    n = this.printer.column();
                    this.printer.p("</span>").column(n);
                }
                if (iterator.hasNext()) {
                    this.printer.p(", ");
                    continue;
                }
                this.printer.p(';');
            }
            this.printer.pln();
        }
    }

    protected void print(Module module) {
        this.printer.indent().pln("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"");
        this.printer.indent().p("                      ").pln("\"http://www.w3.org/TR/html4/strict.dtd\">");
        this.printer.indent().pln("<html>");
        this.printer.indent().pln("<head>");
        this.printer.indent().p("<!-- Generated by Rats!, version ").p("1.7.1").p(", ").p("(C) 2004-2005 Robert Grimm").pln(" -->");
        this.printer.indent().p("<title>Module ").p(module.name).pln("</title>");
        this.printer.indent().p("<link rel=\"stylesheet\" href=\"grammar.css\" ").pln("type=\"text/css\">");
        this.printer.indent().pln("</head>");
        this.printer.indent().pln("<body>");
        this.printDocumentation(module);
        this.printer.indent().pln("<pre class=\"module-header\">");
        this.printModule(module);
        if (null != module.dependencies && 0 < module.dependencies.size()) {
            this.printer.pln();
            Iterator iterator = module.dependencies.iterator();
            while (iterator.hasNext()) {
                this.printer.p((ModuleDependency)iterator.next());
            }
        }
        this.printActions(module);
        this.printOption(module);
        this.printer.indent().pln("</pre>");
        int n = module.productions.size();
        for (int i = 0; i < n; ++i) {
            this.pNumber = i;
            this.printer.p((Production)module.productions.get(i));
        }
        this.printer.indent().pln("</body>");
    }

    public void visit(Grammar grammar) {
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        this.isGrammar = true;
        Iterator iterator = grammar.modules.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            try {
                this.open(module.name + ".html");
            }
            catch (IOException iOException) {
                throw new VisitingException("Unable to access " + module.name + ".html", iOException);
            }
            this.printer.register(this);
            this.analyzer.process(module);
            this.print(module);
            this.printer.flush();
        }
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        this.isGrammar = false;
        try {
            this.open(module.name + ".html");
        }
        catch (IOException iOException) {
            throw new VisitingException("Unable to access " + module.name + ".html", iOException);
        }
        this.printer.register(this);
        this.print(module);
        this.printer.flush();
    }

    protected void print(ModuleName moduleName, boolean bl) {
        int n;
        if (bl) {
            n = this.printer.column();
            this.printer.p("<a href=\"").p(moduleName.name).p(".html\">").column(n).p(moduleName.name);
        } else {
            n = this.printer.column();
            this.printer.p("<a class=\"erroneous\" href=\"#\" title=\"Undefined module\">").column(n).p(moduleName.name);
        }
        n = this.printer.column();
        this.printer.p("</a>").column(n);
    }

    protected void print(ModuleDependency moduleDependency, String string) {
        Module module = this.analyzer.lookup(moduleDependency.visibleName());
        this.printer.indent().p(string).p(' ');
        if (!(null != moduleDependency.target || null == module && "instantiate".equals(string))) {
            this.print(moduleDependency.module, null != module);
        } else {
            this.printer.p(moduleDependency.module);
        }
        if (0 != moduleDependency.arguments.length()) {
            this.printer.p(moduleDependency.arguments);
        }
        if (!(null == moduleDependency.target || null == module && "instantiate".equals(string))) {
            this.print(moduleDependency.target, null != module);
        } else {
            this.printer.p(moduleDependency.target);
        }
        this.printer.pln(';');
    }

    protected void enter(Production production) {
        Object object;
        Object object2;
        Object object3;
        if (production.hasProperty("xtc.parser.DuplicateProductionFolder.Duplicates")) {
            object3 = (List)production.getProperty("xtc.parser.DuplicateProductionFolder.Duplicates");
            this.printer.indent().pln("<div class=\"production-documentation\">");
            this.printer.indent().p("The following production is the result of ").p("folding duplicates ");
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                this.printer.buffer();
                if (1 < object3.size() && !object2.hasNext()) {
                    this.printer.p("and ");
                }
                this.printer.p((String)object);
                if (2 == object3.size() && object2.hasNext()) {
                    this.printer.p(' ');
                } else if (object2.hasNext()) {
                    this.printer.p(", ");
                } else {
                    this.printer.p('.');
                }
                this.printer.fit();
            }
            this.printer.pln();
            this.printer.indent().pln("</div>");
        }
        this.printer.indent().pln("<pre class=\"production-body\">");
        this.printer.indent();
        if (production.isFull()) {
            this.printer.p("<a name=\"").p(production.name.name).p("\"></a>");
        } else {
            this.printer.p("<a name=\"").p(production.name.name).p('-').p(this.pNumber).p("\"></a>");
        }
        if (null != production.attributes && 0 < production.attributes.size()) {
            object3 = production.attributes.iterator();
            while (object3.hasNext()) {
                this.printer.p((Attribute)object3.next()).p(' ');
            }
        }
        this.printer.p(production.type).p(' ');
        if (production.isPartial()) {
            boolean bl = false;
            object2 = null;
            try {
                object2 = this.analyzer.lookup(production.name.qualify(this.analyzer.currentModule().name.name));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = true;
            }
            if (null == object2) {
                this.printer.p("<a class=\"erroneous\" href=\"#\" title=\"");
                if (bl) {
                    this.printer.p("Ambiguous nonterminal");
                } else {
                    this.printer.p("Undefined nonterminal");
                }
            } else {
                object = this.analyzer.currentModule();
                String string = ((Production)object2).qName.getQualifier();
                if (string.equals(((Module)object).name.name)) {
                    this.printer.p("<a href=\"#").p(production.name.name);
                } else {
                    this.printer.p("<a href=\"").p(string).p(".html#").p(production.name.name);
                }
            }
            this.printer.p("\">").p(production.name.name).p("</a>");
        } else {
            this.printer.p(production.name.name);
        }
        this.parenChoice = false;
        this.parenSequence = false;
    }

    protected void exit(Production production) {
        this.printer.indent().pln("</pre>");
    }

    public void visit(SequenceName sequenceName) {
        this.printer.p("&lt;").p(sequenceName.name).p("&gt;");
        this.printer.column(this.printer.column() - 6);
    }

    public void visit(NonTerminal nonTerminal) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer();
        int n = this.printer.column();
        boolean bl = false;
        FullProduction fullProduction = null;
        try {
            fullProduction = this.analyzer.lookup(nonTerminal);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        if (null == fullProduction) {
            this.printer.p("<a class=\"erroneous\" href=\"#\" title=\"");
            if (bl) {
                this.printer.p("Ambiguous nonterminal");
            } else {
                this.printer.p("Undefined nonterminal");
            }
        } else if (this.isGrammar) {
            Module module = this.analyzer.currentModule();
            String string = fullProduction.qName.getQualifier();
            if (string.equals(module.name.name)) {
                this.printer.p("<a href=\"#").p(fullProduction.name.name);
            } else {
                this.printer.p("<a href=\"").p(string).p(".html#").p(fullProduction.name.name);
            }
        } else {
            this.printer.p("<a href=\"#").p(nonTerminal.name);
        }
        this.printer.p("\">").column(n).p(nonTerminal.name);
        n = this.printer.column();
        this.printer.p("</a>").column(n).fit();
    }

    protected void print(String string) {
        int n = this.printer.column();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                this.printer.p("&lt;");
                continue;
            }
            if ('>' == c) {
                this.printer.p("&gt;");
                continue;
            }
            this.printer.p(c);
        }
        this.printer.column(n + n2);
    }
}

