/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import xtc.Constants;
import xtc.parser.ActionBaseValue;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FullProduction;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.Generifier;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.NullValue;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.Rats;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.TextTester;
import xtc.parser.TextValue;
import xtc.parser.Type;
import xtc.tree.AttributeList;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.util.Utilities;

public class DirectLeftRecurser
extends Visitor {
    public static final String RECURSIVE = "xtc.parser.DirectLeftRecurser.Recursive";
    public static final String TRANSFORMABLE = "xtc.parser.DirectLeftRecurser.Transformable";
    public static final int STATE_RECURSION = 1;
    public static final int STATE_BASE = 2;
    protected final Analyzer analyzer;
    protected boolean isVoid;
    protected boolean isTextOnly;
    protected boolean isGeneric;
    protected boolean error;
    protected boolean attConstant;
    protected int state;
    protected boolean isTopLevel;
    protected boolean seenChoice;
    protected List children;
    protected FullProduction pTail;
    protected String varSeed;
    protected String varAction;

    public DirectLeftRecurser(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.children = new ArrayList();
    }

    protected void error(String string, Node node) {
        Utilities.msg(string, node.location, this.analyzer.current().qName.name, null);
        Rats.error();
        this.error = true;
    }

    protected Binding bind(Element element) {
        Binding binding = new Binding(this.analyzer.variable("g"), element);
        this.children.add(binding);
        return binding;
    }

    public Boolean visit(Module module) {
        if (!Rats.optimizeLeftRecursions && !Rats.optimizeLeftIterations) {
            return Boolean.FALSE;
        }
        this.analyzer.register(this);
        this.analyzer.init(module);
        this.error = false;
        this.attConstant = module.hasAttribute(Constants.ATT_CONSTANT);
        for (int i = 0; i < module.productions.size(); ++i) {
            FullProduction fullProduction = (FullProduction)module.productions.get(i);
            if (!DirectLeftRecurser.isTransformable(fullProduction)) continue;
            if (Rats.optionVerbose) {
                System.err.println("[Transforming left-recursion in " + fullProduction.qName + "]");
            }
            this.analyzer.startAdding();
            this.analyzer.process(fullProduction);
            i += this.analyzer.addNewProductionsAt(i + 1);
            fullProduction.removeProperty(TRANSFORMABLE);
        }
        return this.error ? Boolean.TRUE : Boolean.FALSE;
    }

    public void visit(FullProduction fullProduction) {
        this.isVoid = Type.isVoidT(fullProduction.type);
        this.isTextOnly = TextTester.isTextOnly(fullProduction);
        this.isGeneric = Type.isGenericT(fullProduction.type);
        this.isTopLevel = true;
        this.seenChoice = false;
        this.children.clear();
        this.varSeed = null;
        this.varAction = null;
        AttributeList attributeList = new AttributeList((Collection)fullProduction.attributes);
        attributeList.remove(Constants.ATT_STATEFUL);
        attributeList.remove(Constants.ATT_RESETTING);
        if (this.isGeneric && !attributeList.contains(Constants.ATT_CONSTANT) && !this.attConstant) {
            attributeList.add(Constants.ATT_CONSTANT);
        }
        if (Rats.optimizeLeftIterations && !attributeList.contains(Constants.ATT_TRANSIENT)) {
            attributeList.add(Constants.ATT_TRANSIENT);
        }
        String string = null;
        string = this.isGeneric ? (Rats.optimizeLeftIterations ? Type.actionT() : Type.listT()) : Type.voidT();
        this.pTail = new FullProduction(attributeList, string, this.analyzer.tail(), new OrderedChoice());
        this.pTail.qName = this.pTail.name.qualify(this.analyzer.module().name.name);
        if (this.isGeneric) {
            this.varAction = this.analyzer.variable();
        }
        fullProduction.element = (Element)this.dispatch(fullProduction.element);
        if (this.isGeneric) {
            fullProduction.type = Type.genericNodeT();
        }
        if (!Rats.optimizeLeftIterations) {
            Sequence sequence = new Sequence();
            if (this.isGeneric) {
                sequence.add(EmptyListValue.VALUE);
            } else {
                sequence.add(NullValue.VALUE);
            }
            ((OrderedChoice)this.pTail.element).alternatives.add(sequence);
        }
        if (!Rats.optimizeLeftIterations || !this.isVoid && !this.isTextOnly) {
            this.analyzer.add(this.pTail);
        }
        if (this.isGeneric) {
            Generifier.markGenericRecursion((FullProduction)this.analyzer.current());
        }
    }

    public Element visit(OrderedChoice orderedChoice) {
        boolean bl = this.isTopLevel;
        this.isTopLevel = false;
        for (int i = 0; i < orderedChoice.alternatives.size(); ++i) {
            Element element = (Element)orderedChoice.alternatives.get(i);
            if (bl) {
                Sequence sequence = (Sequence)element;
                if (DirectLeftRecurser.isRecursive(sequence, (FullProduction)this.analyzer.current())) {
                    this.state = 1;
                    sequence.elements.remove(0);
                    orderedChoice.alternatives.remove(i);
                    --i;
                    ((OrderedChoice)this.pTail.element).alternatives.add(this.dispatch(sequence));
                    continue;
                }
                this.state = 2;
                if (this.isGeneric) {
                    Binding binding = this.analyzer.getBinding("yyValue", sequence);
                    if (null == binding) {
                        binding = this.analyzer.bind(sequence, "g");
                        if (null == binding) {
                            this.error("unable to determine semantic value of sequence", sequence);
                            binding = new Binding("dummy", sequence);
                        }
                    } else {
                        binding.name = this.analyzer.variable();
                    }
                    this.varSeed = binding.name;
                }
                orderedChoice.alternatives.set(i, this.dispatch(sequence));
                continue;
            }
            orderedChoice.alternatives.set(i, this.dispatch(element));
        }
        this.seenChoice = true;
        return orderedChoice;
    }

    public Element visit(Repetition repetition) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(repetition);
        }
        return repetition;
    }

    public Element visit(Option option) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(option);
        }
        return option;
    }

    public Element visit(Sequence sequence) {
        this.isTopLevel = false;
        int n = this.children.size();
        int n2 = sequence.length();
        for (int i = 0; i < n2; ++i) {
            sequence.elements.set(i, this.dispatch(sequence.get(i)));
        }
        if (this.seenChoice) {
            this.seenChoice = false;
        } else if (1 == this.state) {
            if (Rats.optimizeLeftIterations) {
                if (this.isGeneric) {
                    sequence.add(new GenericActionValue(this.analyzer.current().name.unqualify().name, this.varAction, new ArrayList(this.children)));
                }
            } else if (this.isGeneric) {
                Binding binding = new Binding(this.analyzer.variable(), this.pTail.name);
                sequence.add(binding);
                sequence.add(new GenericRecursionValue(this.analyzer.current().name.unqualify().name, this.varAction, new ArrayList(this.children), binding.name));
            } else {
                sequence.add(this.pTail.name);
                sequence.add(NullValue.VALUE);
            }
        } else if (2 == this.state) {
            if (Rats.optimizeLeftIterations) {
                if (this.isGeneric) {
                    Binding binding = new Binding(this.analyzer.variable(), this.pTail.name);
                    Repetition repetition = new Repetition(false, new Sequence(binding));
                    Binding binding2 = new Binding(this.analyzer.variable(), repetition);
                    sequence.add(binding2).add(new ActionBaseValue(binding2.name, this.varSeed));
                } else {
                    Element element = this.analyzer.copy(Analyzer.strip(this.pTail.element));
                    sequence.add(new Repetition(false, Sequence.ensure(element)));
                    if (this.isTextOnly) {
                        sequence.add(TextValue.VALUE);
                    } else {
                        sequence.add(NullValue.VALUE);
                    }
                }
            } else if (this.isGeneric) {
                Binding binding = new Binding(this.analyzer.variable(), this.pTail.name);
                sequence.add(binding).add(new ActionBaseValue(binding.name, this.varSeed));
            } else if (this.isTextOnly) {
                sequence.add(this.pTail.name).add(TextValue.VALUE);
            } else {
                sequence.add(this.pTail.name).add(NullValue.VALUE);
            }
        } else {
            throw new IllegalStateException("Invalid state " + this.state);
        }
        if (this.isGeneric && 1 == this.state) {
            if (0 == n) {
                this.children.clear();
            } else {
                this.children.subList(n, this.children.size()).clear();
            }
        }
        return sequence;
    }

    public Element visit(Binding binding) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            if ("yyValue".equals(binding.name)) {
                this.error("illegal binding to yyValue in left-recursive sequence", binding);
            }
            this.children.add(binding.name);
        }
        return binding;
    }

    public Element visit(StringMatch stringMatch) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(stringMatch);
        }
        return stringMatch;
    }

    public Element visit(NonTerminal nonTerminal) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
            if (Type.isVoidT(fullProduction.type)) {
                return nonTerminal;
            }
            return this.bind(nonTerminal);
        }
        return nonTerminal;
    }

    public Element visit(StringLiteral stringLiteral) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(stringLiteral);
        }
        return stringLiteral;
    }

    public Element visit(Element element) {
        this.isTopLevel = false;
        return element;
    }

    public static boolean isTransformable(FullProduction fullProduction) {
        if (!(Type.isVoidT(fullProduction.type) || TextTester.isTextOnly(fullProduction) || Type.isGenericT(fullProduction.type))) {
            return false;
        }
        if (fullProduction.hasProperty(TRANSFORMABLE)) {
            return fullProduction.getBooleanProperty(TRANSFORMABLE);
        }
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = ((OrderedChoice)fullProduction.element).alternatives.iterator();
        while (iterator.hasNext()) {
            Sequence sequence = (Sequence)iterator.next();
            if (sequence.isEmpty()) {
                fullProduction.setProperty(TRANSFORMABLE, Boolean.FALSE);
                return false;
            }
            Element element = Analyzer.strip(sequence.get(0));
            if (fullProduction.name.equals(element) || fullProduction.qName.equals(element)) {
                if (!bl || !bl2) {
                    bl = true;
                    continue;
                }
                fullProduction.setProperty(TRANSFORMABLE, Boolean.FALSE);
                return false;
            }
            if (!bl) {
                fullProduction.setProperty(TRANSFORMABLE, Boolean.FALSE);
                return false;
            }
            bl2 = true;
        }
        if (bl && bl2) {
            fullProduction.setProperty(TRANSFORMABLE, Boolean.TRUE);
            return true;
        }
        fullProduction.setProperty(TRANSFORMABLE, Boolean.FALSE);
        return false;
    }

    public static boolean isRecursive(Sequence sequence, FullProduction fullProduction) {
        if (sequence.isEmpty()) {
            return false;
        }
        Element element = Analyzer.strip(sequence.get(0));
        return fullProduction.name.equals(element) || fullProduction.qName.equals(element);
    }

    public static boolean isBase(Sequence sequence, FullProduction fullProduction) {
        return !DirectLeftRecurser.isRecursive(sequence, fullProduction);
    }
}

