/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.Iterator;
import xtc.parser.Action;
import xtc.parser.ActionBaseValue;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.ProperListValue;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.SingletonListValue;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.TextValue;
import xtc.parser.ValueElement;
import xtc.parser.VoidedElement;
import xtc.tree.Visitor;

public class CostEstimator
extends Visitor {
    public static final String COST = "xtc.parser.CostEstimator.Cost";
    protected final Analyzer analyzer;

    public CostEstimator(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        Iterator iterator = module.productions.iterator();
        while (iterator.hasNext()) {
            ((Production)iterator.next()).removeProperty(COST);
        }
        iterator = module.productions.iterator();
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            if (production.hasProperty(COST)) continue;
            this.analyzer.process(production);
        }
    }

    public Integer visit(Production production) {
        this.analyzer.workingOn(production.qName);
        Integer n = (Integer)this.dispatch(production.element);
        this.analyzer.notWorkingOn(production.qName);
        production.setProperty(COST, n);
        return n;
    }

    public Integer visit(OrderedChoice orderedChoice) {
        int n = 0;
        Iterator iterator = orderedChoice.alternatives.iterator();
        while (iterator.hasNext()) {
            n = CostEstimator.add(n, CostEstimator.unbox(this.dispatch((Element)iterator.next())));
        }
        return CostEstimator.box(n);
    }

    public Integer visit(Repetition repetition) {
        return CostEstimator.box(Integer.MAX_VALUE);
    }

    public Integer visit(Option option) {
        return CostEstimator.box(CostEstimator.add(1, CostEstimator.unbox(this.dispatch(option.element))));
    }

    public Integer visit(Sequence sequence) {
        int n = 0;
        Iterator iterator = sequence.iterator();
        while (iterator.hasNext()) {
            n = CostEstimator.add(n, CostEstimator.unbox(this.dispatch((Element)iterator.next())));
        }
        return CostEstimator.box(n);
    }

    public Integer visit(Predicate predicate) {
        return CostEstimator.box(CostEstimator.add(1, CostEstimator.unbox(this.dispatch(predicate.element))));
    }

    public Integer visit(VoidedElement voidedElement) {
        return (Integer)this.dispatch(voidedElement.element);
    }

    public Integer visit(Binding binding) {
        return (Integer)this.dispatch(binding.element);
    }

    public Integer visit(StringMatch stringMatch) {
        return CostEstimator.box(CostEstimator.add(1, CostEstimator.unbox(this.dispatch(stringMatch.element))));
    }

    public Integer visit(NonTerminal nonTerminal) {
        FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
        if (this.analyzer.isBeingWorkedOn(fullProduction.qName)) {
            return CostEstimator.box(Integer.MAX_VALUE);
        }
        return CostEstimator.box(CostEstimator.add(1, CostEstimator.unbox(fullProduction.hasProperty(COST) ? fullProduction.getProperty(COST) : this.dispatch(fullProduction))));
    }

    public Integer visit(StringLiteral stringLiteral) {
        return CostEstimator.box(stringLiteral.text.length());
    }

    public Integer visit(CharCase charCase) {
        if (null == charCase.element) {
            return CostEstimator.box(0);
        }
        return (Integer)this.dispatch(charCase.element);
    }

    public Integer visit(CharSwitch charSwitch) {
        int n = 0;
        Iterator iterator = charSwitch.cases.iterator();
        while (iterator.hasNext()) {
            n = Math.max(n, CostEstimator.unbox(this.dispatch((Element)iterator.next())) + 1);
        }
        if (null == charSwitch.base) {
            n = Math.max(n, CostEstimator.unbox(this.dispatch(charSwitch.base)) + 1);
        }
        return CostEstimator.box(n);
    }

    public Integer visit(Terminal terminal) {
        return CostEstimator.box(1);
    }

    public Integer visit(Action action) {
        return CostEstimator.box(1);
    }

    public Integer visit(ParserAction parserAction) {
        return CostEstimator.box(Integer.MAX_VALUE);
    }

    public Integer visit(TextValue textValue) {
        return CostEstimator.box(1);
    }

    public Integer visit(SingletonListValue singletonListValue) {
        return CostEstimator.box(1);
    }

    public Integer visit(ProperListValue properListValue) {
        return CostEstimator.box(1);
    }

    public Integer visit(ActionBaseValue actionBaseValue) {
        return CostEstimator.box(Integer.MAX_VALUE);
    }

    public Integer visit(GenericNodeValue genericNodeValue) {
        return CostEstimator.box(2);
    }

    public Integer visit(GenericActionValue genericActionValue) {
        return CostEstimator.box(1);
    }

    public Integer visit(GenericRecursionValue genericRecursionValue) {
        return CostEstimator.box(2);
    }

    public Integer visit(ValueElement valueElement) {
        return CostEstimator.box(0);
    }

    protected static int add(int n, int n2) {
        if (Integer.MAX_VALUE == n || Integer.MAX_VALUE == n2) {
            return Integer.MAX_VALUE;
        }
        long l = n + n2;
        if (Integer.MAX_VALUE < l) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    protected static Integer box(int n) {
        return new Integer(n);
    }

    protected static int unbox(Object object) {
        return (Integer)object;
    }

    public static int cost(Production production) {
        if (production.hasProperty(COST)) {
            return (Integer)production.getProperty(COST);
        }
        throw new IllegalStateException("No cost estimates available");
    }
}

