/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import xtc.parser.Action;
import xtc.parser.AlternativeAddition;
import xtc.parser.AlternativeRemoval;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FollowedBy;
import xtc.parser.FullProduction;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.ModuleDependency;
import xtc.parser.ModuleImport;
import xtc.parser.ModuleInstantiation;
import xtc.parser.ModuleList;
import xtc.parser.ModuleModification;
import xtc.parser.NotFollowedBy;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.ProductionOverride;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.VoidedElement;
import xtc.tree.AttributeList;
import xtc.tree.Comment;
import xtc.tree.Node;
import xtc.tree.Visitor;

public class Copier
extends Visitor {
    protected List source = new ArrayList();
    protected List target = new ArrayList();

    public Element copy(Element element) {
        this.source.clear();
        this.target.clear();
        return (Element)this.dispatch(element);
    }

    public Grammar visit(Grammar grammar) {
        Grammar grammar2 = new Grammar(new ArrayList(grammar.modules.size()));
        grammar2.location = grammar.location;
        Iterator iterator = grammar.modules.iterator();
        while (iterator.hasNext()) {
            grammar2.modules.add(this.dispatch((Module)iterator.next()));
        }
        return grammar2;
    }

    public Module visit(Module module) {
        Iterator iterator;
        Module module2 = new Module();
        module2.location = module.location;
        module2.documentation = (Comment)this.dispatch(module.documentation);
        module2.name = module.name;
        module2.parameters = (ModuleList)this.dispatch(module.parameters);
        if (null != module.dependencies) {
            module2.dependencies = new ArrayList(module.dependencies.size());
            iterator = module.dependencies.iterator();
            while (iterator.hasNext()) {
                module2.dependencies.add(this.dispatch((ModuleDependency)iterator.next()));
            }
        }
        module2.modification = module.modification;
        module2.header = (Action)this.dispatch(module.header);
        module2.body = (Action)this.dispatch(module.body);
        module2.footer = (Action)this.dispatch(module.footer);
        if (null != module.attributes) {
            module2.attributes = new AttributeList((Collection)module.attributes);
        }
        module2.productions = new ArrayList(module.productions.size());
        iterator = module.productions.iterator();
        while (iterator.hasNext()) {
            module2.productions.add(this.dispatch((Production)iterator.next()));
        }
        return module2;
    }

    public Comment visit(Comment comment) {
        Comment comment2 = new Comment(comment.type, new ArrayList(comment.text), null);
        comment2.location = comment.location;
        comment2.node = (Node)this.dispatch(comment.node);
        return comment2;
    }

    public ModuleImport visit(ModuleImport moduleImport) {
        ModuleImport moduleImport2 = new ModuleImport(moduleImport.module, (ModuleList)this.dispatch(moduleImport.arguments), moduleImport.target);
        moduleImport2.location = moduleImport.location;
        return moduleImport2;
    }

    public ModuleInstantiation visit(ModuleInstantiation moduleInstantiation) {
        ModuleInstantiation moduleInstantiation2 = new ModuleInstantiation(moduleInstantiation.module, (ModuleList)this.dispatch(moduleInstantiation.arguments), moduleInstantiation.target);
        moduleInstantiation2.location = moduleInstantiation.location;
        return moduleInstantiation2;
    }

    public ModuleModification visit(ModuleModification moduleModification) {
        ModuleModification moduleModification2 = new ModuleModification(moduleModification.module, (ModuleList)this.dispatch(moduleModification.arguments), moduleModification.target);
        moduleModification2.location = moduleModification.location;
        return moduleModification2;
    }

    public ModuleList visit(ModuleList moduleList) {
        ModuleList moduleList2 = new ModuleList(new ArrayList(moduleList.names));
        moduleList2.location = moduleList.location;
        return moduleList2;
    }

    public FullProduction visit(FullProduction fullProduction) {
        FullProduction fullProduction2 = new FullProduction(null, fullProduction.type, fullProduction.name, this.copy(fullProduction.element));
        fullProduction2.location = fullProduction.location;
        if (null != fullProduction.attributes) {
            fullProduction2.attributes = new AttributeList((Collection)fullProduction.attributes);
        }
        fullProduction2.qName = fullProduction.qName;
        return fullProduction2;
    }

    public AlternativeAddition visit(AlternativeAddition alternativeAddition) {
        AlternativeAddition alternativeAddition2 = new AlternativeAddition(alternativeAddition.type, alternativeAddition.name, this.copy(alternativeAddition.element), alternativeAddition.sequence, alternativeAddition.isBefore);
        alternativeAddition2.location = alternativeAddition.location;
        alternativeAddition2.qName = alternativeAddition.qName;
        return alternativeAddition2;
    }

    public AlternativeRemoval visit(AlternativeRemoval alternativeRemoval) {
        AlternativeRemoval alternativeRemoval2 = new AlternativeRemoval(alternativeRemoval.type, alternativeRemoval.name, new ArrayList(alternativeRemoval.sequences));
        alternativeRemoval2.location = alternativeRemoval.location;
        alternativeRemoval2.qName = alternativeRemoval.qName;
        return alternativeRemoval2;
    }

    public ProductionOverride visit(ProductionOverride productionOverride) {
        ProductionOverride productionOverride2 = new ProductionOverride(productionOverride.type, productionOverride.name, this.copy(productionOverride.element), productionOverride.isComplete);
        productionOverride2.location = productionOverride.location;
        if (null != productionOverride.attributes) {
            productionOverride2.attributes = new AttributeList((Collection)productionOverride.attributes);
        }
        productionOverride2.qName = productionOverride.qName;
        return productionOverride2;
    }

    public OrderedChoice visit(OrderedChoice orderedChoice) {
        int n = orderedChoice.alternatives.size();
        OrderedChoice orderedChoice2 = new OrderedChoice(new ArrayList(n));
        orderedChoice2.location = orderedChoice.location;
        for (int i = 0; i < n; ++i) {
            orderedChoice2.alternatives.add(this.dispatch((Element)orderedChoice.alternatives.get(i)));
        }
        return orderedChoice2;
    }

    public Repetition visit(Repetition repetition) {
        Repetition repetition2 = new Repetition(repetition.once, (Element)this.dispatch(repetition.element));
        repetition2.location = repetition.location;
        return repetition2;
    }

    public Option visit(Option option) {
        Option option2 = new Option((Element)this.dispatch(option.element));
        option2.location = option.location;
        return option2;
    }

    public Sequence visit(Sequence sequence) {
        int n = sequence.length();
        Sequence sequence2 = new Sequence(sequence.name, new ArrayList(n));
        sequence2.location = sequence.location;
        for (int i = 0; i < n; ++i) {
            sequence2.add((Element)this.dispatch(sequence.get(i)));
        }
        return sequence2;
    }

    public FollowedBy visit(FollowedBy followedBy) {
        FollowedBy followedBy2 = new FollowedBy((Element)this.dispatch(followedBy.element));
        followedBy2.location = followedBy.location;
        return followedBy2;
    }

    public NotFollowedBy visit(NotFollowedBy notFollowedBy) {
        NotFollowedBy notFollowedBy2 = new NotFollowedBy((Element)this.dispatch(notFollowedBy.element));
        notFollowedBy2.location = notFollowedBy.location;
        return notFollowedBy2;
    }

    public SemanticPredicate visit(SemanticPredicate semanticPredicate) {
        SemanticPredicate semanticPredicate2 = new SemanticPredicate((Action)this.dispatch(semanticPredicate.element));
        semanticPredicate2.location = semanticPredicate.location;
        return semanticPredicate2;
    }

    public VoidedElement visit(VoidedElement voidedElement) {
        VoidedElement voidedElement2 = new VoidedElement((Element)this.dispatch(voidedElement.element));
        voidedElement2.location = voidedElement.location;
        return voidedElement2;
    }

    public Binding visit(Binding binding) {
        Binding binding2 = new Binding(binding.name, (Element)this.dispatch(binding.element));
        binding2.location = binding.location;
        this.source.add(binding);
        this.target.add(binding2);
        return binding2;
    }

    public CharClass visit(CharClass charClass) {
        CharClass charClass2 = new CharClass(charClass.exclusive, new ArrayList(charClass.ranges.size()));
        charClass2.location = charClass.location;
        charClass2.ranges.addAll(charClass.ranges);
        return charClass2;
    }

    public CharCase visit(CharCase charCase) {
        CharCase charCase2 = new CharCase((CharClass)this.dispatch(charCase.klass), (Element)this.dispatch(charCase.element));
        charCase2.location = charCase.location;
        return charCase2;
    }

    public CharSwitch visit(CharSwitch charSwitch) {
        int n = charSwitch.cases.size();
        CharSwitch charSwitch2 = new CharSwitch(new ArrayList(n));
        charSwitch2.location = charSwitch.location;
        for (int i = 0; i < n; ++i) {
            charSwitch2.cases.add(this.dispatch((CharCase)charSwitch.cases.get(i)));
        }
        charSwitch2.base = (Element)this.dispatch(charSwitch.base);
        return charSwitch2;
    }

    public Action visit(Action action) {
        Action action2 = new Action(new ArrayList(action.code), new ArrayList(action.indent));
        action2.location = action.location;
        return action2;
    }

    public ParserAction visit(ParserAction parserAction) {
        ParserAction parserAction2 = new ParserAction((Action)this.dispatch(parserAction.element));
        parserAction2.location = parserAction.location;
        return parserAction2;
    }

    public GenericNodeValue visit(GenericNodeValue genericNodeValue) {
        GenericNodeValue genericNodeValue2 = new GenericNodeValue(genericNodeValue.name, new ArrayList(genericNodeValue.children));
        genericNodeValue2.location = genericNodeValue.location;
        for (int i = 0; i < genericNodeValue2.children.size(); ++i) {
            Binding binding = (Binding)genericNodeValue2.children.get(i);
            int n = -1;
            for (int j = 0; j < this.source.size(); ++j) {
                if (binding != this.source.get(j)) continue;
                n = j;
                break;
            }
            if (-1 == n) {
                throw new IllegalArgumentException("Incomplete element containing a generic node value");
            }
            genericNodeValue2.children.set(i, this.target.get(n));
        }
        return genericNodeValue2;
    }

    public GenericActionValue visit(GenericActionValue genericActionValue) {
        GenericActionValue genericActionValue2 = new GenericActionValue(genericActionValue.name, genericActionValue.first, new ArrayList(genericActionValue.children));
        genericActionValue2.location = genericActionValue.location;
        for (int i = 0; i < genericActionValue2.children.size(); ++i) {
            Binding binding = (Binding)genericActionValue2.children.get(i);
            int n = -1;
            for (int j = 0; j < this.source.size(); ++j) {
                if (binding != this.source.get(j)) continue;
                n = j;
                break;
            }
            if (-1 == n) {
                throw new IllegalArgumentException("Incomplete element containing a generic action value");
            }
            genericActionValue2.children.set(i, this.target.get(n));
        }
        return genericActionValue2;
    }

    public GenericRecursionValue visit(GenericRecursionValue genericRecursionValue) {
        GenericRecursionValue genericRecursionValue2 = new GenericRecursionValue(genericRecursionValue.name, genericRecursionValue.first, new ArrayList(genericRecursionValue.children), genericRecursionValue.list);
        genericRecursionValue2.location = genericRecursionValue.location;
        for (int i = 0; i < genericRecursionValue2.children.size(); ++i) {
            Binding binding = (Binding)genericRecursionValue2.children.get(i);
            int n = -1;
            for (int j = 0; j < this.source.size(); ++j) {
                if (binding != this.source.get(j)) continue;
                n = j;
                break;
            }
            if (-1 == n) {
                throw new IllegalArgumentException("Incomplete element containing a generic recursion value");
            }
            genericRecursionValue2.children.set(i, this.target.get(n));
        }
        return genericRecursionValue2;
    }

    public Element visit(Element element) {
        return element;
    }
}

