/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.ActionBaseValue;
import xtc.parser.Analyzer;
import xtc.parser.AnyChar;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharLiteral;
import xtc.parser.CharRange;
import xtc.parser.CharSwitch;
import xtc.parser.CharTerminal;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FollowedBy;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.MetaData;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.NotFollowedBy;
import xtc.parser.NullValue;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.ProperListValue;
import xtc.parser.Rats;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.SingletonListValue;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.StringValue;
import xtc.parser.TextValue;
import xtc.parser.Type;
import xtc.parser.VoidedElement;
import xtc.tree.Attribute;
import xtc.tree.AttributeList;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.util.Utilities;

public class CodeGenerator
extends Visitor {
    public static final int CHUNK_SIZE = 10;
    public static final String PREFIX_METHOD = "p";
    public static final String PREFIX_FIELD = "f";
    public static final String PREFIX = "yy";
    public static final String DEBUG_NESTING = "yyNesting";
    public static final String STATE = "yyState";
    public static final String PARSE_CHAR = "character";
    public static final String ARG_INDEX = "yyStart";
    public static final String COLUMN = "yyColumn";
    public static final String CHAR = "yyC";
    public static final String INDEX = "yyIndex";
    public static final String RESULT = "yyResult";
    public static final String PRED_INDEX = "yyPredIndex";
    public static final String PRED_RESULT = "yyPredResult";
    public static final String PRED_MATCHED = "yyPredMatched";
    public static final String BASE_INDEX = "yyBase";
    public static final String NESTED_CHOICE = "yyChoice";
    public static final String REPETITION = "yyRepetition";
    public static final String OPTION = "yyOption";
    public static final String REPEATED = "yyRepeated";
    public static final String REP_VALUE = "yyRepValue";
    public static final String OP_VALUE = "yyOpValue";
    public static final String VALUE = "yyValue";
    public static final String PARSE_ERROR = "yyError";
    protected final Analyzer analyzer;
    protected final Printer printer;
    protected boolean attributeVerbose;
    protected boolean attributeWithLocation;
    protected boolean attributeConstant;
    protected boolean attributeIgnoringCase;
    protected boolean attributeNoMatchingErrors;
    protected boolean attributeStateful;
    protected boolean attributeReserved;
    protected String stateClassName;
    protected boolean attributeMain;
    protected String mainMethodNonterminal = null;
    protected boolean attributePrinter;
    protected String printerClassName;
    protected boolean attributeDump;
    protected String className;
    protected boolean chunked;
    protected Map chunkMap;
    protected int chunkCount;
    protected boolean firstElement;
    protected boolean savedFirstElement;
    protected String baseIndex;
    protected boolean useBaseIndex;
    protected String savedBaseIndex;
    protected boolean savedUseBaseIndex;
    protected int choiceLevel;
    protected int repetitionLevel;
    protected int savedRepetitionLevel;
    protected boolean repeatOnce;
    protected String repeatedElement;
    protected int optionLevel;
    protected int savedOptionLevel;
    protected String optionalElement;
    protected List optionTypes;
    protected boolean seenTest;
    protected boolean endsWithParseError;
    protected Iterator elementIter;
    protected String indexName;
    protected String resultName;
    protected String bindingName;
    protected Element bindingElement;
    protected boolean predicate;
    protected boolean notFollowedBy;
    protected Iterator predicateIter;

    public CodeGenerator(Analyzer analyzer, Printer printer) {
        this.analyzer = analyzer;
        this.printer = printer;
    }

    public String fieldName(NonTerminal nonTerminal) {
        if (this.chunked) {
            return "yyColumn.chunk" + this.chunkMap.get(nonTerminal) + "." + PREFIX_FIELD + nonTerminal.toIdentifier();
        }
        return "yyColumn.f" + nonTerminal.toIdentifier();
    }

    public String methodName(NonTerminal nonTerminal) {
        return PREFIX_METHOD + nonTerminal.toIdentifier();
    }

    protected void dump() {
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Dump the memoization table.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param printer The printer for writing the table.");
        this.printer.indent().pln(" */");
        this.printer.indent().pln("public void dump(Printer printer) {").incr();
        this.printer.indent().pln("for (int i=0; i<yyCount; i++) {").incr();
        this.printer.indent().p(this.className).p("Column column = (").p(this.className).pln("Column)yyColumns[i];");
        this.printer.indent().pln("printer.indent().p(i).p(\" = \");");
        this.printer.pln();
        this.printer.indent().pln("if (null == column) {").incr();
        this.printer.indent().pln("printer.pln(\"null;\");");
        this.printer.pln();
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("printer.pln('{').incr();");
        if (0 == this.chunkCount) {
            this.printer.pln();
            Iterator iterator = this.analyzer.module().productions.iterator();
            while (iterator.hasNext()) {
                Production production = (Production)iterator.next();
                MetaData metaData = (MetaData)production.getProperty("xtc.parser.MetaData");
                if (Rats.optimizeChunks && 1 >= metaData.usageCount || Rats.optimizeTransient && production.hasAttribute(Constants.ATT_TRANSIENT)) continue;
                this.printer.indent().p("dump(printer, \"").p(production.name.toIdentifier()).p("\", ").buffer().p("column.").p(PREFIX_FIELD).p(production.name.toIdentifier()).p(");").fit("     ").pln();
            }
        } else {
            int n = 0;
            Object var2_4 = null;
            int n2 = 10;
            boolean bl = true;
            Iterator iterator = this.analyzer.module().productions.iterator();
            while (iterator.hasNext()) {
                Production production = (Production)iterator.next();
                MetaData metaData = (MetaData)production.getProperty("xtc.parser.MetaData");
                if (1 >= metaData.usageCount || Rats.optimizeTransient && production.hasAttribute(Constants.ATT_TRANSIENT)) continue;
                if (10 <= n2) {
                    ++n;
                    n2 = 0;
                    if (bl) {
                        bl = false;
                    } else {
                        this.printer.pln();
                        this.printer.indent().pln("printer.decr().indent().pln(\"};\");");
                        this.printer.decr().indent().pln('}');
                    }
                    this.printer.pln();
                    this.printer.indent().p("Chunk").p(n).p(" chunk").p(n).p(" = column.chunk").p(n).pln(';');
                    this.printer.indent().p("printer.indent().p(\"Chunk(").p(n).p(") = \");");
                    this.printer.pln();
                    this.printer.indent().p("if (null == chunk").p(n).pln(") {").incr();
                    this.printer.indent().pln("printer.pln(\"null;\");");
                    this.printer.pln();
                    this.printer.decr().indent().pln("} else {").incr();
                    this.printer.indent().pln("printer.pln('{').incr();");
                    this.printer.pln();
                }
                this.printer.indent().p("dump(printer, \"").p(production.name.toIdentifier()).p("\", ").buffer().p("chunk").p(n).p('.').p(PREFIX_FIELD).p(production.name.toIdentifier()).p(");").fit("     ").pln();
                ++n2;
            }
            this.printer.pln();
            this.printer.indent().pln("printer.decr().indent().pln(\"};\");");
            this.printer.decr().indent().pln('}');
        }
        this.printer.pln();
        this.printer.indent().pln("printer.decr().indent().pln(\"};\");");
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Dump a memoized result.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param printer The printer.");
        this.printer.indent().pln(" * @param name The name of the result.");
        this.printer.indent().pln(" * @param result The value of the result.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("private void dump(Printer printer, String name, ").pln("Result result) {").incr();
        this.printer.indent().pln("printer.indent().p(name).p(\" = \");");
        this.printer.pln();
        this.printer.indent().pln("if (null == result) {").incr();
        this.printer.indent().pln("printer.pln(\"null;\");");
        this.printer.decr().indent().pln("} else if (result.hasValue()) {").incr();
        this.printer.indent().pln("printer.p(\"Value(\").p(result.index).pln(\");\");");
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("printer.p(\"Error(\").p(result.index).pln(\");\");");
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.pln();
    }

    protected void mainMethod(String string) {
        int n = this.printer.level() * 2 + 8 + Math.max(7, this.className.length() + 1);
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Parse the specified files.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param args The file names.");
        this.printer.indent().pln(" */");
        this.printer.indent().pln("public static void main(String[] args) {").incr();
        this.printer.indent().pln("if ((null == args) || (0 == args.length)) {").incr();
        this.printer.indent().pln("System.err.println(\"Usage: <file-name>+\");");
        this.printer.pln();
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("for (int i=0; i<args.length; i++) {").incr();
        this.printer.indent().p("System.err.println(\"Processing \" + args[i] + ").pln("\" ...\");");
        this.printer.pln();
        this.printer.indent().p("Reader").align(n).pln("in = null;");
        this.printer.indent().pln("try {").incr();
        this.printer.indent().p("in").align(n + 3).pln("= new BufferedReader(new FileReader(args[i]));");
        this.printer.indent().p(this.className).align(n).p("p  = new ").p(this.className).pln("(in, args[i], (int)new File(args[i]).length());");
        this.printer.indent().p("Result").align(n).p("r  = p.p").p(string).pln("(0);");
        this.printer.pln();
        this.printer.indent().pln("if (r.hasValue()) {").incr();
        this.printer.indent().pln("SemanticValue v = (SemanticValue)r;");
        this.printer.pln();
        if (this.attributePrinter) {
            this.printer.indent().pln("if (v.value instanceof Node) {").incr();
            this.printer.indent().pln("Printer ptr = new");
            this.printer.indentMore().p("Printer(new BufferedWriter(new ").pln("OutputStreamWriter(System.out)));");
            this.printer.indent().p("new ").p(this.printerClassName).pln("(ptr).dispatch((Node)v.value);");
            this.printer.indent().pln("ptr.flush();").pln();
            this.printer.decr().indent().pln("} else {").incr();
            this.printer.indent().pln("System.out.println(v.value.toString());");
            this.printer.decr().indent().pln('}');
        } else {
            this.printer.indent().pln("if (v.value instanceof GNode) {").incr();
            this.printer.indent().pln("Printer ptr = new");
            this.printer.indentMore().p("Printer(new BufferedWriter(new ").pln("OutputStreamWriter(System.out)));");
            this.printer.indent().pln("ptr.format((GNode)v.value).pln().flush();");
            this.printer.decr().indent().pln("} else {").incr();
            this.printer.indent().pln("System.out.println(v.value.toString());");
            this.printer.decr().indent().pln('}');
        }
        this.printer.pln();
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("ParseError err = (ParseError)r;");
        this.printer.indent().pln("if (-1 == err.index) {").incr();
        this.printer.indent().pln("System.err.println(\"  Parse error\");");
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().p("System.err.println(\"  \" + p.location(err.index) + ").pln("\": \" + err.msg);");
        this.printer.decr().indent().pln("}");
        this.printer.decr().indent().pln("}");
        this.printer.pln();
        this.printer.decr().indent().pln("} catch (Throwable x) {").incr();
        this.printer.indent().pln("while (null != x.getCause()) {").incr();
        this.printer.indent().pln("x = x.getCause();");
        this.printer.decr().indent().pln("}");
        this.printer.indent().pln("x.printStackTrace();");
        this.printer.decr().indent().pln("} finally {").incr();
        this.printer.indent().pln("try {").incr();
        this.printer.indent().pln("in.close();");
        this.printer.decr().indent().pln("} catch (Throwable x) {");
        this.printer.indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.pln();
    }

    public void visit(Module module) {
        Production production;
        boolean bl;
        int n;
        Object object;
        Object object2;
        Iterator iterator;
        Object object3;
        Object object4;
        this.analyzer.register(this);
        this.printer.register(this);
        this.analyzer.init(module);
        this.className = Utilities.getName(module.getClassName());
        if (null == module.attributes) {
            module.attributes = new AttributeList();
        }
        this.attributeVerbose = module.hasAttribute(Constants.ATT_VERBOSE);
        this.attributeWithLocation = module.hasAttribute(Constants.ATT_WITH_LOCATION);
        this.attributeConstant = module.hasAttribute(Constants.ATT_CONSTANT);
        this.attributeIgnoringCase = module.hasAttribute(Constants.ATT_IGNORING_CASE);
        this.attributeStateful = module.hasAttribute(Constants.ATT_STATEFUL.name);
        this.attributeReserved = module.hasAttribute(Constants.ATT_RESERVED);
        this.attributeMain = module.hasAttribute(Constants.ATT_MAIN.name);
        this.attributePrinter = module.hasAttribute(Constants.ATT_PRINTER.name);
        this.attributeDump = module.hasAttribute(Constants.ATT_DUMP);
        if (this.attributeStateful) {
            this.stateClassName = (String)module.attributes.get((String)Constants.ATT_STATEFUL.name).value;
        }
        if (this.attributeMain) {
            this.mainMethodNonterminal = (String)module.attributes.get((String)Constants.ATT_MAIN.name).value;
        }
        if (this.attributePrinter) {
            this.printerClassName = (String)module.attributes.get((String)Constants.ATT_PRINTER.name).value;
        }
        this.chunked = false;
        this.chunkMap = null;
        this.chunkCount = 0;
        this.printer.sep();
        this.printer.indent().pln("// This file has been generated by");
        this.printer.indent().p("// Rats! Parser Generator, Version ").p("1.7.1").p(", ").pln("(C) 2004-2005 Robert Grimm");
        Date date = new Date();
        this.printer.indent().p("// on ").p(DateFormat.getDateInstance(0).format(date)).p(" at ").p(DateFormat.getTimeInstance(2).format(date)).pln('.');
        this.printer.indent().pln("// Edit at your own risk.");
        this.printer.sep();
        this.printer.pln();
        String string = Utilities.getQualifier(module.getClassName());
        if (null != string) {
            this.printer.indent().p("package ").p(string).pln(';');
            this.printer.pln();
        }
        Type.init();
        if (null != string) {
            Type.importT(string + ".*");
        }
        this.printer.indent().pln("import java.io.Reader;");
        Type.importT("java.io.Reader");
        if (this.attributeMain) {
            this.printer.indent().pln("import java.io.BufferedReader;");
            Type.importT("java.io.BufferedReader");
            this.printer.indent().pln("import java.io.BufferedWriter;");
            Type.importT("java.io.BufferedWriter");
            this.printer.indent().pln("import java.io.File;");
            Type.importT("java.io.File");
            this.printer.indent().pln("import java.io.FileReader;");
            Type.importT("java.io.FileReader");
            this.printer.indent().pln("import java.io.OutputStreamWriter;");
            Type.importT("java.io.OutputStreamWriter");
        }
        this.printer.indent().pln("import java.io.IOException;");
        Type.importT("java.io.IOException");
        this.printer.pln();
        if (module.getBooleanProperty("xtc.parser.Generifier.Generic") || this.attributeReserved) {
            if (module.getBooleanProperty("xtc.parser.Generifier.Generic")) {
                this.printer.indent().pln("import java.util.ArrayList;");
                Type.importT("java.util.ArrayList");
            }
            if (this.attributeReserved) {
                this.printer.indent().pln("import java.util.HashSet;");
                Type.importT("java.util.HashSet");
                this.printer.indent().pln("import java.util.Set;");
                Type.importT("java.util.Set");
            }
            this.printer.pln();
        }
        if (module.getBooleanProperty("xtc.parser.DirectLeftRecurser.Recursive")) {
            this.printer.indent().pln("import xtc.util.Action;");
            Type.importT("xtc.util.Action");
        }
        this.printer.indent().pln("import xtc.util.Pair;");
        Type.importT("xtc.util.Pair");
        this.printer.pln();
        if (this.attributeWithLocation || module.getBooleanProperty("xtc.parser.Generifier.Generic") || this.attributeMain || this.attributeDump) {
            if (this.attributeWithLocation) {
                this.printer.indent().pln("import xtc.tree.Node;");
                Type.importT("xtc.tree.Node");
            }
            if (module.getBooleanProperty("xtc.parser.Generifier.Generic") || this.attributeMain) {
                this.printer.indent().pln("import xtc.tree.GNode;");
                Type.importT("xtc.tree.GNode");
            }
            if (this.attributeMain || this.attributeDump) {
                this.printer.indent().pln("import xtc.tree.Printer;");
                Type.importT("xtc.tree.Printer");
            }
            if (this.attributePrinter) {
                this.printer.indent().pln("import xtc.tree.Visitor;");
                Type.importT("xtc.tree.Visitor");
            }
            this.printer.pln();
        }
        this.printer.indent().pln("import xtc.parser.PackratParser;");
        Type.importT("xtc.parser.PackratParser");
        this.printer.indent().pln("import xtc.parser.Column;");
        Type.importT("xtc.parser.Column");
        this.printer.indent().pln("import xtc.parser.Result;");
        Type.importT("xtc.parser.Result");
        this.printer.indent().pln("import xtc.parser.SemanticValue;");
        Type.importT("xtc.parser.SemanticValue");
        this.printer.indent().pln("import xtc.parser.ParseError;");
        Type.importT("xtc.parser.ParseError");
        this.printer.pln();
        if (null != module.header) {
            this.action(module.header);
            this.printer.pln();
            object4 = module.header.code.iterator();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                if (!((String)object3).startsWith("import ")) continue;
                Type.importT(((String)object3).substring(7, ((String)object3).length() - 1).trim());
            }
        }
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Packrat parser for grammar <code>").p(module.name.name).pln("</code>.");
        this.printer.indent().pln(" *");
        this.printer.indent().p(" * <p />This class has been generated by the ").pln("<i>Rats!</i> parser");
        this.printer.indent().p(" * generator, version ").p("1.7.1").p(", ").p("(C) 2004-2005 Robert Grimm").pln('.');
        this.printer.indent().pln(" */");
        this.printer.indent();
        if (module.hasAttribute(Constants.ATT_VISIBILITY.name)) {
            object4 = (String)module.attributes.get((String)Constants.ATT_VISIBILITY.name).value;
            if (Constants.ATT_PUBLIC.name.equals(object4)) {
                this.printer.p("public ");
            }
        } else {
            this.printer.p("public ");
        }
        this.printer.p("final class ").p(this.className).pln(" extends PackratParser {").incr().pln();
        boolean bl2 = false;
        if (this.attributeVerbose) {
            bl2 = true;
        } else {
            object3 = module.productions.iterator();
            while (object3.hasNext()) {
                if (!((Production)object3.next()).hasAttribute(Constants.ATT_VERBOSE)) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            this.printer.indent().p("/** Flag for whether to emit debugging information while ").pln("parsing. */");
            this.printer.indent().pln("public static final boolean DEBUG = true;");
            this.printer.pln();
        }
        if (module.hasAttribute(Constants.ATT_FLAG.name)) {
            object3 = module.attributes.iterator();
            while (object3.hasNext()) {
                iterator = (Attribute)object3.next();
                if (!((Attribute)((Object)iterator)).name.equals(Constants.ATT_FLAG.name)) continue;
                this.printer.indent().p("/** The ").p((String)((Attribute)((Object)iterator)).value).pln(" flag. */");
                this.printer.indent().p("public static final boolean ").p((String)((Attribute)((Object)iterator)).value).pln(" = true;");
                this.printer.pln();
            }
        }
        if (this.attributeReserved) {
            this.printer.indent().pln("/** The set of reserved keywords. */");
            this.printer.indent().p("protected static final Set RESERVED = ").pln("new HashSet();");
            this.printer.pln();
        }
        if (this.attributeStateful) {
            this.printer.indent().pln("/** The global state object. */");
            this.printer.indent().p("protected static final ").p(this.stateClassName).p(' ').p(STATE).p(" = ").buffer().p("new ").p(this.stateClassName).p("();").fitMore().pln();
            this.printer.pln();
        }
        int n2 = 0;
        iterator = module.productions.iterator();
        while (iterator.hasNext()) {
            object2 = (Production)iterator.next();
            object = (MetaData)((Node)object2).getProperty("xtc.parser.MetaData");
            if (1 >= ((MetaData)object).usageCount || Rats.optimizeTransient && ((Production)object2).hasAttribute(Constants.ATT_TRANSIENT)) continue;
            ++n2;
        }
        if (Rats.optimizeChunks && 10 <= n2) {
            this.chunked = true;
            this.chunkMap = new HashMap(n2 * 4 / 3);
            object2 = null;
            object = null;
            n = 10;
            bl = true;
            iterator = module.productions.iterator();
            while (iterator.hasNext()) {
                production = (Production)iterator.next();
                MetaData metaData = (MetaData)production.getProperty("xtc.parser.MetaData");
                if (1 >= metaData.usageCount || Rats.optimizeTransient && production.hasAttribute(Constants.ATT_TRANSIENT)) continue;
                if (10 <= n) {
                    ++this.chunkCount;
                    object2 = new Integer(this.chunkCount);
                    object = Integer.toString(this.chunkCount);
                    n = 0;
                    if (bl) {
                        bl = false;
                        this.printer.sep();
                    } else {
                        this.printer.decr().indent().pln('}');
                    }
                    this.printer.pln();
                    this.printer.indent().p("/** Chunk ").p((String)object).pln(" of memoized results. */");
                    this.printer.indent().p("static final class Chunk").p((String)object).pln(" {").incr();
                }
                NonTerminal nonTerminal = production.name;
                this.chunkMap.put(nonTerminal, object2);
                ++n;
                this.printer.indent().p("Result ").p(PREFIX_FIELD).p(nonTerminal.toIdentifier()).pln(';');
            }
            this.printer.decr().indent().pln('}');
            this.printer.pln();
        }
        this.printer.sep().pln();
        this.printer.indent().pln("/** Memoization table column. */");
        this.printer.indent().p("static final class ").p(this.className).pln("Column extends Column {").incr();
        if (this.chunked) {
            for (int i = 1; i <= this.chunkCount; ++i) {
                this.printer.indent().p("Chunk").p(i).p(' ').p("chunk").p(i).pln(';');
            }
        } else {
            iterator = module.productions.iterator();
            while (iterator.hasNext()) {
                object2 = (Production)iterator.next();
                object = (MetaData)((Node)object2).getProperty("xtc.parser.MetaData");
                if (Rats.optimizeChunks && 1 >= ((MetaData)object).usageCount || Rats.optimizeTransient && ((Production)object2).hasAttribute(Constants.ATT_TRANSIENT)) continue;
                this.printer.indent().p("Result ").p(PREFIX_FIELD).p(((Production)object2).name.toIdentifier()).pln(';');
            }
        }
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Create a new packrat parser.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param reader The reader.");
        this.printer.indent().pln(" * @param file The file name.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("public ").p(this.className).pln("(final Reader reader, final String file) {").incr();
        this.printer.indent().pln("super(reader, file);");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Create a new packrat parser.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param reader The file reader.");
        this.printer.indent().pln(" * @param file The file name.");
        this.printer.indent().pln(" * @param size The file size.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("public ").p(this.className).pln("(final Reader reader, final String file, final int size) {").incr();
        this.printer.indent().pln("super(reader, file, size);");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.sep().pln();
        this.printer.indent().pln("protected Column newColumn() {").incr();
        this.printer.indent().p("return new ").p(this.className).pln("Column();");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        iterator = module.productions.iterator();
        while (iterator.hasNext()) {
            boolean bl3 = this.attributeVerbose;
            boolean bl4 = this.attributeWithLocation;
            n = this.attributeConstant ? 1 : 0;
            bl = this.attributeIgnoringCase;
            production = (Production)iterator.next();
            if (!bl3 && production.hasAttribute(Constants.ATT_VERBOSE)) {
                this.attributeVerbose = true;
            }
            if (!bl4 && production.hasAttribute(Constants.ATT_WITH_LOCATION)) {
                this.attributeWithLocation = true;
            }
            if (n == 0 && production.hasAttribute(Constants.ATT_CONSTANT)) {
                this.attributeConstant = true;
            }
            if (!bl && production.hasAttribute(Constants.ATT_IGNORING_CASE)) {
                this.attributeIgnoringCase = true;
            }
            this.analyzer.process(production);
            this.attributeIgnoringCase = bl;
            this.attributeConstant = n;
            this.attributeWithLocation = bl4;
            this.attributeVerbose = bl3;
        }
        if (null != module.body) {
            this.printer.sep().pln();
            this.action(module.body);
            this.printer.pln();
        }
        if (this.attributeReserved) {
            this.printer.sep().pln();
            this.printer.indent().pln("/**");
            this.printer.indent().p(" * Add the specified words to the set of ").pln("reserved keywords.");
            this.printer.indent().pln(" *");
            this.printer.indent().pln(" * @param words The new keywords.");
            this.printer.indent().pln(" */");
            this.printer.indent().p("protected static void reserve(String[] ").pln("words) {").incr();
            this.printer.indent().pln("for (int i=0; i<words.length; i++) {").incr();
            this.printer.indent().pln("RESERVED.add(words[i]);");
            this.printer.decr().indent().pln('}');
            this.printer.decr().indent().pln('}');
            this.printer.pln();
        }
        if (this.attributeDump) {
            this.dump();
        }
        if (this.attributeMain) {
            this.mainMethod(this.mainMethodNonterminal);
        }
        this.printer.decr().indent().pln('}');
        if (null != module.footer) {
            this.printer.pln().sep().pln();
            this.action(module.footer);
        }
    }

    public void visit(Production production) {
        int n;
        int n2;
        String string;
        MetaData metaData = (MetaData)production.getProperty("xtc.parser.MetaData");
        this.optionTypes = metaData.options;
        String string2 = this.fieldName(production.name);
        String string3 = this.methodName(production.name);
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Parse ");
        if (production.getBooleanProperty("xtc.Constants.Synthetic")) {
            this.printer.p("synthetic ");
        }
        this.printer.p("nonterminal ").buffer().p(production.qName.name).p('.').fit(" * ").pln();
        if (production.hasProperty("xtc.parser.DuplicateProductionFolder.Duplicates")) {
            this.printer.indent();
            this.printer.p(" * This nonterminal represents the duplicate productions ");
            List list = (List)production.getProperty("xtc.parser.DuplicateProductionFolder.Duplicates");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                this.printer.buffer();
                if (1 < list.size() && !iterator.hasNext()) {
                    this.printer.p("and ");
                }
                this.printer.p(string);
                if (2 == list.size() && iterator.hasNext()) {
                    this.printer.p(' ');
                } else if (iterator.hasNext()) {
                    this.printer.p(", ");
                } else {
                    this.printer.p('.');
                }
                this.printer.fit(" * ");
            }
            this.printer.pln();
        }
        this.printer.indent().pln(" *");
        this.printer.indent().p(" * @param ").p(ARG_INDEX).pln(" The index.");
        this.printer.indent().pln(" * @return The result.");
        this.printer.indent().pln(" * @throws IOException Signals an I/O error.");
        this.printer.indent().pln(" */");
        this.printer.indent();
        if (production.hasAttribute(Constants.ATT_PUBLIC)) {
            this.printer.p("public");
        } else {
            this.printer.p("private");
        }
        long l = this.printer.line();
        this.printer.p(" Result ").p(string3).p("(final ").p(Type.indexT()).p(' ').p(ARG_INDEX).p(") ").buffer().p("throws IOException {").fitMore().pln().incr();
        if (l + 1L < this.printer.line()) {
            this.printer.pln();
        }
        if (!(Rats.optimizeChunks && 1 >= metaData.usageCount || Rats.optimizeTransient && production.hasAttribute(Constants.ATT_TRANSIENT))) {
            this.printer.indent().p(this.className).p("Column ").p(COLUMN).p(" = (").p(this.className).p("Column)column(").p(ARG_INDEX).pln(");");
            if (this.chunked) {
                string = this.chunkMap.get(production.name).toString();
                this.printer.indent().p("if (null == ").p(COLUMN).p(".chunk").p(string).p(") ").p(COLUMN).p(".chunk").p(string).p(" = new Chunk").p(string).pln("();");
            }
            this.printer.indent().p("if (null == ").p(string2).p(") ").buffer().p(string2).p(" = ").p(string3).p("$1(").p(ARG_INDEX).p(");").fitMore().pln();
            this.printer.indent().p("return ").p(string2).pln(';');
            this.printer.decr().indent().pln('}');
            this.printer.pln();
            this.printer.indent().p("/** Actually parse ");
            this.printer.p(production.qName.name).pln(". */");
            l = this.printer.line();
            this.printer.indent().p("private Result ").p(string3).p("$1(final ").p(Type.indexT()).p(' ').p(ARG_INDEX).p(") ").buffer().p("throws IOException {").fitMore().pln().incr();
            if (l + 1L < this.printer.line()) {
                this.printer.pln();
            }
            if (this.attributeVerbose) {
                this.printer.indent().p("if (DEBUG) ").buffer().p("System.err.println(\"").p(string3).p("$1(\"+").p(ARG_INDEX).p("+\"): \"+peek(").p(ARG_INDEX).p("));").fitMore().pln();
                this.printer.pln();
            }
        } else if (this.attributeVerbose) {
            this.printer.indent().p("if (DEBUG) ").buffer().p("System.err.println(\"").p(string3).p("(\"+").p(ARG_INDEX).p("+\"): \"+peek(").p(ARG_INDEX).p("));").fitMore().pln();
            this.printer.pln();
        }
        int n3 = Math.max("ParseError".length(), production.type.length());
        for (n2 = 0; n2 < metaData.options.size(); ++n2) {
            String string4 = (String)metaData.options.get(n2);
            if (null == string4) continue;
            n3 = Math.max(n3, string4.length());
        }
        n2 = this.printer.level() * 2 + n3 + 1;
        if (metaData.requiresChar) {
            this.printer.indent().p(Type.intT()).align(n2).p(CHAR).pln(';');
        }
        if (metaData.requiresIndex) {
            this.printer.indent().p(Type.indexT()).align(n2).p(INDEX).pln(';');
        }
        if (metaData.requiresResult) {
            this.printer.indent().p("Result").align(n2).p(RESULT).pln(';');
        }
        if (metaData.requiresPredIndex) {
            this.printer.indent().p(Type.indexT()).align(n2).p(PRED_INDEX).pln(';');
        }
        if (metaData.requiresPredResult) {
            this.printer.indent().p("Result").align(n2).p(PRED_RESULT).pln(';');
        }
        if (metaData.requiresPredMatch) {
            this.printer.indent().p(Type.booleanT()).align(n2).p(PRED_MATCHED).pln(';');
        }
        if (metaData.requiresBaseIndex) {
            this.printer.indent().p(Type.indexT()).align(n2).p(BASE_INDEX).pln(';');
        }
        for (n = 0; n < metaData.repetitions.size(); ++n) {
            this.printer.indent().p(Type.indexT()).align(n2).p(REPETITION).p(n + 1).pln(';');
            if (((Boolean)metaData.repetitions.get(n)).booleanValue()) {
                this.printer.indent().p(Type.booleanT()).align(n2).p(REPEATED).p(n + 1).pln(';');
            }
            if (!((Boolean)metaData.boundRepetitions.get(n)).booleanValue()) continue;
            this.printer.indent().p(Type.listT()).align(n2).p(REP_VALUE).p(n + 1).pln(';');
        }
        for (n = 0; n < metaData.options.size(); ++n) {
            this.printer.indent().p(Type.indexT()).align(n2).p(OPTION).p(n + 1).pln(';');
            String string5 = (String)metaData.options.get(n);
            if (null == string5) continue;
            this.printer.indent().p(string5).align(n2).p(OP_VALUE).p(n + 1).pln(';');
        }
        if (Type.isVoidT(production.type)) {
            this.printer.indent().p(Type.voidRefT()).align(n2);
        } else {
            this.printer.indent().p(production.type).align(n2);
        }
        this.printer.p(VALUE).pln(';');
        this.printer.indent().p("ParseError").align(n2).p(PARSE_ERROR).pln(" = ParseError.DUMMY;");
        if (this.attributeStateful) {
            if (production.hasAttribute(Constants.ATT_RESETTING)) {
                this.printer.pln();
                this.printer.indent().pln("// Reset the global state object.");
                this.printer.indent().p(STATE).p(".reset(column(").p(ARG_INDEX).pln(").file);");
            }
            if (production.hasAttribute(Constants.ATT_STATEFUL)) {
                this.printer.pln();
                this.printer.indent().pln("// Start a state modification.");
                this.printer.indent().p(STATE).pln(".start();");
            }
        }
        this.indexName = INDEX;
        this.resultName = RESULT;
        this.baseIndex = ARG_INDEX;
        this.useBaseIndex = true;
        this.choiceLevel = -1;
        this.repetitionLevel = 0;
        this.savedRepetitionLevel = 0;
        this.repeatOnce = false;
        this.repeatedElement = null;
        this.optionLevel = 0;
        this.savedOptionLevel = 0;
        this.optionalElement = null;
        this.seenTest = false;
        this.endsWithParseError = false;
        this.dispatch(production.element);
        if (this.seenTest) {
            if (this.attributeStateful && production.hasAttribute(Constants.ATT_STATEFUL)) {
                this.printer.pln();
                this.printer.indent().pln("// Abort the state modification.");
                this.printer.indent().p(STATE).pln(".abort();");
            }
            this.printer.pln();
            this.printer.indent().pln("// Done.");
            if (!(!this.endsWithParseError || production.hasAttribute(Constants.ATT_TRANSIENT) && Rats.optimizeErrors2)) {
                this.parseError();
            }
            this.printer.indent().p("return ").p(PARSE_ERROR).pln(';');
        }
        this.printer.decr().indent().pln('}');
        this.printer.pln();
    }

    protected void result(String string, boolean bl) {
        this.printer.pln();
        this.firstElement = false;
        String string2 = PARSE_CHAR.equals(string) ? CHAR : this.resultName;
        int n = string2.length();
        if (bl) {
            n = Math.max(n, BASE_INDEX.length());
        }
        if (!this.notFollowedBy() && !PARSE_CHAR.equals(string)) {
            n = Math.max(n, PARSE_ERROR.length());
        }
        n += this.printer.level() * 2 + 1;
        if (this.useBaseIndex) {
            if (bl) {
                this.printer.indent().p(BASE_INDEX).align(n).p("= ").buffer().p(this.baseIndex).p(';').fitMore().pln();
                this.printer.indent().p(string2).align(n).p("= ").buffer().p(string).p('(').p(BASE_INDEX).p(");").fitMore().pln();
            } else {
                this.printer.indent().p(string2).align(n).p("= ").buffer().p(string).p('(').p(this.baseIndex).p(");").fitMore().pln();
            }
            if (!this.notFollowedBy() && !PARSE_CHAR.equals(string)) {
                if (Rats.optimizeSelect) {
                    this.printer.indent().p(PARSE_ERROR).align(n).p("= ").buffer().p(this.resultName).p(".select(").p(PARSE_ERROR).p(");").fitMore().pln();
                } else {
                    this.printer.indent().p(PARSE_ERROR).align(n).p("= ").buffer().p(PARSE_ERROR).p(".select(").p(this.resultName).p(".parseError());").fitMore().pln();
                }
            }
            this.useBaseIndex = false;
        } else {
            if (bl) {
                this.printer.indent().p(BASE_INDEX).align(n).p("= ").buffer().p(this.resultName).p(".index;").fitMore().pln();
                this.printer.indent().p(string2).align(n).p("= ").buffer().p(string).p('(').p(BASE_INDEX).p(");").fitMore().pln();
            } else {
                this.printer.indent().p(string2).align(n).p("= ").buffer().p(string).p('(').p(this.resultName).p(".index);").fitMore().pln();
            }
            if (!this.notFollowedBy() && !PARSE_CHAR.equals(string)) {
                if (Rats.optimizeSelect) {
                    this.printer.indent().p(PARSE_ERROR).align(n).p("= ").buffer().p(this.resultName).p(".select(").p(PARSE_ERROR).p(");").fitMore().pln();
                } else {
                    this.printer.indent().p(PARSE_ERROR).align(n).p("= ").buffer().p(PARSE_ERROR).p(".select(").p(this.resultName).p(".parseError());").fitMore().pln();
                }
            }
        }
    }

    protected void valueTest() {
        this.printer.indent().p("if (").p(this.resultName).pln(".hasValue()) {").incr();
    }

    protected void charValueTest() {
        this.printer.indent().p("if (-1 != ").p(CHAR).pln(") {").incr();
    }

    protected void stringValueTest(String string) {
        if (Rats.optimizeMatches) {
            if (this.attributeIgnoringCase) {
                this.printer.indent().p("if (").p(this.resultName).p(".hasValueIgnoreCase(\"").escape(string, 8).pln("\")) {").incr();
            } else {
                this.printer.indent().p("if (").p(this.resultName).p(".hasValue(\"").escape(string, 8).pln("\")) {").incr();
            }
        } else if (this.attributeIgnoringCase) {
            this.printer.indent().p("if (").p(this.resultName).pln(".hasValue() &&").indent().p("   \"").escape(string, 8).p("\".equalsIgnoreCase(").p(this.resultName).pln(".semanticValue().toString())) {").incr();
        } else {
            this.printer.indent().p("if (").p(this.resultName).pln(".hasValue() &&").indent().p("   \"").escape(string, 8).p("\".equals(").p(this.resultName).pln(".semanticValue())) {").incr();
        }
    }

    protected void index(String string) {
        this.printer.indent().p(this.indexName).p(" = ").p(string).pln(" + 1;");
        this.useBaseIndex = true;
        this.baseIndex = this.indexName;
    }

    protected void tested() {
        this.seenTest = true;
    }

    protected void nextElement() {
        if (this.predicate) {
            if (this.predicateIter.hasNext()) {
                this.dispatch((Element)this.predicateIter.next());
                return;
            }
            if (this.savedRepetitionLevel < this.repetitionLevel) {
                this.printer.pln();
                this.printer.indent().p(REPETITION).p(this.repetitionLevel).p(" = ");
                if (this.useBaseIndex) {
                    this.printer.p(this.baseIndex).pln(';');
                    this.useBaseIndex = false;
                } else {
                    this.printer.p(this.resultName).pln(".index;");
                }
                if (this.repeatOnce) {
                    this.printer.indent().p(REPEATED).p(this.repetitionLevel).pln("   = true;");
                }
                if (null != this.repeatedElement) {
                    this.printer.indent().p(REP_VALUE).p(this.repetitionLevel).p("   = ").buffer().p("new Pair(").p(this.repeatedElement).p(", ").p(REP_VALUE).p(this.repetitionLevel).p(");").fitMore().pln();
                }
                this.printer.indent().pln("continue;");
                return;
            }
            if (this.savedOptionLevel < this.optionLevel) {
                this.printer.pln();
                this.printer.indent().p(OPTION).p(this.optionLevel).p("  = ");
                if (this.useBaseIndex) {
                    this.printer.p(this.baseIndex).pln(';');
                    this.useBaseIndex = false;
                } else {
                    this.printer.p(this.resultName).pln(".index;");
                }
                if (null != this.optionalElement) {
                    this.printer.indent().p(OP_VALUE).p(this.optionLevel).p(" = ").p(this.optionalElement).pln(';');
                }
                return;
            }
            if (this.notFollowedBy) {
                this.printer.pln();
                this.printer.indent().p(PRED_MATCHED).pln(" = true;");
                return;
            }
            this.predicate = false;
            this.baseIndex = this.savedBaseIndex;
            this.useBaseIndex = this.savedUseBaseIndex;
            this.indexName = INDEX;
            this.resultName = RESULT;
        }
        if (this.elementIter.hasNext()) {
            this.dispatch((Element)this.elementIter.next());
        } else if (0 < this.repetitionLevel) {
            this.printer.pln();
            this.printer.indent().p(REPETITION).p(this.repetitionLevel).p(" = ");
            if (this.useBaseIndex) {
                this.printer.p(this.baseIndex).pln(';');
                this.useBaseIndex = false;
            } else {
                this.printer.p(this.resultName).pln(".index;");
            }
            if (this.repeatOnce) {
                this.printer.indent().p(REPEATED).p(this.repetitionLevel).pln("   = true;");
            }
            if (null != this.repeatedElement) {
                this.printer.indent().p(REP_VALUE).p(this.repetitionLevel).p("   = ").buffer().p("new Pair(").p(this.repeatedElement).p(", ").p(REP_VALUE).p(this.repetitionLevel).p(");").fitMore().pln();
            }
            this.printer.indent().pln("continue;");
        } else if (0 < this.optionLevel) {
            this.printer.pln();
            this.printer.indent().p(OPTION).p(this.optionLevel).p("  = ");
            if (this.useBaseIndex) {
                this.printer.p(this.baseIndex).pln(';');
                this.useBaseIndex = false;
            } else {
                this.printer.p(this.resultName).pln(".index;");
            }
            if (null != this.optionalElement) {
                this.printer.indent().p(OP_VALUE).p(this.optionLevel).p(" = ").p(this.optionalElement).pln(';');
            }
        } else {
            this.returnValue();
        }
    }

    private void location() {
        if (!this.attributeWithLocation) {
            return;
        }
        int n = Type.classify(this.analyzer.current().type);
        if (2 == n) {
            return;
        }
        if (3 == n) {
            this.printer.indent().p("if (").p(VALUE).pln(" instanceof Node) {").incr();
            this.printer.indent().p("setLocation((Node)").p(VALUE).p(", ").p(ARG_INDEX).pln(");");
            this.printer.decr().indent().pln('}');
        } else {
            this.printer.indent().p("setLocation(").p(VALUE).p(", ").p(ARG_INDEX).pln(");");
        }
    }

    protected void returnValue() {
        this.printer.pln();
        if (this.attributeStateful && this.analyzer.current().hasAttribute(Constants.ATT_STATEFUL)) {
            this.printer.indent().pln("// Commit the state modification.");
            this.printer.indent().p(STATE).pln(".commit();");
            this.printer.pln();
        }
        this.location();
        if (this.useBaseIndex) {
            this.printer.indent().p("return new SemanticValue(").p(VALUE).p(", ").p(this.baseIndex).p(", ").p(PARSE_ERROR).pln(");");
            this.useBaseIndex = false;
        } else if (Rats.optimizeValues) {
            this.printer.indent().p("return ").p(RESULT).p(".createValue(").p(VALUE).p(", ").p(PARSE_ERROR).pln(");");
        } else {
            this.printer.indent().p("return new SemanticValue(").p(VALUE).p(", ").p(RESULT).p(".index, ").p(PARSE_ERROR).pln(");");
        }
    }

    protected void parseError() {
        this.printer.indent().p(PARSE_ERROR).p(" = ").p(PARSE_ERROR).p(".select(\"").p(Utilities.toDescription(this.analyzer.current().name.unqualify().name)).p(" expected\", ").p(ARG_INDEX).pln(");");
    }

    protected void parseError(String string) {
        this.printer.indent().p(PARSE_ERROR).p(" = ").p(PARSE_ERROR).p(".select(\"\\\"").p(Utilities.escape(string, 10)).p("\\\" expected\", ").p(BASE_INDEX).pln(");");
    }

    protected String nestedChoice() {
        return NESTED_CHOICE + Integer.toString(this.choiceLevel);
    }

    public void visit(OrderedChoice orderedChoice) {
        String string = this.baseIndex;
        boolean bl = this.useBaseIndex;
        ++this.choiceLevel;
        if (0 != this.choiceLevel) {
            this.printer.pln();
            if (this.useBaseIndex) {
                this.printer.indent().p("final ").p(Type.intT()).p(' ').p(this.nestedChoice()).p(" = ").p(string).pln(';');
                this.useBaseIndex = false;
            } else {
                this.printer.indent().p("final ").p(Type.intT()).p(' ').p(this.nestedChoice()).p(" = ").buffer().p(this.resultName).p(".index;").fitMore().pln();
            }
        }
        Iterator iterator = orderedChoice.alternatives.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Sequence sequence = (Sequence)iterator.next();
            this.elementIter = sequence.iterator();
            if (0 == this.choiceLevel) {
                this.firstElement = true;
            }
            this.baseIndex = 0 == this.choiceLevel ? ARG_INDEX : this.nestedChoice();
            this.useBaseIndex = true;
            this.seenTest = false;
            ++n;
            this.printer.pln();
            if (0 == this.choiceLevel) {
                this.printer.indent().p("// Alternative ");
            } else {
                this.printer.indent().p("// Nested alternative ");
            }
            if (null == sequence.name) {
                this.printer.p(n).pln('.');
            } else {
                this.printer.p('<').p(sequence.name.name).pln(">.");
            }
            this.nextElement();
        }
        --this.choiceLevel;
        this.useBaseIndex = bl;
        this.baseIndex = string;
    }

    public void visit(Repetition repetition) {
        Iterator iterator;
        Object object;
        this.firstElement = false;
        String string = this.baseIndex;
        boolean bl = this.useBaseIndex;
        boolean bl2 = this.repeatOnce;
        this.repeatOnce = repetition.once;
        String string2 = this.repeatedElement;
        this.repeatedElement = this.hasBinding() ? (null == (object = this.analyzer.getBinding((Sequence)repetition.element)) ? null : ((Binding)object).name) : null;
        object = this.bindingName;
        this.bindingName = null;
        Element element = this.bindingElement;
        this.bindingElement = null;
        ++this.repetitionLevel;
        this.printer.pln();
        this.printer.indent().p(REPETITION).p(this.repetitionLevel).p(" = ");
        if (this.useBaseIndex) {
            this.printer.p(string).pln(';');
            this.useBaseIndex = false;
        } else {
            this.printer.p(this.resultName).pln(".index;");
        }
        if (this.repeatOnce) {
            this.printer.indent().p(REPEATED).p(this.repetitionLevel).pln("   = false;");
        }
        if (null != object) {
            this.printer.indent().p(REP_VALUE).p(this.repetitionLevel).pln("   = Pair.EMPTY;");
        }
        if (this.predicate) {
            iterator = this.predicateIter;
            this.predicateIter = ((Sequence)repetition.element).iterator();
        } else {
            iterator = this.elementIter;
            this.elementIter = ((Sequence)repetition.element).iterator();
        }
        this.printer.indent().pln("while (true) {").incr();
        this.baseIndex = REPETITION + Integer.toString(this.repetitionLevel);
        this.useBaseIndex = true;
        this.nextElement();
        this.printer.indent().pln("break;");
        this.printer.decr().indent().pln('}');
        if (this.predicate) {
            this.predicateIter = iterator;
        } else {
            this.elementIter = iterator;
        }
        if (this.repeatOnce) {
            this.printer.pln();
            this.printer.indent().p("if (").p(REPEATED).p(this.repetitionLevel).pln(") {").incr();
        }
        --this.repetitionLevel;
        this.repeatOnce = bl2;
        this.repeatedElement = string2;
        this.bindingName = object;
        this.bindingElement = element;
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.baseIndex = REPETITION + Integer.toString(this.repetitionLevel + 1);
        this.useBaseIndex = true;
        if (!repetition.once) {
            this.seenTest = false;
        }
        this.nextElement();
        if (repetition.once) {
            this.printer.decr().indent().pln('}');
            this.tested();
        }
        this.baseIndex = string;
        this.useBaseIndex = bl;
    }

    public void visit(Option option) {
        Iterator iterator;
        Object object;
        this.firstElement = false;
        String string = this.baseIndex;
        boolean bl = this.useBaseIndex;
        String string2 = this.optionalElement;
        this.optionalElement = this.hasBinding() ? (null == (object = this.analyzer.getBinding((Sequence)option.element)) ? null : ((Binding)object).name) : null;
        object = this.bindingName;
        this.bindingName = null;
        Element element = this.bindingElement;
        this.bindingElement = null;
        ++this.optionLevel;
        this.printer.pln();
        this.printer.indent().p(OPTION).p(this.optionLevel).p("  = ");
        if (this.useBaseIndex) {
            this.printer.p(string).pln(';');
            this.useBaseIndex = false;
        } else {
            this.printer.p(this.resultName).pln(".index;");
        }
        if (null != object) {
            this.printer.indent().p(OP_VALUE).p(this.optionLevel).pln(" = null;");
        }
        if (this.predicate) {
            iterator = this.predicateIter;
            this.predicateIter = ((Sequence)option.element).iterator();
        } else {
            iterator = this.elementIter;
            this.elementIter = ((Sequence)option.element).iterator();
        }
        this.baseIndex = OPTION + Integer.toString(this.optionLevel);
        this.useBaseIndex = true;
        this.nextElement();
        if (this.predicate) {
            this.predicateIter = iterator;
        } else {
            this.elementIter = iterator;
        }
        --this.optionLevel;
        this.optionalElement = string2;
        this.bindingName = object;
        this.bindingElement = element;
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.baseIndex = OPTION + Integer.toString(this.optionLevel + 1);
        this.useBaseIndex = true;
        this.seenTest = false;
        this.nextElement();
        this.baseIndex = string;
        this.useBaseIndex = bl;
    }

    public void visit(FollowedBy followedBy) {
        if (this.predicate) {
            throw new IllegalStateException("Predicate within predicate");
        }
        this.predicate = true;
        this.notFollowedBy = false;
        this.savedFirstElement = this.firstElement;
        this.savedBaseIndex = this.baseIndex;
        if (!this.useBaseIndex) {
            this.baseIndex = "yyResult.index";
        }
        this.savedUseBaseIndex = this.useBaseIndex;
        this.savedRepetitionLevel = this.repetitionLevel;
        this.savedOptionLevel = this.optionLevel;
        this.useBaseIndex = true;
        this.indexName = PRED_INDEX;
        this.resultName = PRED_RESULT;
        this.predicateIter = ((Sequence)followedBy.element).iterator();
        this.nextElement();
        this.tested();
    }

    protected boolean notFollowedBy() {
        return this.predicate && this.notFollowedBy;
    }

    public void visit(NotFollowedBy notFollowedBy) {
        if (this.predicate) {
            throw new IllegalStateException("Predicate within predicate");
        }
        this.predicate = true;
        this.notFollowedBy = true;
        this.savedFirstElement = this.firstElement;
        this.savedBaseIndex = this.baseIndex;
        if (!this.useBaseIndex) {
            this.baseIndex = "yyResult.index";
        }
        this.savedUseBaseIndex = this.useBaseIndex;
        this.useBaseIndex = true;
        this.savedRepetitionLevel = this.repetitionLevel;
        this.savedOptionLevel = this.optionLevel;
        this.indexName = PRED_INDEX;
        this.resultName = PRED_RESULT;
        this.predicateIter = ((Sequence)notFollowedBy.element).iterator();
        this.printer.pln();
        this.printer.indent().p(PRED_MATCHED).pln(" = false;");
        this.nextElement();
        this.predicate = false;
        this.firstElement = this.savedFirstElement;
        this.baseIndex = this.savedBaseIndex;
        this.useBaseIndex = this.savedUseBaseIndex;
        this.indexName = INDEX;
        this.resultName = RESULT;
        this.printer.pln();
        this.printer.indent().p("if (! ").p(PRED_MATCHED).pln(") {").incr();
        this.nextElement();
        this.printer.decr().indent().pln("} else {").incr();
        this.parseError();
        this.printer.decr().indent().pln('}');
        this.tested();
    }

    public void visit(SemanticPredicate semanticPredicate) {
        this.printer.pln().indent().p("if (");
        Action action = (Action)semanticPredicate.element;
        if (1 == action.code.size()) {
            this.printer.p((String)action.code.get(0)).pln(") {").incr();
        } else {
            boolean bl = true;
            Iterator iterator = action.code.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    this.printer.p((String)iterator.next()).incr();
                    bl = false;
                } else {
                    this.printer.pln().indent().p((String)iterator.next());
                }
                this.printer.pln(") {");
            }
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(VoidedElement voidedElement) {
        this.dispatch(voidedElement.element);
    }

    public void visit(Binding binding) {
        String string = this.bindingName;
        Element element = this.bindingElement;
        this.bindingName = binding.name;
        this.bindingElement = binding.element;
        this.dispatch(binding.element);
        this.bindingName = string;
        this.bindingElement = element;
    }

    protected boolean hasBinding() {
        return null != this.bindingName;
    }

    protected void binding() {
        if (this.bindingElement instanceof NonTerminal) {
            String string = VALUE.equals(this.bindingName) ? this.analyzer.current().type : this.analyzer.lookup((NonTerminal)((NonTerminal)this.bindingElement)).type;
            this.binding1(string, this.bindingName, Type.isRootT(string) ? null : string, this.resultName + ".semanticValue()");
        } else if (this.bindingElement instanceof CharTerminal) {
            if (VALUE.equals(this.bindingName)) {
                this.binding1(Type.charRefT(), this.bindingName, null, "new Character((char)yyC)");
            } else {
                this.binding1(Type.charT(), this.bindingName, null, "(char)yyC");
            }
        } else if (this.bindingElement instanceof StringLiteral) {
            this.binding1(Type.stringT(), this.bindingName, null, "\"" + Utilities.escape(((StringLiteral)this.bindingElement).text, 8) + "\"");
        } else if (this.bindingElement instanceof StringMatch) {
            this.binding1(Type.stringT(), this.bindingName, null, "\"" + Utilities.escape(((StringMatch)this.bindingElement).text, 8) + "\"");
        } else if (this.bindingElement instanceof Repetition) {
            int n = this.repetitionLevel + 1;
            this.binding1(Type.listT(), this.bindingName, null, REP_VALUE + n + ".reverse()");
        } else if (this.bindingElement instanceof Option) {
            int n = this.optionLevel + 1;
            this.binding1((String)this.optionTypes.get(this.optionLevel), this.bindingName, null, OP_VALUE + n);
        } else {
            throw new IllegalStateException("Unrecognized binding element " + this.bindingElement);
        }
    }

    private void binding1(String string, String string2, String string3, String string4) {
        this.printer.indent();
        if (VALUE.equals(string2)) {
            this.printer.p(VALUE).p(" = ");
        } else {
            if (this.attributeConstant) {
                this.printer.p("final ");
            }
            this.printer.p(string).p(' ').p(string2).p(" = ");
        }
        if (null != string3) {
            this.printer.p('(').p(string3).p(')');
        }
        this.printer.p(string4).pln(';');
    }

    protected void clearBinding() {
        this.bindingName = null;
        this.bindingElement = null;
    }

    public void visit(StringMatch stringMatch) {
        boolean bl = this.firstElement;
        NonTerminal nonTerminal = (NonTerminal)stringMatch.element;
        this.result(this.methodName(nonTerminal), !this.notFollowedBy() && (!Rats.optimizeErrors1 || !bl));
        this.stringValueTest(stringMatch.text);
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        if (this.notFollowedBy()) {
            this.printer.decr().indent().pln('}');
        } else if (Rats.optimizeErrors1 && bl) {
            this.printer.decr().indent().pln('}');
            this.endsWithParseError = true;
        } else {
            this.printer.decr().indent().pln("} else {").incr();
            this.parseError(stringMatch.text);
            this.printer.decr().indent().pln('}');
        }
        this.tested();
    }

    public void visit(NonTerminal nonTerminal) {
        this.result(this.methodName(nonTerminal), false);
        this.valueTest();
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        if (!this.notFollowedBy() && this.analyzer.lookup(nonTerminal).hasAttribute(Constants.ATT_TRANSIENT) && Rats.optimizeErrors2) {
            this.endsWithParseError = true;
        }
        this.printer.decr().indent().pln('}');
        this.tested();
    }

    public void visit(AnyChar anyChar) {
        String string = this.useBaseIndex ? this.baseIndex : this.resultName + ".index";
        this.result(PARSE_CHAR, false);
        this.charValueTest();
        this.index(string);
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(CharLiteral charLiteral) {
        String string = this.useBaseIndex ? this.baseIndex : this.resultName + ".index";
        this.result(PARSE_CHAR, false);
        this.printer.indent().p("if ('").escape(charLiteral.c, 8).p("' == ").p(CHAR).pln(") {").incr();
        this.index(string);
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(CharClass charClass) {
        String string;
        String string2 = this.useBaseIndex ? this.baseIndex : this.resultName + ".index";
        this.result(PARSE_CHAR, false);
        this.charValueTest();
        this.index(string2);
        if (this.hasBinding()) {
            this.binding();
            string = this.bindingName;
            this.clearBinding();
            this.printer.pln();
        } else {
            string = CHAR;
        }
        int n = charClass.ranges.size();
        Iterator iterator = charClass.ranges.iterator();
        if (1 == n) {
            this.printer.indent().p("if ");
        } else {
            this.printer.indent().p("if (");
        }
        while (iterator.hasNext()) {
            CharRange charRange = (CharRange)iterator.next();
            if (charClass.exclusive) {
                if (charRange.first == charRange.last) {
                    this.printer.p("('").escape(charRange.first, 8).p("' != ").p(string).p(')');
                } else {
                    this.printer.p('(').p(string).p(" < '").escape(charRange.first, 8).p(") || ('").escape(charRange.last, 8).p("' < ").p(string).p("))");
                }
            } else if (charRange.first == charRange.last) {
                this.printer.p("('").escape(charRange.first, 8).p("' == ").p(string).p(')');
            } else {
                this.printer.p("(('").escape(charRange.first, 8).p("' <= ").p(string).p(") && (").p(string).p(" <= '").escape(charRange.last, 8).p("'))");
            }
            if (!iterator.hasNext()) continue;
            if (charClass.exclusive) {
                this.printer.pln(" &&");
            } else {
                this.printer.pln(" ||");
            }
            this.printer.indent().p("    ");
        }
        if (1 == n) {
            this.printer.pln(" {").incr();
        } else {
            this.printer.pln(") {").incr();
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(StringLiteral stringLiteral) {
        int n;
        boolean bl = this.firstElement;
        int n2 = stringLiteral.text.length();
        for (n = 0; n < n2; ++n) {
            char c = stringLiteral.text.charAt(n);
            String string = this.useBaseIndex ? this.baseIndex : this.resultName + ".index";
            this.result(PARSE_CHAR, 0 == n && !this.notFollowedBy() && (!Rats.optimizeErrors1 || !bl));
            this.printer.indent().p("if ('").escape(c, 8).p("' == ").p(CHAR).pln(") {").incr();
            this.index(string);
        }
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        for (n = 0; n < n2; ++n) {
            if (this.notFollowedBy()) {
                this.printer.decr().indent().pln('}');
                continue;
            }
            if (Rats.optimizeErrors1 && bl) {
                this.printer.decr().indent().pln('}');
                this.endsWithParseError = true;
                continue;
            }
            this.printer.decr().indent().pln("} else {").incr();
            this.parseError(stringLiteral.text);
            this.printer.decr().indent().pln('}');
        }
        this.tested();
    }

    public void visit(CharSwitch charSwitch) {
        String string;
        String string2 = this.useBaseIndex ? this.baseIndex : this.resultName + ".index";
        this.result(PARSE_CHAR, false);
        this.charValueTest();
        this.index(string2);
        this.printer.pln();
        String string3 = this.baseIndex;
        boolean bl = this.useBaseIndex;
        if (this.hasBinding()) {
            this.binding();
            string = this.bindingName;
            this.clearBinding();
            this.printer.pln();
        } else {
            string = CHAR;
        }
        this.printer.indent().p("switch (").p(string).pln(") {").incr();
        Iterator iterator = charSwitch.cases.iterator();
        while (iterator.hasNext()) {
            CharCase charCase = (CharCase)iterator.next();
            Iterator iterator2 = charCase.klass.ranges.iterator();
            while (iterator2.hasNext()) {
                CharRange charRange = (CharRange)iterator2.next();
                for (char c = charRange.first; c <= charRange.last; c = (char)(c + '\u0001')) {
                    this.printer.indentLess().p("case '").escape(c, 8).pln("':");
                }
            }
            if (null == charCase.element) {
                this.printer.indent().pln("/* No match. */");
                this.printer.indent().pln("break;");
            } else {
                this.printer.indent().p('{').incr();
                this.baseIndex = string3;
                this.useBaseIndex = bl;
                this.seenTest = false;
                if (charCase.element instanceof OrderedChoice) {
                    this.dispatch(charCase.element);
                } else {
                    this.elementIter = ((Sequence)charCase.element).iterator();
                    this.nextElement();
                }
                this.printer.decr().indent().pln('}');
                if (this.seenTest) {
                    this.printer.indent().pln("break;");
                }
            }
            this.printer.pln();
        }
        if (null == charSwitch.base) {
            this.printer.indentLess().pln("default:");
            this.printer.indent().pln("/* No match. */");
        } else {
            this.printer.indentLess().pln("default:");
            this.printer.indent().p('{').incr();
            this.baseIndex = string3;
            this.useBaseIndex = bl;
            if (charSwitch.base instanceof OrderedChoice) {
                this.dispatch(charSwitch.base);
            } else {
                this.elementIter = ((Sequence)charSwitch.base).iterator();
                this.nextElement();
            }
            this.printer.decr().indent().pln('}');
        }
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.endsWithParseError = true;
        this.tested();
    }

    protected void action(Action action) {
        int n = this.printer.level();
        int n2 = 0;
        Iterator iterator = action.code.iterator();
        Iterator iterator2 = action.indent.iterator();
        while (iterator.hasNext()) {
            int n3;
            int n4 = (Integer)iterator2.next();
            int n5 = n4 - n2;
            n2 = n4;
            if (0 < n5) {
                for (n3 = 0; n3 < n5; ++n3) {
                    this.printer.incr();
                }
            } else {
                for (n3 = 0; n3 > n5; --n3) {
                    this.printer.decr();
                }
            }
            this.printer.indent().pln(iterator.next().toString());
        }
        this.printer.setLevel(n);
    }

    public void visit(Action action) {
        this.printer.pln();
        this.action(action);
        this.nextElement();
    }

    public void visit(ParserAction parserAction) {
        this.printer.pln();
        if (this.useBaseIndex) {
            this.printer.indent().p(BASE_INDEX).p(" = ").p(this.baseIndex).pln(';');
            this.useBaseIndex = false;
        } else {
            this.printer.indent().p(BASE_INDEX).p(" = ").p(this.resultName).pln(".index;");
        }
        this.printer.pln();
        this.action((Action)parserAction.element);
        this.printer.pln();
        if (!this.notFollowedBy()) {
            if (Rats.optimizeSelect) {
                this.printer.indent().p(PARSE_ERROR).p(" = ").buffer().p(this.resultName).p(".select(").p(PARSE_ERROR).p(");").fitMore().pln();
            } else {
                this.printer.indent().p(PARSE_ERROR).p(" = ").buffer().p(PARSE_ERROR).p(".select(").p(this.resultName).p(".parseError());").fitMore().pln();
            }
        }
        this.valueTest();
        String string = Type.isVoidT(this.analyzer.current().type) ? Type.voidRefT() : this.analyzer.current().type;
        this.printer.indent().p(VALUE).p(" = ");
        if (!Type.isRootT(string)) {
            this.printer.p('(').p(string).p(')');
        }
        this.printer.p(RESULT).p(".semanticValue();");
        this.nextElement();
        this.printer.decr().indent().pln('}');
        this.tested();
    }

    public void visit(NullValue nullValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).pln(" = null;");
        this.nextElement();
    }

    public void visit(StringValue stringValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = \"").escape(stringValue.text, 8).pln("\";");
        this.nextElement();
    }

    public void visit(TextValue textValue) {
        if (this.predicate) {
            throw new IllegalStateException("Text value within predicate");
        }
        this.printer.pln();
        if (this.firstElement) {
            this.printer.indent().p(VALUE).pln(" = \"\";");
        } else if (this.useBaseIndex) {
            this.printer.indent().p(VALUE).p(" = difference(").p(ARG_INDEX).p(", ").p(this.baseIndex).pln(");");
        } else {
            this.printer.indent().p(VALUE).p(" = difference(").p(ARG_INDEX).p(", ").p(RESULT).pln(".index);");
        }
        this.nextElement();
    }

    public void visit(EmptyListValue emptyListValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).pln(" = Pair.EMPTY;");
        this.nextElement();
    }

    public void visit(SingletonListValue singletonListValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = new Pair(").p(singletonListValue.value).pln(");");
        this.nextElement();
    }

    public void visit(ProperListValue properListValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = new Pair(").p(properListValue.value).p(", ").p(properListValue.list).pln(");");
        this.nextElement();
    }

    public void visit(ActionBaseValue actionBaseValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = ");
        if (!Type.isRootT(this.analyzer.current().type)) {
            this.printer.p('(').p(this.analyzer.current().type).p(')');
        }
        this.printer.p("Action.run(").p(actionBaseValue.list).p(", ").p(actionBaseValue.seed).pln(");");
        this.nextElement();
    }

    protected void numberOfChildren(int n, List list) {
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Binding binding = (Binding)iterator.next();
            if (Type.isListT(Type.type(binding.element, this.analyzer))) {
                if (bl) {
                    this.printer.p(" + ");
                } else {
                    bl = true;
                }
                this.printer.p("((Pair)").p(binding.name).p(").size()");
                continue;
            }
            ++n;
        }
        if (!bl) {
            this.printer.p(n);
        } else if (0 != n) {
            this.printer.p(" + ").p(n);
        }
    }

    public void visit(GenericNodeValue genericNodeValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = new GNode(\"").p(genericNodeValue.name).p("\", ");
        this.numberOfChildren(0, genericNodeValue.children);
        this.printer.p(')');
        Iterator iterator = genericNodeValue.children.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (bl) {
                this.printer.pln('.').indentMore();
                bl = false;
            } else {
                this.printer.p('.');
            }
            Binding binding = (Binding)iterator.next();
            if (Type.isListT(Type.type(binding.element, this.analyzer))) {
                this.printer.p("addAll((Pair)");
            } else {
                this.printer.p("add(");
            }
            this.printer.p(binding.name).p(')');
        }
        this.printer.pln(';');
        this.nextElement();
    }

    public void visit(GenericActionValue genericActionValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).pln(" = new Action() {").incr().incr();
        this.printer.indent().p("public Object run(Object ").p(genericActionValue.first).pln(") {").incr();
        this.printer.indent().p("return new GNode(\"").p(genericActionValue.name).p("\", ");
        this.numberOfChildren(1, genericActionValue.children);
        this.printer.pln(").");
        this.printer.indentMore().p("add(").p(genericActionValue.first).p(')');
        Iterator iterator = genericActionValue.children.iterator();
        while (iterator.hasNext()) {
            this.printer.p('.');
            Binding binding = (Binding)iterator.next();
            if (Type.isListT(Type.type(binding.element, this.analyzer))) {
                this.printer.p("addAll((Pair)");
            } else {
                this.printer.p("add(");
            }
            this.printer.p(binding.name).p(')');
        }
        this.printer.pln(';').decr();
        this.printer.indent().p("}};").decr().decr();
        this.nextElement();
    }

    public void visit(GenericRecursionValue genericRecursionValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).pln(" = new Pair(new Action() {").incr().incr();
        this.printer.indent().p("public Object run(Object ").p(genericRecursionValue.first).pln(") {").incr();
        this.printer.indent().p("return new GNode(\"").p(genericRecursionValue.name).p("\", ");
        this.numberOfChildren(1, genericRecursionValue.children);
        this.printer.pln(").");
        this.printer.indentMore().p("add(").p(genericRecursionValue.first).p(')');
        Iterator iterator = genericRecursionValue.children.iterator();
        while (iterator.hasNext()) {
            this.printer.p('.');
            Binding binding = (Binding)iterator.next();
            if (Type.isListT(Type.type(binding.element, this.analyzer))) {
                this.printer.p("addAll((Pair)");
            } else {
                this.printer.p("add(");
            }
            this.printer.p(binding.name).p(')');
        }
        this.printer.pln(';').decr();
        this.printer.indent().p("}}, ").p(genericRecursionValue.list).pln(");").decr().decr();
        this.nextElement();
    }
}

