/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharLiteral;
import xtc.parser.CharRange;
import xtc.parser.CharSwitch;
import xtc.parser.Copier;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.ModuleDependency;
import xtc.parser.ModuleName;
import xtc.parser.NonTerminal;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.Renamer;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.Type;
import xtc.parser.UnaryOperator;
import xtc.parser.ValueElement;
import xtc.parser.VoidedElement;
import xtc.tree.Utility;
import xtc.util.Utilities;

public class Analyzer
extends Utility {
    public static final String SIMPLE_VALUE = "xtc.parser.Analyzer.SimpleValue";
    public static final String SEPARATOR = "$$";
    public static final String SHARED = "$$Shared";
    public static final String VARIABLE = "v$";
    public static final String CHOICE = "$$Choice";
    public static final String STAR = "$$Star";
    public static final String PLUS = "$$Plus";
    public static final String OPTION = "$$Option";
    public static final String TAIL = "$$Tail";
    public static final int MAX_COUNT = 22;
    protected final Copier xerox = new Copier();
    protected boolean isGrammarMode = false;
    protected Grammar grammar;
    protected Map moduleMap = new HashMap();
    protected Map grammarPMap = new HashMap();
    protected Module mCurrent;
    protected Module module;
    protected Map pMap = new HashMap();
    protected Production pCurrent;
    protected Set pWorking = new HashSet();
    protected Set pMarked = new HashSet();
    protected Set pProcessed = new HashSet();
    protected List pNew = new ArrayList();
    protected int varCount;
    protected int choiceCount;
    protected int starCount;
    protected int plusCount;
    protected int optionCount;
    protected int tailCount;
    protected int sharedCount = 1;

    public void reset() {
        this.isGrammarMode = false;
        this.grammar = null;
        this.moduleMap.clear();
        this.grammarPMap.clear();
        this.mCurrent = null;
        this.module = null;
        this.pCurrent = null;
        this.pMap.clear();
        this.pWorking.clear();
        this.pMarked.clear();
        this.pProcessed.clear();
        this.pNew.clear();
        this.varCount = 1;
        this.choiceCount = 1;
        this.starCount = 1;
        this.plusCount = 1;
        this.optionCount = 1;
        this.tailCount = 1;
        this.sharedCount = 1;
    }

    public void init(Grammar grammar) {
        if (this.grammar != grammar) {
            this.grammar = grammar;
            this.moduleMap.clear();
            this.grammarPMap.clear();
            Iterator iterator = grammar.modules.iterator();
            while (iterator.hasNext()) {
                Module module = (Module)iterator.next();
                this.moduleMap.put(module.name.name, module);
                Iterator iterator2 = module.productions.iterator();
                while (iterator2.hasNext()) {
                    Production production = (Production)iterator2.next();
                    if (null == production.qName) {
                        production.qName = production.name.qualify(module.name.name);
                    }
                    if (!production.isFull()) continue;
                    this.addToGrammarMap((FullProduction)production);
                }
            }
        }
        this.pMarked.clear();
        this.pProcessed.clear();
        this.pCurrent = null;
        this.mCurrent = null;
        this.isGrammarMode = true;
    }

    public boolean isImported(String string, Module module) {
        while (null != module) {
            if (null != module.dependencies) {
                Iterator iterator = module.dependencies.iterator();
                while (iterator.hasNext()) {
                    ModuleDependency moduleDependency = (ModuleDependency)iterator.next();
                    if (!moduleDependency.isImport() || !moduleDependency.visibleName().name.equals(string)) continue;
                    return true;
                }
                if (null != module.modification) {
                    module = this.lookup(module.modification.visibleName());
                    continue;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void trace(Module module, Set set, Map map) {
        Object object;
        if (null != module.modification) {
            if (map.containsKey(module.modification.visibleName())) {
                map.put(module.modification.visibleName(), Boolean.TRUE);
            } else {
                map.put(module.modification.visibleName(), Boolean.FALSE);
                object = this.lookup(module.modification.visibleName());
                if (null != object) {
                    this.trace((Module)object, set, map);
                }
            }
        }
        if (null != module.dependencies) {
            object = module.dependencies.iterator();
            while (object.hasNext()) {
                ModuleDependency moduleDependency = (ModuleDependency)object.next();
                if (!moduleDependency.isImport() || set.contains(moduleDependency.visibleName())) continue;
                set.add(moduleDependency.visibleName());
                Module module2 = this.lookup(moduleDependency.visibleName());
                if (null == module2) continue;
                this.trace(module2, set, map);
            }
        }
    }

    public boolean hasAttribute(Module module, String string, Set set) {
        if (!set.contains(module.name)) {
            set.add(module.name);
            if (module.hasAttribute(string)) {
                return true;
            }
            if (null != module.dependencies) {
                Iterator iterator = module.dependencies.iterator();
                while (iterator.hasNext()) {
                    Module module2;
                    ModuleDependency moduleDependency = (ModuleDependency)iterator.next();
                    if (!moduleDependency.isImport() && !moduleDependency.isModification() || null == (module2 = this.lookup(moduleDependency.visibleName())) || !this.hasAttribute(module2, string, set)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void add(Module module) {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        if (!this.moduleMap.containsKey(module.name)) {
            this.moduleMap.put(module.name.name, module);
            Iterator iterator = module.productions.iterator();
            while (iterator.hasNext()) {
                Production production = (Production)iterator.next();
                if (!production.isFull()) continue;
                this.addToGrammarMap((FullProduction)production);
            }
        }
    }

    public void remove(Module module) {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        this.moduleMap.remove(module.name.name);
        Iterator iterator = module.productions.iterator();
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            if (!production.isFull()) continue;
            this.removeFromGrammarMap((FullProduction)production);
        }
    }

    private void addToGrammarMap(FullProduction fullProduction) {
        if (!this.grammarPMap.containsKey(fullProduction.qName)) {
            this.grammarPMap.put(fullProduction.qName, fullProduction);
            if (this.grammarPMap.containsKey(fullProduction.name)) {
                Object v = this.grammarPMap.get(fullProduction.name);
                if (v instanceof FullProduction) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(v);
                    arrayList.add(fullProduction);
                    this.grammarPMap.put(fullProduction.name, arrayList);
                } else {
                    List list = (List)v;
                    list.add(fullProduction);
                }
            } else {
                this.grammarPMap.put(fullProduction.name, fullProduction);
            }
        }
    }

    private void removeFromGrammarMap(FullProduction fullProduction) {
        this.grammarPMap.remove(fullProduction.qName);
        Object object = this.grammarPMap.get(fullProduction.name);
        if (object instanceof FullProduction) {
            if (fullProduction.qName.equals(((FullProduction)object).qName)) {
                this.grammarPMap.remove(fullProduction.name);
            }
        } else {
            List list = (List)object;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!fullProduction.qName.equals(((FullProduction)iterator.next()).qName)) continue;
                iterator.remove();
                break;
            }
            if (1 == list.size()) {
                object = list.get(0);
                this.grammarPMap.put(fullProduction.name, object);
            }
        }
    }

    public Grammar grammar() {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        return this.grammar;
    }

    public boolean isTopLevel(Module module) {
        return this.isGrammarMode ? module == this.grammar.modules.get(0) : module == this.module;
    }

    public Module topLevel() {
        return this.isGrammarMode ? (Module)this.grammar.modules.get(0) : this.module;
    }

    public void init(Module module) {
        if (this.module != module) {
            this.module = module;
            this.pMap.clear();
            Iterator iterator = module.productions.iterator();
            while (iterator.hasNext()) {
                Production production = (Production)iterator.next();
                if (!production.isFull()) continue;
                this.pMap.put(production.name, production);
                this.pMap.put(production.qName, production);
            }
        }
        this.pMarked.clear();
        this.pProcessed.clear();
        this.pCurrent = null;
        this.mCurrent = null;
        this.isGrammarMode = false;
    }

    public Module module() {
        if (this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with module");
        }
        return this.module;
    }

    public Module lookup(String string) {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        return (Module)this.moduleMap.get(string);
    }

    public Module lookup(ModuleName moduleName) {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        return (Module)this.moduleMap.get(moduleName.name);
    }

    public FullProduction lookupGlobally(NonTerminal nonTerminal) {
        if (this.isGrammarMode) {
            return nonTerminal.isQualified() ? (FullProduction)this.grammarPMap.get(nonTerminal) : null;
        }
        return (FullProduction)this.pMap.get(nonTerminal);
    }

    public FullProduction lookup(NonTerminal nonTerminal, Module module) {
        Object v;
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        if (nonTerminal.isQualified()) {
            if (nonTerminal.getQualifier().equals(module.name.name)) {
                if (this.grammarPMap.containsKey(nonTerminal)) {
                    return (FullProduction)this.grammarPMap.get(nonTerminal);
                }
                nonTerminal = nonTerminal.unqualify();
            } else {
                return null;
            }
        }
        if (null == (v = this.grammarPMap.get(nonTerminal))) {
            return null;
        }
        if (v instanceof FullProduction) {
            FullProduction fullProduction = (FullProduction)v;
            return this.isDefined(fullProduction, module) ? fullProduction : null;
        }
        FullProduction fullProduction = null;
        Iterator iterator = ((List)v).iterator();
        while (iterator.hasNext()) {
            FullProduction fullProduction2 = (FullProduction)iterator.next();
            if (!this.isDefined(fullProduction2, module)) continue;
            if (null == fullProduction) {
                fullProduction = fullProduction2;
                continue;
            }
            throw new IllegalArgumentException("Multiple definitions for " + nonTerminal);
        }
        return fullProduction;
    }

    public FullProduction lookup(NonTerminal nonTerminal) {
        if (this.isGrammarMode) {
            FullProduction fullProduction;
            if (nonTerminal.isQualified()) {
                String string = nonTerminal.getQualifier();
                if (string.equals(this.mCurrent.name.name)) {
                    return this.lookup(nonTerminal, this.mCurrent);
                }
                if (this.isImported(string, this.mCurrent)) {
                    Module module = this.lookup(string);
                    return null != module ? this.lookup(nonTerminal, module) : null;
                }
                return null;
            }
            Object v = this.grammarPMap.get(nonTerminal);
            if (null == v) {
                return null;
            }
            if (v instanceof FullProduction) {
                FullProduction fullProduction2 = (FullProduction)v;
                return this.isDefined(fullProduction2, this.mCurrent) || this.isImported(fullProduction2, this.mCurrent) ? fullProduction2 : null;
            }
            FullProduction fullProduction3 = null;
            List list = (List)v;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                fullProduction = (FullProduction)iterator.next();
                if (!this.isDefined(fullProduction, this.mCurrent)) continue;
                if (null == fullProduction3) {
                    fullProduction3 = fullProduction;
                    continue;
                }
                throw new IllegalArgumentException("Multiple definitions for " + nonTerminal);
            }
            if (null != fullProduction3) {
                return fullProduction3;
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                fullProduction = (FullProduction)iterator.next();
                if (!this.isImported(fullProduction, this.mCurrent)) continue;
                if (null == fullProduction3) {
                    fullProduction3 = fullProduction;
                    continue;
                }
                throw new IllegalArgumentException("Multiple imported definitions for " + nonTerminal);
            }
            return fullProduction3;
        }
        return (FullProduction)this.pMap.get(nonTerminal);
    }

    public boolean isDefined(Production production, Module module) {
        String string = production.qName.getQualifier();
        if (module.name.name.equals(string)) {
            return true;
        }
        while (null != module.modification && null != (module = (Module)this.moduleMap.get(module.modification.visibleName().name))) {
            if (!module.name.name.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isImported(Production production, Module module) {
        if (this.isImported1(production, module)) {
            return !production.hasAttribute(Constants.ATT_PRIVATE);
        }
        while (null != module.modification && null != (module = (Module)this.moduleMap.get(module.modification.visibleName().name))) {
            if (!this.isImported1(production, module)) continue;
            return !production.hasAttribute(Constants.ATT_PRIVATE);
        }
        return false;
    }

    private boolean isImported1(Production production, Module module) {
        if (null != module.dependencies) {
            Iterator iterator = module.dependencies.iterator();
            while (iterator.hasNext()) {
                ModuleDependency moduleDependency = (ModuleDependency)iterator.next();
                if (!moduleDependency.isImport() || null == (module = (Module)this.moduleMap.get(moduleDependency.visibleName().name)) || !this.isDefined(production, module)) continue;
                return true;
            }
        }
        return false;
    }

    public void uniquify() {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        HashSet<NonTerminal> hashSet = new HashSet<NonTerminal>();
        HashSet<NonTerminal> hashSet2 = new HashSet<NonTerminal>();
        Iterator iterator = this.grammar.modules.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            Iterator iterator2 = module.productions.iterator();
            while (iterator2.hasNext()) {
                Object object;
                Object object2;
                FullProduction fullProduction = (FullProduction)iterator2.next();
                if (hashSet.contains(fullProduction.qName)) continue;
                Object v = this.grammarPMap.get(fullProduction.name);
                if (v instanceof FullProduction) {
                    hashSet.add(fullProduction.qName);
                    continue;
                }
                List list = (List)v;
                hashSet2.add(fullProduction.name);
                ArrayList<NonTerminal> arrayList = new ArrayList<NonTerminal>();
                Iterator iterator3 = list.iterator();
                while (iterator3.hasNext()) {
                    object2 = (FullProduction)iterator3.next();
                    object = ((FullProduction)object2).qName.getQualifier();
                    if (Utilities.isQualified((String)object)) {
                        arrayList.add(((FullProduction)object2).name.qualify(Utilities.getName((String)object)));
                        continue;
                    }
                    arrayList.add(((FullProduction)object2).qName);
                }
                if (arrayList.size() == new HashSet(arrayList).size()) {
                    iterator3 = list.iterator();
                    object2 = arrayList.iterator();
                    while (iterator3.hasNext()) {
                        object = (FullProduction)iterator3.next();
                        ((FullProduction)object).name = (NonTerminal)object2.next();
                        hashSet.add(((FullProduction)object).qName);
                    }
                    continue;
                }
                iterator3 = list.iterator();
                while (iterator3.hasNext()) {
                    object2 = (FullProduction)iterator3.next();
                    ((FullProduction)object2).name = ((FullProduction)object2).qName;
                    hashSet.add(((FullProduction)object2).qName);
                }
            }
        }
        new Renamer(this, new Renamer.Translation(){

            public NonTerminal map(NonTerminal nonTerminal, Analyzer analyzer) {
                return analyzer.lookup((NonTerminal)nonTerminal).name;
            }
        }).dispatch(this.grammar);
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            this.grammarPMap.remove(iterator.next());
        }
    }

    public void process(Module module) {
        if (this.isGrammarMode) {
            this.mCurrent = module;
        } else if (module != this.module) {
            throw new IllegalArgumentException("Invalid module " + module);
        }
    }

    public Module currentModule() {
        return this.isGrammarMode ? this.mCurrent : this.module;
    }

    public Object enter(Production production) {
        if (this.isGrammarMode) {
            Module module = this.mCurrent;
            this.mCurrent = this.lookup(production.qName.getQualifier());
            return module;
        }
        return null;
    }

    public void exit(Object object) {
        if (this.isGrammarMode) {
            this.mCurrent = (Module)object;
        }
    }

    public void process(Production production) {
        this.pWorking.clear();
        this.varCount = 1;
        this.choiceCount = 1;
        this.starCount = 1;
        this.plusCount = 1;
        this.optionCount = 1;
        this.tailCount = 1;
        this.pCurrent = production;
        this.visitor().dispatch(production);
    }

    public Production current() {
        return this.pCurrent;
    }

    public void workingOn(NonTerminal nonTerminal) {
        this.pWorking.add(nonTerminal);
    }

    public void notWorkingOn(NonTerminal nonTerminal) {
        this.pWorking.remove(nonTerminal);
    }

    public void notWorkingOnAny() {
        this.pWorking.clear();
    }

    public boolean isBeingWorkedOn(NonTerminal nonTerminal) {
        return this.pWorking.contains(nonTerminal);
    }

    public Set working() {
        return this.pWorking;
    }

    public void mark(NonTerminal nonTerminal) {
        this.pMarked.add(nonTerminal);
    }

    public void mark(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.pMarked.add((NonTerminal)iterator.next());
        }
    }

    public void markAll() {
        Iterator iterator = this.module.productions.iterator();
        while (iterator.hasNext()) {
            this.pMarked.add(((Production)iterator.next()).qName);
        }
    }

    public void unmark(NonTerminal nonTerminal) {
        this.pMarked.remove(nonTerminal);
    }

    public void unmarkAll() {
        this.pMarked.clear();
    }

    public boolean hasMarked() {
        return !this.pMarked.isEmpty();
    }

    public boolean isMarked(NonTerminal nonTerminal) {
        return this.pMarked.contains(nonTerminal);
    }

    public Set marked() {
        return this.pMarked;
    }

    public void clearProcessed() {
        this.pProcessed.clear();
    }

    public void processed(NonTerminal nonTerminal) {
        this.pProcessed.add(nonTerminal);
    }

    public boolean isProcessed(NonTerminal nonTerminal) {
        return this.pProcessed.contains(nonTerminal);
    }

    public void startAdding() {
        this.pNew.clear();
    }

    public void add(FullProduction fullProduction) {
        fullProduction.setProperty("xtc.Constants.Synthetic", Boolean.TRUE);
        this.pNew.add(fullProduction);
        this.pMap.put(fullProduction.name, fullProduction);
        this.pMap.put(fullProduction.qName, fullProduction);
    }

    public int addNewProductionsAt(int n) {
        int n2 = this.pNew.size();
        if (0 != n2) {
            this.module.productions.addAll(n, this.pNew);
        }
        return n2;
    }

    public void remove(FullProduction fullProduction) {
        this.pMap.remove(fullProduction.name);
        this.pMap.remove(fullProduction.qName);
    }

    public String variable() {
        String string = VARIABLE + Integer.toString(this.varCount);
        ++this.varCount;
        return string;
    }

    public String variable(String string) {
        String string2 = VARIABLE + string + "$" + Integer.toString(this.varCount);
        ++this.varCount;
        return string2;
    }

    public boolean isSynthetic(String string) {
        return string.startsWith(VARIABLE);
    }

    public NonTerminal choice() {
        NonTerminal nonTerminal = new NonTerminal(this.pCurrent.name + CHOICE + Integer.toString(this.choiceCount));
        ++this.choiceCount;
        return nonTerminal;
    }

    public NonTerminal star() {
        NonTerminal nonTerminal = new NonTerminal(this.pCurrent.name + STAR + Integer.toString(this.starCount));
        ++this.starCount;
        return nonTerminal;
    }

    public NonTerminal plus() {
        NonTerminal nonTerminal = new NonTerminal(this.pCurrent.name + PLUS + Integer.toString(this.plusCount));
        ++this.plusCount;
        return nonTerminal;
    }

    public NonTerminal option() {
        NonTerminal nonTerminal = new NonTerminal(this.pCurrent.name + OPTION + Integer.toString(this.optionCount));
        ++this.optionCount;
        return nonTerminal;
    }

    public NonTerminal tail() {
        NonTerminal nonTerminal = new NonTerminal(this.pCurrent.name + TAIL + Integer.toString(this.tailCount));
        ++this.tailCount;
        return nonTerminal;
    }

    public NonTerminal shared() {
        NonTerminal nonTerminal = new NonTerminal(SHARED + Integer.toString(this.sharedCount));
        ++this.sharedCount;
        return nonTerminal;
    }

    public boolean isSynthetic(NonTerminal nonTerminal) {
        return -1 != nonTerminal.name.indexOf(SEPARATOR);
    }

    public static Element strip(Element element) {
        Sequence sequence;
        if (element instanceof OrderedChoice) {
            OrderedChoice orderedChoice = (OrderedChoice)element;
            if (1 == orderedChoice.alternatives.size()) {
                element = Analyzer.strip((Element)orderedChoice.alternatives.get(0));
            }
        } else if (element instanceof Sequence && 1 == (sequence = (Sequence)element).length()) {
            element = Analyzer.strip(sequence.get(0));
        }
        return element;
    }

    public OrderedChoice stripChoices(OrderedChoice orderedChoice) {
        boolean bl = false;
        do {
            Sequence sequence;
            if (1 != orderedChoice.alternatives.size()) continue;
            Element element = (Element)orderedChoice.alternatives.get(0);
            if (element instanceof OrderedChoice) {
                orderedChoice = (OrderedChoice)element;
                bl = true;
                continue;
            }
            if (!(element instanceof Sequence) || 1 != (sequence = (Sequence)element).length() || !(sequence.get(0) instanceof OrderedChoice)) continue;
            orderedChoice = (OrderedChoice)sequence.get(0);
            bl = true;
        } while (bl);
        return orderedChoice;
    }

    public Module copy(Module module) {
        return (Module)this.xerox.dispatch(module);
    }

    public Element copy(Element element) {
        return this.xerox.copy(element);
    }

    public boolean hasTerminalPrefix(Sequence sequence) {
        Element element;
        return 1 <= sequence.length() && ((element = sequence.get(0)) instanceof CharLiteral || element instanceof StringLiteral || element instanceof CharClass && ((CharClass)element).count() <= 22);
    }

    private int normalLength(Sequence sequence) {
        int n = sequence.length();
        boolean bl = true;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Element element = sequence.get(i);
            if (element instanceof CharLiteral) {
                bl = false;
                ++n2;
                continue;
            }
            if (element instanceof StringLiteral) {
                bl = false;
                n2 += ((StringLiteral)element).text.length();
                continue;
            }
            if (element instanceof CharClass) {
                ++n2;
                continue;
            }
            n2 += n - i;
            break;
        }
        return bl ? -1 : n2;
    }

    public Sequence normalizeTerminals(Sequence sequence) {
        int n = this.normalLength(sequence);
        if (-1 == n) {
            return sequence;
        }
        int n2 = sequence.length();
        Sequence sequence2 = new Sequence(new ArrayList(n));
        for (int i = 0; i < n2; ++i) {
            Element element = sequence.get(i);
            if (element instanceof CharLiteral) {
                sequence2.add(new CharClass(((CharLiteral)element).c));
                continue;
            }
            if (element instanceof StringLiteral) {
                StringLiteral stringLiteral = (StringLiteral)element;
                for (int j = 0; j < stringLiteral.text.length(); ++j) {
                    sequence2.add(new CharClass(stringLiteral.text.charAt(j)));
                }
                continue;
            }
            if (element instanceof CharClass) {
                sequence2.add(element);
                continue;
            }
            sequence2.addAll(sequence.elements.subList(i, n2));
            break;
        }
        return sequence2;
    }

    public Element joinTerminals(Sequence sequence, Element element) {
        Element element2;
        Element element3;
        if (null == element) {
            return sequence;
        }
        if (element instanceof Sequence && 1 == ((Sequence)(element3 = (Sequence)element)).length() && (element2 = ((Sequence)element3).get(0)) instanceof OrderedChoice) {
            element = element2;
        }
        if (element instanceof Sequence) {
            Element element4;
            Element element5;
            element3 = (Sequence)element;
            element2 = ((Sequence)element3).isEmpty() ? null : ((Sequence)element3).get(0);
            Element element6 = element5 = sequence.isEmpty() ? null : sequence.get(0);
            if (element5 instanceof CharClass && element2 instanceof CharClass && element5.equals(element2)) {
                Sequence sequence2 = new Sequence(this.joinTerminals(sequence.subSequence(1), ((Sequence)element3).subSequence(1)));
                sequence2.elements.add(0, element5);
                return sequence2;
            }
            if (element5 instanceof CharClass && ((CharClass)element5).count() <= 22) {
                element4 = (CharClass)element5;
                if (element2 instanceof CharClass) {
                    CharClass charClass = (CharClass)element2;
                    if (charClass.count() <= 22) {
                        return this.joinTerminals(sequence, new Sequence(new CharSwitch(charClass, (Element)((Sequence)element3).subSequence(1))));
                    }
                } else if (element2 instanceof CharSwitch) {
                    CharSwitch charSwitch = (CharSwitch)element2;
                    CharClass charClass = new CharClass(((CharClass)element4).ranges);
                    CharCase charCase = charSwitch.hasCase(charClass);
                    if (((CharClass)element4).exclusive) {
                        if (null != charCase && 1 == charSwitch.cases.size()) {
                            charSwitch.base = this.joinTerminals(sequence.subSequence(1), charSwitch.base);
                            return element;
                        }
                    } else {
                        if (null != charCase) {
                            charCase.element = this.joinTerminals(sequence.subSequence(1), charCase.element);
                            return element;
                        }
                        if (!charSwitch.overlaps(charClass) && null == charSwitch.base) {
                            charSwitch.cases.add(new CharCase(charClass, (Element)sequence.subSequence(1)));
                            return element;
                        }
                    }
                }
            }
            element4 = new OrderedChoice();
            element4.alternatives.add(element);
            element4.alternatives.add(sequence);
            return element4;
        }
        if (element instanceof OrderedChoice) {
            element3 = (OrderedChoice)element;
            int n = ((OrderedChoice)element3).alternatives.size();
            Element element7 = this.joinTerminals(sequence, (Element)((OrderedChoice)element3).alternatives.get(n - 1));
            if (element7 instanceof OrderedChoice) {
                ((OrderedChoice)element3).alternatives.remove(n - 1);
                ((OrderedChoice)element3).alternatives.addAll(((OrderedChoice)element7).alternatives);
            } else {
                ((OrderedChoice)element3).alternatives.set(n - 1, element7);
            }
            return element3;
        }
        return this.joinTerminals(sequence, new Sequence(element));
    }

    public boolean haveCommonPrefix(Sequence sequence, Sequence sequence2) {
        Element element;
        Element element2 = sequence.isEmpty() ? null : sequence.get(0);
        Element element3 = element = sequence2.isEmpty() ? null : sequence2.get(0);
        if (element2 instanceof Binding) {
            return element2.equals(element);
        }
        if (null != element2) {
            return element2.equals(element);
        }
        return false;
    }

    public Sequence normalizePrefix(Sequence sequence, Sequence sequence2) {
        return sequence2;
    }

    public Element joinPrefixes(Sequence sequence, Element element) {
        Element element2;
        Element element3;
        if (null == element) {
            return sequence;
        }
        if (element instanceof Sequence && 1 == ((Sequence)(element3 = (Sequence)element)).length() && (element2 = ((Sequence)element3).get(0)) instanceof OrderedChoice) {
            element = element2;
        }
        if (element instanceof Sequence) {
            Element element4;
            element3 = (Sequence)element;
            element2 = ((Sequence)element3).isEmpty() ? null : ((Sequence)element3).get(0);
            Element element5 = element4 = sequence.isEmpty() ? null : sequence.get(0);
            if (null != element4 && element4.equals(element2)) {
                Sequence sequence2 = new Sequence(this.joinPrefixes(sequence.subSequence(1), ((Sequence)element3).subSequence(1)));
                sequence2.elements.add(0, element4);
                return sequence2;
            }
            OrderedChoice orderedChoice = new OrderedChoice();
            orderedChoice.alternatives.add(element);
            orderedChoice.alternatives.add(sequence);
            return orderedChoice;
        }
        if (element instanceof OrderedChoice) {
            element3 = (OrderedChoice)element;
            int n = ((OrderedChoice)element3).alternatives.size();
            Element element6 = this.joinPrefixes(sequence, (Element)((OrderedChoice)element3).alternatives.get(n - 1));
            if (element6 instanceof OrderedChoice) {
                ((OrderedChoice)element3).alternatives.remove(n - 1);
                ((OrderedChoice)element3).alternatives.addAll(((OrderedChoice)element6).alternatives);
            } else {
                ((OrderedChoice)element3).alternatives.set(n - 1, element6);
            }
            return element3;
        }
        return this.joinPrefixes(sequence, new Sequence(element));
    }

    public String matchingText(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.matchingText(element, stringBuffer)) {
            return stringBuffer.toString();
        }
        return null;
    }

    private boolean matchingText(Element element, StringBuffer stringBuffer) {
        if (element instanceof OrderedChoice) {
            OrderedChoice orderedChoice = (OrderedChoice)element;
            if (1 == orderedChoice.alternatives.size()) {
                return this.matchingText((Element)orderedChoice.alternatives.get(0), stringBuffer);
            }
            return false;
        }
        if (element instanceof Repetition || element instanceof Option) {
            return false;
        }
        if (element instanceof Sequence) {
            Sequence sequence = (Sequence)element;
            int n = sequence.length();
            for (int i = 0; i < n; ++i) {
                if (this.matchingText(sequence.get(i), stringBuffer)) continue;
                return false;
            }
            return true;
        }
        if (element instanceof Predicate) {
            return true;
        }
        if (element instanceof VoidedElement) {
            return false;
        }
        if (element instanceof Binding) {
            return this.matchingText(((Binding)element).element, stringBuffer);
        }
        if (element instanceof StringMatch) {
            return this.matchingText(((StringMatch)element).element, stringBuffer);
        }
        if (element instanceof NonTerminal) {
            FullProduction fullProduction = this.lookup((NonTerminal)element);
            return this.matchingText(fullProduction.element, stringBuffer);
        }
        if (element instanceof StringLiteral) {
            stringBuffer.append(((StringLiteral)element).text);
            return true;
        }
        if (element instanceof CharLiteral) {
            stringBuffer.append(((CharLiteral)element).c);
            return true;
        }
        if (element instanceof CharClass) {
            CharClass charClass = (CharClass)element;
            if (1 == charClass.ranges.size()) {
                CharRange charRange = (CharRange)charClass.ranges.get(0);
                if (charRange.first == charRange.last) {
                    stringBuffer.append(charRange.first);
                    return true;
                }
            }
            return false;
        }
        if (element instanceof Terminal) {
            return false;
        }
        if (element instanceof Action || element instanceof ValueElement) {
            return true;
        }
        if (element instanceof ParserAction) {
            return false;
        }
        return false;
    }

    public Binding bind(Sequence sequence) {
        return this.bind(sequence, null);
    }

    public Binding bind(Sequence sequence, String string) {
        Binding binding = null;
        Element element = null;
        int n = -1;
        int n2 = sequence.length();
        for (int i = 0; i < n2; ++i) {
            Element element2 = sequence.get(i);
            if (element2 instanceof OrderedChoice || element2 instanceof Sequence || element2 instanceof CharSwitch) {
                binding = null;
                n = -1;
                break;
            }
            if (element2 instanceof Repetition || element2 instanceof Option) {
                if (-1 == n) {
                    element = element2;
                    n = i;
                    continue;
                }
                binding = null;
                n = -1;
                break;
            }
            if (element2 instanceof Predicate || element2 instanceof VoidedElement) continue;
            if (element2 instanceof Binding) {
                if (-1 == n) {
                    binding = (Binding)element2;
                    n = i;
                    continue;
                }
                binding = null;
                n = -1;
                break;
            }
            if (element2 instanceof NonTerminal) {
                FullProduction fullProduction = this.lookup((NonTerminal)element2);
                if (Type.isVoidT(fullProduction.type)) continue;
                if (-1 == n) {
                    element = element2;
                    n = i;
                    continue;
                }
                binding = null;
                n = -1;
                break;
            }
            if (element2 instanceof Terminal || element2 instanceof StringMatch) {
                if (-1 == n) {
                    element = element2;
                    n = i;
                    continue;
                }
                binding = null;
                n = -1;
                break;
            }
            binding = null;
            n = -1;
            break;
        }
        if (null != binding) {
            return binding;
        }
        if (-1 == n) {
            return null;
        }
        binding = null == string ? new Binding(this.variable(), element) : new Binding(this.variable(string), element);
        sequence.elements.set(n, binding);
        return binding;
    }

    public Binding getBinding(Sequence sequence) {
        Binding binding = null;
        int n = sequence.length();
        for (int i = 0; i < n; ++i) {
            Element element = sequence.get(i);
            if (!(element instanceof Binding)) continue;
            if (null == binding) {
                binding = (Binding)element;
                continue;
            }
            return null;
        }
        return binding;
    }

    public Binding getBinding(String string, Sequence sequence) {
        Object var3_3 = null;
        int n = sequence.length();
        for (int i = 0; i < n; ++i) {
            Element element = sequence.get(i);
            if (!(element instanceof Binding)) continue;
            Binding binding = (Binding)element;
            if (!string.equals(binding.name)) continue;
            return binding;
        }
        return null;
    }

    public boolean hasSimpleValue(Element element) {
        if (element instanceof OrderedChoice) {
            Iterator iterator = ((OrderedChoice)element).alternatives.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                if (this.hasSimpleValue((Element)iterator.next())) continue;
                bl = false;
            }
            if (bl) {
                element.setProperty(SIMPLE_VALUE, Boolean.TRUE);
            }
            return bl;
        }
        if (element instanceof Sequence) {
            Iterator iterator = ((Sequence)element).iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (!this.hasSimpleValue((Element)iterator.next())) continue;
                bl = true;
            }
            if (bl) {
                element.setProperty(SIMPLE_VALUE, Boolean.TRUE);
            }
            return bl;
        }
        if (element instanceof Binding) {
            Binding binding = (Binding)element;
            this.hasSimpleValue(binding.element);
            return "yyValue".equals(binding.name);
        }
        if (element instanceof StringMatch) {
            return this.hasSimpleValue(((StringMatch)element).element);
        }
        if (element instanceof VoidedElement) {
            return this.hasSimpleValue(((VoidedElement)element).element);
        }
        if (element instanceof UnaryOperator) {
            this.hasSimpleValue(((UnaryOperator)element).element);
            return false;
        }
        if (element instanceof CharSwitch) {
            CharSwitch charSwitch = (CharSwitch)element;
            boolean bl = true;
            if (null != charSwitch.base && !this.hasSimpleValue(charSwitch.base)) {
                bl = false;
            }
            Iterator iterator = charSwitch.cases.iterator();
            while (iterator.hasNext()) {
                if (this.hasSimpleValue(((CharCase)iterator.next()).element)) continue;
                bl = false;
            }
            return bl;
        }
        return element instanceof ValueElement;
    }

    public boolean usesState(Element element) {
        if (element instanceof OrderedChoice) {
            Iterator iterator = ((OrderedChoice)element).alternatives.iterator();
            while (iterator.hasNext()) {
                if (!this.usesState((Element)iterator.next())) continue;
                return true;
            }
            return false;
        }
        if (element instanceof Sequence) {
            Iterator iterator = ((Sequence)element).iterator();
            while (iterator.hasNext()) {
                if (!this.usesState((Element)iterator.next())) continue;
                return true;
            }
            return false;
        }
        if (element instanceof UnaryOperator) {
            return this.usesState(((UnaryOperator)element).element);
        }
        if (element instanceof CharSwitch) {
            CharSwitch charSwitch = (CharSwitch)element;
            if (null != charSwitch.base && this.usesState(charSwitch.base)) {
                return true;
            }
            Iterator iterator = charSwitch.cases.iterator();
            while (iterator.hasNext()) {
                if (!this.usesState(((CharCase)iterator.next()).element)) continue;
                return true;
            }
            return false;
        }
        if (element instanceof Action) {
            Iterator iterator = ((Action)element).code.iterator();
            while (iterator.hasNext()) {
                if (-1 == ((String)iterator.next()).indexOf("yyState")) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

