/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.util.HashMap;
import xtc.tree.Annotation;
import xtc.tree.GNode;
import xtc.tree.LineMarker;
import xtc.tree.Node;
import xtc.tree.Pragma;
import xtc.tree.SourceIdentity;
import xtc.util.State;

public final class CParserState
implements State {
    private static final boolean DEBUG = false;
    private static final int POOL_INIT = 10;
    private static final int POOL_INCR = 5;
    public static final int FLAG_TYPEDEF = 1;
    public static final int FLAG_SCOPE = 2;
    public static final int FLAG_TYPE_SPEC = 4;
    public static final int FLAG_PARAMS = 8;
    public static final int FLAG_MODIFIED = 16;
    public static final int FLAG_STRUCTURE = 32;
    private Context pool;
    private Context top;
    private int nesting;
    private Annotation annotation;

    public CParserState() {
        this.fillPool(10);
        this.top = new Context();
        this.reset(null);
    }

    private void fillPool(int n) {
        for (int i = 0; i < n; ++i) {
            this.addToPool(new Context());
        }
    }

    private Context takeFromPool() {
        if (null == this.pool) {
            this.fillPool(5);
        }
        Context context = this.pool;
        this.pool = context.next;
        context.next = null;
        return context;
    }

    private void addToPool(Context context) {
        context.next = this.pool;
        context.clear();
        this.pool = context;
    }

    private void push(Context context) {
        context.next = this.top;
        this.top = context;
    }

    private Context pop() {
        Context context = this.top;
        this.top = context.next;
        context.next = null;
        return context;
    }

    public void reset(String string) {
        while (null != this.top.next) {
            this.addToPool(this.pop());
        }
        this.top.clear();
        this.top.set(2);
        this.nesting = 0;
        this.annotation = null;
    }

    public void start() {
        this.push(this.takeFromPool());
    }

    public void commit() {
        this.addToPool(this.pop());
    }

    public void abort() {
        this.addToPool(this.pop());
    }

    public void typedef() {
        this.top.set(1);
    }

    public void parameters() {
        this.top.set(8);
    }

    public void functionDeclarator() {
        this.top.clear(8);
    }

    public void typeSpecifier() {
        this.top.set(4);
    }

    public void pushScope() {
        this.top.set(2);
    }

    public void popScope() {
        this.top.clear(2);
    }

    public void enterStructure() {
        this.top.set(32);
    }

    public void exitStructure() {
        this.top.clear(32);
    }

    public void bind(String string) {
        if (this.top.next.isSet(8) || this.top.next.isSet(32)) {
            return;
        }
        Context context = this.top;
        while (!context.isSet(2)) {
            context = context.next;
        }
        context.bindings.put(string, this.top.isSet(1) ? Boolean.TRUE : Boolean.FALSE);
        context.set(16);
    }

    public boolean isType(String string) {
        if (this.top.isSet(4)) {
            return false;
        }
        Context context = this.top;
        while (true) {
            if (!context.isSet(2)) {
                context = context.next;
                continue;
            }
            Object v = context.bindings.get(string);
            if (null != v) {
                boolean bl = (Boolean)v;
                return bl;
            }
            context = context.next;
            if (null == context) break;
        }
        return false;
    }

    public boolean isValid(GNode gNode) {
        if (this.top.isSet(4)) {
            return true;
        }
        return null != gNode;
    }

    public void lineMarker(String string, String string2, String string3, String string4, String string5, String string6) {
        long l;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("Malformed line number for line marker: " + string);
        }
        int n = 0;
        if (null != string3) {
            n |= 1;
        }
        if (null != string4) {
            n |= 2;
        }
        if (null != string5) {
            n |= 4;
        }
        if (null != string6) {
            n |= 8;
        }
        if (null == this.annotation) {
            this.annotation = new LineMarker(l, string2, n, null);
        } else {
            this.annotation.innerMost().node = new LineMarker(l, string2, n, null);
        }
    }

    public void pragma(String string) {
        if (null == this.annotation) {
            this.annotation = new Pragma(string, null);
        } else {
            this.annotation.innerMost().node = new Pragma(string, null);
        }
    }

    public void ident(String string) {
        if (null == this.annotation) {
            this.annotation = new SourceIdentity(string, null);
        } else {
            this.annotation.innerMost().node = new SourceIdentity(string, null);
        }
    }

    public void mark() {
        this.top.mark = null == this.annotation ? null : this.annotation.innerMost();
    }

    public Node annotate(Node node) {
        if (null != this.top.mark) {
            Annotation annotation = null;
            Context context = this.top.next;
            while (null != context) {
                if (null != context.mark) {
                    annotation = context.mark;
                    break;
                }
                context = context.next;
            }
            Annotation annotation2 = (Annotation)this.top.mark.node;
            this.top.mark.node = node;
            if (null == annotation) {
                node = this.annotation;
                this.annotation = annotation2;
            } else {
                node = annotation.node;
                annotation.node = annotation2;
            }
            this.top.mark = null;
        }
        return node;
    }

    static final class Context {
        public Context next;
        public int flags;
        public final HashMap bindings = new HashMap();
        public Annotation mark;

        public void clear() {
            if (this.isSet(16)) {
                this.bindings.clear();
            }
            this.flags = 0;
            this.mark = null;
        }

        public boolean isSet(int n) {
            return 0 != (n & this.flags);
        }

        public void set(int n) {
            this.flags |= n;
        }

        public void clear(int n) {
            this.flags &= ~n;
        }
    }
}

