/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import xtc.lang.CCounter;
import xtc.lang.CParser;
import xtc.lang.CPrinter;
import xtc.parser.ParseError;
import xtc.parser.SemanticValue;
import xtc.tree.GNode;
import xtc.tree.Printer;
import xtc.util.Statistics;

public final class CDriver {
    private static final int WARM_UP_RUNS = 2;
    private static final int TOTAL_RUNS = 22;
    private static boolean error = false;
    private static boolean optionIncremental = true;
    private static boolean optionGC = false;
    private static boolean optionASTStats = false;
    private static boolean optionPrintAST = false;
    private static boolean optionPrint = false;
    private static boolean optionStats = false;
    private static boolean optionTable = false;
    private static boolean optionPrintTable = false;
    private static Statistics fileSizes = null;
    private static Statistics latencies = null;
    private static Statistics heapSizes = null;
    private static Method dump = null;
    static /* synthetic */ Class class$xtc$tree$Printer;
    static /* synthetic */ Class class$xtc$lang$CParser;

    private CDriver() {
    }

    private static void error(ParseError parseError, CParser cParser) throws IOException {
        System.err.println();
        cParser.print(parseError);
        error = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void process(String var0) throws Exception {
        block31: {
            block30: {
                var1_1 = new File(var0).length();
                var3_2 = null;
                if (0x7FFFFFFFL < var1_1) {
                    throw new IllegalArgumentException("File too large");
                }
                try {
                    var4_3 = null;
                    var5_4 = null;
                    var6_5 = 1;
                    if (CDriver.optionStats) {
                        var4_3 = new Statistics();
                        var5_4 = new Statistics();
                        var6_5 = 22;
                        CDriver.fileSizes.add((double)var1_1 / 1024.0);
                    }
                    for (var7_6 = 0; var7_6 < var6_5; ++var7_6) {
                        var3_2 = new BufferedReader(new FileReader(var0));
                        if (CDriver.optionGC) {
                            System.gc();
                        }
                        var8_8 = 0L;
                        var10_9 = 0L;
                        if (CDriver.optionStats) {
                            var10_9 = Runtime.getRuntime().freeMemory();
                            var8_8 = System.currentTimeMillis();
                        }
                        var12_10 = new CParser(var3_2, var0, (int)var1_1);
                        var13_11 = null;
                        if (CDriver.optionIncremental) {
                            var13_11 = new GNode("TranslationUnit");
                            var14_12 = true;
                            while (!var12_10.isEOF(0)) {
                                var15_17 = null;
                                var15_17 = var14_12 != false ? var12_10.pPrelude(0) : var12_10.pExternalDeclaration(0);
                                if (!var15_17.hasValue()) {
                                    CDriver.error((ParseError)var15_17, var12_10);
                                    var19_19 = null;
                                    if (null == var3_2) return;
                                    try {
                                        var3_2.close();
                                        return;
                                    }
                                    catch (Exception var20_24) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                if (var14_12) {
                                    var14_12 = false;
                                } else {
                                    var13_11.add(((SemanticValue)var15_17).value);
                                }
                                var12_10.resetTo(var15_17.index);
                            }
                            var15_17 = var12_10.pAnnotations(0);
                            if (!var15_17.hasValue()) {
                                CDriver.error((ParseError)var15_17, var12_10);
                                var19_20 = null;
                                if (null == var3_2) return;
                                ** try [egrp 1[TRYBLOCK] [5 : 982->989)] { 
lbl56:
                                // 1 sources

                                var3_2.close();
                                return;
lbl58:
                                // 1 sources

                                catch (Exception var20_25) {
                                    // empty catch block
                                }
                                return;
                            }
                            var13_11.add(((SemanticValue)var15_17).value);
                        } else {
                            var14_13 = var12_10.pTranslationUnit(0);
                            if (!var14_13.hasValue()) {
                                CDriver.error((ParseError)var14_13, var12_10);
                                break block30;
                            }
                            var13_11 = (GNode)((SemanticValue)var14_13).value;
                        }
                        if (CDriver.optionASTStats) {
                            var14_14 = new CCounter();
                            var14_14.dispatch(var13_11);
                            var15_17 = new Printer(new BufferedWriter(new OutputStreamWriter(System.out)));
                            var14_14.print((Printer)var15_17);
                            var15_17.flush();
                        }
                        if (CDriver.optionPrint || CDriver.optionPrintAST || CDriver.optionPrintTable) {
                            var14_15 = new Printer(new BufferedWriter(new OutputStreamWriter(System.out)));
                            if (CDriver.optionPrintAST) {
                                var14_15.format(var13_11).pln();
                            }
                            if (CDriver.optionPrint) {
                                new CPrinter(var14_15).dispatch(var13_11);
                            }
                            if (CDriver.optionPrintTable) {
                                CDriver.dump.invoke((Object)var12_10, new Object[]{var14_15});
                            }
                            var14_15.flush();
                        }
                        if (CDriver.optionStats) {
                            var14_16 = System.currentTimeMillis();
                            var16_18 = Runtime.getRuntime().freeMemory();
                            if (var7_6 >= 2) {
                                var4_3.add(var14_16 - var8_8);
                                var5_4.add(var10_9 - var16_18);
                            }
                        }
                        var3_2.close();
                    }
                    if (!CDriver.optionStats) break block31;
                    var7_7 = var4_3.mean();
                    var9_29 = var5_4.mean();
                    CDriver.latencies.add(var7_7);
                    CDriver.heapSizes.add(var9_29 / 1024.0);
                    if (CDriver.optionTable) {
                        System.out.println(var0 + " " + var1_1 + " " + Statistics.round(var7_7) + " " + var4_3.median() + " " + Statistics.round(var4_3.stdev()) + " " + Statistics.round(var9_29) + " " + var5_4.median() + " " + Statistics.round(var5_4.stdev()));
                        break block31;
                    } else {
                        System.out.println("  file size     : " + var1_1);
                        System.out.println("  time   mean   : " + Statistics.round(var7_7));
                        System.out.println("  time   median : " + var4_3.median());
                        System.out.println("  time   stdev  : " + Statistics.round(var4_3.stdev()));
                        System.out.println("  memory mean   : " + Statistics.round(var9_29));
                        System.out.println("  memory median : " + var5_4.median());
                        System.out.println("  memory stdev  : " + Statistics.round(var5_4.stdev()));
                    }
                    break block31;
                }
                catch (Throwable var18_30) {
                    var19_23 = null;
                    if (null == var3_2) throw var18_30;
                    ** try [egrp 1[TRYBLOCK] [5 : 982->989)] { 
lbl121:
                    // 1 sources

                    var3_2.close();
                    throw var18_30;
lbl123:
                    // 1 sources

                    catch (Exception var20_28) {
                        // empty catch block
                    }
                    throw var18_30;
                }
            }
            var19_21 = null;
            if (null == var3_2) return;
            ** try [egrp 1[TRYBLOCK] [5 : 982->989)] { 
lbl130:
            // 1 sources

            var3_2.close();
            return;
lbl132:
            // 1 sources

            catch (Exception var20_26) {
                // empty catch block
            }
            return;
        }
        var19_22 = null;
        if (null == var3_2) return;
        try {}
        catch (Exception var20_27) {
            return;
        }
        var3_2.close();
    }

    public static void main(String[] stringArray) {
        int n;
        System.err.print("C Parser Driver   Version ");
        System.err.print("1.7.1");
        System.err.print("   ");
        System.err.println("(C) 2004-2005 Robert Grimm");
        if (null == stringArray || 0 == stringArray.length) {
            System.err.println();
            System.err.println("Usage: <option>* <file-name>+");
            System.err.println();
            System.err.println("Options are:");
            System.err.println("  -noincr    Do not parse incrementally.");
            System.err.println("  -gc        Perform GC before parsing a file.");
            System.err.println("  -aststats  Collect and print AST statistics.");
            System.err.println("  -ast       Print the AST in generic form.");
            System.err.println("  -source    Print the AST in C source form.");
            System.err.println("  -stats     Collect and print performance statistics.");
            System.err.println("  -table     Print performance statistics as a table.");
            System.err.println("  -memo      Print the memoization table.");
            System.err.println();
            System.exit(1);
        }
        int n2 = -1;
        error = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].startsWith("-")) {
                if ("-noincr".equals(stringArray[n])) {
                    optionIncremental = false;
                    continue;
                }
                if ("-gc".equals(stringArray[n])) {
                    optionGC = true;
                    continue;
                }
                if ("-aststats".equals(stringArray[n])) {
                    optionASTStats = true;
                    continue;
                }
                if ("-ast".equals(stringArray[n])) {
                    optionPrintAST = true;
                    continue;
                }
                if ("-source".equals(stringArray[n])) {
                    optionPrint = true;
                    continue;
                }
                if ("-stats".equals(stringArray[n])) {
                    optionStats = true;
                    continue;
                }
                if ("-table".equals(stringArray[n])) {
                    optionTable = true;
                    continue;
                }
                if ("-memo".equals(stringArray[n])) {
                    try {
                        dump = (class$xtc$lang$CParser == null ? CDriver.class$("xtc.lang.CParser") : class$xtc$lang$CParser).getMethod("dump", class$xtc$tree$Printer == null ? CDriver.class$("xtc.tree.Printer") : class$xtc$tree$Printer);
                    }
                    catch (Exception exception) {
                        System.err.println("Parser cannot print memoization table. Rebuild with dumpTable option.");
                        error = true;
                    }
                    optionPrintTable = true;
                    continue;
                }
                System.err.println("Unrecognized option " + stringArray[n]);
                error = true;
                continue;
            }
            n2 = n;
            break;
        }
        if (-1 == n2) {
            System.err.println("No file names specified");
            error = true;
        }
        if (error) {
            System.exit(1);
        }
        if (optionStats) {
            fileSizes = new Statistics();
            latencies = new Statistics();
            heapSizes = new Statistics();
            if (optionTable) {
                System.out.println("Legend: File, size, time (ave, med, stdev), memory (ave, med, stdev)");
                System.out.println();
            }
        }
        error = false;
        for (n = n2; n < stringArray.length; ++n) {
            if (!optionStats || !optionTable) {
                System.err.println("Processing " + stringArray[n] + " ...");
            }
            try {
                CDriver.process(stringArray[n]);
                continue;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                error = true;
                while (null != throwable2.getCause()) {
                    throwable2 = throwable2.getCause();
                }
                if (throwable2 instanceof FileNotFoundException) {
                    System.err.println(throwable2.getMessage());
                    continue;
                }
                throwable2.printStackTrace();
            }
        }
        if (optionStats) {
            double d = 1000.0 / Statistics.fitSlope(fileSizes, latencies);
            double d2 = Statistics.fitSlope(fileSizes, heapSizes);
            System.out.println();
            System.out.println("Overall performance      : " + Statistics.round(d) + " KB/s");
            System.out.println("Overall heap utilization : " + Statistics.round(d2) + ":1");
        }
        if (error) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

