(ns 
  ^{ :author "Steven Yi"
     :doc "Generator Combinators." } 
  score.mask.generators
  (:require [score.core :refer [wrap-generator]]))

(defn- gen-util
  "Generator util that takes in two generator functions and standard function to 
  apply to values generated by generator functions"
  [func a b]
  (let [afn (wrap-generator a)
        bfn (wrap-generator b)]
   (fn [t]
    (func (afn t) (bfn t)))))

(defn add-gen
  "Generator function that adds together the values from two other generators"
  [a b]
  (gen-util + a b))


(defn mul-gen
  "Generator function that adds together the values from two other generators"
  [a b]
  (gen-util * a b))
