(ns 
  ^{:doc "Chorus Effects"
    :author "Steven Yi"}
  pink.effects.chorus
  (:require [pink.config :refer :all]
            [pink.util :refer [create-buffers generator]]))

(defn chorus
  "Adds stereo chorus to a stereo-signal audio-function."
  [afn ^double wet-dry]
  (let [out (create-buffers 2)
        ilevl 0.3   ; Output level
        idelay 0.01    ; Delay in ms
        idpth 0.002   ; Depth in ms
        imax 0.25    ; Maximum LFO rate
        imin 0.5   ; Minimum LFO rate
        ]
    (generator
      []
      [[l r] afn]
      ()
      (yield out)
      )))
;ilevl   =   0.3   ; Output level
;idelay    =   0.01    ; Delay in ms
;idpth   =   0.002   ; Depth in ms
;imax    =   0.25    ; Maximum LFO rate
;imin    =   0.5   ; Minimum LFO rate
;iwave   =   isin    ; LFO waveform

