(ns ksql.utils
  (:require [cats.context :as ctx]
            [cats.monad.state :as state]))

(defn run-statement
  "Run `statement` in the context of the state monad."
  [statement]
  (seq (state/run (ctx/with-context state/context statement) {})))

(defn ast
  "Return the AST of the `statement`."
  [statement]
  (last (run-statement statement)))
