(ns ksql.transport.core.async
  (:require [cheshire.core :as json]
            [clj-http.client :as clj-http]
            [clojure.core.async :as a]
            [clojure.java.io :as io]
            [ksql.error :as error]
            [ksql.transport.http :as http]))

(defmulti parse-body
  (fn [response]
    (type (:body response))))

(defmethod parse-body java.lang.String
  [{:keys [body] :as response}]
  (with-meta (json/parse-string body keyword)
    (dissoc response :body)))

(defmethod parse-body java.io.InputStream
  [{:keys [body] :as response}]
  (let [channel (a/chan 1 http/response-xf)]
    (a/thread (try (a/onto-chan channel (line-seq (io/reader body)))
                   (catch Exception e
                     (.printStackTrace e))))
    channel))

(defn- success-response
  "Returns a successful response."
  [statement {:keys [body] :as response}]
  (parse-body response))

(defn request!
  "Execute the KSQL `statement`` via HTTP."
  [statement]
  ;; (clojure.pprint/pprint (http/request statement))
  (try (let [response (clj-http/request (http/request statement))]
         ;; (clojure.pprint/pprint response)
         (success-response statement response))
       (catch clojure.lang.ExceptionInfo e
         (case (:type (ex-data e))
           :clj-http.client/unexceptional-status
           (throw (error/unexceptional-status statement e))
           (throw e)))))
