(ns ksql.transport.aleph
  (:require [cheshire.core :as json]
            [byte-streams :as bs]
            [manifold.deferred :as d]
            [clojure.core.async :as async]
            [clojure.java.io :as io]
            [ksql.compiler :as compiler]
            [ksql.error :as error]
            [clojure.string :as str]
            [ksql.transport.http :as http]
            [aleph.http :as aleph]))

(defn- parse-json [s]
  (json/parse-string s keyword))

(defn- log-response [response]
  (prn "LOG " response)
  response)

(defn- on-error [statement error]
  (let [{:keys [body status] :as response} (ex-data error)
        body (some-> body slurp (json/parse-string keyword))]
    (throw (ex-info (str "KSQL Error: " (:message body)) (or body {})))))

(defn- massage-line [s]
  (-> (str/replace s #"^\[" "")
      (str/replace #"}]\s*$" "}")))

(defn- async-response
  [{:keys [body] :as response}]
  (->> body io/reader line-seq
       (remove str/blank?)
       (map massage-line) ;; WTF?
       (map parse-json)))

(defn- sync-response
  [{:keys [body] :as response}]
  (-> body slurp parse-json))

(defn request!
  "Execute the KSQL `statement`` via HTTP."
  [statement]
  ;; (clojure.pprint/pprint (request statement))
  (let [{:keys [as] :as request} (http/request statement)
        parse-response (if (= :stream as) async-response sync-response)]
    @(-> (aleph/request request)
         (d/chain parse-response)
         (d/catch Exception #(on-error statement %)))))
