(ns ksql.statement
  (:require [cats.protocols :as p]
            [clojure.pprint :refer [simple-dispatch]]
            [ksql.compiler :as compiler]
            [ksql.utils :as util]))

(defn- evaluator
  [statement]
  (-> statement util/ast :db :evaluator))

(defn- ex-info-invalid-evaluator
  [statement]
  (let [sql (compiler/sql statement)]
    (ex-info (str "Invalid evaluator: " sql)
             {:evaluator (evaluator statement)
              :statement statement})))

(defn- eval-statement
  [statement]
  (let [evaluator (evaluator statement)]
    (if (ifn? evaluator)
      (evaluator statement)
      (throw (ex-info-invalid-evaluator statement)))))

(defrecord Statement [mfn state-context]
  p/Contextual
  (-get-context [_] state-context)

  p/Extract
  (-extract [_] mfn)

  #?(:clj clojure.lang.IDeref :cljs cljs.core/IDeref)
  (#?(:clj deref :cljs -deref)
    [statement]
    (eval-statement statement)))

(defn- printable-object [statement]
  (compiler/sql statement))

(defn statement?
  "Returns true if `x` is a Statement, otherwise false."
  [x]
  (instance? Statement x))

#?(:clj (defmethod print-method Statement
          [statement writer]
          (print-method (printable-object statement) writer)))

#?(:cljs
   (extend-protocol IPrintWithWriter
     ksql.statement.Statement
     (-pr-writer [statement writer opts]
       (-pr-writer (printable-object statement) writer opts))))

;; Override deref for pretty printing :/ ???

(defmethod simple-dispatch Statement [statement]
  (pr (printable-object statement)))
