(ns ksql.ast.spec
  (:require [clojure.spec.alpha :as s]
            [clojure.spec.gen.alpha :as gen]
            [ksql.ast.children :as children]))

(s/def :ksql.ast/op
  keyword?)

(s/def :ksql.ast/children
  (s/coll-of keyword? :kind vector? :distinct true :max-gen 3))

(defn- child-spec-name [op]
  (keyword (str "ksql.ast." (name op) "/children")))

(defn children [spec]
  (first (s/form (child-spec-name spec))))

;; NODES

;;; limit

(s/def :ksql.ast/limit
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; literal

(s/def :ksql.ast/literal
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; list

(s/def :ksql.ast/list
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; expression

(s/def :ksql.ast/expression
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; as

(s/def :ksql.ast/as
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; result-materialization

(s/def :ksql.ast/result-materialization
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; emit

(s/def :ksql.ast/emit
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; delete-topic

(s/def :ksql.ast/delete-topic
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; if-exists

(s/def :ksql.ast/if-exists
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; insert-columns

(s/def :ksql.ast/insert-columns
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; insert

(s/def :ksql.ast/insert
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; source-name

(s/def :ksql.ast/source-name
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; relation-primary

(s/def :ksql.ast/relation-primary
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; aliased-relation

(s/def :ksql.ast/aliased-relation
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; relation

(s/def :ksql.ast/relation
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; from

(s/def :ksql.ast/from
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; where

(s/def :ksql.ast/where
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; order-by

(s/def :ksql.ast/order-by
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; select-item

(s/def :ksql.ast/select-item
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; select-items

(s/def :ksql.ast/select-items
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; query

(s/def :ksql.ast.query/op #{:query})

(s/def :ksql.ast.query/children
  #{[:select-items :from :where :join :window :group-by :emit :limit]})

(s/def :ksql.ast/query
  (s/keys :req-un [:ksql.ast.query/op
                   :ksql.ast.query/children]))

;;; show

(s/def :ksql.ast/show
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; print

(s/def :ksql.ast/print
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; with

(s/def :ksql.ast/with
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; table-property

(s/def :ksql.ast/table-property
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; base-type

(s/def :ksql.ast/base-type
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; array-type

(s/def :ksql.ast/array-type
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; map-type

(s/def :ksql.ast/map-type
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; struct-field

(s/def :ksql.ast/struct-field
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; struct-type

(s/def :ksql.ast/struct-type
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; create-sink-connector

(s/def :ksql.ast/create-sink-connector
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; create-source-connector

(s/def :ksql.ast/create-source-connector
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; table-element

(s/def :ksql.ast/table-element
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; table-elements

(s/def :ksql.ast/table-elements
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; create-stream

(s/def :ksql.ast/create-stream
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; create-table

(s/def :ksql.ast/create-table
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; drop-connector

(s/def :ksql.ast/drop-connector
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; drop-table

(s/def :ksql.ast/drop-table
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; drop-stream

(s/def :ksql.ast/drop-stream
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; group-by

(s/def :ksql.ast/group-by
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; join-type

(s/def :ksql.ast/join-type
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; join

(s/def :ksql.ast/join
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; terminate

(s/def :ksql.ast/terminate
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; value

(s/def :ksql.ast/value
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; values

(s/def :ksql.ast/values
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; window-expression

(s/def :ksql.ast/window-expression
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; window-type

(s/def :ksql.ast/window-type
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))

;;; window

(s/def :ksql.ast/window
  (s/keys :req-un [:ksql.ast/op
                   :ksql.ast/children]))
