(ns ksql.ast.children
  (:refer-clojure :exclude [group-by list print]))

(def aliased-relation [:relation-primary])
(def array-type [:definition])
(def as [:expression :alias])
(def base-type [:type])
(def create-sink-connector [:name :with])
(def create-source-connector [:name :with])
(def create-stream [:source-name :as :table-elements :with])
(def create-table [:source-name :as :table-elements :with])
(def delete-topic [:delete-topic])
(def drop-connector [:connector])
(def drop-stream [:if-exists :stream :delete-topic])
(def drop-table [:if-exists :table :delete-topic])
(def emit [:result-materialization])
(def expression [:expression])
(def from [:relation])
(def function-call [:name :args])
(def group-by [:expressions])
(def identifier [:identifier])
(def if-exists [:if-exists])
(def insert [:table :columns :values])
(def insert-columns [:elements])
(def join [:type :table :condition])
(def join-type [:type])
(def limit [:limit])
(def list [:type])
(def literal [:literal])
(def map-type [:definition])
(def order-by [:columns])
(def print [:clause])
(def query [:select-items :from :where :join :window :group-by :emit :limit])
(def relation [:aliased-relation])
(def relation-primary [:source-name])
(def result-materialization [:result-materialization])
(def select-item [:expression])
(def select-items [:items])
(def show [:type])
(def source-name [:identifier])
(def struct-field [:name :type])
(def struct-type [:fields])
(def table-element [:identifier :type])
(def table-elements [:elements])
(def table-property [:table-property])
(def terminate [:query])
(def value [:value])
(def values [:columns :values])
(def where [:where])
(def window [:type :expressions])
(def window-expression [:expression])
(def window-type [:type])
(def with [:opts])
