(defproject ksql.core "0.1.0-SNAPSHOT"
  :description "A Clojure client for KSQL"
  :url "https://github.com/r0man/ksql.core"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :deploy-repositories [["releases" :clojars]]
  :aliases {"ci" ["do"
                  ["difftest"]
                  ["doo" "node" "node" "once"]
                  ["doo" "phantom" "none" "once"]
                  ["doo" "phantom" "advanced" "once"]
                  ["lint"]]
            "lint" ["do"  ["eastwood"]]}
  :dependencies [[aleph "0.4.6"]
                 [cheshire "5.9.0"]
                 [clj-http "3.10.0"]
                 [funcool/cats "2.3.3"]
                 [org.clojure/clojure "1.10.1"]
                 [org.clojure/core.async "0.7.559"]]
  :plugins [[jonase/eastwood "0.3.6"]
            [lein-cljsbuild "1.1.7"]
            [lein-difftest "2.0.0"]
            [lein-doo "0.1.11"]]
  :profiles {:dev {:dependencies [[clj-antlr "0.2.5"]
                                  [org.clojure/clojurescript "1.10.597"]
                                  [org.clojure/test.check "0.10.0"]]}}
  :cljsbuild
  {:builds
   [{:id "none"
     :compiler
     {:main ksql.test.runner
      :optimizations :none
      :output-dir "target/none"
      :output-to "target/none.js"
      :parallel-build true
      :pretty-print true
      :verbose false}
     :source-paths ["src" "test"]}
    {:id "node"
     :compiler
     {:main ksql.test.runner
      :optimizations :none
      :output-dir "target/node"
      :output-to "target/node.js"
      :parallel-build true
      :pretty-print true
      :target :nodejs
      :verbose false}
     :source-paths ["src" "test"]}
    {:id "advanced"
     :compiler
     {:main ksql.test.runner
      :optimizations :advanced
      :output-dir "target/advanced"
      :output-to "target/advanced.js"
      :parallel-build true
      :pretty-print true
      :verbose false}
     :source-paths ["src" "test"]}]})
