(ns gamma.constructors
  (:require [cljs.test :refer :all]
            [gamma.api :as g]
            [gamma.tools :refer [glsl-string]])
  (:require-macros [cljs.test :refer [is deftest testing]]))

(enable-console-print!)

(defn ->glsl [x]
  (clojure.string/replace
    (glsl-string x)
    #"\s" ""))

(def vec4-variable {:tag :variable :id "v" :type :vec4})
;; operators

;;;;;;; OPERATORS WITH VARIABLES

(deftest
  operators
  (let [f {:tag :variable :id "f" :type :float}
        v {:tag :variable :id "v" :type :vec4}
        b {:tag :variable :id "b" :type :bool}]
    (is (= (->glsl (g/aget vec4-variable 0)) "v[0];"))
    ;; selector?
    (is (= (->glsl (g/increment f)) "f++;"))
    (is (= (->glsl (g/decrement f)) "f--;"))
    (is (= (->glsl (g/pre-increment f)) "++f;"))
    (is (= (->glsl (g/pre-decrement f)) "--f;"))
    ;(is (= (g/+- t) "x+-"))                        ;;?
    (is (= (->glsl (g/* f f)) "f*f;"))
    (is (= (->glsl (g/div f f)) "f/f;"))
    (is (= (->glsl (g/+ f)) "f+f;"))
    (is (= (->glsl (g/- f)) "f-f;"))
    (is (= (->glsl (g/< f)) "f<f;"))
    (is (= (->glsl (g/> f)) "f>f;"))
    (is (= (->glsl (g/<= f)) "f<=f;"))
    (is (= (->glsl (g/>= f)) "f>=f;"))
    (is (= (->glsl (g/== f)) "f==f;"))
    (is (= (->glsl (g/!= f)) "f!=f;"))
    ;(is (= (g/conditional-choice f) "vec4_v--"))
    (is (= (->glsl (g/set f)) "f=f;"))
    (is (= (->glsl (g/set+ f)) "f+=f;"))
    (is (= (->glsl (g/set- f)) "f-=f;"))
    (is (= (->glsl (g/set* f)) "f*=f;"))
    (is (= (->glsl (g/set-div f)) "f/=f;"))
    ;(is (= (g/constructor f) "vec4_v--"))
    (is (= (->glsl (g/and b)) "b&&b;"))
    (is (= (->glsl (g/or b)) "b||b;"))
    (is (= (->glsl (g/xor b)) "b&&b;"))
    (is (= (->glsl (g/not b)) "!b;"))))

;; need swizzle tests




(deftest
  standard-functions
  (let [t {:tag :variable :id "t" :type :float}
        f {:tag :variable :id "f" :type :float}
        v2 {:tag :variable :id "v2" :type :vec2}
        v3 {:tag :variable :id "v3" :type :vec3}
        v4 {:tag :variable :id "v4" :type :vec4}
        sampler {:tag :variable :id "sampler" :type :sampler2D}]
    (is (= (->glsl (g/radians t)) "radians(t);"))
    (is (= (->glsl (g/degrees t)) "degrees(t);"))
    (is (= (->glsl (g/sin t)) "sin(t);"))
    (is (= (->glsl (g/cos t)) "cos(t);"))
    (is (= (->glsl (g/tan t)) "tan(t);"))
    (is (= (->glsl (g/asin t)) "asin(t);"))
    (is (= (->glsl (g/acos t)) "acos(t);"))
    (is (= (->glsl (g/atan t f2)) "atan(f,f2);"))
    (is (= (->glsl (g/atan t)) "atan(t);"))
    (is (= (->glsl (g/power t f2)) "power(f,f2);"))
    (is (= (->glsl (g/exp t)) "exp(t);"))
    (is (= (->glsl (g/log t)) "log(t);"))
    (is (= (->glsl (g/exp2 t)) "exp2(t);"))
    (is (= (->glsl (g/log2 t)) "log2(t);"))
    (is (= (->glsl (g/sqrt t)) "sqrt(t);"))
    (is (= (->glsl (g/inversesqrt t)) "inversesqrt(t);"))
    (is (= (->glsl (g/abs t)) "abs(t);"))
    (is (= (->glsl (g/sign t)) "sign(t);"))
    (is (= (->glsl (g/floor t)) "floor(t);"))
    (is (= (->glsl (g/ceil t)) "ceil(t);"))
    (is (= (->glsl (g/fract t)) "fract(t);"))
    (is (= (->glsl (g/mod t t)) "mod(t,t);"))
    (is (= (->glsl (g/max t t)) "max(t,t);"))
    (is (= (->glsl (g/clamp t t t)) "clamp(t,t,t);"))
    (is (= (->glsl (g/clamp t f f)) "clamp(t,f,f);"))
    (is (= (->glsl (g/step t t)) "step(t,t);"))
    (is (= (->glsl (g/step f t)) "step(f,t);"))
    (is (= (->glsl (g/smoothstep t t t)) "smoothstep(t,t,t);"))
    (is (= (->glsl (g/smoothstep f f t)) "smoothstep(f,f,t);"))
    (is (= (->glsl (g/length t)) "length(t);"))
    (is (= (->glsl (g/distance t t)) "distance(t,t);"))
    (is (= (->glsl (g/dot t t)) "dot(t,t);"))
    (is (= (->glsl (g/cross v3 v3)) "cross(v3,v3);"))
    (is (= (->glsl (g/normalize t)) "normalize(t);"))
    (is (= (->glsl (g/faceforward t t t)) "faceforward(t,t,t);"))
    (is (= (->glsl (g/reflect t t)) "reflect(t,t);"))
    (is (= (->glsl (g/refract t t f)) "refract(t,t,f);"))
    (is (= (->glsl (g/texture2DLod sampler v2 f)) "texture2DLod(sampler,v2,f);"))
    (is (= (->glsl (g/texture2DProjLod sampler v3 f)) "texture2DProjLod(sampler,v3,f);"))
    (is (= (->glsl (g/texture2DProjLod sampler v4 f)) "texture2DProjLod(sampler,v4,f);"))
    (is (= (->glsl (g/textureCubeLod sampler v4 f)) "textureCubeLod(sampler,v4,f);"))
    (is (= (->glsl (g/texture2D sampler v2 f)) "texture2D(sampler,v2,f);"))
    (is (= (->glsl (g/texture2DProj sampler v3 f)) "texture2DProj(sampler,v3,f);"))
    (is (= (->glsl (g/texture2DProj sampler v4 f)) "texture2DProj(sampler,v4,f);"))
    (is (= (->glsl (g/textureCube sampler v3 f)) "textureCube(sampler,v3,f);"))
    (is (= (->glsl (g/texture2D sampler v2)) "texture2D(sampler,v2);"))
    (is (= (->glsl (g/texture2DProj sampler v3 f)) "texture2DProj(sampler,v3,f);"))
    (is (= (->glsl (g/texture2DProj sampler v4 f)) "texture2DProj(sampler,v4,f);"))
    (is (= (->glsl (g/textureCube sampler v3)) "textureCube(sampler,v3);"))))

