(ns vura.core.julian-day
  (:require
   [vura.core :as core]))

; (def julian-day-epoch
;   (- (core/date->utc-value (core/utc-date 2000 1 1 12)) (core/days 2451545)))


(def julian-day-epoch
  (core/with-time-configuration
    {:offset 0}
    (- (core/days 2440587.5))))

(defn value->julian-day
  "For given value returns which Julian Day value belongs to"
  [value]
  (/ (- value julian-day-epoch) (double core/day)))

(defn date->julian-day [date]
  (-> date core/time->value value->julian-day))

(defn julian-day->value [day]
  (+ julian-day-epoch (core/days day)))

(defn julian-day->date [day]
  (-> day julian-day->value core/value->time))
