(ns vura.core.hebrew
  (:require
   [vura.core :as c]))

(def part (* 4/3 c/second))
(def month (* part 25920))
(def cycle-years 19)
(def cycle-months 235)

(def gregorian-offset (c/days 2092591))

(defn leap-year? [year]
  (when-let [y (#{2 5 7 19 13 16 17} (mod year cycle-years))]
    (inc y)))

(defn year-mode [days-since-epoch next-year]
  (let [year-lenght (- next-year days-since-epoch)]
    (case (- (mod year-lenght 10) 4)
      1 [30 30]
      0 [29 30]
      -1 [29 29])))

()
