// Compiled by ClojureScript 1.7.122 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
goog.require('cljs.repl');
goog.require('figwheel.client.heads_up');
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),args], null));

return args;
});
figwheel.client.autoload_QMARK_ = (cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?(function (){
var pred__22839 = cljs.core._EQ_;
var expr__22840 = (function (){var or__16658__auto__ = localStorage.getItem("figwheel_autoload");
if(cljs.core.truth_(or__16658__auto__)){
return or__16658__auto__;
} else {
return "true";
}
})();
if(cljs.core.truth_(pred__22839.call(null,"true",expr__22840))){
return true;
} else {
if(cljs.core.truth_(pred__22839.call(null,"false",expr__22840))){
return false;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__22840)].join('')));
}
}
}):(function (){
return true;
}));
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
localStorage.setItem("figwheel_autoload",cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));

return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Figwheel autoloading "),cljs.core.str((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));
} else {
return null;
}
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
figwheel.client.console_print = (function figwheel$client$console_print(args){
console.log.apply(console,cljs.core.into_array.call(null,args));

return args;
});
figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__22842__delegate = function (args){
return figwheel.client.figwheel_repl_print.call(null,figwheel.client.console_print.call(null,args));
};
var G__22842 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__22843__i = 0, G__22843__a = new Array(arguments.length -  0);
while (G__22843__i < G__22843__a.length) {G__22843__a[G__22843__i] = arguments[G__22843__i + 0]; ++G__22843__i;}
  args = new cljs.core.IndexedSeq(G__22843__a,0);
} 
return G__22842__delegate.call(this,args);};
G__22842.cljs$lang$maxFixedArity = 0;
G__22842.cljs$lang$applyTo = (function (arglist__22844){
var args = cljs.core.seq(arglist__22844);
return G__22842__delegate(args);
});
G__22842.cljs$core$IFn$_invoke$arity$variadic = G__22842__delegate;
return G__22842;
})()
;
});
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel$client$get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__22845){
var map__22848 = p__22845;
var map__22848__$1 = ((((!((map__22848 == null)))?((((map__22848.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22848.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22848):map__22848);
var message = cljs.core.get.call(null,map__22848__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__22848__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str(class$),cljs.core.str(" : "),cljs.core.str(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__16658__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__16658__auto__)){
return or__16658__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__16646__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__16646__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__16646__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__18741__auto___23010 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___23010,ch){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___23010,ch){
return (function (state_22979){
var state_val_22980 = (state_22979[(1)]);
if((state_val_22980 === (7))){
var inst_22975 = (state_22979[(2)]);
var state_22979__$1 = state_22979;
var statearr_22981_23011 = state_22979__$1;
(statearr_22981_23011[(2)] = inst_22975);

(statearr_22981_23011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22980 === (1))){
var state_22979__$1 = state_22979;
var statearr_22982_23012 = state_22979__$1;
(statearr_22982_23012[(2)] = null);

(statearr_22982_23012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22980 === (4))){
var inst_22932 = (state_22979[(7)]);
var inst_22932__$1 = (state_22979[(2)]);
var state_22979__$1 = (function (){var statearr_22983 = state_22979;
(statearr_22983[(7)] = inst_22932__$1);

return statearr_22983;
})();
if(cljs.core.truth_(inst_22932__$1)){
var statearr_22984_23013 = state_22979__$1;
(statearr_22984_23013[(1)] = (5));

} else {
var statearr_22985_23014 = state_22979__$1;
(statearr_22985_23014[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22980 === (15))){
var inst_22939 = (state_22979[(8)]);
var inst_22954 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_22939);
var inst_22955 = cljs.core.first.call(null,inst_22954);
var inst_22956 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_22955);
var inst_22957 = [cljs.core.str("Figwheel: Not loading code with warnings - "),cljs.core.str(inst_22956)].join('');
var inst_22958 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_22957);
var state_22979__$1 = state_22979;
var statearr_22986_23015 = state_22979__$1;
(statearr_22986_23015[(2)] = inst_22958);

(statearr_22986_23015[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22980 === (13))){
var inst_22963 = (state_22979[(2)]);
var state_22979__$1 = state_22979;
var statearr_22987_23016 = state_22979__$1;
(statearr_22987_23016[(2)] = inst_22963);

(statearr_22987_23016[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22980 === (6))){
var state_22979__$1 = state_22979;
var statearr_22988_23017 = state_22979__$1;
(statearr_22988_23017[(2)] = null);

(statearr_22988_23017[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22980 === (17))){
var inst_22961 = (state_22979[(2)]);
var state_22979__$1 = state_22979;
var statearr_22989_23018 = state_22979__$1;
(statearr_22989_23018[(2)] = inst_22961);

(statearr_22989_23018[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22980 === (3))){
var inst_22977 = (state_22979[(2)]);
var state_22979__$1 = state_22979;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22979__$1,inst_22977);
} else {
if((state_val_22980 === (12))){
var inst_22938 = (state_22979[(9)]);
var inst_22952 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_22938,opts);
var state_22979__$1 = state_22979;
if(cljs.core.truth_(inst_22952)){
var statearr_22990_23019 = state_22979__$1;
(statearr_22990_23019[(1)] = (15));

} else {
var statearr_22991_23020 = state_22979__$1;
(statearr_22991_23020[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22980 === (2))){
var state_22979__$1 = state_22979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22979__$1,(4),ch);
} else {
if((state_val_22980 === (11))){
var inst_22939 = (state_22979[(8)]);
var inst_22944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22945 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_22939);
var inst_22946 = cljs.core.async.timeout.call(null,(1000));
var inst_22947 = [inst_22945,inst_22946];
var inst_22948 = (new cljs.core.PersistentVector(null,2,(5),inst_22944,inst_22947,null));
var state_22979__$1 = state_22979;
return cljs.core.async.ioc_alts_BANG_.call(null,state_22979__$1,(14),inst_22948);
} else {
if((state_val_22980 === (9))){
var inst_22939 = (state_22979[(8)]);
var inst_22965 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_22966 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_22939);
var inst_22967 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_22966);
var inst_22968 = [cljs.core.str("Not loading: "),cljs.core.str(inst_22967)].join('');
var inst_22969 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_22968);
var state_22979__$1 = (function (){var statearr_22992 = state_22979;
(statearr_22992[(10)] = inst_22965);

return statearr_22992;
})();
var statearr_22993_23021 = state_22979__$1;
(statearr_22993_23021[(2)] = inst_22969);

(statearr_22993_23021[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22980 === (5))){
var inst_22932 = (state_22979[(7)]);
var inst_22934 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_22935 = (new cljs.core.PersistentArrayMap(null,2,inst_22934,null));
var inst_22936 = (new cljs.core.PersistentHashSet(null,inst_22935,null));
var inst_22937 = figwheel.client.focus_msgs.call(null,inst_22936,inst_22932);
var inst_22938 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_22937);
var inst_22939 = cljs.core.first.call(null,inst_22937);
var inst_22940 = figwheel.client.autoload_QMARK_.call(null);
var state_22979__$1 = (function (){var statearr_22994 = state_22979;
(statearr_22994[(8)] = inst_22939);

(statearr_22994[(9)] = inst_22938);

return statearr_22994;
})();
if(cljs.core.truth_(inst_22940)){
var statearr_22995_23022 = state_22979__$1;
(statearr_22995_23022[(1)] = (8));

} else {
var statearr_22996_23023 = state_22979__$1;
(statearr_22996_23023[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22980 === (14))){
var inst_22950 = (state_22979[(2)]);
var state_22979__$1 = state_22979;
var statearr_22997_23024 = state_22979__$1;
(statearr_22997_23024[(2)] = inst_22950);

(statearr_22997_23024[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22980 === (16))){
var state_22979__$1 = state_22979;
var statearr_22998_23025 = state_22979__$1;
(statearr_22998_23025[(2)] = null);

(statearr_22998_23025[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22980 === (10))){
var inst_22971 = (state_22979[(2)]);
var state_22979__$1 = (function (){var statearr_22999 = state_22979;
(statearr_22999[(11)] = inst_22971);

return statearr_22999;
})();
var statearr_23000_23026 = state_22979__$1;
(statearr_23000_23026[(2)] = null);

(statearr_23000_23026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22980 === (8))){
var inst_22938 = (state_22979[(9)]);
var inst_22942 = figwheel.client.reload_file_state_QMARK_.call(null,inst_22938,opts);
var state_22979__$1 = state_22979;
if(cljs.core.truth_(inst_22942)){
var statearr_23001_23027 = state_22979__$1;
(statearr_23001_23027[(1)] = (11));

} else {
var statearr_23002_23028 = state_22979__$1;
(statearr_23002_23028[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto___23010,ch))
;
return ((function (switch__18676__auto__,c__18741__auto___23010,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__18677__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__18677__auto____0 = (function (){
var statearr_23006 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23006[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__18677__auto__);

(statearr_23006[(1)] = (1));

return statearr_23006;
});
var figwheel$client$file_reloader_plugin_$_state_machine__18677__auto____1 = (function (state_22979){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_22979);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e23007){if((e23007 instanceof Object)){
var ex__18680__auto__ = e23007;
var statearr_23008_23029 = state_22979;
(statearr_23008_23029[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22979);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23007;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23030 = state_22979;
state_22979 = G__23030;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__18677__auto__ = function(state_22979){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__18677__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__18677__auto____1.call(this,state_22979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__18677__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__18677__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___23010,ch))
})();
var state__18743__auto__ = (function (){var statearr_23009 = f__18742__auto__.call(null);
(statearr_23009[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___23010);

return statearr_23009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___23010,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__23031_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__23031_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_23038 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_23038){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var _STAR_print_fn_STAR_23036 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR_23037 = cljs.core._STAR_print_newline_STAR_;
cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_fn_STAR_23036,_STAR_print_newline_STAR_23037,base_path_23038){
return (function() { 
var G__23039__delegate = function (args){
return figwheel.client.figwheel_repl_print.call(null,figwheel.client.console_print.call(null,args));
};
var G__23039 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__23040__i = 0, G__23040__a = new Array(arguments.length -  0);
while (G__23040__i < G__23040__a.length) {G__23040__a[G__23040__i] = arguments[G__23040__i + 0]; ++G__23040__i;}
  args = new cljs.core.IndexedSeq(G__23040__a,0);
} 
return G__23039__delegate.call(this,args);};
G__23039.cljs$lang$maxFixedArity = 0;
G__23039.cljs$lang$applyTo = (function (arglist__23041){
var args = cljs.core.seq(arglist__23041);
return G__23039__delegate(args);
});
G__23039.cljs$core$IFn$_invoke$arity$variadic = G__23039__delegate;
return G__23039;
})()
;})(_STAR_print_fn_STAR_23036,_STAR_print_newline_STAR_23037,base_path_23038))
;

cljs.core._STAR_print_newline_STAR_ = false;

try{return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),[cljs.core.str(figwheel.client.utils.eval_helper.call(null,code,opts))].join('')], null));
}finally {cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_23037;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_23036;
}}catch (e23035){if((e23035 instanceof Error)){
var e = e23035;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_23038], null));
} else {
var e = e23035;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_23038))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = {};
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__23042){
var map__23049 = p__23042;
var map__23049__$1 = ((((!((map__23049 == null)))?((((map__23049.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23049.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23049):map__23049);
var opts = map__23049__$1;
var build_id = cljs.core.get.call(null,map__23049__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__23049,map__23049__$1,opts,build_id){
return (function (p__23051){
var vec__23052 = p__23051;
var map__23053 = cljs.core.nth.call(null,vec__23052,(0),null);
var map__23053__$1 = ((((!((map__23053 == null)))?((((map__23053.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23053.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23053):map__23053);
var msg = map__23053__$1;
var msg_name = cljs.core.get.call(null,map__23053__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__23052,(1));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__23052,map__23053,map__23053__$1,msg,msg_name,_,map__23049,map__23049__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__23052,map__23053,map__23053__$1,msg,msg_name,_,map__23049,map__23049__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__23049,map__23049__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__23059){
var vec__23060 = p__23059;
var map__23061 = cljs.core.nth.call(null,vec__23060,(0),null);
var map__23061__$1 = ((((!((map__23061 == null)))?((((map__23061.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23061.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23061):map__23061);
var msg = map__23061__$1;
var msg_name = cljs.core.get.call(null,map__23061__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__23060,(1));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__23063){
var map__23073 = p__23063;
var map__23073__$1 = ((((!((map__23073 == null)))?((((map__23073.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23073.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23073):map__23073);
var on_compile_warning = cljs.core.get.call(null,map__23073__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__23073__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__23073,map__23073__$1,on_compile_warning,on_compile_fail){
return (function (p__23075){
var vec__23076 = p__23075;
var map__23077 = cljs.core.nth.call(null,vec__23076,(0),null);
var map__23077__$1 = ((((!((map__23077 == null)))?((((map__23077.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23077.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23077):map__23077);
var msg = map__23077__$1;
var msg_name = cljs.core.get.call(null,map__23077__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__23076,(1));
var pred__23079 = cljs.core._EQ_;
var expr__23080 = msg_name;
if(cljs.core.truth_(pred__23079.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__23080))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__23079.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__23080))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__23073,map__23073__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__18741__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto__,msg_hist,msg_names,msg){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto__,msg_hist,msg_names,msg){
return (function (state_23296){
var state_val_23297 = (state_23296[(1)]);
if((state_val_23297 === (7))){
var inst_23220 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
if(cljs.core.truth_(inst_23220)){
var statearr_23298_23344 = state_23296__$1;
(statearr_23298_23344[(1)] = (8));

} else {
var statearr_23299_23345 = state_23296__$1;
(statearr_23299_23345[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (20))){
var inst_23290 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
var statearr_23300_23346 = state_23296__$1;
(statearr_23300_23346[(2)] = inst_23290);

(statearr_23300_23346[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (27))){
var inst_23286 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
var statearr_23301_23347 = state_23296__$1;
(statearr_23301_23347[(2)] = inst_23286);

(statearr_23301_23347[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (1))){
var inst_23213 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_23296__$1 = state_23296;
if(cljs.core.truth_(inst_23213)){
var statearr_23302_23348 = state_23296__$1;
(statearr_23302_23348[(1)] = (2));

} else {
var statearr_23303_23349 = state_23296__$1;
(statearr_23303_23349[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (24))){
var inst_23288 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
var statearr_23304_23350 = state_23296__$1;
(statearr_23304_23350[(2)] = inst_23288);

(statearr_23304_23350[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (4))){
var inst_23294 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23296__$1,inst_23294);
} else {
if((state_val_23297 === (15))){
var inst_23292 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
var statearr_23305_23351 = state_23296__$1;
(statearr_23305_23351[(2)] = inst_23292);

(statearr_23305_23351[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (21))){
var inst_23251 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
var statearr_23306_23352 = state_23296__$1;
(statearr_23306_23352[(2)] = inst_23251);

(statearr_23306_23352[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (31))){
var inst_23275 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_23296__$1 = state_23296;
if(cljs.core.truth_(inst_23275)){
var statearr_23307_23353 = state_23296__$1;
(statearr_23307_23353[(1)] = (34));

} else {
var statearr_23308_23354 = state_23296__$1;
(statearr_23308_23354[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (32))){
var inst_23284 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
var statearr_23309_23355 = state_23296__$1;
(statearr_23309_23355[(2)] = inst_23284);

(statearr_23309_23355[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (33))){
var inst_23273 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
var statearr_23310_23356 = state_23296__$1;
(statearr_23310_23356[(2)] = inst_23273);

(statearr_23310_23356[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (13))){
var inst_23234 = figwheel.client.heads_up.clear.call(null);
var state_23296__$1 = state_23296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23296__$1,(16),inst_23234);
} else {
if((state_val_23297 === (22))){
var inst_23255 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_23256 = figwheel.client.heads_up.append_message.call(null,inst_23255);
var state_23296__$1 = state_23296;
var statearr_23311_23357 = state_23296__$1;
(statearr_23311_23357[(2)] = inst_23256);

(statearr_23311_23357[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (36))){
var inst_23282 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
var statearr_23312_23358 = state_23296__$1;
(statearr_23312_23358[(2)] = inst_23282);

(statearr_23312_23358[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (29))){
var inst_23266 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
var statearr_23313_23359 = state_23296__$1;
(statearr_23313_23359[(2)] = inst_23266);

(statearr_23313_23359[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (6))){
var inst_23215 = (state_23296[(7)]);
var state_23296__$1 = state_23296;
var statearr_23314_23360 = state_23296__$1;
(statearr_23314_23360[(2)] = inst_23215);

(statearr_23314_23360[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (28))){
var inst_23262 = (state_23296[(2)]);
var inst_23263 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_23264 = figwheel.client.heads_up.display_warning.call(null,inst_23263);
var state_23296__$1 = (function (){var statearr_23315 = state_23296;
(statearr_23315[(8)] = inst_23262);

return statearr_23315;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23296__$1,(29),inst_23264);
} else {
if((state_val_23297 === (25))){
var inst_23260 = figwheel.client.heads_up.clear.call(null);
var state_23296__$1 = state_23296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23296__$1,(28),inst_23260);
} else {
if((state_val_23297 === (34))){
var inst_23277 = figwheel.client.heads_up.flash_loaded.call(null);
var state_23296__$1 = state_23296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23296__$1,(37),inst_23277);
} else {
if((state_val_23297 === (17))){
var inst_23242 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
var statearr_23316_23361 = state_23296__$1;
(statearr_23316_23361[(2)] = inst_23242);

(statearr_23316_23361[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (3))){
var inst_23232 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_23296__$1 = state_23296;
if(cljs.core.truth_(inst_23232)){
var statearr_23317_23362 = state_23296__$1;
(statearr_23317_23362[(1)] = (13));

} else {
var statearr_23318_23363 = state_23296__$1;
(statearr_23318_23363[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (12))){
var inst_23228 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
var statearr_23319_23364 = state_23296__$1;
(statearr_23319_23364[(2)] = inst_23228);

(statearr_23319_23364[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (2))){
var inst_23215 = (state_23296[(7)]);
var inst_23215__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_23296__$1 = (function (){var statearr_23320 = state_23296;
(statearr_23320[(7)] = inst_23215__$1);

return statearr_23320;
})();
if(cljs.core.truth_(inst_23215__$1)){
var statearr_23321_23365 = state_23296__$1;
(statearr_23321_23365[(1)] = (5));

} else {
var statearr_23322_23366 = state_23296__$1;
(statearr_23322_23366[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (23))){
var inst_23258 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_23296__$1 = state_23296;
if(cljs.core.truth_(inst_23258)){
var statearr_23323_23367 = state_23296__$1;
(statearr_23323_23367[(1)] = (25));

} else {
var statearr_23324_23368 = state_23296__$1;
(statearr_23324_23368[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (35))){
var state_23296__$1 = state_23296;
var statearr_23325_23369 = state_23296__$1;
(statearr_23325_23369[(2)] = null);

(statearr_23325_23369[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (19))){
var inst_23253 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_23296__$1 = state_23296;
if(cljs.core.truth_(inst_23253)){
var statearr_23326_23370 = state_23296__$1;
(statearr_23326_23370[(1)] = (22));

} else {
var statearr_23327_23371 = state_23296__$1;
(statearr_23327_23371[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (11))){
var inst_23224 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
var statearr_23328_23372 = state_23296__$1;
(statearr_23328_23372[(2)] = inst_23224);

(statearr_23328_23372[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (9))){
var inst_23226 = figwheel.client.heads_up.clear.call(null);
var state_23296__$1 = state_23296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23296__$1,(12),inst_23226);
} else {
if((state_val_23297 === (5))){
var inst_23217 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_23296__$1 = state_23296;
var statearr_23329_23373 = state_23296__$1;
(statearr_23329_23373[(2)] = inst_23217);

(statearr_23329_23373[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (14))){
var inst_23244 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_23296__$1 = state_23296;
if(cljs.core.truth_(inst_23244)){
var statearr_23330_23374 = state_23296__$1;
(statearr_23330_23374[(1)] = (18));

} else {
var statearr_23331_23375 = state_23296__$1;
(statearr_23331_23375[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (26))){
var inst_23268 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_23296__$1 = state_23296;
if(cljs.core.truth_(inst_23268)){
var statearr_23332_23376 = state_23296__$1;
(statearr_23332_23376[(1)] = (30));

} else {
var statearr_23333_23377 = state_23296__$1;
(statearr_23333_23377[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (16))){
var inst_23236 = (state_23296[(2)]);
var inst_23237 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_23238 = figwheel.client.format_messages.call(null,inst_23237);
var inst_23239 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_23240 = figwheel.client.heads_up.display_error.call(null,inst_23238,inst_23239);
var state_23296__$1 = (function (){var statearr_23334 = state_23296;
(statearr_23334[(9)] = inst_23236);

return statearr_23334;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23296__$1,(17),inst_23240);
} else {
if((state_val_23297 === (30))){
var inst_23270 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_23271 = figwheel.client.heads_up.display_warning.call(null,inst_23270);
var state_23296__$1 = state_23296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23296__$1,(33),inst_23271);
} else {
if((state_val_23297 === (10))){
var inst_23230 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
var statearr_23335_23378 = state_23296__$1;
(statearr_23335_23378[(2)] = inst_23230);

(statearr_23335_23378[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (18))){
var inst_23246 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_23247 = figwheel.client.format_messages.call(null,inst_23246);
var inst_23248 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_23249 = figwheel.client.heads_up.display_error.call(null,inst_23247,inst_23248);
var state_23296__$1 = state_23296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23296__$1,(21),inst_23249);
} else {
if((state_val_23297 === (37))){
var inst_23279 = (state_23296[(2)]);
var state_23296__$1 = state_23296;
var statearr_23336_23379 = state_23296__$1;
(statearr_23336_23379[(2)] = inst_23279);

(statearr_23336_23379[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23297 === (8))){
var inst_23222 = figwheel.client.heads_up.flash_loaded.call(null);
var state_23296__$1 = state_23296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23296__$1,(11),inst_23222);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__18676__auto__,c__18741__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__18677__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__18677__auto____0 = (function (){
var statearr_23340 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23340[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__18677__auto__);

(statearr_23340[(1)] = (1));

return statearr_23340;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__18677__auto____1 = (function (state_23296){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_23296);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e23341){if((e23341 instanceof Object)){
var ex__18680__auto__ = e23341;
var statearr_23342_23380 = state_23296;
(statearr_23342_23380[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23296);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23341;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23381 = state_23296;
state_23296 = G__23381;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__18677__auto__ = function(state_23296){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__18677__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__18677__auto____1.call(this,state_23296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__18677__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__18677__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto__,msg_hist,msg_names,msg))
})();
var state__18743__auto__ = (function (){var statearr_23343 = f__18742__auto__.call(null);
(statearr_23343[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto__);

return statearr_23343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto__,msg_hist,msg_names,msg))
);

return c__18741__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__18741__auto___23444 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___23444,ch){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___23444,ch){
return (function (state_23427){
var state_val_23428 = (state_23427[(1)]);
if((state_val_23428 === (1))){
var state_23427__$1 = state_23427;
var statearr_23429_23445 = state_23427__$1;
(statearr_23429_23445[(2)] = null);

(statearr_23429_23445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23428 === (2))){
var state_23427__$1 = state_23427;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23427__$1,(4),ch);
} else {
if((state_val_23428 === (3))){
var inst_23425 = (state_23427[(2)]);
var state_23427__$1 = state_23427;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23427__$1,inst_23425);
} else {
if((state_val_23428 === (4))){
var inst_23415 = (state_23427[(7)]);
var inst_23415__$1 = (state_23427[(2)]);
var state_23427__$1 = (function (){var statearr_23430 = state_23427;
(statearr_23430[(7)] = inst_23415__$1);

return statearr_23430;
})();
if(cljs.core.truth_(inst_23415__$1)){
var statearr_23431_23446 = state_23427__$1;
(statearr_23431_23446[(1)] = (5));

} else {
var statearr_23432_23447 = state_23427__$1;
(statearr_23432_23447[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23428 === (5))){
var inst_23415 = (state_23427[(7)]);
var inst_23417 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_23415);
var state_23427__$1 = state_23427;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23427__$1,(8),inst_23417);
} else {
if((state_val_23428 === (6))){
var state_23427__$1 = state_23427;
var statearr_23433_23448 = state_23427__$1;
(statearr_23433_23448[(2)] = null);

(statearr_23433_23448[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23428 === (7))){
var inst_23423 = (state_23427[(2)]);
var state_23427__$1 = state_23427;
var statearr_23434_23449 = state_23427__$1;
(statearr_23434_23449[(2)] = inst_23423);

(statearr_23434_23449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23428 === (8))){
var inst_23419 = (state_23427[(2)]);
var state_23427__$1 = (function (){var statearr_23435 = state_23427;
(statearr_23435[(8)] = inst_23419);

return statearr_23435;
})();
var statearr_23436_23450 = state_23427__$1;
(statearr_23436_23450[(2)] = null);

(statearr_23436_23450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__18741__auto___23444,ch))
;
return ((function (switch__18676__auto__,c__18741__auto___23444,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__18677__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__18677__auto____0 = (function (){
var statearr_23440 = [null,null,null,null,null,null,null,null,null];
(statearr_23440[(0)] = figwheel$client$heads_up_plugin_$_state_machine__18677__auto__);

(statearr_23440[(1)] = (1));

return statearr_23440;
});
var figwheel$client$heads_up_plugin_$_state_machine__18677__auto____1 = (function (state_23427){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_23427);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e23441){if((e23441 instanceof Object)){
var ex__18680__auto__ = e23441;
var statearr_23442_23451 = state_23427;
(statearr_23442_23451[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23427);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23441;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23452 = state_23427;
state_23427 = G__23452;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__18677__auto__ = function(state_23427){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__18677__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__18677__auto____1.call(this,state_23427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__18677__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__18677__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___23444,ch))
})();
var state__18743__auto__ = (function (){var statearr_23443 = f__18742__auto__.call(null);
(statearr_23443[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___23444);

return statearr_23443;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___23444,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__18741__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto__){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto__){
return (function (state_23473){
var state_val_23474 = (state_23473[(1)]);
if((state_val_23474 === (1))){
var inst_23468 = cljs.core.async.timeout.call(null,(3000));
var state_23473__$1 = state_23473;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23473__$1,(2),inst_23468);
} else {
if((state_val_23474 === (2))){
var inst_23470 = (state_23473[(2)]);
var inst_23471 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_23473__$1 = (function (){var statearr_23475 = state_23473;
(statearr_23475[(7)] = inst_23470);

return statearr_23475;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23473__$1,inst_23471);
} else {
return null;
}
}
});})(c__18741__auto__))
;
return ((function (switch__18676__auto__,c__18741__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__18677__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__18677__auto____0 = (function (){
var statearr_23479 = [null,null,null,null,null,null,null,null];
(statearr_23479[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__18677__auto__);

(statearr_23479[(1)] = (1));

return statearr_23479;
});
var figwheel$client$enforce_project_plugin_$_state_machine__18677__auto____1 = (function (state_23473){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_23473);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e23480){if((e23480 instanceof Object)){
var ex__18680__auto__ = e23480;
var statearr_23481_23483 = state_23473;
(statearr_23481_23483[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23473);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23480;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23484 = state_23473;
state_23473 = G__23484;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__18677__auto__ = function(state_23473){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__18677__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__18677__auto____1.call(this,state_23473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__18677__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__18677__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto__))
})();
var state__18743__auto__ = (function (){var statearr_23482 = f__18742__auto__.call(null);
(statearr_23482[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto__);

return statearr_23482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto__))
);

return c__18741__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__23485){
var map__23492 = p__23485;
var map__23492__$1 = ((((!((map__23492 == null)))?((((map__23492.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23492.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23492):map__23492);
var ed = map__23492__$1;
var formatted_exception = cljs.core.get.call(null,map__23492__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__23492__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__23492__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__23494_23498 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__23495_23499 = null;
var count__23496_23500 = (0);
var i__23497_23501 = (0);
while(true){
if((i__23497_23501 < count__23496_23500)){
var msg_23502 = cljs.core._nth.call(null,chunk__23495_23499,i__23497_23501);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_23502);

var G__23503 = seq__23494_23498;
var G__23504 = chunk__23495_23499;
var G__23505 = count__23496_23500;
var G__23506 = (i__23497_23501 + (1));
seq__23494_23498 = G__23503;
chunk__23495_23499 = G__23504;
count__23496_23500 = G__23505;
i__23497_23501 = G__23506;
continue;
} else {
var temp__4425__auto___23507 = cljs.core.seq.call(null,seq__23494_23498);
if(temp__4425__auto___23507){
var seq__23494_23508__$1 = temp__4425__auto___23507;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23494_23508__$1)){
var c__17461__auto___23509 = cljs.core.chunk_first.call(null,seq__23494_23508__$1);
var G__23510 = cljs.core.chunk_rest.call(null,seq__23494_23508__$1);
var G__23511 = c__17461__auto___23509;
var G__23512 = cljs.core.count.call(null,c__17461__auto___23509);
var G__23513 = (0);
seq__23494_23498 = G__23510;
chunk__23495_23499 = G__23511;
count__23496_23500 = G__23512;
i__23497_23501 = G__23513;
continue;
} else {
var msg_23514 = cljs.core.first.call(null,seq__23494_23508__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_23514);

var G__23515 = cljs.core.next.call(null,seq__23494_23508__$1);
var G__23516 = null;
var G__23517 = (0);
var G__23518 = (0);
seq__23494_23498 = G__23515;
chunk__23495_23499 = G__23516;
count__23496_23500 = G__23517;
i__23497_23501 = G__23518;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Error on file "),cljs.core.str(new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", line "),cljs.core.str(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", column "),cljs.core.str(new cljs.core.Keyword(null,"column","column",2078222095).cljs$core$IFn$_invoke$arity$1(cause))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__23519){
var map__23522 = p__23519;
var map__23522__$1 = ((((!((map__23522 == null)))?((((map__23522.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23522.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23522):map__23522);
var w = map__23522__$1;
var message = cljs.core.get.call(null,map__23522__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str("Figwheel: Compile Warning - "),cljs.core.str(message)].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[figwheel.client.default_on_compile_warning,figwheel.client.default_on_jsload,true,figwheel.client.default_on_compile_fail,false,true,[cljs.core.str("ws://"),cljs.core.str((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str("/figwheel-ws")].join(''),figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__16646__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__16646__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__16646__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__23530 = cljs.core.seq.call(null,plugins);
var chunk__23531 = null;
var count__23532 = (0);
var i__23533 = (0);
while(true){
if((i__23533 < count__23532)){
var vec__23534 = cljs.core._nth.call(null,chunk__23531,i__23533);
var k = cljs.core.nth.call(null,vec__23534,(0),null);
var plugin = cljs.core.nth.call(null,vec__23534,(1),null);
if(cljs.core.truth_(plugin)){
var pl_23536 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__23530,chunk__23531,count__23532,i__23533,pl_23536,vec__23534,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_23536.call(null,msg_hist);
});})(seq__23530,chunk__23531,count__23532,i__23533,pl_23536,vec__23534,k,plugin))
);
} else {
}

var G__23537 = seq__23530;
var G__23538 = chunk__23531;
var G__23539 = count__23532;
var G__23540 = (i__23533 + (1));
seq__23530 = G__23537;
chunk__23531 = G__23538;
count__23532 = G__23539;
i__23533 = G__23540;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__23530);
if(temp__4425__auto__){
var seq__23530__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23530__$1)){
var c__17461__auto__ = cljs.core.chunk_first.call(null,seq__23530__$1);
var G__23541 = cljs.core.chunk_rest.call(null,seq__23530__$1);
var G__23542 = c__17461__auto__;
var G__23543 = cljs.core.count.call(null,c__17461__auto__);
var G__23544 = (0);
seq__23530 = G__23541;
chunk__23531 = G__23542;
count__23532 = G__23543;
i__23533 = G__23544;
continue;
} else {
var vec__23535 = cljs.core.first.call(null,seq__23530__$1);
var k = cljs.core.nth.call(null,vec__23535,(0),null);
var plugin = cljs.core.nth.call(null,vec__23535,(1),null);
if(cljs.core.truth_(plugin)){
var pl_23545 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__23530,chunk__23531,count__23532,i__23533,pl_23545,vec__23535,k,plugin,seq__23530__$1,temp__4425__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_23545.call(null,msg_hist);
});})(seq__23530,chunk__23531,count__23532,i__23533,pl_23545,vec__23535,k,plugin,seq__23530__$1,temp__4425__auto__))
);
} else {
}

var G__23546 = cljs.core.next.call(null,seq__23530__$1);
var G__23547 = null;
var G__23548 = (0);
var G__23549 = (0);
seq__23530 = G__23546;
chunk__23531 = G__23547;
count__23532 = G__23548;
i__23533 = G__23549;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args23550 = [];
var len__17716__auto___23553 = arguments.length;
var i__17717__auto___23554 = (0);
while(true){
if((i__17717__auto___23554 < len__17716__auto___23553)){
args23550.push((arguments[i__17717__auto___23554]));

var G__23555 = (i__17717__auto___23554 + (1));
i__17717__auto___23554 = G__23555;
continue;
} else {
}
break;
}

var G__23552 = args23550.length;
switch (G__23552) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23550.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

return figwheel.client.socket.open.call(null,system_options);
}));
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;
figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__17723__auto__ = [];
var len__17716__auto___23561 = arguments.length;
var i__17717__auto___23562 = (0);
while(true){
if((i__17717__auto___23562 < len__17716__auto___23561)){
args__17723__auto__.push((arguments[i__17717__auto___23562]));

var G__23563 = (i__17717__auto___23562 + (1));
i__17717__auto___23562 = G__23563;
continue;
} else {
}
break;
}

var argseq__17724__auto__ = ((((0) < args__17723__auto__.length))?(new cljs.core.IndexedSeq(args__17723__auto__.slice((0)),(0))):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__17724__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__23558){
var map__23559 = p__23558;
var map__23559__$1 = ((((!((map__23559 == null)))?((((map__23559.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23559.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23559):map__23559);
var opts = map__23559__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq23557){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq23557));
});

//# sourceMappingURL=client.js.map