kosmos-sentry: clojure sentry client library with kosmos configuration
====================================

A Clojure library to send events to a sentry host that is configured with kosmos

### Usage

```clojure
[kosmos/kosmos-sentry "0.0.9"]
```

Configuration:

In kosmos, define the `dsn` and `environment` values under a `sentry` key:

```clojure
...

:sentry
{
 :dsn "http://secret:key@sentry.healthfinch.com/id"
 :environment "development"

 ;; ----
 ;; used to determine in_app seleection in sentry message for stackframes
 ;; see doc string in code for in_app?
 ;;
 :inclusions ["kosmos.db" "application.server" "http-clj.client"]
 :exclusions ["kosmos" "application" "http-clj"]
 }

```

**:inclusions**: are a list of strings or regex's that determine which stackframe namespaces/classes you want to include as `in_app`
**:exclusions**: are a list of strings or regex's that you do NOT want to include as in_app from the stackframe namespaces/classes

The main function is a fn named `report!`:

- `(report! event)`

where `event` is a map of sentry top level keywords and interfaces. 

There are many helper functions that let you compose the map according to your needs.  There is also a default fn `event`

- `(event args)`

- `(event args exception)`

**args**: a map of things to include in the message sent  
  -- tags are static and defined in the sentry server (see the Tags option under settings for the app being configured)  
  -- extra are dynamic user defined values  
  -- fingerprint is vector of strings used to rollup messages (when stackframes are not present) (not sure this is working in our version??)

**exception**: a java exception or ex-info  
  -- the data map associated with ex-info exceptions are sent via the extra key in the resulting message  
  
The helper fns are convenience fns to give you control on how the event is built for when you don't like the default `event` fn:

```
(require '[kosmos.sentry.helpers :as h])

(-> {}
    (h/server-name)
    (h/timestamp)
    (f/figerprint "a" "b" "c")
    ...
    )
```

### License

Kosmos is distributed under the [Eclipse Public License](http://opensource.org/licenses/eclipse-1.0.php), the same as Clojure.

