// Compiled by ClojureScript 1.10.339 {:optimize-constants true}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined')){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__3949__auto__ = ((cljs.core.map_QMARK_.call(null,m)) && (typeof cljs.core.cst$kw$namespace.cljs$core$IFn$_invoke$arity$1(m) === 'string') && ((((cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(m) === 'string'))) && (cljs.core._EQ_.call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(m),cljs.core.cst$kw$namespace)));
if(or__3949__auto__){
return or__3949__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__3949__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
var or__3949__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__3949__auto____$1)){
return or__3949__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__27964_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__27964_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependency_data !== 'undefined')){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pathToName,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$dependents,cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pathToName,path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pathToName,path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dependents,ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__27965 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__27966 = null;
var count__27967 = (0);
var i__27968 = (0);
while(true){
if((i__27968 < count__27967)){
var n = cljs.core._nth.call(null,chunk__27966,i__27968);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__27969 = seq__27965;
var G__27970 = chunk__27966;
var G__27971 = count__27967;
var G__27972 = (i__27968 + (1));
seq__27965 = G__27969;
chunk__27966 = G__27970;
count__27967 = G__27971;
i__27968 = G__27972;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__27965);
if(temp__5457__auto__){
var seq__27965__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27965__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__27965__$1);
var G__27973 = cljs.core.chunk_rest.call(null,seq__27965__$1);
var G__27974 = c__4351__auto__;
var G__27975 = cljs.core.count.call(null,c__4351__auto__);
var G__27976 = (0);
seq__27965 = G__27973;
chunk__27966 = G__27974;
count__27967 = G__27975;
i__27968 = G__27976;
continue;
} else {
var n = cljs.core.first.call(null,seq__27965__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__27977 = cljs.core.next.call(null,seq__27965__$1);
var G__27978 = null;
var G__27979 = (0);
var G__27980 = (0);
seq__27965 = G__27977;
chunk__27966 = G__27978;
count__27967 = G__27979;
i__27968 = G__27980;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dependents,ns], null));
});
figwheel.client.file_reloading.in_upper_level_QMARK_ = (function figwheel$client$file_reloading$in_upper_level_QMARK_(topo_state,current_depth,dep){
return cljs.core.some.call(null,(function (p__27981){
var vec__27982 = p__27981;
var _ = cljs.core.nth.call(null,vec__27982,(0),null);
var v = cljs.core.nth.call(null,vec__27982,(1),null);
var and__3938__auto__ = v;
if(cljs.core.truth_(and__3938__auto__)){
return v.call(null,dep);
} else {
return and__3938__auto__;
}
}),cljs.core.filter.call(null,(function (p__27985){
var vec__27986 = p__27985;
var k = cljs.core.nth.call(null,vec__27986,(0),null);
var v = cljs.core.nth.call(null,vec__27986,(1),null);
return (k > current_depth);
}),topo_state));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__27998_28006 = cljs.core.seq.call(null,deps);
var chunk__27999_28007 = null;
var count__28000_28008 = (0);
var i__28001_28009 = (0);
while(true){
if((i__28001_28009 < count__28000_28008)){
var dep_28010 = cljs.core._nth.call(null,chunk__27999_28007,i__28001_28009);
if(cljs.core.truth_((function (){var and__3938__auto__ = dep_28010;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_28010));
} else {
return and__3938__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_28010,(depth + (1)),state);
} else {
}


var G__28011 = seq__27998_28006;
var G__28012 = chunk__27999_28007;
var G__28013 = count__28000_28008;
var G__28014 = (i__28001_28009 + (1));
seq__27998_28006 = G__28011;
chunk__27999_28007 = G__28012;
count__28000_28008 = G__28013;
i__28001_28009 = G__28014;
continue;
} else {
var temp__5457__auto___28015 = cljs.core.seq.call(null,seq__27998_28006);
if(temp__5457__auto___28015){
var seq__27998_28016__$1 = temp__5457__auto___28015;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27998_28016__$1)){
var c__4351__auto___28017 = cljs.core.chunk_first.call(null,seq__27998_28016__$1);
var G__28018 = cljs.core.chunk_rest.call(null,seq__27998_28016__$1);
var G__28019 = c__4351__auto___28017;
var G__28020 = cljs.core.count.call(null,c__4351__auto___28017);
var G__28021 = (0);
seq__27998_28006 = G__28018;
chunk__27999_28007 = G__28019;
count__28000_28008 = G__28020;
i__28001_28009 = G__28021;
continue;
} else {
var dep_28022 = cljs.core.first.call(null,seq__27998_28016__$1);
if(cljs.core.truth_((function (){var and__3938__auto__ = dep_28022;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_28022));
} else {
return and__3938__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_28022,(depth + (1)),state);
} else {
}


var G__28023 = cljs.core.next.call(null,seq__27998_28016__$1);
var G__28024 = null;
var G__28025 = (0);
var G__28026 = (0);
seq__27998_28006 = G__28023;
chunk__27999_28007 = G__28024;
count__28000_28008 = G__28025;
i__28001_28009 = G__28026;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__28002){
var vec__28003 = p__28002;
var seq__28004 = cljs.core.seq.call(null,vec__28003);
var first__28005 = cljs.core.first.call(null,seq__28004);
var seq__28004__$1 = cljs.core.next.call(null,seq__28004);
var x = first__28005;
var xs = seq__28004__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__28003,seq__28004,first__28005,seq__28004__$1,x,xs,get_deps__$1){
return (function (p1__27989_SHARP_){
return clojure.set.difference.call(null,p1__27989_SHARP_,x);
});})(vec__28003,seq__28004,first__28005,seq__28004__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__28027 = cljs.core.seq.call(null,provides);
var chunk__28028 = null;
var count__28029 = (0);
var i__28030 = (0);
while(true){
if((i__28030 < count__28029)){
var prov = cljs.core._nth.call(null,chunk__28028,i__28030);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__28031_28039 = cljs.core.seq.call(null,requires);
var chunk__28032_28040 = null;
var count__28033_28041 = (0);
var i__28034_28042 = (0);
while(true){
if((i__28034_28042 < count__28033_28041)){
var req_28043 = cljs.core._nth.call(null,chunk__28032_28040,i__28034_28042);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_28043,prov);


var G__28044 = seq__28031_28039;
var G__28045 = chunk__28032_28040;
var G__28046 = count__28033_28041;
var G__28047 = (i__28034_28042 + (1));
seq__28031_28039 = G__28044;
chunk__28032_28040 = G__28045;
count__28033_28041 = G__28046;
i__28034_28042 = G__28047;
continue;
} else {
var temp__5457__auto___28048 = cljs.core.seq.call(null,seq__28031_28039);
if(temp__5457__auto___28048){
var seq__28031_28049__$1 = temp__5457__auto___28048;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28031_28049__$1)){
var c__4351__auto___28050 = cljs.core.chunk_first.call(null,seq__28031_28049__$1);
var G__28051 = cljs.core.chunk_rest.call(null,seq__28031_28049__$1);
var G__28052 = c__4351__auto___28050;
var G__28053 = cljs.core.count.call(null,c__4351__auto___28050);
var G__28054 = (0);
seq__28031_28039 = G__28051;
chunk__28032_28040 = G__28052;
count__28033_28041 = G__28053;
i__28034_28042 = G__28054;
continue;
} else {
var req_28055 = cljs.core.first.call(null,seq__28031_28049__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_28055,prov);


var G__28056 = cljs.core.next.call(null,seq__28031_28049__$1);
var G__28057 = null;
var G__28058 = (0);
var G__28059 = (0);
seq__28031_28039 = G__28056;
chunk__28032_28040 = G__28057;
count__28033_28041 = G__28058;
i__28034_28042 = G__28059;
continue;
}
} else {
}
}
break;
}


var G__28060 = seq__28027;
var G__28061 = chunk__28028;
var G__28062 = count__28029;
var G__28063 = (i__28030 + (1));
seq__28027 = G__28060;
chunk__28028 = G__28061;
count__28029 = G__28062;
i__28030 = G__28063;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__28027);
if(temp__5457__auto__){
var seq__28027__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28027__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__28027__$1);
var G__28064 = cljs.core.chunk_rest.call(null,seq__28027__$1);
var G__28065 = c__4351__auto__;
var G__28066 = cljs.core.count.call(null,c__4351__auto__);
var G__28067 = (0);
seq__28027 = G__28064;
chunk__28028 = G__28065;
count__28029 = G__28066;
i__28030 = G__28067;
continue;
} else {
var prov = cljs.core.first.call(null,seq__28027__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__28035_28068 = cljs.core.seq.call(null,requires);
var chunk__28036_28069 = null;
var count__28037_28070 = (0);
var i__28038_28071 = (0);
while(true){
if((i__28038_28071 < count__28037_28070)){
var req_28072 = cljs.core._nth.call(null,chunk__28036_28069,i__28038_28071);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_28072,prov);


var G__28073 = seq__28035_28068;
var G__28074 = chunk__28036_28069;
var G__28075 = count__28037_28070;
var G__28076 = (i__28038_28071 + (1));
seq__28035_28068 = G__28073;
chunk__28036_28069 = G__28074;
count__28037_28070 = G__28075;
i__28038_28071 = G__28076;
continue;
} else {
var temp__5457__auto___28077__$1 = cljs.core.seq.call(null,seq__28035_28068);
if(temp__5457__auto___28077__$1){
var seq__28035_28078__$1 = temp__5457__auto___28077__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28035_28078__$1)){
var c__4351__auto___28079 = cljs.core.chunk_first.call(null,seq__28035_28078__$1);
var G__28080 = cljs.core.chunk_rest.call(null,seq__28035_28078__$1);
var G__28081 = c__4351__auto___28079;
var G__28082 = cljs.core.count.call(null,c__4351__auto___28079);
var G__28083 = (0);
seq__28035_28068 = G__28080;
chunk__28036_28069 = G__28081;
count__28037_28070 = G__28082;
i__28038_28071 = G__28083;
continue;
} else {
var req_28084 = cljs.core.first.call(null,seq__28035_28078__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_28084,prov);


var G__28085 = cljs.core.next.call(null,seq__28035_28078__$1);
var G__28086 = null;
var G__28087 = (0);
var G__28088 = (0);
seq__28035_28068 = G__28085;
chunk__28036_28069 = G__28086;
count__28037_28070 = G__28087;
i__28038_28071 = G__28088;
continue;
}
} else {
}
}
break;
}


var G__28089 = cljs.core.next.call(null,seq__28027__$1);
var G__28090 = null;
var G__28091 = (0);
var G__28092 = (0);
seq__28027 = G__28089;
chunk__28028 = G__28090;
count__28029 = G__28091;
i__28030 = G__28092;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__28093_28097 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__28094_28098 = null;
var count__28095_28099 = (0);
var i__28096_28100 = (0);
while(true){
if((i__28096_28100 < count__28095_28099)){
var ns_28101 = cljs.core._nth.call(null,chunk__28094_28098,i__28096_28100);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_28101);


var G__28102 = seq__28093_28097;
var G__28103 = chunk__28094_28098;
var G__28104 = count__28095_28099;
var G__28105 = (i__28096_28100 + (1));
seq__28093_28097 = G__28102;
chunk__28094_28098 = G__28103;
count__28095_28099 = G__28104;
i__28096_28100 = G__28105;
continue;
} else {
var temp__5457__auto___28106 = cljs.core.seq.call(null,seq__28093_28097);
if(temp__5457__auto___28106){
var seq__28093_28107__$1 = temp__5457__auto___28106;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28093_28107__$1)){
var c__4351__auto___28108 = cljs.core.chunk_first.call(null,seq__28093_28107__$1);
var G__28109 = cljs.core.chunk_rest.call(null,seq__28093_28107__$1);
var G__28110 = c__4351__auto___28108;
var G__28111 = cljs.core.count.call(null,c__4351__auto___28108);
var G__28112 = (0);
seq__28093_28097 = G__28109;
chunk__28094_28098 = G__28110;
count__28095_28099 = G__28111;
i__28096_28100 = G__28112;
continue;
} else {
var ns_28113 = cljs.core.first.call(null,seq__28093_28107__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_28113);


var G__28114 = cljs.core.next.call(null,seq__28093_28107__$1);
var G__28115 = null;
var G__28116 = (0);
var G__28117 = (0);
seq__28093_28097 = G__28114;
chunk__28094_28098 = G__28115;
count__28095_28099 = G__28116;
i__28096_28100 = G__28117;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__3949__auto__ = goog.require__;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__28118__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__28118 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__28119__i = 0, G__28119__a = new Array(arguments.length -  0);
while (G__28119__i < G__28119__a.length) {G__28119__a[G__28119__i] = arguments[G__28119__i + 0]; ++G__28119__i;}
  args = new cljs.core.IndexedSeq(G__28119__a,0,null);
} 
return G__28118__delegate.call(this,args);};
G__28118.cljs$lang$maxFixedArity = 0;
G__28118.cljs$lang$applyTo = (function (arglist__28120){
var args = cljs.core.seq(arglist__28120);
return G__28118__delegate(args);
});
G__28118.cljs$core$IFn$_invoke$arity$variadic = G__28118__delegate;
return G__28118;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined')){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = (((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.safeLoad !== 'undefined'))?(function (p1__28121_SHARP_,p2__28122_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__28121_SHARP_)].join('')),p2__28122_SHARP_);
}):(((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.load !== 'undefined'))?(function (p1__28123_SHARP_,p2__28124_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__28123_SHARP_)].join(''),p2__28124_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__28125 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__28125.addCallback(((function (G__28125){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__28125))
);

G__28125.addErrback(((function (G__28125){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__28125))
);

return G__28125;
});
figwheel.client.file_reloading.write_script_tag_import = figwheel.client.file_reloading.reload_file_in_html_env;
goog.exportSymbol('figwheel.client.file_reloading.write_script_tag_import', figwheel.client.file_reloading.write_script_tag_import);
figwheel.client.file_reloading.worker_import_script = (function figwheel$client$file_reloading$worker_import_script(request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e28126){if((e28126 instanceof Error)){
var e = e28126;
figwheel.client.utils.log.call(null,cljs.core.cst$kw$error,["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,cljs.core.cst$kw$error,e.stack);

return false;
} else {
throw e28126;

}
}})());
});
goog.exportSymbol('figwheel.client.file_reloading.worker_import_script', figwheel.client.file_reloading.worker_import_script);
figwheel.client.file_reloading.create_node_script_import_fn = (function figwheel$client$file_reloading$create_node_script_import_fn(){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e28127){if((e28127 instanceof Error)){
var e = e28127;
figwheel.client.utils.log.call(null,cljs.core.cst$kw$error,["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,cljs.core.cst$kw$error,e.stack);

return false;
} else {
throw e28127;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path))
});
goog.exportSymbol('figwheel.client.file_reloading.create_node_script_import_fn', figwheel.client.file_reloading.create_node_script_import_fn);
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__28128 = cljs.core._EQ_;
var expr__28129 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__28128.call(null,cljs.core.cst$kw$node,expr__28129))){
return figwheel.client.file_reloading.create_node_script_import_fn.call(null);
} else {
if(cljs.core.truth_(pred__28128.call(null,cljs.core.cst$kw$html,expr__28129))){
return figwheel.client.file_reloading.write_script_tag_import;
} else {
if(cljs.core.truth_(pred__28128.call(null,cljs.core.cst$kw$worker,expr__28129))){
return figwheel.client.file_reloading.worker_import_script;
} else {
return ((function (pred__28128,expr__28129){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__28128,expr__28129))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__28131,callback){
var map__28132 = p__28131;
var map__28132__$1 = ((((!((map__28132 == null)))?(((((map__28132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28132.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28132):map__28132);
var file_msg = map__28132__$1;
var request_url = cljs.core.get.call(null,map__28132__$1,cljs.core.cst$kw$request_DASH_url);

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return (function (){var or__3949__auto__ = goog.object.get(goog.global,"FIGWHEEL_IMPORT_SCRIPT");
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return figwheel.client.file_reloading.reload_file_STAR_;
}
})().call(null,request_url,((function (map__28132,map__28132__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,cljs.core.cst$kw$loaded_DASH_file,true)], null));
} else {
figwheel.client.utils.log.call(null,cljs.core.cst$kw$error,["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__28132,map__28132__$1,file_msg,request_url))
);
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_chan !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined')){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined')){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_url,url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reloader_loop !== 'undefined')){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__25854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto__){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto__){
return (function (state_28170){
var state_val_28171 = (state_28170[(1)]);
if((state_val_28171 === (7))){
var inst_28166 = (state_28170[(2)]);
var state_28170__$1 = state_28170;
var statearr_28172_28198 = state_28170__$1;
(statearr_28172_28198[(2)] = inst_28166);

(statearr_28172_28198[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28171 === (1))){
var state_28170__$1 = state_28170;
var statearr_28173_28199 = state_28170__$1;
(statearr_28173_28199[(2)] = null);

(statearr_28173_28199[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28171 === (4))){
var inst_28136 = (state_28170[(7)]);
var inst_28136__$1 = (state_28170[(2)]);
var state_28170__$1 = (function (){var statearr_28174 = state_28170;
(statearr_28174[(7)] = inst_28136__$1);

return statearr_28174;
})();
if(cljs.core.truth_(inst_28136__$1)){
var statearr_28175_28200 = state_28170__$1;
(statearr_28175_28200[(1)] = (5));

} else {
var statearr_28176_28201 = state_28170__$1;
(statearr_28176_28201[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28171 === (15))){
var inst_28151 = (state_28170[(8)]);
var inst_28149 = (state_28170[(9)]);
var inst_28153 = inst_28151.call(null,inst_28149);
var state_28170__$1 = state_28170;
var statearr_28177_28202 = state_28170__$1;
(statearr_28177_28202[(2)] = inst_28153);

(statearr_28177_28202[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28171 === (13))){
var inst_28160 = (state_28170[(2)]);
var state_28170__$1 = state_28170;
var statearr_28178_28203 = state_28170__$1;
(statearr_28178_28203[(2)] = inst_28160);

(statearr_28178_28203[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28171 === (6))){
var state_28170__$1 = state_28170;
var statearr_28179_28204 = state_28170__$1;
(statearr_28179_28204[(2)] = null);

(statearr_28179_28204[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28171 === (17))){
var inst_28157 = (state_28170[(2)]);
var state_28170__$1 = state_28170;
var statearr_28180_28205 = state_28170__$1;
(statearr_28180_28205[(2)] = inst_28157);

(statearr_28180_28205[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28171 === (3))){
var inst_28168 = (state_28170[(2)]);
var state_28170__$1 = state_28170;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28170__$1,inst_28168);
} else {
if((state_val_28171 === (12))){
var state_28170__$1 = state_28170;
var statearr_28181_28206 = state_28170__$1;
(statearr_28181_28206[(2)] = null);

(statearr_28181_28206[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28171 === (2))){
var state_28170__$1 = state_28170;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28170__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_28171 === (11))){
var inst_28141 = (state_28170[(10)]);
var inst_28147 = figwheel.client.file_reloading.blocking_load.call(null,inst_28141);
var state_28170__$1 = state_28170;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28170__$1,(14),inst_28147);
} else {
if((state_val_28171 === (9))){
var inst_28141 = (state_28170[(10)]);
var state_28170__$1 = state_28170;
if(cljs.core.truth_(inst_28141)){
var statearr_28182_28207 = state_28170__$1;
(statearr_28182_28207[(1)] = (11));

} else {
var statearr_28183_28208 = state_28170__$1;
(statearr_28183_28208[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28171 === (5))){
var inst_28136 = (state_28170[(7)]);
var inst_28142 = (state_28170[(11)]);
var inst_28141 = cljs.core.nth.call(null,inst_28136,(0),null);
var inst_28142__$1 = cljs.core.nth.call(null,inst_28136,(1),null);
var state_28170__$1 = (function (){var statearr_28184 = state_28170;
(statearr_28184[(10)] = inst_28141);

(statearr_28184[(11)] = inst_28142__$1);

return statearr_28184;
})();
if(cljs.core.truth_(inst_28142__$1)){
var statearr_28185_28209 = state_28170__$1;
(statearr_28185_28209[(1)] = (8));

} else {
var statearr_28186_28210 = state_28170__$1;
(statearr_28186_28210[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28171 === (14))){
var inst_28151 = (state_28170[(8)]);
var inst_28141 = (state_28170[(10)]);
var inst_28149 = (state_28170[(2)]);
var inst_28150 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_28151__$1 = cljs.core.get.call(null,inst_28150,inst_28141);
var state_28170__$1 = (function (){var statearr_28187 = state_28170;
(statearr_28187[(8)] = inst_28151__$1);

(statearr_28187[(9)] = inst_28149);

return statearr_28187;
})();
if(cljs.core.truth_(inst_28151__$1)){
var statearr_28188_28211 = state_28170__$1;
(statearr_28188_28211[(1)] = (15));

} else {
var statearr_28189_28212 = state_28170__$1;
(statearr_28189_28212[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28171 === (16))){
var inst_28149 = (state_28170[(9)]);
var inst_28155 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_28149);
var state_28170__$1 = state_28170;
var statearr_28190_28213 = state_28170__$1;
(statearr_28190_28213[(2)] = inst_28155);

(statearr_28190_28213[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28171 === (10))){
var inst_28162 = (state_28170[(2)]);
var state_28170__$1 = (function (){var statearr_28191 = state_28170;
(statearr_28191[(12)] = inst_28162);

return statearr_28191;
})();
var statearr_28192_28214 = state_28170__$1;
(statearr_28192_28214[(2)] = null);

(statearr_28192_28214[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28171 === (8))){
var inst_28142 = (state_28170[(11)]);
var inst_28144 = eval(inst_28142);
var state_28170__$1 = state_28170;
var statearr_28193_28215 = state_28170__$1;
(statearr_28193_28215[(2)] = inst_28144);

(statearr_28193_28215[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto__))
;
return ((function (switch__25763__auto__,c__25854__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__25764__auto__ = null;
var figwheel$client$file_reloading$state_machine__25764__auto____0 = (function (){
var statearr_28194 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28194[(0)] = figwheel$client$file_reloading$state_machine__25764__auto__);

(statearr_28194[(1)] = (1));

return statearr_28194;
});
var figwheel$client$file_reloading$state_machine__25764__auto____1 = (function (state_28170){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_28170);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e28195){if((e28195 instanceof Object)){
var ex__25767__auto__ = e28195;
var statearr_28196_28216 = state_28170;
(statearr_28196_28216[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28170);

return cljs.core.cst$kw$recur;
} else {
throw e28195;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__28217 = state_28170;
state_28170 = G__28217;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__25764__auto__ = function(state_28170){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__25764__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__25764__auto____1.call(this,state_28170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__25764__auto____0;
figwheel$client$file_reloading$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__25764__auto____1;
return figwheel$client$file_reloading$state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto__))
})();
var state__25856__auto__ = (function (){var statearr_28197 = f__25855__auto__.call(null);
(statearr_28197[(6)] = c__25854__auto__);

return statearr_28197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto__))
);

return c__25854__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(var_args){
var G__28219 = arguments.length;
switch (G__28219) {
case 1:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1 = (function (url){
return figwheel.client.file_reloading.queued_file_reload.call(null,url,null);
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2 = (function (url,opt_source_text){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,opt_source_text], null));
});

figwheel.client.file_reloading.queued_file_reload.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__28221,callback){
var map__28222 = p__28221;
var map__28222__$1 = ((((!((map__28222 == null)))?(((((map__28222.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28222.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28222):map__28222);
var file_msg = map__28222__$1;
var namespace = cljs.core.get.call(null,map__28222__$1,cljs.core.cst$kw$namespace);
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__28222,map__28222__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$loaded_DASH_file], null)))], null));
});})(request_url,map__28222,map__28222__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__28224){
var map__28225 = p__28224;
var map__28225__$1 = ((((!((map__28225 == null)))?(((((map__28225.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28225.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28225):map__28225);
var file_msg = map__28225__$1;
var namespace = cljs.core.get.call(null,map__28225__$1,cljs.core.cst$kw$namespace);
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return cljs.core.cst$kw$figwheel_DASH_no_DASH_load.cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.ns_exists_QMARK_ = (function figwheel$client$file_reloading$ns_exists_QMARK_(namespace){
return !((cljs.core.reduce.call(null,cljs.core.fnil.call(null,goog.object.get,({})),goog.global,clojure.string.split.call(null,cljs.core.name.call(null,namespace),".")) == null));
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__28227){
var map__28228 = p__28227;
var map__28228__$1 = ((((!((map__28228 == null)))?(((((map__28228.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28228.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28228):map__28228);
var file_msg = map__28228__$1;
var namespace = cljs.core.get.call(null,map__28228__$1,cljs.core.cst$kw$namespace);

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__3938__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__3938__auto__){
var or__3949__auto__ = cljs.core.cst$kw$figwheel_DASH_always.cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
var or__3949__auto____$1 = cljs.core.cst$kw$figwheel_DASH_load.cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__3949__auto____$1)){
return or__3949__auto____$1;
} else {
var or__3949__auto____$2 = figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
if(cljs.core.truth_(or__3949__auto____$2)){
return or__3949__auto____$2;
} else {
return figwheel.client.file_reloading.ns_exists_QMARK_.call(null,namespace);
}
}
}
} else {
return and__3938__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__28230,callback){
var map__28231 = p__28230;
var map__28231__$1 = ((((!((map__28231 == null)))?(((((map__28231.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28231.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28231):map__28231);
var file_msg = map__28231__$1;
var request_url = cljs.core.get.call(null,map__28231__$1,cljs.core.cst$kw$request_DASH_url);
var namespace = cljs.core.get.call(null,map__28231__$1,cljs.core.cst$kw$namespace);

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__25854__auto___28281 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___28281,out){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___28281,out){
return (function (state_28266){
var state_val_28267 = (state_28266[(1)]);
if((state_val_28267 === (1))){
var inst_28240 = cljs.core.seq.call(null,files);
var inst_28241 = cljs.core.first.call(null,inst_28240);
var inst_28242 = cljs.core.next.call(null,inst_28240);
var inst_28243 = files;
var state_28266__$1 = (function (){var statearr_28268 = state_28266;
(statearr_28268[(7)] = inst_28241);

(statearr_28268[(8)] = inst_28243);

(statearr_28268[(9)] = inst_28242);

return statearr_28268;
})();
var statearr_28269_28282 = state_28266__$1;
(statearr_28269_28282[(2)] = null);

(statearr_28269_28282[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28267 === (2))){
var inst_28249 = (state_28266[(10)]);
var inst_28243 = (state_28266[(8)]);
var inst_28248 = cljs.core.seq.call(null,inst_28243);
var inst_28249__$1 = cljs.core.first.call(null,inst_28248);
var inst_28250 = cljs.core.next.call(null,inst_28248);
var inst_28251 = (inst_28249__$1 == null);
var inst_28252 = cljs.core.not.call(null,inst_28251);
var state_28266__$1 = (function (){var statearr_28270 = state_28266;
(statearr_28270[(11)] = inst_28250);

(statearr_28270[(10)] = inst_28249__$1);

return statearr_28270;
})();
if(inst_28252){
var statearr_28271_28283 = state_28266__$1;
(statearr_28271_28283[(1)] = (4));

} else {
var statearr_28272_28284 = state_28266__$1;
(statearr_28272_28284[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28267 === (3))){
var inst_28264 = (state_28266[(2)]);
var state_28266__$1 = state_28266;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28266__$1,inst_28264);
} else {
if((state_val_28267 === (4))){
var inst_28249 = (state_28266[(10)]);
var inst_28254 = figwheel.client.file_reloading.reload_js_file.call(null,inst_28249);
var state_28266__$1 = state_28266;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28266__$1,(7),inst_28254);
} else {
if((state_val_28267 === (5))){
var inst_28260 = cljs.core.async.close_BANG_.call(null,out);
var state_28266__$1 = state_28266;
var statearr_28273_28285 = state_28266__$1;
(statearr_28273_28285[(2)] = inst_28260);

(statearr_28273_28285[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28267 === (6))){
var inst_28262 = (state_28266[(2)]);
var state_28266__$1 = state_28266;
var statearr_28274_28286 = state_28266__$1;
(statearr_28274_28286[(2)] = inst_28262);

(statearr_28274_28286[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28267 === (7))){
var inst_28250 = (state_28266[(11)]);
var inst_28256 = (state_28266[(2)]);
var inst_28257 = cljs.core.async.put_BANG_.call(null,out,inst_28256);
var inst_28243 = inst_28250;
var state_28266__$1 = (function (){var statearr_28275 = state_28266;
(statearr_28275[(12)] = inst_28257);

(statearr_28275[(8)] = inst_28243);

return statearr_28275;
})();
var statearr_28276_28287 = state_28266__$1;
(statearr_28276_28287[(2)] = null);

(statearr_28276_28287[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__25854__auto___28281,out))
;
return ((function (switch__25763__auto__,c__25854__auto___28281,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__25764__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__25764__auto____0 = (function (){
var statearr_28277 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28277[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__25764__auto__);

(statearr_28277[(1)] = (1));

return statearr_28277;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__25764__auto____1 = (function (state_28266){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_28266);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e28278){if((e28278 instanceof Object)){
var ex__25767__auto__ = e28278;
var statearr_28279_28288 = state_28266;
(statearr_28279_28288[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28266);

return cljs.core.cst$kw$recur;
} else {
throw e28278;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__28289 = state_28266;
state_28266 = G__28289;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__25764__auto__ = function(state_28266){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__25764__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__25764__auto____1.call(this,state_28266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__25764__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__25764__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___28281,out))
})();
var state__25856__auto__ = (function (){var statearr_28280 = f__25855__auto__.call(null);
(statearr_28280[(6)] = c__25854__auto___28281);

return statearr_28280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___28281,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__28290,opts){
var map__28291 = p__28290;
var map__28291__$1 = ((((!((map__28291 == null)))?(((((map__28291.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28291.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28291):map__28291);
var eval_body = cljs.core.get.call(null,map__28291__$1,cljs.core.cst$kw$eval_DASH_body);
var file = cljs.core.get.call(null,map__28291__$1,cljs.core.cst$kw$file);
if(cljs.core.truth_((function (){var and__3938__auto__ = eval_body;
if(cljs.core.truth_(and__3938__auto__)){
return typeof eval_body === 'string';
} else {
return and__3938__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e28293){var e = e28293;
return figwheel.client.utils.log.call(null,cljs.core.cst$kw$error,["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,cljs.core.cst$kw$namespace,files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),cljs.core.cst$kw$namespace),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__5455__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__28294_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.cst$kw$namespace.cljs$core$IFn$_invoke$arity$1(p1__28294_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__5455__auto__)){
var file_msg = temp__5455__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,cljs.core.cst$kw$namespace,cljs.core.cst$kw$namespace,n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,cljs.core.cst$kw$namespace,files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,cljs.core.cst$kw$namespace),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__28295){
var vec__28296 = p__28295;
var k = cljs.core.nth.call(null,vec__28296,(0),null);
var v = cljs.core.nth.call(null,vec__28296,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$namespace,k,cljs.core.cst$kw$type,cljs.core.cst$kw$namespace], null);
}),cljs.core.filter.call(null,(function (p__28299){
var vec__28300 = p__28299;
var k = cljs.core.nth.call(null,vec__28300,(0),null);
var v = cljs.core.nth.call(null,vec__28300,(1),null);
return cljs.core.cst$kw$figwheel_DASH_always.cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__28306,p__28307){
var map__28308 = p__28306;
var map__28308__$1 = ((((!((map__28308 == null)))?(((((map__28308.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28308.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28308):map__28308);
var opts = map__28308__$1;
var before_jsload = cljs.core.get.call(null,map__28308__$1,cljs.core.cst$kw$before_DASH_jsload);
var on_jsload = cljs.core.get.call(null,map__28308__$1,cljs.core.cst$kw$on_DASH_jsload);
var reload_dependents = cljs.core.get.call(null,map__28308__$1,cljs.core.cst$kw$reload_DASH_dependents);
var map__28309 = p__28307;
var map__28309__$1 = ((((!((map__28309 == null)))?(((((map__28309.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28309.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28309):map__28309);
var msg = map__28309__$1;
var files = cljs.core.get.call(null,map__28309__$1,cljs.core.cst$kw$files);
var figwheel_meta = cljs.core.get.call(null,map__28309__$1,cljs.core.cst$kw$figwheel_DASH_meta);
var recompile_dependents = cljs.core.get.call(null,map__28309__$1,cljs.core.cst$kw$recompile_DASH_dependents);
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__25854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_28463){
var state_val_28464 = (state_28463[(1)]);
if((state_val_28464 === (7))){
var inst_28323 = (state_28463[(7)]);
var inst_28326 = (state_28463[(8)]);
var inst_28325 = (state_28463[(9)]);
var inst_28324 = (state_28463[(10)]);
var inst_28331 = cljs.core._nth.call(null,inst_28324,inst_28326);
var inst_28332 = figwheel.client.file_reloading.eval_body.call(null,inst_28331,opts);
var inst_28333 = (inst_28326 + (1));
var tmp28465 = inst_28323;
var tmp28466 = inst_28325;
var tmp28467 = inst_28324;
var inst_28323__$1 = tmp28465;
var inst_28324__$1 = tmp28467;
var inst_28325__$1 = tmp28466;
var inst_28326__$1 = inst_28333;
var state_28463__$1 = (function (){var statearr_28468 = state_28463;
(statearr_28468[(7)] = inst_28323__$1);

(statearr_28468[(8)] = inst_28326__$1);

(statearr_28468[(9)] = inst_28325__$1);

(statearr_28468[(10)] = inst_28324__$1);

(statearr_28468[(11)] = inst_28332);

return statearr_28468;
})();
var statearr_28469_28552 = state_28463__$1;
(statearr_28469_28552[(2)] = null);

(statearr_28469_28552[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (20))){
var inst_28366 = (state_28463[(12)]);
var inst_28374 = figwheel.client.file_reloading.sort_files.call(null,inst_28366);
var state_28463__$1 = state_28463;
var statearr_28470_28553 = state_28463__$1;
(statearr_28470_28553[(2)] = inst_28374);

(statearr_28470_28553[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (27))){
var state_28463__$1 = state_28463;
var statearr_28471_28554 = state_28463__$1;
(statearr_28471_28554[(2)] = null);

(statearr_28471_28554[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (1))){
var inst_28315 = (state_28463[(13)]);
var inst_28312 = before_jsload.call(null,files);
var inst_28313 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_28314 = (function (){return ((function (inst_28315,inst_28312,inst_28313,state_val_28464,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__28303_SHARP_){
return cljs.core.cst$kw$eval_DASH_body.cljs$core$IFn$_invoke$arity$1(p1__28303_SHARP_);
});
;})(inst_28315,inst_28312,inst_28313,state_val_28464,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28315__$1 = cljs.core.filter.call(null,inst_28314,files);
var inst_28316 = cljs.core.not_empty.call(null,inst_28315__$1);
var state_28463__$1 = (function (){var statearr_28472 = state_28463;
(statearr_28472[(14)] = inst_28312);

(statearr_28472[(13)] = inst_28315__$1);

(statearr_28472[(15)] = inst_28313);

return statearr_28472;
})();
if(cljs.core.truth_(inst_28316)){
var statearr_28473_28555 = state_28463__$1;
(statearr_28473_28555[(1)] = (2));

} else {
var statearr_28474_28556 = state_28463__$1;
(statearr_28474_28556[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (24))){
var state_28463__$1 = state_28463;
var statearr_28475_28557 = state_28463__$1;
(statearr_28475_28557[(2)] = null);

(statearr_28475_28557[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (39))){
var inst_28416 = (state_28463[(16)]);
var state_28463__$1 = state_28463;
var statearr_28476_28558 = state_28463__$1;
(statearr_28476_28558[(2)] = inst_28416);

(statearr_28476_28558[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (46))){
var inst_28458 = (state_28463[(2)]);
var state_28463__$1 = state_28463;
var statearr_28477_28559 = state_28463__$1;
(statearr_28477_28559[(2)] = inst_28458);

(statearr_28477_28559[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (4))){
var inst_28360 = (state_28463[(2)]);
var inst_28361 = cljs.core.List.EMPTY;
var inst_28362 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_28361);
var inst_28363 = (function (){return ((function (inst_28360,inst_28361,inst_28362,state_val_28464,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__28304_SHARP_){
var and__3938__auto__ = cljs.core.cst$kw$namespace.cljs$core$IFn$_invoke$arity$1(p1__28304_SHARP_);
if(cljs.core.truth_(and__3938__auto__)){
return ((cljs.core.not.call(null,cljs.core.cst$kw$eval_DASH_body.cljs$core$IFn$_invoke$arity$1(p1__28304_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__28304_SHARP_))));
} else {
return and__3938__auto__;
}
});
;})(inst_28360,inst_28361,inst_28362,state_val_28464,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28364 = cljs.core.filter.call(null,inst_28363,files);
var inst_28365 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_28366 = cljs.core.concat.call(null,inst_28364,inst_28365);
var state_28463__$1 = (function (){var statearr_28478 = state_28463;
(statearr_28478[(12)] = inst_28366);

(statearr_28478[(17)] = inst_28360);

(statearr_28478[(18)] = inst_28362);

return statearr_28478;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_28479_28560 = state_28463__$1;
(statearr_28479_28560[(1)] = (16));

} else {
var statearr_28480_28561 = state_28463__$1;
(statearr_28480_28561[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (15))){
var inst_28350 = (state_28463[(2)]);
var state_28463__$1 = state_28463;
var statearr_28481_28562 = state_28463__$1;
(statearr_28481_28562[(2)] = inst_28350);

(statearr_28481_28562[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (21))){
var inst_28376 = (state_28463[(19)]);
var inst_28376__$1 = (state_28463[(2)]);
var inst_28377 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_28376__$1);
var state_28463__$1 = (function (){var statearr_28482 = state_28463;
(statearr_28482[(19)] = inst_28376__$1);

return statearr_28482;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28463__$1,(22),inst_28377);
} else {
if((state_val_28464 === (31))){
var inst_28461 = (state_28463[(2)]);
var state_28463__$1 = state_28463;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28463__$1,inst_28461);
} else {
if((state_val_28464 === (32))){
var inst_28416 = (state_28463[(16)]);
var inst_28421 = inst_28416.cljs$lang$protocol_mask$partition0$;
var inst_28422 = (inst_28421 & (64));
var inst_28423 = inst_28416.cljs$core$ISeq$;
var inst_28424 = (cljs.core.PROTOCOL_SENTINEL === inst_28423);
var inst_28425 = ((inst_28422) || (inst_28424));
var state_28463__$1 = state_28463;
if(cljs.core.truth_(inst_28425)){
var statearr_28483_28563 = state_28463__$1;
(statearr_28483_28563[(1)] = (35));

} else {
var statearr_28484_28564 = state_28463__$1;
(statearr_28484_28564[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (40))){
var inst_28438 = (state_28463[(20)]);
var inst_28437 = (state_28463[(2)]);
var inst_28438__$1 = cljs.core.get.call(null,inst_28437,cljs.core.cst$kw$figwheel_DASH_no_DASH_load);
var inst_28439 = cljs.core.get.call(null,inst_28437,cljs.core.cst$kw$not_DASH_required);
var inst_28440 = cljs.core.not_empty.call(null,inst_28438__$1);
var state_28463__$1 = (function (){var statearr_28485 = state_28463;
(statearr_28485[(21)] = inst_28439);

(statearr_28485[(20)] = inst_28438__$1);

return statearr_28485;
})();
if(cljs.core.truth_(inst_28440)){
var statearr_28486_28565 = state_28463__$1;
(statearr_28486_28565[(1)] = (41));

} else {
var statearr_28487_28566 = state_28463__$1;
(statearr_28487_28566[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (33))){
var state_28463__$1 = state_28463;
var statearr_28488_28567 = state_28463__$1;
(statearr_28488_28567[(2)] = false);

(statearr_28488_28567[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (13))){
var inst_28336 = (state_28463[(22)]);
var inst_28340 = cljs.core.chunk_first.call(null,inst_28336);
var inst_28341 = cljs.core.chunk_rest.call(null,inst_28336);
var inst_28342 = cljs.core.count.call(null,inst_28340);
var inst_28323 = inst_28341;
var inst_28324 = inst_28340;
var inst_28325 = inst_28342;
var inst_28326 = (0);
var state_28463__$1 = (function (){var statearr_28489 = state_28463;
(statearr_28489[(7)] = inst_28323);

(statearr_28489[(8)] = inst_28326);

(statearr_28489[(9)] = inst_28325);

(statearr_28489[(10)] = inst_28324);

return statearr_28489;
})();
var statearr_28490_28568 = state_28463__$1;
(statearr_28490_28568[(2)] = null);

(statearr_28490_28568[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (22))){
var inst_28384 = (state_28463[(23)]);
var inst_28380 = (state_28463[(24)]);
var inst_28379 = (state_28463[(25)]);
var inst_28376 = (state_28463[(19)]);
var inst_28379__$1 = (state_28463[(2)]);
var inst_28380__$1 = cljs.core.filter.call(null,cljs.core.cst$kw$loaded_DASH_file,inst_28379__$1);
var inst_28381 = (function (){var all_files = inst_28376;
var res_SINGLEQUOTE_ = inst_28379__$1;
var res = inst_28380__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_28384,inst_28380,inst_28379,inst_28376,inst_28379__$1,inst_28380__$1,state_val_28464,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__28305_SHARP_){
return cljs.core.not.call(null,cljs.core.cst$kw$loaded_DASH_file.cljs$core$IFn$_invoke$arity$1(p1__28305_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_28384,inst_28380,inst_28379,inst_28376,inst_28379__$1,inst_28380__$1,state_val_28464,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28382 = cljs.core.filter.call(null,inst_28381,inst_28379__$1);
var inst_28383 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_28384__$1 = cljs.core.filter.call(null,cljs.core.cst$kw$loaded_DASH_file,inst_28383);
var inst_28385 = cljs.core.not_empty.call(null,inst_28384__$1);
var state_28463__$1 = (function (){var statearr_28491 = state_28463;
(statearr_28491[(23)] = inst_28384__$1);

(statearr_28491[(24)] = inst_28380__$1);

(statearr_28491[(26)] = inst_28382);

(statearr_28491[(25)] = inst_28379__$1);

return statearr_28491;
})();
if(cljs.core.truth_(inst_28385)){
var statearr_28492_28569 = state_28463__$1;
(statearr_28492_28569[(1)] = (23));

} else {
var statearr_28493_28570 = state_28463__$1;
(statearr_28493_28570[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (36))){
var state_28463__$1 = state_28463;
var statearr_28494_28571 = state_28463__$1;
(statearr_28494_28571[(2)] = false);

(statearr_28494_28571[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (41))){
var inst_28438 = (state_28463[(20)]);
var inst_28442 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,cljs.core.cst$kw$namespace);
var inst_28443 = cljs.core.map.call(null,inst_28442,inst_28438);
var inst_28444 = cljs.core.pr_str.call(null,inst_28443);
var inst_28445 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28444)].join('');
var inst_28446 = figwheel.client.utils.log.call(null,inst_28445);
var state_28463__$1 = state_28463;
var statearr_28495_28572 = state_28463__$1;
(statearr_28495_28572[(2)] = inst_28446);

(statearr_28495_28572[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (43))){
var inst_28439 = (state_28463[(21)]);
var inst_28449 = (state_28463[(2)]);
var inst_28450 = cljs.core.not_empty.call(null,inst_28439);
var state_28463__$1 = (function (){var statearr_28496 = state_28463;
(statearr_28496[(27)] = inst_28449);

return statearr_28496;
})();
if(cljs.core.truth_(inst_28450)){
var statearr_28497_28573 = state_28463__$1;
(statearr_28497_28573[(1)] = (44));

} else {
var statearr_28498_28574 = state_28463__$1;
(statearr_28498_28574[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (29))){
var inst_28384 = (state_28463[(23)]);
var inst_28380 = (state_28463[(24)]);
var inst_28382 = (state_28463[(26)]);
var inst_28379 = (state_28463[(25)]);
var inst_28416 = (state_28463[(16)]);
var inst_28376 = (state_28463[(19)]);
var inst_28412 = figwheel.client.utils.log.call(null,cljs.core.cst$kw$debug,"Figwheel: NOT loading these files ");
var inst_28415 = (function (){var all_files = inst_28376;
var res_SINGLEQUOTE_ = inst_28379;
var res = inst_28380;
var files_not_loaded = inst_28382;
var dependencies_that_loaded = inst_28384;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28384,inst_28380,inst_28382,inst_28379,inst_28416,inst_28376,inst_28412,state_val_28464,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__28414){
var map__28499 = p__28414;
var map__28499__$1 = ((((!((map__28499 == null)))?(((((map__28499.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28499.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28499):map__28499);
var namespace = cljs.core.get.call(null,map__28499__$1,cljs.core.cst$kw$namespace);
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return cljs.core.cst$kw$not_DASH_required;
} else {
if(cljs.core.truth_(meta_data.call(null,cljs.core.cst$kw$figwheel_DASH_no_DASH_load))){
return cljs.core.cst$kw$figwheel_DASH_no_DASH_load;
} else {
return cljs.core.cst$kw$not_DASH_required;

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28384,inst_28380,inst_28382,inst_28379,inst_28416,inst_28376,inst_28412,state_val_28464,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28416__$1 = cljs.core.group_by.call(null,inst_28415,inst_28382);
var inst_28418 = (inst_28416__$1 == null);
var inst_28419 = cljs.core.not.call(null,inst_28418);
var state_28463__$1 = (function (){var statearr_28501 = state_28463;
(statearr_28501[(28)] = inst_28412);

(statearr_28501[(16)] = inst_28416__$1);

return statearr_28501;
})();
if(inst_28419){
var statearr_28502_28575 = state_28463__$1;
(statearr_28502_28575[(1)] = (32));

} else {
var statearr_28503_28576 = state_28463__$1;
(statearr_28503_28576[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (44))){
var inst_28439 = (state_28463[(21)]);
var inst_28452 = cljs.core.map.call(null,cljs.core.cst$kw$file,inst_28439);
var inst_28453 = cljs.core.pr_str.call(null,inst_28452);
var inst_28454 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28453)].join('');
var inst_28455 = figwheel.client.utils.log.call(null,inst_28454);
var state_28463__$1 = state_28463;
var statearr_28504_28577 = state_28463__$1;
(statearr_28504_28577[(2)] = inst_28455);

(statearr_28504_28577[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (6))){
var inst_28357 = (state_28463[(2)]);
var state_28463__$1 = state_28463;
var statearr_28505_28578 = state_28463__$1;
(statearr_28505_28578[(2)] = inst_28357);

(statearr_28505_28578[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (28))){
var inst_28382 = (state_28463[(26)]);
var inst_28409 = (state_28463[(2)]);
var inst_28410 = cljs.core.not_empty.call(null,inst_28382);
var state_28463__$1 = (function (){var statearr_28506 = state_28463;
(statearr_28506[(29)] = inst_28409);

return statearr_28506;
})();
if(cljs.core.truth_(inst_28410)){
var statearr_28507_28579 = state_28463__$1;
(statearr_28507_28579[(1)] = (29));

} else {
var statearr_28508_28580 = state_28463__$1;
(statearr_28508_28580[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (25))){
var inst_28380 = (state_28463[(24)]);
var inst_28396 = (state_28463[(2)]);
var inst_28397 = cljs.core.not_empty.call(null,inst_28380);
var state_28463__$1 = (function (){var statearr_28509 = state_28463;
(statearr_28509[(30)] = inst_28396);

return statearr_28509;
})();
if(cljs.core.truth_(inst_28397)){
var statearr_28510_28581 = state_28463__$1;
(statearr_28510_28581[(1)] = (26));

} else {
var statearr_28511_28582 = state_28463__$1;
(statearr_28511_28582[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (34))){
var inst_28432 = (state_28463[(2)]);
var state_28463__$1 = state_28463;
if(cljs.core.truth_(inst_28432)){
var statearr_28512_28583 = state_28463__$1;
(statearr_28512_28583[(1)] = (38));

} else {
var statearr_28513_28584 = state_28463__$1;
(statearr_28513_28584[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (17))){
var state_28463__$1 = state_28463;
var statearr_28514_28585 = state_28463__$1;
(statearr_28514_28585[(2)] = recompile_dependents);

(statearr_28514_28585[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (3))){
var state_28463__$1 = state_28463;
var statearr_28515_28586 = state_28463__$1;
(statearr_28515_28586[(2)] = null);

(statearr_28515_28586[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (12))){
var inst_28353 = (state_28463[(2)]);
var state_28463__$1 = state_28463;
var statearr_28516_28587 = state_28463__$1;
(statearr_28516_28587[(2)] = inst_28353);

(statearr_28516_28587[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (2))){
var inst_28315 = (state_28463[(13)]);
var inst_28322 = cljs.core.seq.call(null,inst_28315);
var inst_28323 = inst_28322;
var inst_28324 = null;
var inst_28325 = (0);
var inst_28326 = (0);
var state_28463__$1 = (function (){var statearr_28517 = state_28463;
(statearr_28517[(7)] = inst_28323);

(statearr_28517[(8)] = inst_28326);

(statearr_28517[(9)] = inst_28325);

(statearr_28517[(10)] = inst_28324);

return statearr_28517;
})();
var statearr_28518_28588 = state_28463__$1;
(statearr_28518_28588[(2)] = null);

(statearr_28518_28588[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (23))){
var inst_28384 = (state_28463[(23)]);
var inst_28380 = (state_28463[(24)]);
var inst_28382 = (state_28463[(26)]);
var inst_28379 = (state_28463[(25)]);
var inst_28376 = (state_28463[(19)]);
var inst_28387 = figwheel.client.utils.log.call(null,cljs.core.cst$kw$debug,"Figwheel: loaded these dependencies");
var inst_28389 = (function (){var all_files = inst_28376;
var res_SINGLEQUOTE_ = inst_28379;
var res = inst_28380;
var files_not_loaded = inst_28382;
var dependencies_that_loaded = inst_28384;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28384,inst_28380,inst_28382,inst_28379,inst_28376,inst_28387,state_val_28464,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__28388){
var map__28519 = p__28388;
var map__28519__$1 = ((((!((map__28519 == null)))?(((((map__28519.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28519.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28519):map__28519);
var request_url = cljs.core.get.call(null,map__28519__$1,cljs.core.cst$kw$request_DASH_url);
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28384,inst_28380,inst_28382,inst_28379,inst_28376,inst_28387,state_val_28464,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28390 = cljs.core.reverse.call(null,inst_28384);
var inst_28391 = cljs.core.map.call(null,inst_28389,inst_28390);
var inst_28392 = cljs.core.pr_str.call(null,inst_28391);
var inst_28393 = figwheel.client.utils.log.call(null,inst_28392);
var state_28463__$1 = (function (){var statearr_28521 = state_28463;
(statearr_28521[(31)] = inst_28387);

return statearr_28521;
})();
var statearr_28522_28589 = state_28463__$1;
(statearr_28522_28589[(2)] = inst_28393);

(statearr_28522_28589[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (35))){
var state_28463__$1 = state_28463;
var statearr_28523_28590 = state_28463__$1;
(statearr_28523_28590[(2)] = true);

(statearr_28523_28590[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (19))){
var inst_28366 = (state_28463[(12)]);
var inst_28372 = figwheel.client.file_reloading.expand_files.call(null,inst_28366);
var state_28463__$1 = state_28463;
var statearr_28524_28591 = state_28463__$1;
(statearr_28524_28591[(2)] = inst_28372);

(statearr_28524_28591[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (11))){
var state_28463__$1 = state_28463;
var statearr_28525_28592 = state_28463__$1;
(statearr_28525_28592[(2)] = null);

(statearr_28525_28592[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (9))){
var inst_28355 = (state_28463[(2)]);
var state_28463__$1 = state_28463;
var statearr_28526_28593 = state_28463__$1;
(statearr_28526_28593[(2)] = inst_28355);

(statearr_28526_28593[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (5))){
var inst_28326 = (state_28463[(8)]);
var inst_28325 = (state_28463[(9)]);
var inst_28328 = (inst_28326 < inst_28325);
var inst_28329 = inst_28328;
var state_28463__$1 = state_28463;
if(cljs.core.truth_(inst_28329)){
var statearr_28527_28594 = state_28463__$1;
(statearr_28527_28594[(1)] = (7));

} else {
var statearr_28528_28595 = state_28463__$1;
(statearr_28528_28595[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (14))){
var inst_28336 = (state_28463[(22)]);
var inst_28345 = cljs.core.first.call(null,inst_28336);
var inst_28346 = figwheel.client.file_reloading.eval_body.call(null,inst_28345,opts);
var inst_28347 = cljs.core.next.call(null,inst_28336);
var inst_28323 = inst_28347;
var inst_28324 = null;
var inst_28325 = (0);
var inst_28326 = (0);
var state_28463__$1 = (function (){var statearr_28529 = state_28463;
(statearr_28529[(7)] = inst_28323);

(statearr_28529[(8)] = inst_28326);

(statearr_28529[(32)] = inst_28346);

(statearr_28529[(9)] = inst_28325);

(statearr_28529[(10)] = inst_28324);

return statearr_28529;
})();
var statearr_28530_28596 = state_28463__$1;
(statearr_28530_28596[(2)] = null);

(statearr_28530_28596[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (45))){
var state_28463__$1 = state_28463;
var statearr_28531_28597 = state_28463__$1;
(statearr_28531_28597[(2)] = null);

(statearr_28531_28597[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (26))){
var inst_28384 = (state_28463[(23)]);
var inst_28380 = (state_28463[(24)]);
var inst_28382 = (state_28463[(26)]);
var inst_28379 = (state_28463[(25)]);
var inst_28376 = (state_28463[(19)]);
var inst_28399 = figwheel.client.utils.log.call(null,cljs.core.cst$kw$debug,"Figwheel: loaded these files");
var inst_28401 = (function (){var all_files = inst_28376;
var res_SINGLEQUOTE_ = inst_28379;
var res = inst_28380;
var files_not_loaded = inst_28382;
var dependencies_that_loaded = inst_28384;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28384,inst_28380,inst_28382,inst_28379,inst_28376,inst_28399,state_val_28464,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__28400){
var map__28532 = p__28400;
var map__28532__$1 = ((((!((map__28532 == null)))?(((((map__28532.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28532.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28532):map__28532);
var namespace = cljs.core.get.call(null,map__28532__$1,cljs.core.cst$kw$namespace);
var file = cljs.core.get.call(null,map__28532__$1,cljs.core.cst$kw$file);
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28384,inst_28380,inst_28382,inst_28379,inst_28376,inst_28399,state_val_28464,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28402 = cljs.core.map.call(null,inst_28401,inst_28380);
var inst_28403 = cljs.core.pr_str.call(null,inst_28402);
var inst_28404 = figwheel.client.utils.log.call(null,inst_28403);
var inst_28405 = (function (){var all_files = inst_28376;
var res_SINGLEQUOTE_ = inst_28379;
var res = inst_28380;
var files_not_loaded = inst_28382;
var dependencies_that_loaded = inst_28384;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28384,inst_28380,inst_28382,inst_28379,inst_28376,inst_28399,inst_28401,inst_28402,inst_28403,inst_28404,state_val_28464,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_28384,inst_28380,inst_28382,inst_28379,inst_28376,inst_28399,inst_28401,inst_28402,inst_28403,inst_28404,state_val_28464,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_28406 = setTimeout(inst_28405,(10));
var state_28463__$1 = (function (){var statearr_28534 = state_28463;
(statearr_28534[(33)] = inst_28399);

(statearr_28534[(34)] = inst_28404);

return statearr_28534;
})();
var statearr_28535_28598 = state_28463__$1;
(statearr_28535_28598[(2)] = inst_28406);

(statearr_28535_28598[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (16))){
var state_28463__$1 = state_28463;
var statearr_28536_28599 = state_28463__$1;
(statearr_28536_28599[(2)] = reload_dependents);

(statearr_28536_28599[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (38))){
var inst_28416 = (state_28463[(16)]);
var inst_28434 = cljs.core.apply.call(null,cljs.core.hash_map,inst_28416);
var state_28463__$1 = state_28463;
var statearr_28537_28600 = state_28463__$1;
(statearr_28537_28600[(2)] = inst_28434);

(statearr_28537_28600[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (30))){
var state_28463__$1 = state_28463;
var statearr_28538_28601 = state_28463__$1;
(statearr_28538_28601[(2)] = null);

(statearr_28538_28601[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (10))){
var inst_28336 = (state_28463[(22)]);
var inst_28338 = cljs.core.chunked_seq_QMARK_.call(null,inst_28336);
var state_28463__$1 = state_28463;
if(inst_28338){
var statearr_28539_28602 = state_28463__$1;
(statearr_28539_28602[(1)] = (13));

} else {
var statearr_28540_28603 = state_28463__$1;
(statearr_28540_28603[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (18))){
var inst_28370 = (state_28463[(2)]);
var state_28463__$1 = state_28463;
if(cljs.core.truth_(inst_28370)){
var statearr_28541_28604 = state_28463__$1;
(statearr_28541_28604[(1)] = (19));

} else {
var statearr_28542_28605 = state_28463__$1;
(statearr_28542_28605[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (42))){
var state_28463__$1 = state_28463;
var statearr_28543_28606 = state_28463__$1;
(statearr_28543_28606[(2)] = null);

(statearr_28543_28606[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (37))){
var inst_28429 = (state_28463[(2)]);
var state_28463__$1 = state_28463;
var statearr_28544_28607 = state_28463__$1;
(statearr_28544_28607[(2)] = inst_28429);

(statearr_28544_28607[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28464 === (8))){
var inst_28323 = (state_28463[(7)]);
var inst_28336 = (state_28463[(22)]);
var inst_28336__$1 = cljs.core.seq.call(null,inst_28323);
var state_28463__$1 = (function (){var statearr_28545 = state_28463;
(statearr_28545[(22)] = inst_28336__$1);

return statearr_28545;
})();
if(inst_28336__$1){
var statearr_28546_28608 = state_28463__$1;
(statearr_28546_28608[(1)] = (10));

} else {
var statearr_28547_28609 = state_28463__$1;
(statearr_28547_28609[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__25763__auto__,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__25764__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__25764__auto____0 = (function (){
var statearr_28548 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28548[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__25764__auto__);

(statearr_28548[(1)] = (1));

return statearr_28548;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__25764__auto____1 = (function (state_28463){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_28463);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e28549){if((e28549 instanceof Object)){
var ex__25767__auto__ = e28549;
var statearr_28550_28610 = state_28463;
(statearr_28550_28610[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28463);

return cljs.core.cst$kw$recur;
} else {
throw e28549;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__28611 = state_28463;
state_28463 = G__28611;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__25764__auto__ = function(state_28463){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__25764__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__25764__auto____1.call(this,state_28463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__25764__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__25764__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__25856__auto__ = (function (){var statearr_28551 = f__25855__auto__.call(null);
(statearr_28551[(6)] = c__25854__auto__);

return statearr_28551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto__,map__28308,map__28308__$1,opts,before_jsload,on_jsload,reload_dependents,map__28309,map__28309__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__25854__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__28614,link){
var map__28615 = p__28614;
var map__28615__$1 = ((((!((map__28615 == null)))?(((((map__28615.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28615.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28615):map__28615);
var file = cljs.core.get.call(null,map__28615__$1,cljs.core.cst$kw$file);
var temp__5457__auto__ = link.href;
if(cljs.core.truth_(temp__5457__auto__)){
var link_href = temp__5457__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__5457__auto__,map__28615,map__28615__$1,file){
return (function (p1__28612_SHARP_,p2__28613_SHARP_){
if(cljs.core._EQ_.call(null,p1__28612_SHARP_,p2__28613_SHARP_)){
return p1__28612_SHARP_;
} else {
return false;
}
});})(link_href,temp__5457__auto__,map__28615,map__28615__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$link,link,cljs.core.cst$kw$link_DASH_href,link_href,cljs.core.cst$kw$match_DASH_length,match_length,cljs.core.cst$kw$current_DASH_url_DASH_length,cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__5457__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__28618){
var map__28619 = p__28618;
var map__28619__$1 = ((((!((map__28619 == null)))?(((((map__28619.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28619.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28619):map__28619);
var match_length = cljs.core.get.call(null,map__28619__$1,cljs.core.cst$kw$match_DASH_length);
var current_url_length = cljs.core.get.call(null,map__28619__$1,cljs.core.cst$kw$current_DASH_url_DASH_length);
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__28617_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__28617_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__5457__auto__)){
var res = temp__5457__auto__;
return cljs.core.cst$kw$link.cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__28621_SHARP_,p2__28622_SHARP_){
return cljs.core.assoc.call(null,p1__28621_SHARP_,cljs.core.get.call(null,p2__28622_SHARP_,key),p2__28622_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__5455__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__5455__auto__)){
var link = temp__5455__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__5455__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,cljs.core.cst$kw$loaded,true));
});})(link,temp__5455__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_28623 = cljs.core.filter.call(null,cljs.core.cst$kw$loaded,f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_28623);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_28623);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__28624,p__28625){
var map__28626 = p__28624;
var map__28626__$1 = ((((!((map__28626 == null)))?(((((map__28626.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28626.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28626):map__28626);
var on_cssload = cljs.core.get.call(null,map__28626__$1,cljs.core.cst$kw$on_DASH_cssload);
var map__28627 = p__28625;
var map__28627__$1 = ((((!((map__28627 == null)))?(((((map__28627.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28627.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28627):map__28627);
var files_msg = map__28627__$1;
var files = cljs.core.get.call(null,map__28627__$1,cljs.core.cst$kw$files);
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__5457__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,cljs.core.cst$kw$file,files));
if(cljs.core.truth_(temp__5457__auto__)){
var f_datas = temp__5457__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1535482702664
