// Compiled by ClojureScript 1.10.339 {:optimize-constants true}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.16";
figwheel.client.js_stringify = (((((typeof JSON !== 'undefined')) && (!((JSON.stringify == null)))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e29716){if((e29716 instanceof Error)){
var e = e29716;
return "Error: Unable to stringify";
} else {
throw e29716;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__29719 = arguments.length;
switch (G__29719) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$figwheel_DASH_event,"callback",cljs.core.cst$kw$callback_DASH_name,"figwheel-repl-print",cljs.core.cst$kw$content,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$stream,stream,cljs.core.cst$kw$args,cljs.core.mapv.call(null,(function (p1__29717_SHARP_){
if(typeof p1__29717_SHARP_ === 'string'){
return p1__29717_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__29717_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,cljs.core.cst$kw$out,args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__4534__auto__ = [];
var len__4531__auto___29722 = arguments.length;
var i__4532__auto___29723 = (0);
while(true){
if((i__4532__auto___29723 < len__4531__auto___29722)){
args__4534__auto__.push((arguments[i__4532__auto___29723]));

var G__29724 = (i__4532__auto___29723 + (1));
i__4532__auto___29723 = G__29724;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,cljs.core.cst$kw$out,args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq29721){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29721));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__4534__auto__ = [];
var len__4531__auto___29726 = arguments.length;
var i__4532__auto___29727 = (0);
while(true){
if((i__4532__auto___29727 < len__4531__auto___29726)){
args__4534__auto__.push((arguments[i__4532__auto___29727]));

var G__29728 = (i__4532__auto___29727 + (1));
i__4532__auto___29727 = G__29728;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,cljs.core.cst$kw$err,args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq29725){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq29725));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,cljs.core.cst$kw$figwheel_DASH_autoload,true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,cljs.core.cst$kw$figwheel_DASH_autoload,cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,cljs.core.cst$kw$info,["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,cljs.core.cst$kw$info,["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,cljs.core.cst$kw$figwheel_DASH_autoload,b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,cljs.core.cst$kw$figwheel_DASH_repl_DASH_pprint,true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,cljs.core.cst$kw$figwheel_DASH_repl_DASH_pprint,b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$message,cljs.core.cst$kw$class], null)),figwheel.client.get_essential_messages.call(null,cljs.core.cst$kw$cause.cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__29729){
var map__29730 = p__29729;
var map__29730__$1 = ((((!((map__29730 == null)))?(((((map__29730.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29730.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29730):map__29730);
var message = cljs.core.get.call(null,map__29730__$1,cljs.core.cst$kw$message);
var class$ = cljs.core.get.call(null,map__29730__$1,cljs.core.cst$kw$class);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,cljs.core.cst$kw$msg_DASH_name),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__3949__auto__ = cljs.core.cst$kw$load_DASH_warninged_DASH_code.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,cljs.core.cst$kw$compile_DASH_warning);
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__3938__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),cljs.core.cst$kw$files_DASH_changed);
if(and__3938__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__3938__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return ((cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),cljs.core.cst$kw$files_DASH_changed)) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts))));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$compile_DASH_warning,cljs.core.cst$kw$compile_DASH_warning], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,cljs.core.cst$kw$compile_DASH_warning,cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$compile_DASH_warning,cljs.core.cst$kw$files_DASH_changed,cljs.core.cst$kw$compile_DASH_warning], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,cljs.core.cst$kw$compile_DASH_failed,cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$compile_DASH_failed,cljs.core.cst$kw$compile_DASH_failed], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,cljs.core.cst$kw$css_DASH_files_DASH_changed,cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__25854__auto___29809 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___29809,ch){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___29809,ch){
return (function (state_29781){
var state_val_29782 = (state_29781[(1)]);
if((state_val_29782 === (7))){
var inst_29777 = (state_29781[(2)]);
var state_29781__$1 = state_29781;
var statearr_29783_29810 = state_29781__$1;
(statearr_29783_29810[(2)] = inst_29777);

(statearr_29783_29810[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29782 === (1))){
var state_29781__$1 = state_29781;
var statearr_29784_29811 = state_29781__$1;
(statearr_29784_29811[(2)] = null);

(statearr_29784_29811[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29782 === (4))){
var inst_29734 = (state_29781[(7)]);
var inst_29734__$1 = (state_29781[(2)]);
var state_29781__$1 = (function (){var statearr_29785 = state_29781;
(statearr_29785[(7)] = inst_29734__$1);

return statearr_29785;
})();
if(cljs.core.truth_(inst_29734__$1)){
var statearr_29786_29812 = state_29781__$1;
(statearr_29786_29812[(1)] = (5));

} else {
var statearr_29787_29813 = state_29781__$1;
(statearr_29787_29813[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29782 === (15))){
var inst_29741 = (state_29781[(8)]);
var inst_29756 = cljs.core.cst$kw$files.cljs$core$IFn$_invoke$arity$1(inst_29741);
var inst_29757 = cljs.core.first.call(null,inst_29756);
var inst_29758 = cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(inst_29757);
var inst_29759 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29758)].join('');
var inst_29760 = figwheel.client.utils.log.call(null,cljs.core.cst$kw$warn,inst_29759);
var state_29781__$1 = state_29781;
var statearr_29788_29814 = state_29781__$1;
(statearr_29788_29814[(2)] = inst_29760);

(statearr_29788_29814[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29782 === (13))){
var inst_29765 = (state_29781[(2)]);
var state_29781__$1 = state_29781;
var statearr_29789_29815 = state_29781__$1;
(statearr_29789_29815[(2)] = inst_29765);

(statearr_29789_29815[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29782 === (6))){
var state_29781__$1 = state_29781;
var statearr_29790_29816 = state_29781__$1;
(statearr_29790_29816[(2)] = null);

(statearr_29790_29816[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29782 === (17))){
var inst_29763 = (state_29781[(2)]);
var state_29781__$1 = state_29781;
var statearr_29791_29817 = state_29781__$1;
(statearr_29791_29817[(2)] = inst_29763);

(statearr_29791_29817[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29782 === (3))){
var inst_29779 = (state_29781[(2)]);
var state_29781__$1 = state_29781;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29781__$1,inst_29779);
} else {
if((state_val_29782 === (12))){
var inst_29740 = (state_29781[(9)]);
var inst_29754 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_29740,opts);
var state_29781__$1 = state_29781;
if(cljs.core.truth_(inst_29754)){
var statearr_29792_29818 = state_29781__$1;
(statearr_29792_29818[(1)] = (15));

} else {
var statearr_29793_29819 = state_29781__$1;
(statearr_29793_29819[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29782 === (2))){
var state_29781__$1 = state_29781;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29781__$1,(4),ch);
} else {
if((state_val_29782 === (11))){
var inst_29741 = (state_29781[(8)]);
var inst_29746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29747 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_29741);
var inst_29748 = cljs.core.async.timeout.call(null,(1000));
var inst_29749 = [inst_29747,inst_29748];
var inst_29750 = (new cljs.core.PersistentVector(null,2,(5),inst_29746,inst_29749,null));
var state_29781__$1 = state_29781;
return cljs.core.async.ioc_alts_BANG_.call(null,state_29781__$1,(14),inst_29750);
} else {
if((state_val_29782 === (9))){
var inst_29741 = (state_29781[(8)]);
var inst_29767 = figwheel.client.utils.log.call(null,cljs.core.cst$kw$warn,"Figwheel: code autoloading is OFF");
var inst_29768 = cljs.core.cst$kw$files.cljs$core$IFn$_invoke$arity$1(inst_29741);
var inst_29769 = cljs.core.map.call(null,cljs.core.cst$kw$file,inst_29768);
var inst_29770 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29769)].join('');
var inst_29771 = figwheel.client.utils.log.call(null,cljs.core.cst$kw$info,inst_29770);
var state_29781__$1 = (function (){var statearr_29794 = state_29781;
(statearr_29794[(10)] = inst_29767);

return statearr_29794;
})();
var statearr_29795_29820 = state_29781__$1;
(statearr_29795_29820[(2)] = inst_29771);

(statearr_29795_29820[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29782 === (5))){
var inst_29734 = (state_29781[(7)]);
var inst_29736 = [cljs.core.cst$kw$compile_DASH_warning,null,cljs.core.cst$kw$files_DASH_changed,null];
var inst_29737 = (new cljs.core.PersistentArrayMap(null,2,inst_29736,null));
var inst_29738 = (new cljs.core.PersistentHashSet(null,inst_29737,null));
var inst_29739 = figwheel.client.focus_msgs.call(null,inst_29738,inst_29734);
var inst_29740 = cljs.core.map.call(null,cljs.core.cst$kw$msg_DASH_name,inst_29739);
var inst_29741 = cljs.core.first.call(null,inst_29739);
var inst_29742 = figwheel.client.autoload_QMARK_.call(null);
var state_29781__$1 = (function (){var statearr_29796 = state_29781;
(statearr_29796[(8)] = inst_29741);

(statearr_29796[(9)] = inst_29740);

return statearr_29796;
})();
if(cljs.core.truth_(inst_29742)){
var statearr_29797_29821 = state_29781__$1;
(statearr_29797_29821[(1)] = (8));

} else {
var statearr_29798_29822 = state_29781__$1;
(statearr_29798_29822[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29782 === (14))){
var inst_29752 = (state_29781[(2)]);
var state_29781__$1 = state_29781;
var statearr_29799_29823 = state_29781__$1;
(statearr_29799_29823[(2)] = inst_29752);

(statearr_29799_29823[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29782 === (16))){
var state_29781__$1 = state_29781;
var statearr_29800_29824 = state_29781__$1;
(statearr_29800_29824[(2)] = null);

(statearr_29800_29824[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29782 === (10))){
var inst_29773 = (state_29781[(2)]);
var state_29781__$1 = (function (){var statearr_29801 = state_29781;
(statearr_29801[(11)] = inst_29773);

return statearr_29801;
})();
var statearr_29802_29825 = state_29781__$1;
(statearr_29802_29825[(2)] = null);

(statearr_29802_29825[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29782 === (8))){
var inst_29740 = (state_29781[(9)]);
var inst_29744 = figwheel.client.reload_file_state_QMARK_.call(null,inst_29740,opts);
var state_29781__$1 = state_29781;
if(cljs.core.truth_(inst_29744)){
var statearr_29803_29826 = state_29781__$1;
(statearr_29803_29826[(1)] = (11));

} else {
var statearr_29804_29827 = state_29781__$1;
(statearr_29804_29827[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto___29809,ch))
;
return ((function (switch__25763__auto__,c__25854__auto___29809,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__25764__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__25764__auto____0 = (function (){
var statearr_29805 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29805[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__25764__auto__);

(statearr_29805[(1)] = (1));

return statearr_29805;
});
var figwheel$client$file_reloader_plugin_$_state_machine__25764__auto____1 = (function (state_29781){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_29781);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e29806){if((e29806 instanceof Object)){
var ex__25767__auto__ = e29806;
var statearr_29807_29828 = state_29781;
(statearr_29807_29828[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29781);

return cljs.core.cst$kw$recur;
} else {
throw e29806;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__29829 = state_29781;
state_29781 = G__29829;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__25764__auto__ = function(state_29781){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__25764__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__25764__auto____1.call(this,state_29781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__25764__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__25764__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___29809,ch))
})();
var state__25856__auto__ = (function (){var statearr_29808 = f__25855__auto__.call(null);
(statearr_29808[(6)] = c__25854__auto___29809);

return statearr_29808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___29809,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__29830_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__29830_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return cljs.core.cst$kw$chrome;
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return cljs.core.cst$kw$safari;
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return cljs.core.cst$kw$chrome;
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return cljs.core.cst$kw$firefox;
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return cljs.core.cst$kw$ie;
} else {
return null;
}
}
}
}
}
});
var base_path_29834 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_29834){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var sb = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_29832 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_29833 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_29832,_STAR_print_fn_STAR_29833,sb,base_path_29834){
return (function (x){
return sb.append(x);
});})(_STAR_print_newline_STAR_29832,_STAR_print_fn_STAR_29833,sb,base_path_29834))
;

try{var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$status,cljs.core.cst$kw$success,cljs.core.cst$kw$out,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb)].join(''),cljs.core.cst$kw$ua_DASH_product,figwheel.client.get_ua_product.call(null),cljs.core.cst$kw$value,result_value], null));
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_29833;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_29832;
}}catch (e29831){if((e29831 instanceof Error)){
var e = e29831;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$status,cljs.core.cst$kw$exception,cljs.core.cst$kw$value,cljs.core.pr_str.call(null,e),cljs.core.cst$kw$ua_DASH_product,figwheel.client.get_ua_product.call(null),cljs.core.cst$kw$stacktrace,clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),cljs.core.cst$kw$base_DASH_path,base_path_29834], null));
} else {
var e = e29831;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$status,cljs.core.cst$kw$exception,cljs.core.cst$kw$ua_DASH_product,figwheel.client.get_ua_product.call(null),cljs.core.cst$kw$value,cljs.core.pr_str.call(null,e),cljs.core.cst$kw$stacktrace,"No stacktrace available."], null));

}
}});})(base_path_29834))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__29835){
var map__29836 = p__29835;
var map__29836__$1 = ((((!((map__29836 == null)))?(((((map__29836.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29836.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29836):map__29836);
var opts = map__29836__$1;
var build_id = cljs.core.get.call(null,map__29836__$1,cljs.core.cst$kw$build_DASH_id);
return ((function (map__29836,map__29836__$1,opts,build_id){
return (function (p__29838){
var vec__29839 = p__29838;
var seq__29840 = cljs.core.seq.call(null,vec__29839);
var first__29841 = cljs.core.first.call(null,seq__29840);
var seq__29840__$1 = cljs.core.next.call(null,seq__29840);
var map__29842 = first__29841;
var map__29842__$1 = ((((!((map__29842 == null)))?(((((map__29842.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29842.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29842):map__29842);
var msg = map__29842__$1;
var msg_name = cljs.core.get.call(null,map__29842__$1,cljs.core.cst$kw$msg_DASH_name);
var _ = seq__29840__$1;
if(cljs.core._EQ_.call(null,cljs.core.cst$kw$repl_DASH_eval,msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__29839,seq__29840,first__29841,seq__29840__$1,map__29842,map__29842__$1,msg,msg_name,_,map__29836,map__29836__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$figwheel_DASH_event,"callback",cljs.core.cst$kw$callback_DASH_name,cljs.core.cst$kw$callback_DASH_name.cljs$core$IFn$_invoke$arity$1(msg),cljs.core.cst$kw$content,res], null));
});})(vec__29839,seq__29840,first__29841,seq__29840__$1,map__29842,map__29842__$1,msg,msg_name,_,map__29836,map__29836__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__29836,map__29836__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__29844){
var vec__29845 = p__29844;
var seq__29846 = cljs.core.seq.call(null,vec__29845);
var first__29847 = cljs.core.first.call(null,seq__29846);
var seq__29846__$1 = cljs.core.next.call(null,seq__29846);
var map__29848 = first__29847;
var map__29848__$1 = ((((!((map__29848 == null)))?(((((map__29848.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29848.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29848):map__29848);
var msg = map__29848__$1;
var msg_name = cljs.core.get.call(null,map__29848__$1,cljs.core.cst$kw$msg_DASH_name);
var _ = seq__29846__$1;
if(cljs.core._EQ_.call(null,msg_name,cljs.core.cst$kw$css_DASH_files_DASH_changed)){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__29850){
var map__29851 = p__29850;
var map__29851__$1 = ((((!((map__29851 == null)))?(((((map__29851.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29851.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29851):map__29851);
var on_compile_warning = cljs.core.get.call(null,map__29851__$1,cljs.core.cst$kw$on_DASH_compile_DASH_warning);
var on_compile_fail = cljs.core.get.call(null,map__29851__$1,cljs.core.cst$kw$on_DASH_compile_DASH_fail);
return ((function (map__29851,map__29851__$1,on_compile_warning,on_compile_fail){
return (function (p__29853){
var vec__29854 = p__29853;
var seq__29855 = cljs.core.seq.call(null,vec__29854);
var first__29856 = cljs.core.first.call(null,seq__29855);
var seq__29855__$1 = cljs.core.next.call(null,seq__29855);
var map__29857 = first__29856;
var map__29857__$1 = ((((!((map__29857 == null)))?(((((map__29857.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29857.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29857):map__29857);
var msg = map__29857__$1;
var msg_name = cljs.core.get.call(null,map__29857__$1,cljs.core.cst$kw$msg_DASH_name);
var _ = seq__29855__$1;
var pred__29859 = cljs.core._EQ_;
var expr__29860 = msg_name;
if(cljs.core.truth_(pred__29859.call(null,cljs.core.cst$kw$compile_DASH_warning,expr__29860))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__29859.call(null,cljs.core.cst$kw$compile_DASH_failed,expr__29860))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__29851,map__29851__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(cljs.core.cst$kw$auto_DASH_jump_DASH_to_DASH_source_DASH_on_DASH_error.cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$compile_DASH_failed,null,cljs.core.cst$kw$compile_DASH_warning,null,cljs.core.cst$kw$files_DASH_changed,null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,cljs.core.cst$kw$msg_DASH_name,msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__25854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto__,msg_hist,msg_names,msg){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto__,msg_hist,msg_names,msg){
return (function (state_29949){
var state_val_29950 = (state_29949[(1)]);
if((state_val_29950 === (7))){
var inst_29869 = (state_29949[(2)]);
var state_29949__$1 = state_29949;
if(cljs.core.truth_(inst_29869)){
var statearr_29951_29998 = state_29949__$1;
(statearr_29951_29998[(1)] = (8));

} else {
var statearr_29952_29999 = state_29949__$1;
(statearr_29952_29999[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (20))){
var inst_29943 = (state_29949[(2)]);
var state_29949__$1 = state_29949;
var statearr_29953_30000 = state_29949__$1;
(statearr_29953_30000[(2)] = inst_29943);

(statearr_29953_30000[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (27))){
var inst_29939 = (state_29949[(2)]);
var state_29949__$1 = state_29949;
var statearr_29954_30001 = state_29949__$1;
(statearr_29954_30001[(2)] = inst_29939);

(statearr_29954_30001[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (1))){
var inst_29862 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_29949__$1 = state_29949;
if(cljs.core.truth_(inst_29862)){
var statearr_29955_30002 = state_29949__$1;
(statearr_29955_30002[(1)] = (2));

} else {
var statearr_29956_30003 = state_29949__$1;
(statearr_29956_30003[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (24))){
var inst_29941 = (state_29949[(2)]);
var state_29949__$1 = state_29949;
var statearr_29957_30004 = state_29949__$1;
(statearr_29957_30004[(2)] = inst_29941);

(statearr_29957_30004[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (4))){
var inst_29947 = (state_29949[(2)]);
var state_29949__$1 = state_29949;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29949__$1,inst_29947);
} else {
if((state_val_29950 === (15))){
var inst_29945 = (state_29949[(2)]);
var state_29949__$1 = state_29949;
var statearr_29958_30005 = state_29949__$1;
(statearr_29958_30005[(2)] = inst_29945);

(statearr_29958_30005[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (21))){
var inst_29898 = (state_29949[(2)]);
var inst_29899 = cljs.core.cst$kw$exception_DASH_data.cljs$core$IFn$_invoke$arity$1(msg);
var inst_29900 = figwheel.client.auto_jump_to_error.call(null,opts,inst_29899);
var state_29949__$1 = (function (){var statearr_29959 = state_29949;
(statearr_29959[(7)] = inst_29898);

return statearr_29959;
})();
var statearr_29960_30006 = state_29949__$1;
(statearr_29960_30006[(2)] = inst_29900);

(statearr_29960_30006[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (31))){
var inst_29928 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_29949__$1 = state_29949;
if(cljs.core.truth_(inst_29928)){
var statearr_29961_30007 = state_29949__$1;
(statearr_29961_30007[(1)] = (34));

} else {
var statearr_29962_30008 = state_29949__$1;
(statearr_29962_30008[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (32))){
var inst_29937 = (state_29949[(2)]);
var state_29949__$1 = state_29949;
var statearr_29963_30009 = state_29949__$1;
(statearr_29963_30009[(2)] = inst_29937);

(statearr_29963_30009[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (33))){
var inst_29924 = (state_29949[(2)]);
var inst_29925 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(msg);
var inst_29926 = figwheel.client.auto_jump_to_error.call(null,opts,inst_29925);
var state_29949__$1 = (function (){var statearr_29964 = state_29949;
(statearr_29964[(8)] = inst_29924);

return statearr_29964;
})();
var statearr_29965_30010 = state_29949__$1;
(statearr_29965_30010[(2)] = inst_29926);

(statearr_29965_30010[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (13))){
var inst_29883 = figwheel.client.heads_up.clear.call(null);
var state_29949__$1 = state_29949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29949__$1,(16),inst_29883);
} else {
if((state_val_29950 === (22))){
var inst_29904 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(msg);
var inst_29905 = figwheel.client.heads_up.append_warning_message.call(null,inst_29904);
var state_29949__$1 = state_29949;
var statearr_29966_30011 = state_29949__$1;
(statearr_29966_30011[(2)] = inst_29905);

(statearr_29966_30011[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (36))){
var inst_29935 = (state_29949[(2)]);
var state_29949__$1 = state_29949;
var statearr_29967_30012 = state_29949__$1;
(statearr_29967_30012[(2)] = inst_29935);

(statearr_29967_30012[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (29))){
var inst_29915 = (state_29949[(2)]);
var inst_29916 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(msg);
var inst_29917 = figwheel.client.auto_jump_to_error.call(null,opts,inst_29916);
var state_29949__$1 = (function (){var statearr_29968 = state_29949;
(statearr_29968[(9)] = inst_29915);

return statearr_29968;
})();
var statearr_29969_30013 = state_29949__$1;
(statearr_29969_30013[(2)] = inst_29917);

(statearr_29969_30013[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (6))){
var inst_29864 = (state_29949[(10)]);
var state_29949__$1 = state_29949;
var statearr_29970_30014 = state_29949__$1;
(statearr_29970_30014[(2)] = inst_29864);

(statearr_29970_30014[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (28))){
var inst_29911 = (state_29949[(2)]);
var inst_29912 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(msg);
var inst_29913 = figwheel.client.heads_up.display_warning.call(null,inst_29912);
var state_29949__$1 = (function (){var statearr_29971 = state_29949;
(statearr_29971[(11)] = inst_29911);

return statearr_29971;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29949__$1,(29),inst_29913);
} else {
if((state_val_29950 === (25))){
var inst_29909 = figwheel.client.heads_up.clear.call(null);
var state_29949__$1 = state_29949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29949__$1,(28),inst_29909);
} else {
if((state_val_29950 === (34))){
var inst_29930 = figwheel.client.heads_up.flash_loaded.call(null);
var state_29949__$1 = state_29949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29949__$1,(37),inst_29930);
} else {
if((state_val_29950 === (17))){
var inst_29889 = (state_29949[(2)]);
var inst_29890 = cljs.core.cst$kw$exception_DASH_data.cljs$core$IFn$_invoke$arity$1(msg);
var inst_29891 = figwheel.client.auto_jump_to_error.call(null,opts,inst_29890);
var state_29949__$1 = (function (){var statearr_29972 = state_29949;
(statearr_29972[(12)] = inst_29889);

return statearr_29972;
})();
var statearr_29973_30015 = state_29949__$1;
(statearr_29973_30015[(2)] = inst_29891);

(statearr_29973_30015[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (3))){
var inst_29881 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_29949__$1 = state_29949;
if(cljs.core.truth_(inst_29881)){
var statearr_29974_30016 = state_29949__$1;
(statearr_29974_30016[(1)] = (13));

} else {
var statearr_29975_30017 = state_29949__$1;
(statearr_29975_30017[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (12))){
var inst_29877 = (state_29949[(2)]);
var state_29949__$1 = state_29949;
var statearr_29976_30018 = state_29949__$1;
(statearr_29976_30018[(2)] = inst_29877);

(statearr_29976_30018[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (2))){
var inst_29864 = (state_29949[(10)]);
var inst_29864__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_29949__$1 = (function (){var statearr_29977 = state_29949;
(statearr_29977[(10)] = inst_29864__$1);

return statearr_29977;
})();
if(cljs.core.truth_(inst_29864__$1)){
var statearr_29978_30019 = state_29949__$1;
(statearr_29978_30019[(1)] = (5));

} else {
var statearr_29979_30020 = state_29949__$1;
(statearr_29979_30020[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (23))){
var inst_29907 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_29949__$1 = state_29949;
if(cljs.core.truth_(inst_29907)){
var statearr_29980_30021 = state_29949__$1;
(statearr_29980_30021[(1)] = (25));

} else {
var statearr_29981_30022 = state_29949__$1;
(statearr_29981_30022[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (35))){
var state_29949__$1 = state_29949;
var statearr_29982_30023 = state_29949__$1;
(statearr_29982_30023[(2)] = null);

(statearr_29982_30023[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (19))){
var inst_29902 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_29949__$1 = state_29949;
if(cljs.core.truth_(inst_29902)){
var statearr_29983_30024 = state_29949__$1;
(statearr_29983_30024[(1)] = (22));

} else {
var statearr_29984_30025 = state_29949__$1;
(statearr_29984_30025[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (11))){
var inst_29873 = (state_29949[(2)]);
var state_29949__$1 = state_29949;
var statearr_29985_30026 = state_29949__$1;
(statearr_29985_30026[(2)] = inst_29873);

(statearr_29985_30026[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (9))){
var inst_29875 = figwheel.client.heads_up.clear.call(null);
var state_29949__$1 = state_29949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29949__$1,(12),inst_29875);
} else {
if((state_val_29950 === (5))){
var inst_29866 = cljs.core.cst$kw$autoload.cljs$core$IFn$_invoke$arity$1(opts);
var state_29949__$1 = state_29949;
var statearr_29986_30027 = state_29949__$1;
(statearr_29986_30027[(2)] = inst_29866);

(statearr_29986_30027[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (14))){
var inst_29893 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_29949__$1 = state_29949;
if(cljs.core.truth_(inst_29893)){
var statearr_29987_30028 = state_29949__$1;
(statearr_29987_30028[(1)] = (18));

} else {
var statearr_29988_30029 = state_29949__$1;
(statearr_29988_30029[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (26))){
var inst_29919 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_29949__$1 = state_29949;
if(cljs.core.truth_(inst_29919)){
var statearr_29989_30030 = state_29949__$1;
(statearr_29989_30030[(1)] = (30));

} else {
var statearr_29990_30031 = state_29949__$1;
(statearr_29990_30031[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (16))){
var inst_29885 = (state_29949[(2)]);
var inst_29886 = cljs.core.cst$kw$exception_DASH_data.cljs$core$IFn$_invoke$arity$1(msg);
var inst_29887 = figwheel.client.heads_up.display_exception.call(null,inst_29886);
var state_29949__$1 = (function (){var statearr_29991 = state_29949;
(statearr_29991[(13)] = inst_29885);

return statearr_29991;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29949__$1,(17),inst_29887);
} else {
if((state_val_29950 === (30))){
var inst_29921 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(msg);
var inst_29922 = figwheel.client.heads_up.display_warning.call(null,inst_29921);
var state_29949__$1 = state_29949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29949__$1,(33),inst_29922);
} else {
if((state_val_29950 === (10))){
var inst_29879 = (state_29949[(2)]);
var state_29949__$1 = state_29949;
var statearr_29992_30032 = state_29949__$1;
(statearr_29992_30032[(2)] = inst_29879);

(statearr_29992_30032[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (18))){
var inst_29895 = cljs.core.cst$kw$exception_DASH_data.cljs$core$IFn$_invoke$arity$1(msg);
var inst_29896 = figwheel.client.heads_up.display_exception.call(null,inst_29895);
var state_29949__$1 = state_29949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29949__$1,(21),inst_29896);
} else {
if((state_val_29950 === (37))){
var inst_29932 = (state_29949[(2)]);
var state_29949__$1 = state_29949;
var statearr_29993_30033 = state_29949__$1;
(statearr_29993_30033[(2)] = inst_29932);

(statearr_29993_30033[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29950 === (8))){
var inst_29871 = figwheel.client.heads_up.flash_loaded.call(null);
var state_29949__$1 = state_29949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29949__$1,(11),inst_29871);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__25763__auto__,c__25854__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25764__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25764__auto____0 = (function (){
var statearr_29994 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29994[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25764__auto__);

(statearr_29994[(1)] = (1));

return statearr_29994;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25764__auto____1 = (function (state_29949){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_29949);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e29995){if((e29995 instanceof Object)){
var ex__25767__auto__ = e29995;
var statearr_29996_30034 = state_29949;
(statearr_29996_30034[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29949);

return cljs.core.cst$kw$recur;
} else {
throw e29995;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__30035 = state_29949;
state_29949 = G__30035;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25764__auto__ = function(state_29949){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25764__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25764__auto____1.call(this,state_29949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25764__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25764__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto__,msg_hist,msg_names,msg))
})();
var state__25856__auto__ = (function (){var statearr_29997 = f__25855__auto__.call(null);
(statearr_29997[(6)] = c__25854__auto__);

return statearr_29997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto__,msg_hist,msg_names,msg))
);

return c__25854__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__25854__auto___30064 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___30064,ch){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___30064,ch){
return (function (state_30050){
var state_val_30051 = (state_30050[(1)]);
if((state_val_30051 === (1))){
var state_30050__$1 = state_30050;
var statearr_30052_30065 = state_30050__$1;
(statearr_30052_30065[(2)] = null);

(statearr_30052_30065[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30051 === (2))){
var state_30050__$1 = state_30050;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30050__$1,(4),ch);
} else {
if((state_val_30051 === (3))){
var inst_30048 = (state_30050[(2)]);
var state_30050__$1 = state_30050;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30050__$1,inst_30048);
} else {
if((state_val_30051 === (4))){
var inst_30038 = (state_30050[(7)]);
var inst_30038__$1 = (state_30050[(2)]);
var state_30050__$1 = (function (){var statearr_30053 = state_30050;
(statearr_30053[(7)] = inst_30038__$1);

return statearr_30053;
})();
if(cljs.core.truth_(inst_30038__$1)){
var statearr_30054_30066 = state_30050__$1;
(statearr_30054_30066[(1)] = (5));

} else {
var statearr_30055_30067 = state_30050__$1;
(statearr_30055_30067[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30051 === (5))){
var inst_30038 = (state_30050[(7)]);
var inst_30040 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_30038);
var state_30050__$1 = state_30050;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30050__$1,(8),inst_30040);
} else {
if((state_val_30051 === (6))){
var state_30050__$1 = state_30050;
var statearr_30056_30068 = state_30050__$1;
(statearr_30056_30068[(2)] = null);

(statearr_30056_30068[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30051 === (7))){
var inst_30046 = (state_30050[(2)]);
var state_30050__$1 = state_30050;
var statearr_30057_30069 = state_30050__$1;
(statearr_30057_30069[(2)] = inst_30046);

(statearr_30057_30069[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30051 === (8))){
var inst_30042 = (state_30050[(2)]);
var state_30050__$1 = (function (){var statearr_30058 = state_30050;
(statearr_30058[(8)] = inst_30042);

return statearr_30058;
})();
var statearr_30059_30070 = state_30050__$1;
(statearr_30059_30070[(2)] = null);

(statearr_30059_30070[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__25854__auto___30064,ch))
;
return ((function (switch__25763__auto__,c__25854__auto___30064,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__25764__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__25764__auto____0 = (function (){
var statearr_30060 = [null,null,null,null,null,null,null,null,null];
(statearr_30060[(0)] = figwheel$client$heads_up_plugin_$_state_machine__25764__auto__);

(statearr_30060[(1)] = (1));

return statearr_30060;
});
var figwheel$client$heads_up_plugin_$_state_machine__25764__auto____1 = (function (state_30050){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_30050);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e30061){if((e30061 instanceof Object)){
var ex__25767__auto__ = e30061;
var statearr_30062_30071 = state_30050;
(statearr_30062_30071[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30050);

return cljs.core.cst$kw$recur;
} else {
throw e30061;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__30072 = state_30050;
state_30050 = G__30072;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__25764__auto__ = function(state_30050){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__25764__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__25764__auto____1.call(this,state_30050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__25764__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__25764__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___30064,ch))
})();
var state__25856__auto__ = (function (){var statearr_30063 = f__25855__auto__.call(null);
(statearr_30063[(6)] = c__25854__auto___30064);

return statearr_30063;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___30064,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,cljs.core.cst$kw$project_DASH_id,cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(cljs.core.cst$kw$heads_DASH_up_DASH_display.cljs$core$IFn$_invoke$arity$1(opts))){
var c__25854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto__){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto__){
return (function (state_30078){
var state_val_30079 = (state_30078[(1)]);
if((state_val_30079 === (1))){
var inst_30073 = cljs.core.async.timeout.call(null,(3000));
var state_30078__$1 = state_30078;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30078__$1,(2),inst_30073);
} else {
if((state_val_30079 === (2))){
var inst_30075 = (state_30078[(2)]);
var inst_30076 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_30078__$1 = (function (){var statearr_30080 = state_30078;
(statearr_30080[(7)] = inst_30075);

return statearr_30080;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30078__$1,inst_30076);
} else {
return null;
}
}
});})(c__25854__auto__))
;
return ((function (switch__25763__auto__,c__25854__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__25764__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__25764__auto____0 = (function (){
var statearr_30081 = [null,null,null,null,null,null,null,null];
(statearr_30081[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__25764__auto__);

(statearr_30081[(1)] = (1));

return statearr_30081;
});
var figwheel$client$enforce_project_plugin_$_state_machine__25764__auto____1 = (function (state_30078){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_30078);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e30082){if((e30082 instanceof Object)){
var ex__25767__auto__ = e30082;
var statearr_30083_30085 = state_30078;
(statearr_30083_30085[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30078);

return cljs.core.cst$kw$recur;
} else {
throw e30082;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__30086 = state_30078;
state_30078 = G__30086;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__25764__auto__ = function(state_30078){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__25764__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__25764__auto____1.call(this,state_30078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__25764__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__25764__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto__))
})();
var state__25856__auto__ = (function (){var statearr_30084 = f__25855__auto__.call(null);
(statearr_30084[(6)] = c__25854__auto__);

return statearr_30084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto__))
);

return c__25854__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__5457__auto__ = cljs.core.cst$kw$figwheel_DASH_version.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__5457__auto__)){
var figwheel_version = temp__5457__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(cljs.core.cst$kw$heads_DASH_up_DASH_display.cljs$core$IFn$_invoke$arity$1(opts))){
var c__25854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto__,figwheel_version,temp__5457__auto__){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto__,figwheel_version,temp__5457__auto__){
return (function (state_30093){
var state_val_30094 = (state_30093[(1)]);
if((state_val_30094 === (1))){
var inst_30087 = cljs.core.async.timeout.call(null,(2000));
var state_30093__$1 = state_30093;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30093__$1,(2),inst_30087);
} else {
if((state_val_30094 === (2))){
var inst_30089 = (state_30093[(2)]);
var inst_30090 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_30091 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_30090);
var state_30093__$1 = (function (){var statearr_30095 = state_30093;
(statearr_30095[(7)] = inst_30089);

return statearr_30095;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30093__$1,inst_30091);
} else {
return null;
}
}
});})(c__25854__auto__,figwheel_version,temp__5457__auto__))
;
return ((function (switch__25763__auto__,c__25854__auto__,figwheel_version,temp__5457__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25764__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25764__auto____0 = (function (){
var statearr_30096 = [null,null,null,null,null,null,null,null];
(statearr_30096[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25764__auto__);

(statearr_30096[(1)] = (1));

return statearr_30096;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25764__auto____1 = (function (state_30093){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_30093);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e30097){if((e30097 instanceof Object)){
var ex__25767__auto__ = e30097;
var statearr_30098_30100 = state_30093;
(statearr_30098_30100[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30093);

return cljs.core.cst$kw$recur;
} else {
throw e30097;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__30101 = state_30093;
state_30093 = G__30101;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25764__auto__ = function(state_30093){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25764__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25764__auto____1.call(this,state_30093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25764__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25764__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto__,figwheel_version,temp__5457__auto__))
})();
var state__25856__auto__ = (function (){var statearr_30099 = f__25855__auto__.call(null);
(statearr_30099[(6)] = c__25854__auto__);

return statearr_30099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto__,figwheel_version,temp__5457__auto__))
);

return c__25854__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__30102){
var map__30103 = p__30102;
var map__30103__$1 = ((((!((map__30103 == null)))?(((((map__30103.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30103.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30103):map__30103);
var file = cljs.core.get.call(null,map__30103__$1,cljs.core.cst$kw$file);
var line = cljs.core.get.call(null,map__30103__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.call(null,map__30103__$1,cljs.core.cst$kw$column);
var G__30105 = "";
var G__30105__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30105),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__30105);
var G__30105__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30105__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__30105__$1);
if(cljs.core.truth_((function (){var and__3938__auto__ = line;
if(cljs.core.truth_(and__3938__auto__)){
return column;
} else {
return and__3938__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30105__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__30105__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__30106){
var map__30107 = p__30106;
var map__30107__$1 = ((((!((map__30107 == null)))?(((((map__30107.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30107.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30107):map__30107);
var ed = map__30107__$1;
var formatted_exception = cljs.core.get.call(null,map__30107__$1,cljs.core.cst$kw$formatted_DASH_exception);
var exception_data = cljs.core.get.call(null,map__30107__$1,cljs.core.cst$kw$exception_DASH_data);
var cause = cljs.core.get.call(null,map__30107__$1,cljs.core.cst$kw$cause);
figwheel.client.utils.log.call(null,cljs.core.cst$kw$debug,"Figwheel: Compile Exception");

var seq__30109_30113 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__30110_30114 = null;
var count__30111_30115 = (0);
var i__30112_30116 = (0);
while(true){
if((i__30112_30116 < count__30111_30115)){
var msg_30117 = cljs.core._nth.call(null,chunk__30110_30114,i__30112_30116);
figwheel.client.utils.log.call(null,cljs.core.cst$kw$info,msg_30117);


var G__30118 = seq__30109_30113;
var G__30119 = chunk__30110_30114;
var G__30120 = count__30111_30115;
var G__30121 = (i__30112_30116 + (1));
seq__30109_30113 = G__30118;
chunk__30110_30114 = G__30119;
count__30111_30115 = G__30120;
i__30112_30116 = G__30121;
continue;
} else {
var temp__5457__auto___30122 = cljs.core.seq.call(null,seq__30109_30113);
if(temp__5457__auto___30122){
var seq__30109_30123__$1 = temp__5457__auto___30122;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30109_30123__$1)){
var c__4351__auto___30124 = cljs.core.chunk_first.call(null,seq__30109_30123__$1);
var G__30125 = cljs.core.chunk_rest.call(null,seq__30109_30123__$1);
var G__30126 = c__4351__auto___30124;
var G__30127 = cljs.core.count.call(null,c__4351__auto___30124);
var G__30128 = (0);
seq__30109_30113 = G__30125;
chunk__30110_30114 = G__30126;
count__30111_30115 = G__30127;
i__30112_30116 = G__30128;
continue;
} else {
var msg_30129 = cljs.core.first.call(null,seq__30109_30123__$1);
figwheel.client.utils.log.call(null,cljs.core.cst$kw$info,msg_30129);


var G__30130 = cljs.core.next.call(null,seq__30109_30123__$1);
var G__30131 = null;
var G__30132 = (0);
var G__30133 = (0);
seq__30109_30113 = G__30130;
chunk__30110_30114 = G__30131;
count__30111_30115 = G__30132;
i__30112_30116 = G__30133;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,cljs.core.cst$kw$info,["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__30134){
var map__30135 = p__30134;
var map__30135__$1 = ((((!((map__30135 == null)))?(((((map__30135.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30135.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30135):map__30135);
var w = map__30135__$1;
var message = cljs.core.get.call(null,map__30135__$1,cljs.core.cst$kw$message);
figwheel.client.utils.log.call(null,cljs.core.cst$kw$warn,["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,cljs.core.cst$kw$debug,"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,cljs.core.cst$kw$debug,"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,cljs.core.cst$kw$info,cljs.core.pr_str.call(null,cljs.core.map.call(null,cljs.core.cst$kw$file,files)));

return files;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.config_defaults !== 'undefined')){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$on_DASH_compile_DASH_warning,cljs.core.cst$kw$on_DASH_jsload,cljs.core.cst$kw$reload_DASH_dependents,cljs.core.cst$kw$on_DASH_compile_DASH_fail,cljs.core.cst$kw$debug,cljs.core.cst$kw$heads_DASH_up_DASH_display,cljs.core.cst$kw$websocket_DASH_url,cljs.core.cst$kw$auto_DASH_jump_DASH_to_DASH_source_DASH_on_DASH_error,cljs.core.cst$kw$before_DASH_jsload,cljs.core.cst$kw$load_DASH_warninged_DASH_code,cljs.core.cst$kw$eval_DASH_fn,cljs.core.cst$kw$retry_DASH_count,cljs.core.cst$kw$autoload,cljs.core.cst$kw$on_DASH_cssload],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},cljs.core.cst$sym$figwheel$client_SLASH_default_DASH_on_DASH_compile_DASH_warning,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$figwheel$client,cljs.core.cst$sym$default_DASH_on_DASH_compile_DASH_warning,"resources/public/js/compiled/out/figwheel/client.cljs",33,1,361,361,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$message], null),cljs.core.cst$kw$as,cljs.core.cst$sym$w], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},cljs.core.cst$sym$figwheel$client_SLASH_default_DASH_on_DASH_compile_DASH_fail,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$figwheel$client,cljs.core.cst$sym$default_DASH_on_DASH_compile_DASH_fail,"resources/public/js/compiled/out/figwheel/client.cljs",30,1,353,353,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$formatted_DASH_exception,cljs.core.cst$sym$exception_DASH_data,cljs.core.cst$sym$cause], null),cljs.core.cst$kw$as,cljs.core.cst$sym$ed], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(cljs.core.cst$kw$jsload_DASH_callback.cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,cljs.core.cst$kw$on_DASH_jsload,cljs.core.cst$kw$jsload_DASH_callback.cljs$core$IFn$_invoke$arity$1(config)),cljs.core.cst$kw$jsload_DASH_callback);
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$websocket_DASH_url], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$enforce_DASH_project_DASH_plugin,figwheel.client.enforce_project_plugin,cljs.core.cst$kw$enforce_DASH_figwheel_DASH_version_DASH_plugin,figwheel.client.enforce_figwheel_version_plugin,cljs.core.cst$kw$file_DASH_reloader_DASH_plugin,figwheel.client.file_reloader_plugin,cljs.core.cst$kw$comp_DASH_fail_DASH_warning_DASH_plugin,figwheel.client.compile_fail_warning_plugin,cljs.core.cst$kw$css_DASH_reloader_DASH_plugin,figwheel.client.css_reloader_plugin,cljs.core.cst$kw$repl_DASH_plugin,figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$file_DASH_reloader_DASH_plugin,cljs.core.cst$kw$comp_DASH_fail_DASH_warning_DASH_plugin,cljs.core.cst$kw$repl_DASH_plugin], null)):base);
var base__$2 = ((cljs.core.cst$kw$autoload.cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,cljs.core.cst$kw$file_DASH_reloader_DASH_plugin):base__$1);
if(cljs.core.truth_((function (){var and__3938__auto__ = cljs.core.cst$kw$heads_DASH_up_DASH_display.cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__3938__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__3938__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,cljs.core.cst$kw$heads_DASH_up_DASH_display_DASH_plugin,figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_json_message_watch = (function figwheel$client$add_json_message_watch(key,callback){
return figwheel.client.add_message_watch.call(null,key,cljs.core.comp.call(null,callback,cljs.core.clj__GT_js));
});
goog.exportSymbol('figwheel.client.add_json_message_watch', figwheel.client.add_json_message_watch);
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__30137 = cljs.core.seq.call(null,plugins);
var chunk__30138 = null;
var count__30139 = (0);
var i__30140 = (0);
while(true){
if((i__30140 < count__30139)){
var vec__30141 = cljs.core._nth.call(null,chunk__30138,i__30140);
var k = cljs.core.nth.call(null,vec__30141,(0),null);
var plugin = cljs.core.nth.call(null,vec__30141,(1),null);
if(cljs.core.truth_(plugin)){
var pl_30147 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__30137,chunk__30138,count__30139,i__30140,pl_30147,vec__30141,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_30147.call(null,msg_hist);
});})(seq__30137,chunk__30138,count__30139,i__30140,pl_30147,vec__30141,k,plugin))
);
} else {
}


var G__30148 = seq__30137;
var G__30149 = chunk__30138;
var G__30150 = count__30139;
var G__30151 = (i__30140 + (1));
seq__30137 = G__30148;
chunk__30138 = G__30149;
count__30139 = G__30150;
i__30140 = G__30151;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__30137);
if(temp__5457__auto__){
var seq__30137__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30137__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__30137__$1);
var G__30152 = cljs.core.chunk_rest.call(null,seq__30137__$1);
var G__30153 = c__4351__auto__;
var G__30154 = cljs.core.count.call(null,c__4351__auto__);
var G__30155 = (0);
seq__30137 = G__30152;
chunk__30138 = G__30153;
count__30139 = G__30154;
i__30140 = G__30155;
continue;
} else {
var vec__30144 = cljs.core.first.call(null,seq__30137__$1);
var k = cljs.core.nth.call(null,vec__30144,(0),null);
var plugin = cljs.core.nth.call(null,vec__30144,(1),null);
if(cljs.core.truth_(plugin)){
var pl_30156 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__30137,chunk__30138,count__30139,i__30140,pl_30156,vec__30144,k,plugin,seq__30137__$1,temp__5457__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_30156.call(null,msg_hist);
});})(seq__30137,chunk__30138,count__30139,i__30140,pl_30156,vec__30144,k,plugin,seq__30137__$1,temp__5457__auto__))
);
} else {
}


var G__30157 = cljs.core.next.call(null,seq__30137__$1);
var G__30158 = null;
var G__30159 = (0);
var G__30160 = (0);
seq__30137 = G__30157;
chunk__30138 = G__30158;
count__30139 = G__30159;
i__30140 = G__30160;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__30162 = arguments.length;
switch (G__30162) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.__figwheel_start_once__ !== 'undefined')){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = cljs.core.cst$kw$plugins.cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = cljs.core.cst$kw$merge_DASH_plugins.cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,cljs.core.cst$kw$plugins,cljs.core.cst$kw$merge_DASH_plugins))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = cljs.core.cst$kw$debug.cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__30163_30168 = cljs.core.seq.call(null,cljs.core.cst$kw$initial_DASH_messages.cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__30164_30169 = null;
var count__30165_30170 = (0);
var i__30166_30171 = (0);
while(true){
if((i__30166_30171 < count__30165_30170)){
var msg_30172 = cljs.core._nth.call(null,chunk__30164_30169,i__30166_30171);
figwheel.client.socket.handle_incoming_message.call(null,msg_30172);


var G__30173 = seq__30163_30168;
var G__30174 = chunk__30164_30169;
var G__30175 = count__30165_30170;
var G__30176 = (i__30166_30171 + (1));
seq__30163_30168 = G__30173;
chunk__30164_30169 = G__30174;
count__30165_30170 = G__30175;
i__30166_30171 = G__30176;
continue;
} else {
var temp__5457__auto___30177 = cljs.core.seq.call(null,seq__30163_30168);
if(temp__5457__auto___30177){
var seq__30163_30178__$1 = temp__5457__auto___30177;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30163_30178__$1)){
var c__4351__auto___30179 = cljs.core.chunk_first.call(null,seq__30163_30178__$1);
var G__30180 = cljs.core.chunk_rest.call(null,seq__30163_30178__$1);
var G__30181 = c__4351__auto___30179;
var G__30182 = cljs.core.count.call(null,c__4351__auto___30179);
var G__30183 = (0);
seq__30163_30168 = G__30180;
chunk__30164_30169 = G__30181;
count__30165_30170 = G__30182;
i__30166_30171 = G__30183;
continue;
} else {
var msg_30184 = cljs.core.first.call(null,seq__30163_30178__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_30184);


var G__30185 = cljs.core.next.call(null,seq__30163_30178__$1);
var G__30186 = null;
var G__30187 = (0);
var G__30188 = (0);
seq__30163_30168 = G__30185;
chunk__30164_30169 = G__30186;
count__30165_30170 = G__30187;
i__30166_30171 = G__30188;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30193 = arguments.length;
var i__4532__auto___30194 = (0);
while(true){
if((i__4532__auto___30194 < len__4531__auto___30193)){
args__4534__auto__.push((arguments[i__4532__auto___30194]));

var G__30195 = (i__4532__auto___30194 + (1));
i__4532__auto___30194 = G__30195;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__30190){
var map__30191 = p__30190;
var map__30191__$1 = ((((!((map__30191 == null)))?(((((map__30191.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30191.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30191):map__30191);
var opts = map__30191__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq30189){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq30189));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e30196){if((e30196 instanceof Error)){
var e = e30196;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$autoload,false], null);
} else {
throw e30196;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,cljs.core.cst$kw$listen_DASH_for_DASH_successful_DASH_compile,((function (config){
return (function (p__30197){
var map__30198 = p__30197;
var map__30198__$1 = ((((!((map__30198 == null)))?(((((map__30198.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30198.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30198):map__30198);
var msg_name = cljs.core.get.call(null,map__30198__$1,cljs.core.cst$kw$msg_DASH_name);
if(cljs.core._EQ_.call(null,msg_name,cljs.core.cst$kw$files_DASH_changed)){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1535482704333
