// Compiled by ClojureScript 1.10.339 {:optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__25914 = arguments.length;
switch (G__25914) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25915 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25915 = (function (f,blockable,meta25916){
this.f = f;
this.blockable = blockable;
this.meta25916 = meta25916;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25915.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25917,meta25916__$1){
var self__ = this;
var _25917__$1 = this;
return (new cljs.core.async.t_cljs$core$async25915(self__.f,self__.blockable,meta25916__$1));
});

cljs.core.async.t_cljs$core$async25915.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25917){
var self__ = this;
var _25917__$1 = this;
return self__.meta25916;
});

cljs.core.async.t_cljs$core$async25915.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25915.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async25915.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async25915.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async25915.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta25916], null);
});

cljs.core.async.t_cljs$core$async25915.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25915.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25915";

cljs.core.async.t_cljs$core$async25915.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async25915");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25915.
 */
cljs.core.async.__GT_t_cljs$core$async25915 = (function cljs$core$async$__GT_t_cljs$core$async25915(f__$1,blockable__$1,meta25916){
return (new cljs.core.async.t_cljs$core$async25915(f__$1,blockable__$1,meta25916));
});

}

return (new cljs.core.async.t_cljs$core$async25915(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__25921 = arguments.length;
switch (G__25921) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__25924 = arguments.length;
switch (G__25924) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__25927 = arguments.length;
switch (G__25927) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_25929 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_25929);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_25929,ret){
return (function (){
return fn1.call(null,val_25929);
});})(val_25929,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__25931 = arguments.length;
switch (G__25931) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5455__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4408__auto___25933 = n;
var x_25934 = (0);
while(true){
if((x_25934 < n__4408__auto___25933)){
(a[x_25934] = (0));

var G__25935 = (x_25934 + (1));
x_25934 = G__25935;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__25936 = (i + (1));
i = G__25936;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25937 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25937 = (function (flag,meta25938){
this.flag = flag;
this.meta25938 = meta25938;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25937.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_25939,meta25938__$1){
var self__ = this;
var _25939__$1 = this;
return (new cljs.core.async.t_cljs$core$async25937(self__.flag,meta25938__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async25937.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_25939){
var self__ = this;
var _25939__$1 = this;
return self__.meta25938;
});})(flag))
;

cljs.core.async.t_cljs$core$async25937.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25937.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async25937.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async25937.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async25937.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta25938], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async25937.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25937.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25937";

cljs.core.async.t_cljs$core$async25937.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async25937");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25937.
 */
cljs.core.async.__GT_t_cljs$core$async25937 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async25937(flag__$1,meta25938){
return (new cljs.core.async.t_cljs$core$async25937(flag__$1,meta25938));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async25937(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25940 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25940 = (function (flag,cb,meta25941){
this.flag = flag;
this.cb = cb;
this.meta25941 = meta25941;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25940.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25942,meta25941__$1){
var self__ = this;
var _25942__$1 = this;
return (new cljs.core.async.t_cljs$core$async25940(self__.flag,self__.cb,meta25941__$1));
});

cljs.core.async.t_cljs$core$async25940.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25942){
var self__ = this;
var _25942__$1 = this;
return self__.meta25941;
});

cljs.core.async.t_cljs$core$async25940.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25940.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async25940.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async25940.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async25940.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta25941], null);
});

cljs.core.async.t_cljs$core$async25940.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25940.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25940";

cljs.core.async.t_cljs$core$async25940.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async25940");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25940.
 */
cljs.core.async.__GT_t_cljs$core$async25940 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async25940(flag__$1,cb__$1,meta25941){
return (new cljs.core.async.t_cljs$core$async25940(flag__$1,cb__$1,meta25941));
});

}

return (new cljs.core.async.t_cljs$core$async25940(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__25943_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25943_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__25944_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25944_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3949__auto__ = wport;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return port;
}
})()], null));
} else {
var G__25945 = (i + (1));
i = G__25945;
continue;
}
} else {
return null;
}
break;
}
})();
var or__3949__auto__ = ret;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,cljs.core.cst$kw$default)){
var temp__5457__auto__ = (function (){var and__3938__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__3938__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___25951 = arguments.length;
var i__4532__auto___25952 = (0);
while(true){
if((i__4532__auto___25952 < len__4531__auto___25951)){
args__4534__auto__.push((arguments[i__4532__auto___25952]));

var G__25953 = (i__4532__auto___25952 + (1));
i__4532__auto___25952 = G__25953;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__25948){
var map__25949 = p__25948;
var map__25949__$1 = ((((!((map__25949 == null)))?(((((map__25949.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25949.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25949):map__25949);
var opts = map__25949__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq25946){
var G__25947 = cljs.core.first.call(null,seq25946);
var seq25946__$1 = cljs.core.next.call(null,seq25946);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__25947,seq25946__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__25955 = arguments.length;
switch (G__25955) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__25854__auto___26001 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___26001){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___26001){
return (function (state_25979){
var state_val_25980 = (state_25979[(1)]);
if((state_val_25980 === (7))){
var inst_25975 = (state_25979[(2)]);
var state_25979__$1 = state_25979;
var statearr_25981_26002 = state_25979__$1;
(statearr_25981_26002[(2)] = inst_25975);

(statearr_25981_26002[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25980 === (1))){
var state_25979__$1 = state_25979;
var statearr_25982_26003 = state_25979__$1;
(statearr_25982_26003[(2)] = null);

(statearr_25982_26003[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25980 === (4))){
var inst_25958 = (state_25979[(7)]);
var inst_25958__$1 = (state_25979[(2)]);
var inst_25959 = (inst_25958__$1 == null);
var state_25979__$1 = (function (){var statearr_25983 = state_25979;
(statearr_25983[(7)] = inst_25958__$1);

return statearr_25983;
})();
if(cljs.core.truth_(inst_25959)){
var statearr_25984_26004 = state_25979__$1;
(statearr_25984_26004[(1)] = (5));

} else {
var statearr_25985_26005 = state_25979__$1;
(statearr_25985_26005[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25980 === (13))){
var state_25979__$1 = state_25979;
var statearr_25986_26006 = state_25979__$1;
(statearr_25986_26006[(2)] = null);

(statearr_25986_26006[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25980 === (6))){
var inst_25958 = (state_25979[(7)]);
var state_25979__$1 = state_25979;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25979__$1,(11),to,inst_25958);
} else {
if((state_val_25980 === (3))){
var inst_25977 = (state_25979[(2)]);
var state_25979__$1 = state_25979;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25979__$1,inst_25977);
} else {
if((state_val_25980 === (12))){
var state_25979__$1 = state_25979;
var statearr_25987_26007 = state_25979__$1;
(statearr_25987_26007[(2)] = null);

(statearr_25987_26007[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25980 === (2))){
var state_25979__$1 = state_25979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25979__$1,(4),from);
} else {
if((state_val_25980 === (11))){
var inst_25968 = (state_25979[(2)]);
var state_25979__$1 = state_25979;
if(cljs.core.truth_(inst_25968)){
var statearr_25988_26008 = state_25979__$1;
(statearr_25988_26008[(1)] = (12));

} else {
var statearr_25989_26009 = state_25979__$1;
(statearr_25989_26009[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25980 === (9))){
var state_25979__$1 = state_25979;
var statearr_25990_26010 = state_25979__$1;
(statearr_25990_26010[(2)] = null);

(statearr_25990_26010[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25980 === (5))){
var state_25979__$1 = state_25979;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25991_26011 = state_25979__$1;
(statearr_25991_26011[(1)] = (8));

} else {
var statearr_25992_26012 = state_25979__$1;
(statearr_25992_26012[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25980 === (14))){
var inst_25973 = (state_25979[(2)]);
var state_25979__$1 = state_25979;
var statearr_25993_26013 = state_25979__$1;
(statearr_25993_26013[(2)] = inst_25973);

(statearr_25993_26013[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25980 === (10))){
var inst_25965 = (state_25979[(2)]);
var state_25979__$1 = state_25979;
var statearr_25994_26014 = state_25979__$1;
(statearr_25994_26014[(2)] = inst_25965);

(statearr_25994_26014[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25980 === (8))){
var inst_25962 = cljs.core.async.close_BANG_.call(null,to);
var state_25979__$1 = state_25979;
var statearr_25995_26015 = state_25979__$1;
(statearr_25995_26015[(2)] = inst_25962);

(statearr_25995_26015[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto___26001))
;
return ((function (switch__25763__auto__,c__25854__auto___26001){
return (function() {
var cljs$core$async$state_machine__25764__auto__ = null;
var cljs$core$async$state_machine__25764__auto____0 = (function (){
var statearr_25996 = [null,null,null,null,null,null,null,null];
(statearr_25996[(0)] = cljs$core$async$state_machine__25764__auto__);

(statearr_25996[(1)] = (1));

return statearr_25996;
});
var cljs$core$async$state_machine__25764__auto____1 = (function (state_25979){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_25979);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e25997){if((e25997 instanceof Object)){
var ex__25767__auto__ = e25997;
var statearr_25998_26016 = state_25979;
(statearr_25998_26016[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25979);

return cljs.core.cst$kw$recur;
} else {
throw e25997;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__26017 = state_25979;
state_25979 = G__26017;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$state_machine__25764__auto__ = function(state_25979){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25764__auto____1.call(this,state_25979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25764__auto____0;
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25764__auto____1;
return cljs$core$async$state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___26001))
})();
var state__25856__auto__ = (function (){var statearr_25999 = f__25855__auto__.call(null);
(statearr_25999[(6)] = c__25854__auto___26001);

return statearr_25999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___26001))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__26018){
var vec__26019 = p__26018;
var v = cljs.core.nth.call(null,vec__26019,(0),null);
var p = cljs.core.nth.call(null,vec__26019,(1),null);
var job = vec__26019;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__25854__auto___26190 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___26190,res,vec__26019,v,p,job,jobs,results){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___26190,res,vec__26019,v,p,job,jobs,results){
return (function (state_26026){
var state_val_26027 = (state_26026[(1)]);
if((state_val_26027 === (1))){
var state_26026__$1 = state_26026;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26026__$1,(2),res,v);
} else {
if((state_val_26027 === (2))){
var inst_26023 = (state_26026[(2)]);
var inst_26024 = cljs.core.async.close_BANG_.call(null,res);
var state_26026__$1 = (function (){var statearr_26028 = state_26026;
(statearr_26028[(7)] = inst_26023);

return statearr_26028;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26026__$1,inst_26024);
} else {
return null;
}
}
});})(c__25854__auto___26190,res,vec__26019,v,p,job,jobs,results))
;
return ((function (switch__25763__auto__,c__25854__auto___26190,res,vec__26019,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____0 = (function (){
var statearr_26029 = [null,null,null,null,null,null,null,null];
(statearr_26029[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__);

(statearr_26029[(1)] = (1));

return statearr_26029;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____1 = (function (state_26026){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_26026);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e26030){if((e26030 instanceof Object)){
var ex__25767__auto__ = e26030;
var statearr_26031_26191 = state_26026;
(statearr_26031_26191[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26026);

return cljs.core.cst$kw$recur;
} else {
throw e26030;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__26192 = state_26026;
state_26026 = G__26192;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__ = function(state_26026){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____1.call(this,state_26026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___26190,res,vec__26019,v,p,job,jobs,results))
})();
var state__25856__auto__ = (function (){var statearr_26032 = f__25855__auto__.call(null);
(statearr_26032[(6)] = c__25854__auto___26190);

return statearr_26032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___26190,res,vec__26019,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__26033){
var vec__26034 = p__26033;
var v = cljs.core.nth.call(null,vec__26034,(0),null);
var p = cljs.core.nth.call(null,vec__26034,(1),null);
var job = vec__26034;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4408__auto___26193 = n;
var __26194 = (0);
while(true){
if((__26194 < n__4408__auto___26193)){
var G__26037_26195 = type;
var G__26037_26196__$1 = (((G__26037_26195 instanceof cljs.core.Keyword))?G__26037_26195.fqn:null);
switch (G__26037_26196__$1) {
case "compute":
var c__25854__auto___26198 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__26194,c__25854__auto___26198,G__26037_26195,G__26037_26196__$1,n__4408__auto___26193,jobs,results,process,async){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (__26194,c__25854__auto___26198,G__26037_26195,G__26037_26196__$1,n__4408__auto___26193,jobs,results,process,async){
return (function (state_26050){
var state_val_26051 = (state_26050[(1)]);
if((state_val_26051 === (1))){
var state_26050__$1 = state_26050;
var statearr_26052_26199 = state_26050__$1;
(statearr_26052_26199[(2)] = null);

(statearr_26052_26199[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26051 === (2))){
var state_26050__$1 = state_26050;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26050__$1,(4),jobs);
} else {
if((state_val_26051 === (3))){
var inst_26048 = (state_26050[(2)]);
var state_26050__$1 = state_26050;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26050__$1,inst_26048);
} else {
if((state_val_26051 === (4))){
var inst_26040 = (state_26050[(2)]);
var inst_26041 = process.call(null,inst_26040);
var state_26050__$1 = state_26050;
if(cljs.core.truth_(inst_26041)){
var statearr_26053_26200 = state_26050__$1;
(statearr_26053_26200[(1)] = (5));

} else {
var statearr_26054_26201 = state_26050__$1;
(statearr_26054_26201[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26051 === (5))){
var state_26050__$1 = state_26050;
var statearr_26055_26202 = state_26050__$1;
(statearr_26055_26202[(2)] = null);

(statearr_26055_26202[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26051 === (6))){
var state_26050__$1 = state_26050;
var statearr_26056_26203 = state_26050__$1;
(statearr_26056_26203[(2)] = null);

(statearr_26056_26203[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26051 === (7))){
var inst_26046 = (state_26050[(2)]);
var state_26050__$1 = state_26050;
var statearr_26057_26204 = state_26050__$1;
(statearr_26057_26204[(2)] = inst_26046);

(statearr_26057_26204[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__26194,c__25854__auto___26198,G__26037_26195,G__26037_26196__$1,n__4408__auto___26193,jobs,results,process,async))
;
return ((function (__26194,switch__25763__auto__,c__25854__auto___26198,G__26037_26195,G__26037_26196__$1,n__4408__auto___26193,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____0 = (function (){
var statearr_26058 = [null,null,null,null,null,null,null];
(statearr_26058[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__);

(statearr_26058[(1)] = (1));

return statearr_26058;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____1 = (function (state_26050){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_26050);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e26059){if((e26059 instanceof Object)){
var ex__25767__auto__ = e26059;
var statearr_26060_26205 = state_26050;
(statearr_26060_26205[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26050);

return cljs.core.cst$kw$recur;
} else {
throw e26059;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__26206 = state_26050;
state_26050 = G__26206;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__ = function(state_26050){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____1.call(this,state_26050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__;
})()
;})(__26194,switch__25763__auto__,c__25854__auto___26198,G__26037_26195,G__26037_26196__$1,n__4408__auto___26193,jobs,results,process,async))
})();
var state__25856__auto__ = (function (){var statearr_26061 = f__25855__auto__.call(null);
(statearr_26061[(6)] = c__25854__auto___26198);

return statearr_26061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(__26194,c__25854__auto___26198,G__26037_26195,G__26037_26196__$1,n__4408__auto___26193,jobs,results,process,async))
);


break;
case "async":
var c__25854__auto___26207 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__26194,c__25854__auto___26207,G__26037_26195,G__26037_26196__$1,n__4408__auto___26193,jobs,results,process,async){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (__26194,c__25854__auto___26207,G__26037_26195,G__26037_26196__$1,n__4408__auto___26193,jobs,results,process,async){
return (function (state_26074){
var state_val_26075 = (state_26074[(1)]);
if((state_val_26075 === (1))){
var state_26074__$1 = state_26074;
var statearr_26076_26208 = state_26074__$1;
(statearr_26076_26208[(2)] = null);

(statearr_26076_26208[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26075 === (2))){
var state_26074__$1 = state_26074;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26074__$1,(4),jobs);
} else {
if((state_val_26075 === (3))){
var inst_26072 = (state_26074[(2)]);
var state_26074__$1 = state_26074;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26074__$1,inst_26072);
} else {
if((state_val_26075 === (4))){
var inst_26064 = (state_26074[(2)]);
var inst_26065 = async.call(null,inst_26064);
var state_26074__$1 = state_26074;
if(cljs.core.truth_(inst_26065)){
var statearr_26077_26209 = state_26074__$1;
(statearr_26077_26209[(1)] = (5));

} else {
var statearr_26078_26210 = state_26074__$1;
(statearr_26078_26210[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26075 === (5))){
var state_26074__$1 = state_26074;
var statearr_26079_26211 = state_26074__$1;
(statearr_26079_26211[(2)] = null);

(statearr_26079_26211[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26075 === (6))){
var state_26074__$1 = state_26074;
var statearr_26080_26212 = state_26074__$1;
(statearr_26080_26212[(2)] = null);

(statearr_26080_26212[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26075 === (7))){
var inst_26070 = (state_26074[(2)]);
var state_26074__$1 = state_26074;
var statearr_26081_26213 = state_26074__$1;
(statearr_26081_26213[(2)] = inst_26070);

(statearr_26081_26213[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__26194,c__25854__auto___26207,G__26037_26195,G__26037_26196__$1,n__4408__auto___26193,jobs,results,process,async))
;
return ((function (__26194,switch__25763__auto__,c__25854__auto___26207,G__26037_26195,G__26037_26196__$1,n__4408__auto___26193,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____0 = (function (){
var statearr_26082 = [null,null,null,null,null,null,null];
(statearr_26082[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__);

(statearr_26082[(1)] = (1));

return statearr_26082;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____1 = (function (state_26074){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_26074);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e26083){if((e26083 instanceof Object)){
var ex__25767__auto__ = e26083;
var statearr_26084_26214 = state_26074;
(statearr_26084_26214[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26074);

return cljs.core.cst$kw$recur;
} else {
throw e26083;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__26215 = state_26074;
state_26074 = G__26215;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__ = function(state_26074){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____1.call(this,state_26074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__;
})()
;})(__26194,switch__25763__auto__,c__25854__auto___26207,G__26037_26195,G__26037_26196__$1,n__4408__auto___26193,jobs,results,process,async))
})();
var state__25856__auto__ = (function (){var statearr_26085 = f__25855__auto__.call(null);
(statearr_26085[(6)] = c__25854__auto___26207);

return statearr_26085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(__26194,c__25854__auto___26207,G__26037_26195,G__26037_26196__$1,n__4408__auto___26193,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__26037_26196__$1)].join('')));

}

var G__26216 = (__26194 + (1));
__26194 = G__26216;
continue;
} else {
}
break;
}

var c__25854__auto___26217 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___26217,jobs,results,process,async){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___26217,jobs,results,process,async){
return (function (state_26107){
var state_val_26108 = (state_26107[(1)]);
if((state_val_26108 === (1))){
var state_26107__$1 = state_26107;
var statearr_26109_26218 = state_26107__$1;
(statearr_26109_26218[(2)] = null);

(statearr_26109_26218[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26108 === (2))){
var state_26107__$1 = state_26107;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26107__$1,(4),from);
} else {
if((state_val_26108 === (3))){
var inst_26105 = (state_26107[(2)]);
var state_26107__$1 = state_26107;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26107__$1,inst_26105);
} else {
if((state_val_26108 === (4))){
var inst_26088 = (state_26107[(7)]);
var inst_26088__$1 = (state_26107[(2)]);
var inst_26089 = (inst_26088__$1 == null);
var state_26107__$1 = (function (){var statearr_26110 = state_26107;
(statearr_26110[(7)] = inst_26088__$1);

return statearr_26110;
})();
if(cljs.core.truth_(inst_26089)){
var statearr_26111_26219 = state_26107__$1;
(statearr_26111_26219[(1)] = (5));

} else {
var statearr_26112_26220 = state_26107__$1;
(statearr_26112_26220[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26108 === (5))){
var inst_26091 = cljs.core.async.close_BANG_.call(null,jobs);
var state_26107__$1 = state_26107;
var statearr_26113_26221 = state_26107__$1;
(statearr_26113_26221[(2)] = inst_26091);

(statearr_26113_26221[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26108 === (6))){
var inst_26088 = (state_26107[(7)]);
var inst_26093 = (state_26107[(8)]);
var inst_26093__$1 = cljs.core.async.chan.call(null,(1));
var inst_26094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26095 = [inst_26088,inst_26093__$1];
var inst_26096 = (new cljs.core.PersistentVector(null,2,(5),inst_26094,inst_26095,null));
var state_26107__$1 = (function (){var statearr_26114 = state_26107;
(statearr_26114[(8)] = inst_26093__$1);

return statearr_26114;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26107__$1,(8),jobs,inst_26096);
} else {
if((state_val_26108 === (7))){
var inst_26103 = (state_26107[(2)]);
var state_26107__$1 = state_26107;
var statearr_26115_26222 = state_26107__$1;
(statearr_26115_26222[(2)] = inst_26103);

(statearr_26115_26222[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26108 === (8))){
var inst_26093 = (state_26107[(8)]);
var inst_26098 = (state_26107[(2)]);
var state_26107__$1 = (function (){var statearr_26116 = state_26107;
(statearr_26116[(9)] = inst_26098);

return statearr_26116;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26107__$1,(9),results,inst_26093);
} else {
if((state_val_26108 === (9))){
var inst_26100 = (state_26107[(2)]);
var state_26107__$1 = (function (){var statearr_26117 = state_26107;
(statearr_26117[(10)] = inst_26100);

return statearr_26117;
})();
var statearr_26118_26223 = state_26107__$1;
(statearr_26118_26223[(2)] = null);

(statearr_26118_26223[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__25854__auto___26217,jobs,results,process,async))
;
return ((function (switch__25763__auto__,c__25854__auto___26217,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____0 = (function (){
var statearr_26119 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26119[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__);

(statearr_26119[(1)] = (1));

return statearr_26119;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____1 = (function (state_26107){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_26107);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e26120){if((e26120 instanceof Object)){
var ex__25767__auto__ = e26120;
var statearr_26121_26224 = state_26107;
(statearr_26121_26224[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26107);

return cljs.core.cst$kw$recur;
} else {
throw e26120;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__26225 = state_26107;
state_26107 = G__26225;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__ = function(state_26107){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____1.call(this,state_26107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___26217,jobs,results,process,async))
})();
var state__25856__auto__ = (function (){var statearr_26122 = f__25855__auto__.call(null);
(statearr_26122[(6)] = c__25854__auto___26217);

return statearr_26122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___26217,jobs,results,process,async))
);


var c__25854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto__,jobs,results,process,async){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto__,jobs,results,process,async){
return (function (state_26160){
var state_val_26161 = (state_26160[(1)]);
if((state_val_26161 === (7))){
var inst_26156 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26162_26226 = state_26160__$1;
(statearr_26162_26226[(2)] = inst_26156);

(statearr_26162_26226[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26161 === (20))){
var state_26160__$1 = state_26160;
var statearr_26163_26227 = state_26160__$1;
(statearr_26163_26227[(2)] = null);

(statearr_26163_26227[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26161 === (1))){
var state_26160__$1 = state_26160;
var statearr_26164_26228 = state_26160__$1;
(statearr_26164_26228[(2)] = null);

(statearr_26164_26228[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26161 === (4))){
var inst_26125 = (state_26160[(7)]);
var inst_26125__$1 = (state_26160[(2)]);
var inst_26126 = (inst_26125__$1 == null);
var state_26160__$1 = (function (){var statearr_26165 = state_26160;
(statearr_26165[(7)] = inst_26125__$1);

return statearr_26165;
})();
if(cljs.core.truth_(inst_26126)){
var statearr_26166_26229 = state_26160__$1;
(statearr_26166_26229[(1)] = (5));

} else {
var statearr_26167_26230 = state_26160__$1;
(statearr_26167_26230[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26161 === (15))){
var inst_26138 = (state_26160[(8)]);
var state_26160__$1 = state_26160;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26160__$1,(18),to,inst_26138);
} else {
if((state_val_26161 === (21))){
var inst_26151 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26168_26231 = state_26160__$1;
(statearr_26168_26231[(2)] = inst_26151);

(statearr_26168_26231[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26161 === (13))){
var inst_26153 = (state_26160[(2)]);
var state_26160__$1 = (function (){var statearr_26169 = state_26160;
(statearr_26169[(9)] = inst_26153);

return statearr_26169;
})();
var statearr_26170_26232 = state_26160__$1;
(statearr_26170_26232[(2)] = null);

(statearr_26170_26232[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26161 === (6))){
var inst_26125 = (state_26160[(7)]);
var state_26160__$1 = state_26160;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26160__$1,(11),inst_26125);
} else {
if((state_val_26161 === (17))){
var inst_26146 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
if(cljs.core.truth_(inst_26146)){
var statearr_26171_26233 = state_26160__$1;
(statearr_26171_26233[(1)] = (19));

} else {
var statearr_26172_26234 = state_26160__$1;
(statearr_26172_26234[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26161 === (3))){
var inst_26158 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26160__$1,inst_26158);
} else {
if((state_val_26161 === (12))){
var inst_26135 = (state_26160[(10)]);
var state_26160__$1 = state_26160;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26160__$1,(14),inst_26135);
} else {
if((state_val_26161 === (2))){
var state_26160__$1 = state_26160;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26160__$1,(4),results);
} else {
if((state_val_26161 === (19))){
var state_26160__$1 = state_26160;
var statearr_26173_26235 = state_26160__$1;
(statearr_26173_26235[(2)] = null);

(statearr_26173_26235[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26161 === (11))){
var inst_26135 = (state_26160[(2)]);
var state_26160__$1 = (function (){var statearr_26174 = state_26160;
(statearr_26174[(10)] = inst_26135);

return statearr_26174;
})();
var statearr_26175_26236 = state_26160__$1;
(statearr_26175_26236[(2)] = null);

(statearr_26175_26236[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26161 === (9))){
var state_26160__$1 = state_26160;
var statearr_26176_26237 = state_26160__$1;
(statearr_26176_26237[(2)] = null);

(statearr_26176_26237[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26161 === (5))){
var state_26160__$1 = state_26160;
if(cljs.core.truth_(close_QMARK_)){
var statearr_26177_26238 = state_26160__$1;
(statearr_26177_26238[(1)] = (8));

} else {
var statearr_26178_26239 = state_26160__$1;
(statearr_26178_26239[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26161 === (14))){
var inst_26138 = (state_26160[(8)]);
var inst_26140 = (state_26160[(11)]);
var inst_26138__$1 = (state_26160[(2)]);
var inst_26139 = (inst_26138__$1 == null);
var inst_26140__$1 = cljs.core.not.call(null,inst_26139);
var state_26160__$1 = (function (){var statearr_26179 = state_26160;
(statearr_26179[(8)] = inst_26138__$1);

(statearr_26179[(11)] = inst_26140__$1);

return statearr_26179;
})();
if(inst_26140__$1){
var statearr_26180_26240 = state_26160__$1;
(statearr_26180_26240[(1)] = (15));

} else {
var statearr_26181_26241 = state_26160__$1;
(statearr_26181_26241[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26161 === (16))){
var inst_26140 = (state_26160[(11)]);
var state_26160__$1 = state_26160;
var statearr_26182_26242 = state_26160__$1;
(statearr_26182_26242[(2)] = inst_26140);

(statearr_26182_26242[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26161 === (10))){
var inst_26132 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26183_26243 = state_26160__$1;
(statearr_26183_26243[(2)] = inst_26132);

(statearr_26183_26243[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26161 === (18))){
var inst_26143 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26184_26244 = state_26160__$1;
(statearr_26184_26244[(2)] = inst_26143);

(statearr_26184_26244[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26161 === (8))){
var inst_26129 = cljs.core.async.close_BANG_.call(null,to);
var state_26160__$1 = state_26160;
var statearr_26185_26245 = state_26160__$1;
(statearr_26185_26245[(2)] = inst_26129);

(statearr_26185_26245[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto__,jobs,results,process,async))
;
return ((function (switch__25763__auto__,c__25854__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____0 = (function (){
var statearr_26186 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26186[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__);

(statearr_26186[(1)] = (1));

return statearr_26186;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____1 = (function (state_26160){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_26160);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e26187){if((e26187 instanceof Object)){
var ex__25767__auto__ = e26187;
var statearr_26188_26246 = state_26160;
(statearr_26188_26246[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26160);

return cljs.core.cst$kw$recur;
} else {
throw e26187;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__26247 = state_26160;
state_26160 = G__26247;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__ = function(state_26160){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____1.call(this,state_26160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25764__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto__,jobs,results,process,async))
})();
var state__25856__auto__ = (function (){var statearr_26189 = f__25855__auto__.call(null);
(statearr_26189[(6)] = c__25854__auto__);

return statearr_26189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto__,jobs,results,process,async))
);

return c__25854__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__26249 = arguments.length;
switch (G__26249) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__26252 = arguments.length;
switch (G__26252) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__26255 = arguments.length;
switch (G__26255) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__25854__auto___26304 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___26304,tc,fc){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___26304,tc,fc){
return (function (state_26281){
var state_val_26282 = (state_26281[(1)]);
if((state_val_26282 === (7))){
var inst_26277 = (state_26281[(2)]);
var state_26281__$1 = state_26281;
var statearr_26283_26305 = state_26281__$1;
(statearr_26283_26305[(2)] = inst_26277);

(statearr_26283_26305[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26282 === (1))){
var state_26281__$1 = state_26281;
var statearr_26284_26306 = state_26281__$1;
(statearr_26284_26306[(2)] = null);

(statearr_26284_26306[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26282 === (4))){
var inst_26258 = (state_26281[(7)]);
var inst_26258__$1 = (state_26281[(2)]);
var inst_26259 = (inst_26258__$1 == null);
var state_26281__$1 = (function (){var statearr_26285 = state_26281;
(statearr_26285[(7)] = inst_26258__$1);

return statearr_26285;
})();
if(cljs.core.truth_(inst_26259)){
var statearr_26286_26307 = state_26281__$1;
(statearr_26286_26307[(1)] = (5));

} else {
var statearr_26287_26308 = state_26281__$1;
(statearr_26287_26308[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26282 === (13))){
var state_26281__$1 = state_26281;
var statearr_26288_26309 = state_26281__$1;
(statearr_26288_26309[(2)] = null);

(statearr_26288_26309[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26282 === (6))){
var inst_26258 = (state_26281[(7)]);
var inst_26264 = p.call(null,inst_26258);
var state_26281__$1 = state_26281;
if(cljs.core.truth_(inst_26264)){
var statearr_26289_26310 = state_26281__$1;
(statearr_26289_26310[(1)] = (9));

} else {
var statearr_26290_26311 = state_26281__$1;
(statearr_26290_26311[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26282 === (3))){
var inst_26279 = (state_26281[(2)]);
var state_26281__$1 = state_26281;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26281__$1,inst_26279);
} else {
if((state_val_26282 === (12))){
var state_26281__$1 = state_26281;
var statearr_26291_26312 = state_26281__$1;
(statearr_26291_26312[(2)] = null);

(statearr_26291_26312[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26282 === (2))){
var state_26281__$1 = state_26281;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26281__$1,(4),ch);
} else {
if((state_val_26282 === (11))){
var inst_26258 = (state_26281[(7)]);
var inst_26268 = (state_26281[(2)]);
var state_26281__$1 = state_26281;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26281__$1,(8),inst_26268,inst_26258);
} else {
if((state_val_26282 === (9))){
var state_26281__$1 = state_26281;
var statearr_26292_26313 = state_26281__$1;
(statearr_26292_26313[(2)] = tc);

(statearr_26292_26313[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26282 === (5))){
var inst_26261 = cljs.core.async.close_BANG_.call(null,tc);
var inst_26262 = cljs.core.async.close_BANG_.call(null,fc);
var state_26281__$1 = (function (){var statearr_26293 = state_26281;
(statearr_26293[(8)] = inst_26261);

return statearr_26293;
})();
var statearr_26294_26314 = state_26281__$1;
(statearr_26294_26314[(2)] = inst_26262);

(statearr_26294_26314[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26282 === (14))){
var inst_26275 = (state_26281[(2)]);
var state_26281__$1 = state_26281;
var statearr_26295_26315 = state_26281__$1;
(statearr_26295_26315[(2)] = inst_26275);

(statearr_26295_26315[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26282 === (10))){
var state_26281__$1 = state_26281;
var statearr_26296_26316 = state_26281__$1;
(statearr_26296_26316[(2)] = fc);

(statearr_26296_26316[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26282 === (8))){
var inst_26270 = (state_26281[(2)]);
var state_26281__$1 = state_26281;
if(cljs.core.truth_(inst_26270)){
var statearr_26297_26317 = state_26281__$1;
(statearr_26297_26317[(1)] = (12));

} else {
var statearr_26298_26318 = state_26281__$1;
(statearr_26298_26318[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto___26304,tc,fc))
;
return ((function (switch__25763__auto__,c__25854__auto___26304,tc,fc){
return (function() {
var cljs$core$async$state_machine__25764__auto__ = null;
var cljs$core$async$state_machine__25764__auto____0 = (function (){
var statearr_26299 = [null,null,null,null,null,null,null,null,null];
(statearr_26299[(0)] = cljs$core$async$state_machine__25764__auto__);

(statearr_26299[(1)] = (1));

return statearr_26299;
});
var cljs$core$async$state_machine__25764__auto____1 = (function (state_26281){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_26281);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e26300){if((e26300 instanceof Object)){
var ex__25767__auto__ = e26300;
var statearr_26301_26319 = state_26281;
(statearr_26301_26319[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26281);

return cljs.core.cst$kw$recur;
} else {
throw e26300;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__26320 = state_26281;
state_26281 = G__26320;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$state_machine__25764__auto__ = function(state_26281){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25764__auto____1.call(this,state_26281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25764__auto____0;
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25764__auto____1;
return cljs$core$async$state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___26304,tc,fc))
})();
var state__25856__auto__ = (function (){var statearr_26302 = f__25855__auto__.call(null);
(statearr_26302[(6)] = c__25854__auto___26304);

return statearr_26302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___26304,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__25854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto__){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto__){
return (function (state_26341){
var state_val_26342 = (state_26341[(1)]);
if((state_val_26342 === (7))){
var inst_26337 = (state_26341[(2)]);
var state_26341__$1 = state_26341;
var statearr_26343_26361 = state_26341__$1;
(statearr_26343_26361[(2)] = inst_26337);

(statearr_26343_26361[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26342 === (1))){
var inst_26321 = init;
var state_26341__$1 = (function (){var statearr_26344 = state_26341;
(statearr_26344[(7)] = inst_26321);

return statearr_26344;
})();
var statearr_26345_26362 = state_26341__$1;
(statearr_26345_26362[(2)] = null);

(statearr_26345_26362[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26342 === (4))){
var inst_26324 = (state_26341[(8)]);
var inst_26324__$1 = (state_26341[(2)]);
var inst_26325 = (inst_26324__$1 == null);
var state_26341__$1 = (function (){var statearr_26346 = state_26341;
(statearr_26346[(8)] = inst_26324__$1);

return statearr_26346;
})();
if(cljs.core.truth_(inst_26325)){
var statearr_26347_26363 = state_26341__$1;
(statearr_26347_26363[(1)] = (5));

} else {
var statearr_26348_26364 = state_26341__$1;
(statearr_26348_26364[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26342 === (6))){
var inst_26328 = (state_26341[(9)]);
var inst_26324 = (state_26341[(8)]);
var inst_26321 = (state_26341[(7)]);
var inst_26328__$1 = f.call(null,inst_26321,inst_26324);
var inst_26329 = cljs.core.reduced_QMARK_.call(null,inst_26328__$1);
var state_26341__$1 = (function (){var statearr_26349 = state_26341;
(statearr_26349[(9)] = inst_26328__$1);

return statearr_26349;
})();
if(inst_26329){
var statearr_26350_26365 = state_26341__$1;
(statearr_26350_26365[(1)] = (8));

} else {
var statearr_26351_26366 = state_26341__$1;
(statearr_26351_26366[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26342 === (3))){
var inst_26339 = (state_26341[(2)]);
var state_26341__$1 = state_26341;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26341__$1,inst_26339);
} else {
if((state_val_26342 === (2))){
var state_26341__$1 = state_26341;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26341__$1,(4),ch);
} else {
if((state_val_26342 === (9))){
var inst_26328 = (state_26341[(9)]);
var inst_26321 = inst_26328;
var state_26341__$1 = (function (){var statearr_26352 = state_26341;
(statearr_26352[(7)] = inst_26321);

return statearr_26352;
})();
var statearr_26353_26367 = state_26341__$1;
(statearr_26353_26367[(2)] = null);

(statearr_26353_26367[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26342 === (5))){
var inst_26321 = (state_26341[(7)]);
var state_26341__$1 = state_26341;
var statearr_26354_26368 = state_26341__$1;
(statearr_26354_26368[(2)] = inst_26321);

(statearr_26354_26368[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26342 === (10))){
var inst_26335 = (state_26341[(2)]);
var state_26341__$1 = state_26341;
var statearr_26355_26369 = state_26341__$1;
(statearr_26355_26369[(2)] = inst_26335);

(statearr_26355_26369[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26342 === (8))){
var inst_26328 = (state_26341[(9)]);
var inst_26331 = cljs.core.deref.call(null,inst_26328);
var state_26341__$1 = state_26341;
var statearr_26356_26370 = state_26341__$1;
(statearr_26356_26370[(2)] = inst_26331);

(statearr_26356_26370[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto__))
;
return ((function (switch__25763__auto__,c__25854__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__25764__auto__ = null;
var cljs$core$async$reduce_$_state_machine__25764__auto____0 = (function (){
var statearr_26357 = [null,null,null,null,null,null,null,null,null,null];
(statearr_26357[(0)] = cljs$core$async$reduce_$_state_machine__25764__auto__);

(statearr_26357[(1)] = (1));

return statearr_26357;
});
var cljs$core$async$reduce_$_state_machine__25764__auto____1 = (function (state_26341){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_26341);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e26358){if((e26358 instanceof Object)){
var ex__25767__auto__ = e26358;
var statearr_26359_26371 = state_26341;
(statearr_26359_26371[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26341);

return cljs.core.cst$kw$recur;
} else {
throw e26358;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__26372 = state_26341;
state_26341 = G__26372;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__25764__auto__ = function(state_26341){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__25764__auto____1.call(this,state_26341);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__25764__auto____0;
cljs$core$async$reduce_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__25764__auto____1;
return cljs$core$async$reduce_$_state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto__))
})();
var state__25856__auto__ = (function (){var statearr_26360 = f__25855__auto__.call(null);
(statearr_26360[(6)] = c__25854__auto__);

return statearr_26360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto__))
);

return c__25854__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__25854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto__,f__$1){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto__,f__$1){
return (function (state_26378){
var state_val_26379 = (state_26378[(1)]);
if((state_val_26379 === (1))){
var inst_26373 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_26378__$1 = state_26378;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26378__$1,(2),inst_26373);
} else {
if((state_val_26379 === (2))){
var inst_26375 = (state_26378[(2)]);
var inst_26376 = f__$1.call(null,inst_26375);
var state_26378__$1 = state_26378;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26378__$1,inst_26376);
} else {
return null;
}
}
});})(c__25854__auto__,f__$1))
;
return ((function (switch__25763__auto__,c__25854__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__25764__auto__ = null;
var cljs$core$async$transduce_$_state_machine__25764__auto____0 = (function (){
var statearr_26380 = [null,null,null,null,null,null,null];
(statearr_26380[(0)] = cljs$core$async$transduce_$_state_machine__25764__auto__);

(statearr_26380[(1)] = (1));

return statearr_26380;
});
var cljs$core$async$transduce_$_state_machine__25764__auto____1 = (function (state_26378){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_26378);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e26381){if((e26381 instanceof Object)){
var ex__25767__auto__ = e26381;
var statearr_26382_26384 = state_26378;
(statearr_26382_26384[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26378);

return cljs.core.cst$kw$recur;
} else {
throw e26381;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__26385 = state_26378;
state_26378 = G__26385;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__25764__auto__ = function(state_26378){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__25764__auto____1.call(this,state_26378);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__25764__auto____0;
cljs$core$async$transduce_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__25764__auto____1;
return cljs$core$async$transduce_$_state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto__,f__$1))
})();
var state__25856__auto__ = (function (){var statearr_26383 = f__25855__auto__.call(null);
(statearr_26383[(6)] = c__25854__auto__);

return statearr_26383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto__,f__$1))
);

return c__25854__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__26387 = arguments.length;
switch (G__26387) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__25854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto__){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto__){
return (function (state_26412){
var state_val_26413 = (state_26412[(1)]);
if((state_val_26413 === (7))){
var inst_26394 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26414_26435 = state_26412__$1;
(statearr_26414_26435[(2)] = inst_26394);

(statearr_26414_26435[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26413 === (1))){
var inst_26388 = cljs.core.seq.call(null,coll);
var inst_26389 = inst_26388;
var state_26412__$1 = (function (){var statearr_26415 = state_26412;
(statearr_26415[(7)] = inst_26389);

return statearr_26415;
})();
var statearr_26416_26436 = state_26412__$1;
(statearr_26416_26436[(2)] = null);

(statearr_26416_26436[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26413 === (4))){
var inst_26389 = (state_26412[(7)]);
var inst_26392 = cljs.core.first.call(null,inst_26389);
var state_26412__$1 = state_26412;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26412__$1,(7),ch,inst_26392);
} else {
if((state_val_26413 === (13))){
var inst_26406 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26417_26437 = state_26412__$1;
(statearr_26417_26437[(2)] = inst_26406);

(statearr_26417_26437[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26413 === (6))){
var inst_26397 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26397)){
var statearr_26418_26438 = state_26412__$1;
(statearr_26418_26438[(1)] = (8));

} else {
var statearr_26419_26439 = state_26412__$1;
(statearr_26419_26439[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26413 === (3))){
var inst_26410 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26412__$1,inst_26410);
} else {
if((state_val_26413 === (12))){
var state_26412__$1 = state_26412;
var statearr_26420_26440 = state_26412__$1;
(statearr_26420_26440[(2)] = null);

(statearr_26420_26440[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26413 === (2))){
var inst_26389 = (state_26412[(7)]);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26389)){
var statearr_26421_26441 = state_26412__$1;
(statearr_26421_26441[(1)] = (4));

} else {
var statearr_26422_26442 = state_26412__$1;
(statearr_26422_26442[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26413 === (11))){
var inst_26403 = cljs.core.async.close_BANG_.call(null,ch);
var state_26412__$1 = state_26412;
var statearr_26423_26443 = state_26412__$1;
(statearr_26423_26443[(2)] = inst_26403);

(statearr_26423_26443[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26413 === (9))){
var state_26412__$1 = state_26412;
if(cljs.core.truth_(close_QMARK_)){
var statearr_26424_26444 = state_26412__$1;
(statearr_26424_26444[(1)] = (11));

} else {
var statearr_26425_26445 = state_26412__$1;
(statearr_26425_26445[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26413 === (5))){
var inst_26389 = (state_26412[(7)]);
var state_26412__$1 = state_26412;
var statearr_26426_26446 = state_26412__$1;
(statearr_26426_26446[(2)] = inst_26389);

(statearr_26426_26446[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26413 === (10))){
var inst_26408 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26427_26447 = state_26412__$1;
(statearr_26427_26447[(2)] = inst_26408);

(statearr_26427_26447[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26413 === (8))){
var inst_26389 = (state_26412[(7)]);
var inst_26399 = cljs.core.next.call(null,inst_26389);
var inst_26389__$1 = inst_26399;
var state_26412__$1 = (function (){var statearr_26428 = state_26412;
(statearr_26428[(7)] = inst_26389__$1);

return statearr_26428;
})();
var statearr_26429_26448 = state_26412__$1;
(statearr_26429_26448[(2)] = null);

(statearr_26429_26448[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto__))
;
return ((function (switch__25763__auto__,c__25854__auto__){
return (function() {
var cljs$core$async$state_machine__25764__auto__ = null;
var cljs$core$async$state_machine__25764__auto____0 = (function (){
var statearr_26430 = [null,null,null,null,null,null,null,null];
(statearr_26430[(0)] = cljs$core$async$state_machine__25764__auto__);

(statearr_26430[(1)] = (1));

return statearr_26430;
});
var cljs$core$async$state_machine__25764__auto____1 = (function (state_26412){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_26412);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e26431){if((e26431 instanceof Object)){
var ex__25767__auto__ = e26431;
var statearr_26432_26449 = state_26412;
(statearr_26432_26449[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26412);

return cljs.core.cst$kw$recur;
} else {
throw e26431;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__26450 = state_26412;
state_26412 = G__26450;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$state_machine__25764__auto__ = function(state_26412){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25764__auto____1.call(this,state_26412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25764__auto____0;
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25764__auto____1;
return cljs$core$async$state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto__))
})();
var state__25856__auto__ = (function (){var statearr_26433 = f__25855__auto__.call(null);
(statearr_26433[(6)] = c__25854__auto__);

return statearr_26433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto__))
);

return c__25854__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if(((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,_);
} else {
var m__4244__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4244__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,ch);
} else {
var m__4244__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m);
} else {
var m__4244__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26451 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26451 = (function (ch,cs,meta26452){
this.ch = ch;
this.cs = cs;
this.meta26452 = meta26452;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26451.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_26453,meta26452__$1){
var self__ = this;
var _26453__$1 = this;
return (new cljs.core.async.t_cljs$core$async26451(self__.ch,self__.cs,meta26452__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async26451.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_26453){
var self__ = this;
var _26453__$1 = this;
return self__.meta26452;
});})(cs))
;

cljs.core.async.t_cljs$core$async26451.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26451.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async26451.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26451.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async26451.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async26451.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async26451.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta26452], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async26451.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26451.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26451";

cljs.core.async.t_cljs$core$async26451.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async26451");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26451.
 */
cljs.core.async.__GT_t_cljs$core$async26451 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async26451(ch__$1,cs__$1,meta26452){
return (new cljs.core.async.t_cljs$core$async26451(ch__$1,cs__$1,meta26452));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async26451(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__25854__auto___26673 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___26673,cs,m,dchan,dctr,done){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___26673,cs,m,dchan,dctr,done){
return (function (state_26588){
var state_val_26589 = (state_26588[(1)]);
if((state_val_26589 === (7))){
var inst_26584 = (state_26588[(2)]);
var state_26588__$1 = state_26588;
var statearr_26590_26674 = state_26588__$1;
(statearr_26590_26674[(2)] = inst_26584);

(statearr_26590_26674[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (20))){
var inst_26487 = (state_26588[(7)]);
var inst_26499 = cljs.core.first.call(null,inst_26487);
var inst_26500 = cljs.core.nth.call(null,inst_26499,(0),null);
var inst_26501 = cljs.core.nth.call(null,inst_26499,(1),null);
var state_26588__$1 = (function (){var statearr_26591 = state_26588;
(statearr_26591[(8)] = inst_26500);

return statearr_26591;
})();
if(cljs.core.truth_(inst_26501)){
var statearr_26592_26675 = state_26588__$1;
(statearr_26592_26675[(1)] = (22));

} else {
var statearr_26593_26676 = state_26588__$1;
(statearr_26593_26676[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (27))){
var inst_26536 = (state_26588[(9)]);
var inst_26531 = (state_26588[(10)]);
var inst_26456 = (state_26588[(11)]);
var inst_26529 = (state_26588[(12)]);
var inst_26536__$1 = cljs.core._nth.call(null,inst_26529,inst_26531);
var inst_26537 = cljs.core.async.put_BANG_.call(null,inst_26536__$1,inst_26456,done);
var state_26588__$1 = (function (){var statearr_26594 = state_26588;
(statearr_26594[(9)] = inst_26536__$1);

return statearr_26594;
})();
if(cljs.core.truth_(inst_26537)){
var statearr_26595_26677 = state_26588__$1;
(statearr_26595_26677[(1)] = (30));

} else {
var statearr_26596_26678 = state_26588__$1;
(statearr_26596_26678[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (1))){
var state_26588__$1 = state_26588;
var statearr_26597_26679 = state_26588__$1;
(statearr_26597_26679[(2)] = null);

(statearr_26597_26679[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (24))){
var inst_26487 = (state_26588[(7)]);
var inst_26506 = (state_26588[(2)]);
var inst_26507 = cljs.core.next.call(null,inst_26487);
var inst_26465 = inst_26507;
var inst_26466 = null;
var inst_26467 = (0);
var inst_26468 = (0);
var state_26588__$1 = (function (){var statearr_26598 = state_26588;
(statearr_26598[(13)] = inst_26506);

(statearr_26598[(14)] = inst_26466);

(statearr_26598[(15)] = inst_26468);

(statearr_26598[(16)] = inst_26467);

(statearr_26598[(17)] = inst_26465);

return statearr_26598;
})();
var statearr_26599_26680 = state_26588__$1;
(statearr_26599_26680[(2)] = null);

(statearr_26599_26680[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (39))){
var state_26588__$1 = state_26588;
var statearr_26603_26681 = state_26588__$1;
(statearr_26603_26681[(2)] = null);

(statearr_26603_26681[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (4))){
var inst_26456 = (state_26588[(11)]);
var inst_26456__$1 = (state_26588[(2)]);
var inst_26457 = (inst_26456__$1 == null);
var state_26588__$1 = (function (){var statearr_26604 = state_26588;
(statearr_26604[(11)] = inst_26456__$1);

return statearr_26604;
})();
if(cljs.core.truth_(inst_26457)){
var statearr_26605_26682 = state_26588__$1;
(statearr_26605_26682[(1)] = (5));

} else {
var statearr_26606_26683 = state_26588__$1;
(statearr_26606_26683[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (15))){
var inst_26466 = (state_26588[(14)]);
var inst_26468 = (state_26588[(15)]);
var inst_26467 = (state_26588[(16)]);
var inst_26465 = (state_26588[(17)]);
var inst_26483 = (state_26588[(2)]);
var inst_26484 = (inst_26468 + (1));
var tmp26600 = inst_26466;
var tmp26601 = inst_26467;
var tmp26602 = inst_26465;
var inst_26465__$1 = tmp26602;
var inst_26466__$1 = tmp26600;
var inst_26467__$1 = tmp26601;
var inst_26468__$1 = inst_26484;
var state_26588__$1 = (function (){var statearr_26607 = state_26588;
(statearr_26607[(18)] = inst_26483);

(statearr_26607[(14)] = inst_26466__$1);

(statearr_26607[(15)] = inst_26468__$1);

(statearr_26607[(16)] = inst_26467__$1);

(statearr_26607[(17)] = inst_26465__$1);

return statearr_26607;
})();
var statearr_26608_26684 = state_26588__$1;
(statearr_26608_26684[(2)] = null);

(statearr_26608_26684[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (21))){
var inst_26510 = (state_26588[(2)]);
var state_26588__$1 = state_26588;
var statearr_26612_26685 = state_26588__$1;
(statearr_26612_26685[(2)] = inst_26510);

(statearr_26612_26685[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (31))){
var inst_26536 = (state_26588[(9)]);
var inst_26540 = done.call(null,null);
var inst_26541 = cljs.core.async.untap_STAR_.call(null,m,inst_26536);
var state_26588__$1 = (function (){var statearr_26613 = state_26588;
(statearr_26613[(19)] = inst_26540);

return statearr_26613;
})();
var statearr_26614_26686 = state_26588__$1;
(statearr_26614_26686[(2)] = inst_26541);

(statearr_26614_26686[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (32))){
var inst_26531 = (state_26588[(10)]);
var inst_26530 = (state_26588[(20)]);
var inst_26528 = (state_26588[(21)]);
var inst_26529 = (state_26588[(12)]);
var inst_26543 = (state_26588[(2)]);
var inst_26544 = (inst_26531 + (1));
var tmp26609 = inst_26530;
var tmp26610 = inst_26528;
var tmp26611 = inst_26529;
var inst_26528__$1 = tmp26610;
var inst_26529__$1 = tmp26611;
var inst_26530__$1 = tmp26609;
var inst_26531__$1 = inst_26544;
var state_26588__$1 = (function (){var statearr_26615 = state_26588;
(statearr_26615[(22)] = inst_26543);

(statearr_26615[(10)] = inst_26531__$1);

(statearr_26615[(20)] = inst_26530__$1);

(statearr_26615[(21)] = inst_26528__$1);

(statearr_26615[(12)] = inst_26529__$1);

return statearr_26615;
})();
var statearr_26616_26687 = state_26588__$1;
(statearr_26616_26687[(2)] = null);

(statearr_26616_26687[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (40))){
var inst_26556 = (state_26588[(23)]);
var inst_26560 = done.call(null,null);
var inst_26561 = cljs.core.async.untap_STAR_.call(null,m,inst_26556);
var state_26588__$1 = (function (){var statearr_26617 = state_26588;
(statearr_26617[(24)] = inst_26560);

return statearr_26617;
})();
var statearr_26618_26688 = state_26588__$1;
(statearr_26618_26688[(2)] = inst_26561);

(statearr_26618_26688[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (33))){
var inst_26547 = (state_26588[(25)]);
var inst_26549 = cljs.core.chunked_seq_QMARK_.call(null,inst_26547);
var state_26588__$1 = state_26588;
if(inst_26549){
var statearr_26619_26689 = state_26588__$1;
(statearr_26619_26689[(1)] = (36));

} else {
var statearr_26620_26690 = state_26588__$1;
(statearr_26620_26690[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (13))){
var inst_26477 = (state_26588[(26)]);
var inst_26480 = cljs.core.async.close_BANG_.call(null,inst_26477);
var state_26588__$1 = state_26588;
var statearr_26621_26691 = state_26588__$1;
(statearr_26621_26691[(2)] = inst_26480);

(statearr_26621_26691[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (22))){
var inst_26500 = (state_26588[(8)]);
var inst_26503 = cljs.core.async.close_BANG_.call(null,inst_26500);
var state_26588__$1 = state_26588;
var statearr_26622_26692 = state_26588__$1;
(statearr_26622_26692[(2)] = inst_26503);

(statearr_26622_26692[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (36))){
var inst_26547 = (state_26588[(25)]);
var inst_26551 = cljs.core.chunk_first.call(null,inst_26547);
var inst_26552 = cljs.core.chunk_rest.call(null,inst_26547);
var inst_26553 = cljs.core.count.call(null,inst_26551);
var inst_26528 = inst_26552;
var inst_26529 = inst_26551;
var inst_26530 = inst_26553;
var inst_26531 = (0);
var state_26588__$1 = (function (){var statearr_26623 = state_26588;
(statearr_26623[(10)] = inst_26531);

(statearr_26623[(20)] = inst_26530);

(statearr_26623[(21)] = inst_26528);

(statearr_26623[(12)] = inst_26529);

return statearr_26623;
})();
var statearr_26624_26693 = state_26588__$1;
(statearr_26624_26693[(2)] = null);

(statearr_26624_26693[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (41))){
var inst_26547 = (state_26588[(25)]);
var inst_26563 = (state_26588[(2)]);
var inst_26564 = cljs.core.next.call(null,inst_26547);
var inst_26528 = inst_26564;
var inst_26529 = null;
var inst_26530 = (0);
var inst_26531 = (0);
var state_26588__$1 = (function (){var statearr_26625 = state_26588;
(statearr_26625[(27)] = inst_26563);

(statearr_26625[(10)] = inst_26531);

(statearr_26625[(20)] = inst_26530);

(statearr_26625[(21)] = inst_26528);

(statearr_26625[(12)] = inst_26529);

return statearr_26625;
})();
var statearr_26626_26694 = state_26588__$1;
(statearr_26626_26694[(2)] = null);

(statearr_26626_26694[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (43))){
var state_26588__$1 = state_26588;
var statearr_26627_26695 = state_26588__$1;
(statearr_26627_26695[(2)] = null);

(statearr_26627_26695[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (29))){
var inst_26572 = (state_26588[(2)]);
var state_26588__$1 = state_26588;
var statearr_26628_26696 = state_26588__$1;
(statearr_26628_26696[(2)] = inst_26572);

(statearr_26628_26696[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (44))){
var inst_26581 = (state_26588[(2)]);
var state_26588__$1 = (function (){var statearr_26629 = state_26588;
(statearr_26629[(28)] = inst_26581);

return statearr_26629;
})();
var statearr_26630_26697 = state_26588__$1;
(statearr_26630_26697[(2)] = null);

(statearr_26630_26697[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (6))){
var inst_26520 = (state_26588[(29)]);
var inst_26519 = cljs.core.deref.call(null,cs);
var inst_26520__$1 = cljs.core.keys.call(null,inst_26519);
var inst_26521 = cljs.core.count.call(null,inst_26520__$1);
var inst_26522 = cljs.core.reset_BANG_.call(null,dctr,inst_26521);
var inst_26527 = cljs.core.seq.call(null,inst_26520__$1);
var inst_26528 = inst_26527;
var inst_26529 = null;
var inst_26530 = (0);
var inst_26531 = (0);
var state_26588__$1 = (function (){var statearr_26631 = state_26588;
(statearr_26631[(10)] = inst_26531);

(statearr_26631[(20)] = inst_26530);

(statearr_26631[(30)] = inst_26522);

(statearr_26631[(21)] = inst_26528);

(statearr_26631[(29)] = inst_26520__$1);

(statearr_26631[(12)] = inst_26529);

return statearr_26631;
})();
var statearr_26632_26698 = state_26588__$1;
(statearr_26632_26698[(2)] = null);

(statearr_26632_26698[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (28))){
var inst_26547 = (state_26588[(25)]);
var inst_26528 = (state_26588[(21)]);
var inst_26547__$1 = cljs.core.seq.call(null,inst_26528);
var state_26588__$1 = (function (){var statearr_26633 = state_26588;
(statearr_26633[(25)] = inst_26547__$1);

return statearr_26633;
})();
if(inst_26547__$1){
var statearr_26634_26699 = state_26588__$1;
(statearr_26634_26699[(1)] = (33));

} else {
var statearr_26635_26700 = state_26588__$1;
(statearr_26635_26700[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (25))){
var inst_26531 = (state_26588[(10)]);
var inst_26530 = (state_26588[(20)]);
var inst_26533 = (inst_26531 < inst_26530);
var inst_26534 = inst_26533;
var state_26588__$1 = state_26588;
if(cljs.core.truth_(inst_26534)){
var statearr_26636_26701 = state_26588__$1;
(statearr_26636_26701[(1)] = (27));

} else {
var statearr_26637_26702 = state_26588__$1;
(statearr_26637_26702[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (34))){
var state_26588__$1 = state_26588;
var statearr_26638_26703 = state_26588__$1;
(statearr_26638_26703[(2)] = null);

(statearr_26638_26703[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (17))){
var state_26588__$1 = state_26588;
var statearr_26639_26704 = state_26588__$1;
(statearr_26639_26704[(2)] = null);

(statearr_26639_26704[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (3))){
var inst_26586 = (state_26588[(2)]);
var state_26588__$1 = state_26588;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26588__$1,inst_26586);
} else {
if((state_val_26589 === (12))){
var inst_26515 = (state_26588[(2)]);
var state_26588__$1 = state_26588;
var statearr_26640_26705 = state_26588__$1;
(statearr_26640_26705[(2)] = inst_26515);

(statearr_26640_26705[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (2))){
var state_26588__$1 = state_26588;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26588__$1,(4),ch);
} else {
if((state_val_26589 === (23))){
var state_26588__$1 = state_26588;
var statearr_26641_26706 = state_26588__$1;
(statearr_26641_26706[(2)] = null);

(statearr_26641_26706[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (35))){
var inst_26570 = (state_26588[(2)]);
var state_26588__$1 = state_26588;
var statearr_26642_26707 = state_26588__$1;
(statearr_26642_26707[(2)] = inst_26570);

(statearr_26642_26707[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (19))){
var inst_26487 = (state_26588[(7)]);
var inst_26491 = cljs.core.chunk_first.call(null,inst_26487);
var inst_26492 = cljs.core.chunk_rest.call(null,inst_26487);
var inst_26493 = cljs.core.count.call(null,inst_26491);
var inst_26465 = inst_26492;
var inst_26466 = inst_26491;
var inst_26467 = inst_26493;
var inst_26468 = (0);
var state_26588__$1 = (function (){var statearr_26643 = state_26588;
(statearr_26643[(14)] = inst_26466);

(statearr_26643[(15)] = inst_26468);

(statearr_26643[(16)] = inst_26467);

(statearr_26643[(17)] = inst_26465);

return statearr_26643;
})();
var statearr_26644_26708 = state_26588__$1;
(statearr_26644_26708[(2)] = null);

(statearr_26644_26708[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (11))){
var inst_26487 = (state_26588[(7)]);
var inst_26465 = (state_26588[(17)]);
var inst_26487__$1 = cljs.core.seq.call(null,inst_26465);
var state_26588__$1 = (function (){var statearr_26645 = state_26588;
(statearr_26645[(7)] = inst_26487__$1);

return statearr_26645;
})();
if(inst_26487__$1){
var statearr_26646_26709 = state_26588__$1;
(statearr_26646_26709[(1)] = (16));

} else {
var statearr_26647_26710 = state_26588__$1;
(statearr_26647_26710[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (9))){
var inst_26517 = (state_26588[(2)]);
var state_26588__$1 = state_26588;
var statearr_26648_26711 = state_26588__$1;
(statearr_26648_26711[(2)] = inst_26517);

(statearr_26648_26711[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (5))){
var inst_26463 = cljs.core.deref.call(null,cs);
var inst_26464 = cljs.core.seq.call(null,inst_26463);
var inst_26465 = inst_26464;
var inst_26466 = null;
var inst_26467 = (0);
var inst_26468 = (0);
var state_26588__$1 = (function (){var statearr_26649 = state_26588;
(statearr_26649[(14)] = inst_26466);

(statearr_26649[(15)] = inst_26468);

(statearr_26649[(16)] = inst_26467);

(statearr_26649[(17)] = inst_26465);

return statearr_26649;
})();
var statearr_26650_26712 = state_26588__$1;
(statearr_26650_26712[(2)] = null);

(statearr_26650_26712[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (14))){
var state_26588__$1 = state_26588;
var statearr_26651_26713 = state_26588__$1;
(statearr_26651_26713[(2)] = null);

(statearr_26651_26713[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (45))){
var inst_26578 = (state_26588[(2)]);
var state_26588__$1 = state_26588;
var statearr_26652_26714 = state_26588__$1;
(statearr_26652_26714[(2)] = inst_26578);

(statearr_26652_26714[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (26))){
var inst_26520 = (state_26588[(29)]);
var inst_26574 = (state_26588[(2)]);
var inst_26575 = cljs.core.seq.call(null,inst_26520);
var state_26588__$1 = (function (){var statearr_26653 = state_26588;
(statearr_26653[(31)] = inst_26574);

return statearr_26653;
})();
if(inst_26575){
var statearr_26654_26715 = state_26588__$1;
(statearr_26654_26715[(1)] = (42));

} else {
var statearr_26655_26716 = state_26588__$1;
(statearr_26655_26716[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (16))){
var inst_26487 = (state_26588[(7)]);
var inst_26489 = cljs.core.chunked_seq_QMARK_.call(null,inst_26487);
var state_26588__$1 = state_26588;
if(inst_26489){
var statearr_26656_26717 = state_26588__$1;
(statearr_26656_26717[(1)] = (19));

} else {
var statearr_26657_26718 = state_26588__$1;
(statearr_26657_26718[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (38))){
var inst_26567 = (state_26588[(2)]);
var state_26588__$1 = state_26588;
var statearr_26658_26719 = state_26588__$1;
(statearr_26658_26719[(2)] = inst_26567);

(statearr_26658_26719[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (30))){
var state_26588__$1 = state_26588;
var statearr_26659_26720 = state_26588__$1;
(statearr_26659_26720[(2)] = null);

(statearr_26659_26720[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (10))){
var inst_26466 = (state_26588[(14)]);
var inst_26468 = (state_26588[(15)]);
var inst_26476 = cljs.core._nth.call(null,inst_26466,inst_26468);
var inst_26477 = cljs.core.nth.call(null,inst_26476,(0),null);
var inst_26478 = cljs.core.nth.call(null,inst_26476,(1),null);
var state_26588__$1 = (function (){var statearr_26660 = state_26588;
(statearr_26660[(26)] = inst_26477);

return statearr_26660;
})();
if(cljs.core.truth_(inst_26478)){
var statearr_26661_26721 = state_26588__$1;
(statearr_26661_26721[(1)] = (13));

} else {
var statearr_26662_26722 = state_26588__$1;
(statearr_26662_26722[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (18))){
var inst_26513 = (state_26588[(2)]);
var state_26588__$1 = state_26588;
var statearr_26663_26723 = state_26588__$1;
(statearr_26663_26723[(2)] = inst_26513);

(statearr_26663_26723[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (42))){
var state_26588__$1 = state_26588;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26588__$1,(45),dchan);
} else {
if((state_val_26589 === (37))){
var inst_26556 = (state_26588[(23)]);
var inst_26547 = (state_26588[(25)]);
var inst_26456 = (state_26588[(11)]);
var inst_26556__$1 = cljs.core.first.call(null,inst_26547);
var inst_26557 = cljs.core.async.put_BANG_.call(null,inst_26556__$1,inst_26456,done);
var state_26588__$1 = (function (){var statearr_26664 = state_26588;
(statearr_26664[(23)] = inst_26556__$1);

return statearr_26664;
})();
if(cljs.core.truth_(inst_26557)){
var statearr_26665_26724 = state_26588__$1;
(statearr_26665_26724[(1)] = (39));

} else {
var statearr_26666_26725 = state_26588__$1;
(statearr_26666_26725[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26589 === (8))){
var inst_26468 = (state_26588[(15)]);
var inst_26467 = (state_26588[(16)]);
var inst_26470 = (inst_26468 < inst_26467);
var inst_26471 = inst_26470;
var state_26588__$1 = state_26588;
if(cljs.core.truth_(inst_26471)){
var statearr_26667_26726 = state_26588__$1;
(statearr_26667_26726[(1)] = (10));

} else {
var statearr_26668_26727 = state_26588__$1;
(statearr_26668_26727[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto___26673,cs,m,dchan,dctr,done))
;
return ((function (switch__25763__auto__,c__25854__auto___26673,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__25764__auto__ = null;
var cljs$core$async$mult_$_state_machine__25764__auto____0 = (function (){
var statearr_26669 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26669[(0)] = cljs$core$async$mult_$_state_machine__25764__auto__);

(statearr_26669[(1)] = (1));

return statearr_26669;
});
var cljs$core$async$mult_$_state_machine__25764__auto____1 = (function (state_26588){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_26588);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e26670){if((e26670 instanceof Object)){
var ex__25767__auto__ = e26670;
var statearr_26671_26728 = state_26588;
(statearr_26671_26728[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26588);

return cljs.core.cst$kw$recur;
} else {
throw e26670;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__26729 = state_26588;
state_26588 = G__26729;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__25764__auto__ = function(state_26588){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__25764__auto____1.call(this,state_26588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__25764__auto____0;
cljs$core$async$mult_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__25764__auto____1;
return cljs$core$async$mult_$_state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___26673,cs,m,dchan,dctr,done))
})();
var state__25856__auto__ = (function (){var statearr_26672 = f__25855__auto__.call(null);
(statearr_26672[(6)] = c__25854__auto___26673);

return statearr_26672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___26673,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__26731 = arguments.length;
switch (G__26731) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,ch);
} else {
var m__4244__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,ch);
} else {
var m__4244__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m);
} else {
var m__4244__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,state_map);
} else {
var m__4244__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,mode);
} else {
var m__4244__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___26743 = arguments.length;
var i__4532__auto___26744 = (0);
while(true){
if((i__4532__auto___26744 < len__4531__auto___26743)){
args__4534__auto__.push((arguments[i__4532__auto___26744]));

var G__26745 = (i__4532__auto___26744 + (1));
i__4532__auto___26744 = G__26745;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__26737){
var map__26738 = p__26737;
var map__26738__$1 = ((((!((map__26738 == null)))?(((((map__26738.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26738.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26738):map__26738);
var opts = map__26738__$1;
var statearr_26740_26746 = state;
(statearr_26740_26746[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts.call(null,((function (map__26738,map__26738__$1,opts){
return (function (val){
var statearr_26741_26747 = state;
(statearr_26741_26747[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__26738,map__26738__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_26742_26748 = state;
(statearr_26742_26748[(2)] = cljs.core.deref.call(null,cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq26733){
var G__26734 = cljs.core.first.call(null,seq26733);
var seq26733__$1 = cljs.core.next.call(null,seq26733);
var G__26735 = cljs.core.first.call(null,seq26733__$1);
var seq26733__$2 = cljs.core.next.call(null,seq26733__$1);
var G__26736 = cljs.core.first.call(null,seq26733__$2);
var seq26733__$3 = cljs.core.next.call(null,seq26733__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__26734,G__26735,G__26736,seq26733__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.call(null,cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,cljs.core.cst$kw$solo,chs);
var pauses = pick.call(null,cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick.call(null,cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_.call(null,solos)))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26749 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26749 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta26750){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta26750 = meta26750;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26749.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_26751,meta26750__$1){
var self__ = this;
var _26751__$1 = this;
return (new cljs.core.async.t_cljs$core$async26749(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta26750__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26749.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_26751){
var self__ = this;
var _26751__$1 = this;
return self__.meta26750;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26749.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26749.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26749.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26749.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26749.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26749.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26749.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26749.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26749.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta26750], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26749.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26749.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26749";

cljs.core.async.t_cljs$core$async26749.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async26749");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26749.
 */
cljs.core.async.__GT_t_cljs$core$async26749 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async26749(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta26750){
return (new cljs.core.async.t_cljs$core$async26749(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta26750));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async26749(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__25854__auto___26913 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___26913,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___26913,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_26853){
var state_val_26854 = (state_26853[(1)]);
if((state_val_26854 === (7))){
var inst_26768 = (state_26853[(2)]);
var state_26853__$1 = state_26853;
var statearr_26855_26914 = state_26853__$1;
(statearr_26855_26914[(2)] = inst_26768);

(statearr_26855_26914[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (20))){
var inst_26780 = (state_26853[(7)]);
var state_26853__$1 = state_26853;
var statearr_26856_26915 = state_26853__$1;
(statearr_26856_26915[(2)] = inst_26780);

(statearr_26856_26915[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (27))){
var state_26853__$1 = state_26853;
var statearr_26857_26916 = state_26853__$1;
(statearr_26857_26916[(2)] = null);

(statearr_26857_26916[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (1))){
var inst_26755 = (state_26853[(8)]);
var inst_26755__$1 = calc_state.call(null);
var inst_26757 = (inst_26755__$1 == null);
var inst_26758 = cljs.core.not.call(null,inst_26757);
var state_26853__$1 = (function (){var statearr_26858 = state_26853;
(statearr_26858[(8)] = inst_26755__$1);

return statearr_26858;
})();
if(inst_26758){
var statearr_26859_26917 = state_26853__$1;
(statearr_26859_26917[(1)] = (2));

} else {
var statearr_26860_26918 = state_26853__$1;
(statearr_26860_26918[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (24))){
var inst_26827 = (state_26853[(9)]);
var inst_26804 = (state_26853[(10)]);
var inst_26813 = (state_26853[(11)]);
var inst_26827__$1 = inst_26804.call(null,inst_26813);
var state_26853__$1 = (function (){var statearr_26861 = state_26853;
(statearr_26861[(9)] = inst_26827__$1);

return statearr_26861;
})();
if(cljs.core.truth_(inst_26827__$1)){
var statearr_26862_26919 = state_26853__$1;
(statearr_26862_26919[(1)] = (29));

} else {
var statearr_26863_26920 = state_26853__$1;
(statearr_26863_26920[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (4))){
var inst_26771 = (state_26853[(2)]);
var state_26853__$1 = state_26853;
if(cljs.core.truth_(inst_26771)){
var statearr_26864_26921 = state_26853__$1;
(statearr_26864_26921[(1)] = (8));

} else {
var statearr_26865_26922 = state_26853__$1;
(statearr_26865_26922[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (15))){
var inst_26798 = (state_26853[(2)]);
var state_26853__$1 = state_26853;
if(cljs.core.truth_(inst_26798)){
var statearr_26866_26923 = state_26853__$1;
(statearr_26866_26923[(1)] = (19));

} else {
var statearr_26867_26924 = state_26853__$1;
(statearr_26867_26924[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (21))){
var inst_26803 = (state_26853[(12)]);
var inst_26803__$1 = (state_26853[(2)]);
var inst_26804 = cljs.core.get.call(null,inst_26803__$1,cljs.core.cst$kw$solos);
var inst_26805 = cljs.core.get.call(null,inst_26803__$1,cljs.core.cst$kw$mutes);
var inst_26806 = cljs.core.get.call(null,inst_26803__$1,cljs.core.cst$kw$reads);
var state_26853__$1 = (function (){var statearr_26868 = state_26853;
(statearr_26868[(10)] = inst_26804);

(statearr_26868[(13)] = inst_26805);

(statearr_26868[(12)] = inst_26803__$1);

return statearr_26868;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_26853__$1,(22),inst_26806);
} else {
if((state_val_26854 === (31))){
var inst_26835 = (state_26853[(2)]);
var state_26853__$1 = state_26853;
if(cljs.core.truth_(inst_26835)){
var statearr_26869_26925 = state_26853__$1;
(statearr_26869_26925[(1)] = (32));

} else {
var statearr_26870_26926 = state_26853__$1;
(statearr_26870_26926[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (32))){
var inst_26812 = (state_26853[(14)]);
var state_26853__$1 = state_26853;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26853__$1,(35),out,inst_26812);
} else {
if((state_val_26854 === (33))){
var inst_26803 = (state_26853[(12)]);
var inst_26780 = inst_26803;
var state_26853__$1 = (function (){var statearr_26871 = state_26853;
(statearr_26871[(7)] = inst_26780);

return statearr_26871;
})();
var statearr_26872_26927 = state_26853__$1;
(statearr_26872_26927[(2)] = null);

(statearr_26872_26927[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (13))){
var inst_26780 = (state_26853[(7)]);
var inst_26787 = inst_26780.cljs$lang$protocol_mask$partition0$;
var inst_26788 = (inst_26787 & (64));
var inst_26789 = inst_26780.cljs$core$ISeq$;
var inst_26790 = (cljs.core.PROTOCOL_SENTINEL === inst_26789);
var inst_26791 = ((inst_26788) || (inst_26790));
var state_26853__$1 = state_26853;
if(cljs.core.truth_(inst_26791)){
var statearr_26873_26928 = state_26853__$1;
(statearr_26873_26928[(1)] = (16));

} else {
var statearr_26874_26929 = state_26853__$1;
(statearr_26874_26929[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (22))){
var inst_26812 = (state_26853[(14)]);
var inst_26813 = (state_26853[(11)]);
var inst_26811 = (state_26853[(2)]);
var inst_26812__$1 = cljs.core.nth.call(null,inst_26811,(0),null);
var inst_26813__$1 = cljs.core.nth.call(null,inst_26811,(1),null);
var inst_26814 = (inst_26812__$1 == null);
var inst_26815 = cljs.core._EQ_.call(null,inst_26813__$1,change);
var inst_26816 = ((inst_26814) || (inst_26815));
var state_26853__$1 = (function (){var statearr_26875 = state_26853;
(statearr_26875[(14)] = inst_26812__$1);

(statearr_26875[(11)] = inst_26813__$1);

return statearr_26875;
})();
if(cljs.core.truth_(inst_26816)){
var statearr_26876_26930 = state_26853__$1;
(statearr_26876_26930[(1)] = (23));

} else {
var statearr_26877_26931 = state_26853__$1;
(statearr_26877_26931[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (36))){
var inst_26803 = (state_26853[(12)]);
var inst_26780 = inst_26803;
var state_26853__$1 = (function (){var statearr_26878 = state_26853;
(statearr_26878[(7)] = inst_26780);

return statearr_26878;
})();
var statearr_26879_26932 = state_26853__$1;
(statearr_26879_26932[(2)] = null);

(statearr_26879_26932[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (29))){
var inst_26827 = (state_26853[(9)]);
var state_26853__$1 = state_26853;
var statearr_26880_26933 = state_26853__$1;
(statearr_26880_26933[(2)] = inst_26827);

(statearr_26880_26933[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (6))){
var state_26853__$1 = state_26853;
var statearr_26881_26934 = state_26853__$1;
(statearr_26881_26934[(2)] = false);

(statearr_26881_26934[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (28))){
var inst_26823 = (state_26853[(2)]);
var inst_26824 = calc_state.call(null);
var inst_26780 = inst_26824;
var state_26853__$1 = (function (){var statearr_26882 = state_26853;
(statearr_26882[(7)] = inst_26780);

(statearr_26882[(15)] = inst_26823);

return statearr_26882;
})();
var statearr_26883_26935 = state_26853__$1;
(statearr_26883_26935[(2)] = null);

(statearr_26883_26935[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (25))){
var inst_26849 = (state_26853[(2)]);
var state_26853__$1 = state_26853;
var statearr_26884_26936 = state_26853__$1;
(statearr_26884_26936[(2)] = inst_26849);

(statearr_26884_26936[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (34))){
var inst_26847 = (state_26853[(2)]);
var state_26853__$1 = state_26853;
var statearr_26885_26937 = state_26853__$1;
(statearr_26885_26937[(2)] = inst_26847);

(statearr_26885_26937[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (17))){
var state_26853__$1 = state_26853;
var statearr_26886_26938 = state_26853__$1;
(statearr_26886_26938[(2)] = false);

(statearr_26886_26938[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (3))){
var state_26853__$1 = state_26853;
var statearr_26887_26939 = state_26853__$1;
(statearr_26887_26939[(2)] = false);

(statearr_26887_26939[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (12))){
var inst_26851 = (state_26853[(2)]);
var state_26853__$1 = state_26853;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26853__$1,inst_26851);
} else {
if((state_val_26854 === (2))){
var inst_26755 = (state_26853[(8)]);
var inst_26760 = inst_26755.cljs$lang$protocol_mask$partition0$;
var inst_26761 = (inst_26760 & (64));
var inst_26762 = inst_26755.cljs$core$ISeq$;
var inst_26763 = (cljs.core.PROTOCOL_SENTINEL === inst_26762);
var inst_26764 = ((inst_26761) || (inst_26763));
var state_26853__$1 = state_26853;
if(cljs.core.truth_(inst_26764)){
var statearr_26888_26940 = state_26853__$1;
(statearr_26888_26940[(1)] = (5));

} else {
var statearr_26889_26941 = state_26853__$1;
(statearr_26889_26941[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (23))){
var inst_26812 = (state_26853[(14)]);
var inst_26818 = (inst_26812 == null);
var state_26853__$1 = state_26853;
if(cljs.core.truth_(inst_26818)){
var statearr_26890_26942 = state_26853__$1;
(statearr_26890_26942[(1)] = (26));

} else {
var statearr_26891_26943 = state_26853__$1;
(statearr_26891_26943[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (35))){
var inst_26838 = (state_26853[(2)]);
var state_26853__$1 = state_26853;
if(cljs.core.truth_(inst_26838)){
var statearr_26892_26944 = state_26853__$1;
(statearr_26892_26944[(1)] = (36));

} else {
var statearr_26893_26945 = state_26853__$1;
(statearr_26893_26945[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (19))){
var inst_26780 = (state_26853[(7)]);
var inst_26800 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26780);
var state_26853__$1 = state_26853;
var statearr_26894_26946 = state_26853__$1;
(statearr_26894_26946[(2)] = inst_26800);

(statearr_26894_26946[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (11))){
var inst_26780 = (state_26853[(7)]);
var inst_26784 = (inst_26780 == null);
var inst_26785 = cljs.core.not.call(null,inst_26784);
var state_26853__$1 = state_26853;
if(inst_26785){
var statearr_26895_26947 = state_26853__$1;
(statearr_26895_26947[(1)] = (13));

} else {
var statearr_26896_26948 = state_26853__$1;
(statearr_26896_26948[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (9))){
var inst_26755 = (state_26853[(8)]);
var state_26853__$1 = state_26853;
var statearr_26897_26949 = state_26853__$1;
(statearr_26897_26949[(2)] = inst_26755);

(statearr_26897_26949[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (5))){
var state_26853__$1 = state_26853;
var statearr_26898_26950 = state_26853__$1;
(statearr_26898_26950[(2)] = true);

(statearr_26898_26950[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (14))){
var state_26853__$1 = state_26853;
var statearr_26899_26951 = state_26853__$1;
(statearr_26899_26951[(2)] = false);

(statearr_26899_26951[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (26))){
var inst_26813 = (state_26853[(11)]);
var inst_26820 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_26813);
var state_26853__$1 = state_26853;
var statearr_26900_26952 = state_26853__$1;
(statearr_26900_26952[(2)] = inst_26820);

(statearr_26900_26952[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (16))){
var state_26853__$1 = state_26853;
var statearr_26901_26953 = state_26853__$1;
(statearr_26901_26953[(2)] = true);

(statearr_26901_26953[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (38))){
var inst_26843 = (state_26853[(2)]);
var state_26853__$1 = state_26853;
var statearr_26902_26954 = state_26853__$1;
(statearr_26902_26954[(2)] = inst_26843);

(statearr_26902_26954[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (30))){
var inst_26804 = (state_26853[(10)]);
var inst_26805 = (state_26853[(13)]);
var inst_26813 = (state_26853[(11)]);
var inst_26830 = cljs.core.empty_QMARK_.call(null,inst_26804);
var inst_26831 = inst_26805.call(null,inst_26813);
var inst_26832 = cljs.core.not.call(null,inst_26831);
var inst_26833 = ((inst_26830) && (inst_26832));
var state_26853__$1 = state_26853;
var statearr_26903_26955 = state_26853__$1;
(statearr_26903_26955[(2)] = inst_26833);

(statearr_26903_26955[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (10))){
var inst_26755 = (state_26853[(8)]);
var inst_26776 = (state_26853[(2)]);
var inst_26777 = cljs.core.get.call(null,inst_26776,cljs.core.cst$kw$solos);
var inst_26778 = cljs.core.get.call(null,inst_26776,cljs.core.cst$kw$mutes);
var inst_26779 = cljs.core.get.call(null,inst_26776,cljs.core.cst$kw$reads);
var inst_26780 = inst_26755;
var state_26853__$1 = (function (){var statearr_26904 = state_26853;
(statearr_26904[(7)] = inst_26780);

(statearr_26904[(16)] = inst_26778);

(statearr_26904[(17)] = inst_26777);

(statearr_26904[(18)] = inst_26779);

return statearr_26904;
})();
var statearr_26905_26956 = state_26853__$1;
(statearr_26905_26956[(2)] = null);

(statearr_26905_26956[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (18))){
var inst_26795 = (state_26853[(2)]);
var state_26853__$1 = state_26853;
var statearr_26906_26957 = state_26853__$1;
(statearr_26906_26957[(2)] = inst_26795);

(statearr_26906_26957[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (37))){
var state_26853__$1 = state_26853;
var statearr_26907_26958 = state_26853__$1;
(statearr_26907_26958[(2)] = null);

(statearr_26907_26958[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26854 === (8))){
var inst_26755 = (state_26853[(8)]);
var inst_26773 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26755);
var state_26853__$1 = state_26853;
var statearr_26908_26959 = state_26853__$1;
(statearr_26908_26959[(2)] = inst_26773);

(statearr_26908_26959[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto___26913,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__25763__auto__,c__25854__auto___26913,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__25764__auto__ = null;
var cljs$core$async$mix_$_state_machine__25764__auto____0 = (function (){
var statearr_26909 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26909[(0)] = cljs$core$async$mix_$_state_machine__25764__auto__);

(statearr_26909[(1)] = (1));

return statearr_26909;
});
var cljs$core$async$mix_$_state_machine__25764__auto____1 = (function (state_26853){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_26853);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e26910){if((e26910 instanceof Object)){
var ex__25767__auto__ = e26910;
var statearr_26911_26960 = state_26853;
(statearr_26911_26960[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26853);

return cljs.core.cst$kw$recur;
} else {
throw e26910;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__26961 = state_26853;
state_26853 = G__26961;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__25764__auto__ = function(state_26853){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__25764__auto____1.call(this,state_26853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__25764__auto____0;
cljs$core$async$mix_$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__25764__auto____1;
return cljs$core$async$mix_$_state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___26913,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__25856__auto__ = (function (){var statearr_26912 = f__25855__auto__.call(null);
(statearr_26912[(6)] = c__25854__auto___26913);

return statearr_26912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___26913,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4244__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,p,v,ch);
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__26963 = arguments.length;
switch (G__26963) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,p);
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,p,v);
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__26967 = arguments.length;
switch (G__26967) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__3949__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3949__auto__,mults){
return (function (p1__26965_SHARP_){
if(cljs.core.truth_(p1__26965_SHARP_.call(null,topic))){
return p1__26965_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__26965_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3949__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26968 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26968 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta26969){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta26969 = meta26969;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26968.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_26970,meta26969__$1){
var self__ = this;
var _26970__$1 = this;
return (new cljs.core.async.t_cljs$core$async26968(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta26969__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26968.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_26970){
var self__ = this;
var _26970__$1 = this;
return self__.meta26969;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26968.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26968.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26968.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26968.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26968.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26968.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26968.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26968.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta26969], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26968.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26968.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26968";

cljs.core.async.t_cljs$core$async26968.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async26968");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26968.
 */
cljs.core.async.__GT_t_cljs$core$async26968 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async26968(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta26969){
return (new cljs.core.async.t_cljs$core$async26968(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta26969));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async26968(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__25854__auto___27088 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___27088,mults,ensure_mult,p){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___27088,mults,ensure_mult,p){
return (function (state_27042){
var state_val_27043 = (state_27042[(1)]);
if((state_val_27043 === (7))){
var inst_27038 = (state_27042[(2)]);
var state_27042__$1 = state_27042;
var statearr_27044_27089 = state_27042__$1;
(statearr_27044_27089[(2)] = inst_27038);

(statearr_27044_27089[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (20))){
var state_27042__$1 = state_27042;
var statearr_27045_27090 = state_27042__$1;
(statearr_27045_27090[(2)] = null);

(statearr_27045_27090[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (1))){
var state_27042__$1 = state_27042;
var statearr_27046_27091 = state_27042__$1;
(statearr_27046_27091[(2)] = null);

(statearr_27046_27091[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (24))){
var inst_27021 = (state_27042[(7)]);
var inst_27030 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_27021);
var state_27042__$1 = state_27042;
var statearr_27047_27092 = state_27042__$1;
(statearr_27047_27092[(2)] = inst_27030);

(statearr_27047_27092[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (4))){
var inst_26973 = (state_27042[(8)]);
var inst_26973__$1 = (state_27042[(2)]);
var inst_26974 = (inst_26973__$1 == null);
var state_27042__$1 = (function (){var statearr_27048 = state_27042;
(statearr_27048[(8)] = inst_26973__$1);

return statearr_27048;
})();
if(cljs.core.truth_(inst_26974)){
var statearr_27049_27093 = state_27042__$1;
(statearr_27049_27093[(1)] = (5));

} else {
var statearr_27050_27094 = state_27042__$1;
(statearr_27050_27094[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (15))){
var inst_27015 = (state_27042[(2)]);
var state_27042__$1 = state_27042;
var statearr_27051_27095 = state_27042__$1;
(statearr_27051_27095[(2)] = inst_27015);

(statearr_27051_27095[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (21))){
var inst_27035 = (state_27042[(2)]);
var state_27042__$1 = (function (){var statearr_27052 = state_27042;
(statearr_27052[(9)] = inst_27035);

return statearr_27052;
})();
var statearr_27053_27097 = state_27042__$1;
(statearr_27053_27097[(2)] = null);

(statearr_27053_27097[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (13))){
var inst_26997 = (state_27042[(10)]);
var inst_26999 = cljs.core.chunked_seq_QMARK_.call(null,inst_26997);
var state_27042__$1 = state_27042;
if(inst_26999){
var statearr_27054_27098 = state_27042__$1;
(statearr_27054_27098[(1)] = (16));

} else {
var statearr_27055_27099 = state_27042__$1;
(statearr_27055_27099[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (22))){
var inst_27027 = (state_27042[(2)]);
var state_27042__$1 = state_27042;
if(cljs.core.truth_(inst_27027)){
var statearr_27056_27100 = state_27042__$1;
(statearr_27056_27100[(1)] = (23));

} else {
var statearr_27057_27101 = state_27042__$1;
(statearr_27057_27101[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (6))){
var inst_27023 = (state_27042[(11)]);
var inst_27021 = (state_27042[(7)]);
var inst_26973 = (state_27042[(8)]);
var inst_27021__$1 = topic_fn.call(null,inst_26973);
var inst_27022 = cljs.core.deref.call(null,mults);
var inst_27023__$1 = cljs.core.get.call(null,inst_27022,inst_27021__$1);
var state_27042__$1 = (function (){var statearr_27058 = state_27042;
(statearr_27058[(11)] = inst_27023__$1);

(statearr_27058[(7)] = inst_27021__$1);

return statearr_27058;
})();
if(cljs.core.truth_(inst_27023__$1)){
var statearr_27059_27102 = state_27042__$1;
(statearr_27059_27102[(1)] = (19));

} else {
var statearr_27060_27103 = state_27042__$1;
(statearr_27060_27103[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (25))){
var inst_27032 = (state_27042[(2)]);
var state_27042__$1 = state_27042;
var statearr_27061_27104 = state_27042__$1;
(statearr_27061_27104[(2)] = inst_27032);

(statearr_27061_27104[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (17))){
var inst_26997 = (state_27042[(10)]);
var inst_27006 = cljs.core.first.call(null,inst_26997);
var inst_27007 = cljs.core.async.muxch_STAR_.call(null,inst_27006);
var inst_27008 = cljs.core.async.close_BANG_.call(null,inst_27007);
var inst_27009 = cljs.core.next.call(null,inst_26997);
var inst_26983 = inst_27009;
var inst_26984 = null;
var inst_26985 = (0);
var inst_26986 = (0);
var state_27042__$1 = (function (){var statearr_27062 = state_27042;
(statearr_27062[(12)] = inst_26984);

(statearr_27062[(13)] = inst_26983);

(statearr_27062[(14)] = inst_27008);

(statearr_27062[(15)] = inst_26985);

(statearr_27062[(16)] = inst_26986);

return statearr_27062;
})();
var statearr_27063_27105 = state_27042__$1;
(statearr_27063_27105[(2)] = null);

(statearr_27063_27105[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (3))){
var inst_27040 = (state_27042[(2)]);
var state_27042__$1 = state_27042;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27042__$1,inst_27040);
} else {
if((state_val_27043 === (12))){
var inst_27017 = (state_27042[(2)]);
var state_27042__$1 = state_27042;
var statearr_27064_27106 = state_27042__$1;
(statearr_27064_27106[(2)] = inst_27017);

(statearr_27064_27106[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (2))){
var state_27042__$1 = state_27042;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27042__$1,(4),ch);
} else {
if((state_val_27043 === (23))){
var state_27042__$1 = state_27042;
var statearr_27065_27107 = state_27042__$1;
(statearr_27065_27107[(2)] = null);

(statearr_27065_27107[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (19))){
var inst_27023 = (state_27042[(11)]);
var inst_26973 = (state_27042[(8)]);
var inst_27025 = cljs.core.async.muxch_STAR_.call(null,inst_27023);
var state_27042__$1 = state_27042;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27042__$1,(22),inst_27025,inst_26973);
} else {
if((state_val_27043 === (11))){
var inst_26997 = (state_27042[(10)]);
var inst_26983 = (state_27042[(13)]);
var inst_26997__$1 = cljs.core.seq.call(null,inst_26983);
var state_27042__$1 = (function (){var statearr_27066 = state_27042;
(statearr_27066[(10)] = inst_26997__$1);

return statearr_27066;
})();
if(inst_26997__$1){
var statearr_27067_27108 = state_27042__$1;
(statearr_27067_27108[(1)] = (13));

} else {
var statearr_27068_27109 = state_27042__$1;
(statearr_27068_27109[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (9))){
var inst_27019 = (state_27042[(2)]);
var state_27042__$1 = state_27042;
var statearr_27069_27110 = state_27042__$1;
(statearr_27069_27110[(2)] = inst_27019);

(statearr_27069_27110[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (5))){
var inst_26980 = cljs.core.deref.call(null,mults);
var inst_26981 = cljs.core.vals.call(null,inst_26980);
var inst_26982 = cljs.core.seq.call(null,inst_26981);
var inst_26983 = inst_26982;
var inst_26984 = null;
var inst_26985 = (0);
var inst_26986 = (0);
var state_27042__$1 = (function (){var statearr_27070 = state_27042;
(statearr_27070[(12)] = inst_26984);

(statearr_27070[(13)] = inst_26983);

(statearr_27070[(15)] = inst_26985);

(statearr_27070[(16)] = inst_26986);

return statearr_27070;
})();
var statearr_27071_27111 = state_27042__$1;
(statearr_27071_27111[(2)] = null);

(statearr_27071_27111[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (14))){
var state_27042__$1 = state_27042;
var statearr_27075_27112 = state_27042__$1;
(statearr_27075_27112[(2)] = null);

(statearr_27075_27112[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (16))){
var inst_26997 = (state_27042[(10)]);
var inst_27001 = cljs.core.chunk_first.call(null,inst_26997);
var inst_27002 = cljs.core.chunk_rest.call(null,inst_26997);
var inst_27003 = cljs.core.count.call(null,inst_27001);
var inst_26983 = inst_27002;
var inst_26984 = inst_27001;
var inst_26985 = inst_27003;
var inst_26986 = (0);
var state_27042__$1 = (function (){var statearr_27076 = state_27042;
(statearr_27076[(12)] = inst_26984);

(statearr_27076[(13)] = inst_26983);

(statearr_27076[(15)] = inst_26985);

(statearr_27076[(16)] = inst_26986);

return statearr_27076;
})();
var statearr_27077_27113 = state_27042__$1;
(statearr_27077_27113[(2)] = null);

(statearr_27077_27113[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (10))){
var inst_26984 = (state_27042[(12)]);
var inst_26983 = (state_27042[(13)]);
var inst_26985 = (state_27042[(15)]);
var inst_26986 = (state_27042[(16)]);
var inst_26991 = cljs.core._nth.call(null,inst_26984,inst_26986);
var inst_26992 = cljs.core.async.muxch_STAR_.call(null,inst_26991);
var inst_26993 = cljs.core.async.close_BANG_.call(null,inst_26992);
var inst_26994 = (inst_26986 + (1));
var tmp27072 = inst_26984;
var tmp27073 = inst_26983;
var tmp27074 = inst_26985;
var inst_26983__$1 = tmp27073;
var inst_26984__$1 = tmp27072;
var inst_26985__$1 = tmp27074;
var inst_26986__$1 = inst_26994;
var state_27042__$1 = (function (){var statearr_27078 = state_27042;
(statearr_27078[(12)] = inst_26984__$1);

(statearr_27078[(13)] = inst_26983__$1);

(statearr_27078[(17)] = inst_26993);

(statearr_27078[(15)] = inst_26985__$1);

(statearr_27078[(16)] = inst_26986__$1);

return statearr_27078;
})();
var statearr_27079_27114 = state_27042__$1;
(statearr_27079_27114[(2)] = null);

(statearr_27079_27114[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (18))){
var inst_27012 = (state_27042[(2)]);
var state_27042__$1 = state_27042;
var statearr_27080_27115 = state_27042__$1;
(statearr_27080_27115[(2)] = inst_27012);

(statearr_27080_27115[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27043 === (8))){
var inst_26985 = (state_27042[(15)]);
var inst_26986 = (state_27042[(16)]);
var inst_26988 = (inst_26986 < inst_26985);
var inst_26989 = inst_26988;
var state_27042__$1 = state_27042;
if(cljs.core.truth_(inst_26989)){
var statearr_27081_27116 = state_27042__$1;
(statearr_27081_27116[(1)] = (10));

} else {
var statearr_27082_27117 = state_27042__$1;
(statearr_27082_27117[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto___27088,mults,ensure_mult,p))
;
return ((function (switch__25763__auto__,c__25854__auto___27088,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__25764__auto__ = null;
var cljs$core$async$state_machine__25764__auto____0 = (function (){
var statearr_27083 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27083[(0)] = cljs$core$async$state_machine__25764__auto__);

(statearr_27083[(1)] = (1));

return statearr_27083;
});
var cljs$core$async$state_machine__25764__auto____1 = (function (state_27042){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_27042);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e27084){if((e27084 instanceof Object)){
var ex__25767__auto__ = e27084;
var statearr_27085_27118 = state_27042;
(statearr_27085_27118[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27042);

return cljs.core.cst$kw$recur;
} else {
throw e27084;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__27119 = state_27042;
state_27042 = G__27119;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$state_machine__25764__auto__ = function(state_27042){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25764__auto____1.call(this,state_27042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25764__auto____0;
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25764__auto____1;
return cljs$core$async$state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___27088,mults,ensure_mult,p))
})();
var state__25856__auto__ = (function (){var statearr_27086 = f__25855__auto__.call(null);
(statearr_27086[(6)] = c__25854__auto___27088);

return statearr_27086;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___27088,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__27121 = arguments.length;
switch (G__27121) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__27124 = arguments.length;
switch (G__27124) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__27127 = arguments.length;
switch (G__27127) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__25854__auto___27194 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___27194,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___27194,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_27166){
var state_val_27167 = (state_27166[(1)]);
if((state_val_27167 === (7))){
var state_27166__$1 = state_27166;
var statearr_27168_27195 = state_27166__$1;
(statearr_27168_27195[(2)] = null);

(statearr_27168_27195[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27167 === (1))){
var state_27166__$1 = state_27166;
var statearr_27169_27196 = state_27166__$1;
(statearr_27169_27196[(2)] = null);

(statearr_27169_27196[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27167 === (4))){
var inst_27130 = (state_27166[(7)]);
var inst_27132 = (inst_27130 < cnt);
var state_27166__$1 = state_27166;
if(cljs.core.truth_(inst_27132)){
var statearr_27170_27197 = state_27166__$1;
(statearr_27170_27197[(1)] = (6));

} else {
var statearr_27171_27198 = state_27166__$1;
(statearr_27171_27198[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27167 === (15))){
var inst_27162 = (state_27166[(2)]);
var state_27166__$1 = state_27166;
var statearr_27172_27199 = state_27166__$1;
(statearr_27172_27199[(2)] = inst_27162);

(statearr_27172_27199[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27167 === (13))){
var inst_27155 = cljs.core.async.close_BANG_.call(null,out);
var state_27166__$1 = state_27166;
var statearr_27173_27200 = state_27166__$1;
(statearr_27173_27200[(2)] = inst_27155);

(statearr_27173_27200[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27167 === (6))){
var state_27166__$1 = state_27166;
var statearr_27174_27201 = state_27166__$1;
(statearr_27174_27201[(2)] = null);

(statearr_27174_27201[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27167 === (3))){
var inst_27164 = (state_27166[(2)]);
var state_27166__$1 = state_27166;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27166__$1,inst_27164);
} else {
if((state_val_27167 === (12))){
var inst_27152 = (state_27166[(8)]);
var inst_27152__$1 = (state_27166[(2)]);
var inst_27153 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_27152__$1);
var state_27166__$1 = (function (){var statearr_27175 = state_27166;
(statearr_27175[(8)] = inst_27152__$1);

return statearr_27175;
})();
if(cljs.core.truth_(inst_27153)){
var statearr_27176_27202 = state_27166__$1;
(statearr_27176_27202[(1)] = (13));

} else {
var statearr_27177_27203 = state_27166__$1;
(statearr_27177_27203[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27167 === (2))){
var inst_27129 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_27130 = (0);
var state_27166__$1 = (function (){var statearr_27178 = state_27166;
(statearr_27178[(9)] = inst_27129);

(statearr_27178[(7)] = inst_27130);

return statearr_27178;
})();
var statearr_27179_27204 = state_27166__$1;
(statearr_27179_27204[(2)] = null);

(statearr_27179_27204[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27167 === (11))){
var inst_27130 = (state_27166[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_27166,(10),Object,null,(9));
var inst_27139 = chs__$1.call(null,inst_27130);
var inst_27140 = done.call(null,inst_27130);
var inst_27141 = cljs.core.async.take_BANG_.call(null,inst_27139,inst_27140);
var state_27166__$1 = state_27166;
var statearr_27180_27205 = state_27166__$1;
(statearr_27180_27205[(2)] = inst_27141);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27166__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_27167 === (9))){
var inst_27130 = (state_27166[(7)]);
var inst_27143 = (state_27166[(2)]);
var inst_27144 = (inst_27130 + (1));
var inst_27130__$1 = inst_27144;
var state_27166__$1 = (function (){var statearr_27181 = state_27166;
(statearr_27181[(10)] = inst_27143);

(statearr_27181[(7)] = inst_27130__$1);

return statearr_27181;
})();
var statearr_27182_27206 = state_27166__$1;
(statearr_27182_27206[(2)] = null);

(statearr_27182_27206[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27167 === (5))){
var inst_27150 = (state_27166[(2)]);
var state_27166__$1 = (function (){var statearr_27183 = state_27166;
(statearr_27183[(11)] = inst_27150);

return statearr_27183;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27166__$1,(12),dchan);
} else {
if((state_val_27167 === (14))){
var inst_27152 = (state_27166[(8)]);
var inst_27157 = cljs.core.apply.call(null,f,inst_27152);
var state_27166__$1 = state_27166;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27166__$1,(16),out,inst_27157);
} else {
if((state_val_27167 === (16))){
var inst_27159 = (state_27166[(2)]);
var state_27166__$1 = (function (){var statearr_27184 = state_27166;
(statearr_27184[(12)] = inst_27159);

return statearr_27184;
})();
var statearr_27185_27207 = state_27166__$1;
(statearr_27185_27207[(2)] = null);

(statearr_27185_27207[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27167 === (10))){
var inst_27134 = (state_27166[(2)]);
var inst_27135 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_27166__$1 = (function (){var statearr_27186 = state_27166;
(statearr_27186[(13)] = inst_27134);

return statearr_27186;
})();
var statearr_27187_27208 = state_27166__$1;
(statearr_27187_27208[(2)] = inst_27135);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27166__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_27167 === (8))){
var inst_27148 = (state_27166[(2)]);
var state_27166__$1 = state_27166;
var statearr_27188_27209 = state_27166__$1;
(statearr_27188_27209[(2)] = inst_27148);

(statearr_27188_27209[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto___27194,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__25763__auto__,c__25854__auto___27194,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__25764__auto__ = null;
var cljs$core$async$state_machine__25764__auto____0 = (function (){
var statearr_27189 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27189[(0)] = cljs$core$async$state_machine__25764__auto__);

(statearr_27189[(1)] = (1));

return statearr_27189;
});
var cljs$core$async$state_machine__25764__auto____1 = (function (state_27166){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_27166);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e27190){if((e27190 instanceof Object)){
var ex__25767__auto__ = e27190;
var statearr_27191_27210 = state_27166;
(statearr_27191_27210[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27166);

return cljs.core.cst$kw$recur;
} else {
throw e27190;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__27211 = state_27166;
state_27166 = G__27211;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$state_machine__25764__auto__ = function(state_27166){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25764__auto____1.call(this,state_27166);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25764__auto____0;
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25764__auto____1;
return cljs$core$async$state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___27194,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__25856__auto__ = (function (){var statearr_27192 = f__25855__auto__.call(null);
(statearr_27192[(6)] = c__25854__auto___27194);

return statearr_27192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___27194,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__27214 = arguments.length;
switch (G__27214) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25854__auto___27268 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___27268,out){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___27268,out){
return (function (state_27246){
var state_val_27247 = (state_27246[(1)]);
if((state_val_27247 === (7))){
var inst_27226 = (state_27246[(7)]);
var inst_27225 = (state_27246[(8)]);
var inst_27225__$1 = (state_27246[(2)]);
var inst_27226__$1 = cljs.core.nth.call(null,inst_27225__$1,(0),null);
var inst_27227 = cljs.core.nth.call(null,inst_27225__$1,(1),null);
var inst_27228 = (inst_27226__$1 == null);
var state_27246__$1 = (function (){var statearr_27248 = state_27246;
(statearr_27248[(7)] = inst_27226__$1);

(statearr_27248[(9)] = inst_27227);

(statearr_27248[(8)] = inst_27225__$1);

return statearr_27248;
})();
if(cljs.core.truth_(inst_27228)){
var statearr_27249_27269 = state_27246__$1;
(statearr_27249_27269[(1)] = (8));

} else {
var statearr_27250_27270 = state_27246__$1;
(statearr_27250_27270[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27247 === (1))){
var inst_27215 = cljs.core.vec.call(null,chs);
var inst_27216 = inst_27215;
var state_27246__$1 = (function (){var statearr_27251 = state_27246;
(statearr_27251[(10)] = inst_27216);

return statearr_27251;
})();
var statearr_27252_27271 = state_27246__$1;
(statearr_27252_27271[(2)] = null);

(statearr_27252_27271[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27247 === (4))){
var inst_27216 = (state_27246[(10)]);
var state_27246__$1 = state_27246;
return cljs.core.async.ioc_alts_BANG_.call(null,state_27246__$1,(7),inst_27216);
} else {
if((state_val_27247 === (6))){
var inst_27242 = (state_27246[(2)]);
var state_27246__$1 = state_27246;
var statearr_27253_27272 = state_27246__$1;
(statearr_27253_27272[(2)] = inst_27242);

(statearr_27253_27272[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27247 === (3))){
var inst_27244 = (state_27246[(2)]);
var state_27246__$1 = state_27246;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27246__$1,inst_27244);
} else {
if((state_val_27247 === (2))){
var inst_27216 = (state_27246[(10)]);
var inst_27218 = cljs.core.count.call(null,inst_27216);
var inst_27219 = (inst_27218 > (0));
var state_27246__$1 = state_27246;
if(cljs.core.truth_(inst_27219)){
var statearr_27255_27273 = state_27246__$1;
(statearr_27255_27273[(1)] = (4));

} else {
var statearr_27256_27274 = state_27246__$1;
(statearr_27256_27274[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27247 === (11))){
var inst_27216 = (state_27246[(10)]);
var inst_27235 = (state_27246[(2)]);
var tmp27254 = inst_27216;
var inst_27216__$1 = tmp27254;
var state_27246__$1 = (function (){var statearr_27257 = state_27246;
(statearr_27257[(10)] = inst_27216__$1);

(statearr_27257[(11)] = inst_27235);

return statearr_27257;
})();
var statearr_27258_27275 = state_27246__$1;
(statearr_27258_27275[(2)] = null);

(statearr_27258_27275[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27247 === (9))){
var inst_27226 = (state_27246[(7)]);
var state_27246__$1 = state_27246;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27246__$1,(11),out,inst_27226);
} else {
if((state_val_27247 === (5))){
var inst_27240 = cljs.core.async.close_BANG_.call(null,out);
var state_27246__$1 = state_27246;
var statearr_27259_27276 = state_27246__$1;
(statearr_27259_27276[(2)] = inst_27240);

(statearr_27259_27276[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27247 === (10))){
var inst_27238 = (state_27246[(2)]);
var state_27246__$1 = state_27246;
var statearr_27260_27277 = state_27246__$1;
(statearr_27260_27277[(2)] = inst_27238);

(statearr_27260_27277[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27247 === (8))){
var inst_27226 = (state_27246[(7)]);
var inst_27227 = (state_27246[(9)]);
var inst_27216 = (state_27246[(10)]);
var inst_27225 = (state_27246[(8)]);
var inst_27230 = (function (){var cs = inst_27216;
var vec__27221 = inst_27225;
var v = inst_27226;
var c = inst_27227;
return ((function (cs,vec__27221,v,c,inst_27226,inst_27227,inst_27216,inst_27225,state_val_27247,c__25854__auto___27268,out){
return (function (p1__27212_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__27212_SHARP_);
});
;})(cs,vec__27221,v,c,inst_27226,inst_27227,inst_27216,inst_27225,state_val_27247,c__25854__auto___27268,out))
})();
var inst_27231 = cljs.core.filterv.call(null,inst_27230,inst_27216);
var inst_27216__$1 = inst_27231;
var state_27246__$1 = (function (){var statearr_27261 = state_27246;
(statearr_27261[(10)] = inst_27216__$1);

return statearr_27261;
})();
var statearr_27262_27278 = state_27246__$1;
(statearr_27262_27278[(2)] = null);

(statearr_27262_27278[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto___27268,out))
;
return ((function (switch__25763__auto__,c__25854__auto___27268,out){
return (function() {
var cljs$core$async$state_machine__25764__auto__ = null;
var cljs$core$async$state_machine__25764__auto____0 = (function (){
var statearr_27263 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27263[(0)] = cljs$core$async$state_machine__25764__auto__);

(statearr_27263[(1)] = (1));

return statearr_27263;
});
var cljs$core$async$state_machine__25764__auto____1 = (function (state_27246){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_27246);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e27264){if((e27264 instanceof Object)){
var ex__25767__auto__ = e27264;
var statearr_27265_27279 = state_27246;
(statearr_27265_27279[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27246);

return cljs.core.cst$kw$recur;
} else {
throw e27264;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__27280 = state_27246;
state_27246 = G__27280;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$state_machine__25764__auto__ = function(state_27246){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25764__auto____1.call(this,state_27246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25764__auto____0;
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25764__auto____1;
return cljs$core$async$state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___27268,out))
})();
var state__25856__auto__ = (function (){var statearr_27266 = f__25855__auto__.call(null);
(statearr_27266[(6)] = c__25854__auto___27268);

return statearr_27266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___27268,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__27282 = arguments.length;
switch (G__27282) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25854__auto___27327 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___27327,out){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___27327,out){
return (function (state_27306){
var state_val_27307 = (state_27306[(1)]);
if((state_val_27307 === (7))){
var inst_27288 = (state_27306[(7)]);
var inst_27288__$1 = (state_27306[(2)]);
var inst_27289 = (inst_27288__$1 == null);
var inst_27290 = cljs.core.not.call(null,inst_27289);
var state_27306__$1 = (function (){var statearr_27308 = state_27306;
(statearr_27308[(7)] = inst_27288__$1);

return statearr_27308;
})();
if(inst_27290){
var statearr_27309_27328 = state_27306__$1;
(statearr_27309_27328[(1)] = (8));

} else {
var statearr_27310_27329 = state_27306__$1;
(statearr_27310_27329[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27307 === (1))){
var inst_27283 = (0);
var state_27306__$1 = (function (){var statearr_27311 = state_27306;
(statearr_27311[(8)] = inst_27283);

return statearr_27311;
})();
var statearr_27312_27330 = state_27306__$1;
(statearr_27312_27330[(2)] = null);

(statearr_27312_27330[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27307 === (4))){
var state_27306__$1 = state_27306;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27306__$1,(7),ch);
} else {
if((state_val_27307 === (6))){
var inst_27301 = (state_27306[(2)]);
var state_27306__$1 = state_27306;
var statearr_27313_27331 = state_27306__$1;
(statearr_27313_27331[(2)] = inst_27301);

(statearr_27313_27331[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27307 === (3))){
var inst_27303 = (state_27306[(2)]);
var inst_27304 = cljs.core.async.close_BANG_.call(null,out);
var state_27306__$1 = (function (){var statearr_27314 = state_27306;
(statearr_27314[(9)] = inst_27303);

return statearr_27314;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27306__$1,inst_27304);
} else {
if((state_val_27307 === (2))){
var inst_27283 = (state_27306[(8)]);
var inst_27285 = (inst_27283 < n);
var state_27306__$1 = state_27306;
if(cljs.core.truth_(inst_27285)){
var statearr_27315_27332 = state_27306__$1;
(statearr_27315_27332[(1)] = (4));

} else {
var statearr_27316_27333 = state_27306__$1;
(statearr_27316_27333[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27307 === (11))){
var inst_27283 = (state_27306[(8)]);
var inst_27293 = (state_27306[(2)]);
var inst_27294 = (inst_27283 + (1));
var inst_27283__$1 = inst_27294;
var state_27306__$1 = (function (){var statearr_27317 = state_27306;
(statearr_27317[(8)] = inst_27283__$1);

(statearr_27317[(10)] = inst_27293);

return statearr_27317;
})();
var statearr_27318_27334 = state_27306__$1;
(statearr_27318_27334[(2)] = null);

(statearr_27318_27334[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27307 === (9))){
var state_27306__$1 = state_27306;
var statearr_27319_27335 = state_27306__$1;
(statearr_27319_27335[(2)] = null);

(statearr_27319_27335[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27307 === (5))){
var state_27306__$1 = state_27306;
var statearr_27320_27336 = state_27306__$1;
(statearr_27320_27336[(2)] = null);

(statearr_27320_27336[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27307 === (10))){
var inst_27298 = (state_27306[(2)]);
var state_27306__$1 = state_27306;
var statearr_27321_27337 = state_27306__$1;
(statearr_27321_27337[(2)] = inst_27298);

(statearr_27321_27337[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27307 === (8))){
var inst_27288 = (state_27306[(7)]);
var state_27306__$1 = state_27306;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27306__$1,(11),out,inst_27288);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto___27327,out))
;
return ((function (switch__25763__auto__,c__25854__auto___27327,out){
return (function() {
var cljs$core$async$state_machine__25764__auto__ = null;
var cljs$core$async$state_machine__25764__auto____0 = (function (){
var statearr_27322 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27322[(0)] = cljs$core$async$state_machine__25764__auto__);

(statearr_27322[(1)] = (1));

return statearr_27322;
});
var cljs$core$async$state_machine__25764__auto____1 = (function (state_27306){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_27306);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e27323){if((e27323 instanceof Object)){
var ex__25767__auto__ = e27323;
var statearr_27324_27338 = state_27306;
(statearr_27324_27338[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27306);

return cljs.core.cst$kw$recur;
} else {
throw e27323;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__27339 = state_27306;
state_27306 = G__27339;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$state_machine__25764__auto__ = function(state_27306){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25764__auto____1.call(this,state_27306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25764__auto____0;
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25764__auto____1;
return cljs$core$async$state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___27327,out))
})();
var state__25856__auto__ = (function (){var statearr_27325 = f__25855__auto__.call(null);
(statearr_27325[(6)] = c__25854__auto___27327);

return statearr_27325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___27327,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27341 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27341 = (function (f,ch,meta27342){
this.f = f;
this.ch = ch;
this.meta27342 = meta27342;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27341.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27343,meta27342__$1){
var self__ = this;
var _27343__$1 = this;
return (new cljs.core.async.t_cljs$core$async27341(self__.f,self__.ch,meta27342__$1));
});

cljs.core.async.t_cljs$core$async27341.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27343){
var self__ = this;
var _27343__$1 = this;
return self__.meta27342;
});

cljs.core.async.t_cljs$core$async27341.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27341.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async27341.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async27341.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27341.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27344 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27344 = (function (f,ch,meta27342,_,fn1,meta27345){
this.f = f;
this.ch = ch;
this.meta27342 = meta27342;
this._ = _;
this.fn1 = fn1;
this.meta27345 = meta27345;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27344.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_27346,meta27345__$1){
var self__ = this;
var _27346__$1 = this;
return (new cljs.core.async.t_cljs$core$async27344(self__.f,self__.ch,self__.meta27342,self__._,self__.fn1,meta27345__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async27344.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_27346){
var self__ = this;
var _27346__$1 = this;
return self__.meta27345;
});})(___$1))
;

cljs.core.async.t_cljs$core$async27344.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27344.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async27344.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async27344.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__27340_SHARP_){
return f1.call(null,(((p1__27340_SHARP_ == null))?null:self__.f.call(null,p1__27340_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async27344.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta27342,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async27341], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta27345], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async27344.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27344.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27344";

cljs.core.async.t_cljs$core$async27344.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async27344");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27344.
 */
cljs.core.async.__GT_t_cljs$core$async27344 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async27344(f__$1,ch__$1,meta27342__$1,___$2,fn1__$1,meta27345){
return (new cljs.core.async.t_cljs$core$async27344(f__$1,ch__$1,meta27342__$1,___$2,fn1__$1,meta27345));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async27344(self__.f,self__.ch,self__.meta27342,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__3938__auto__ = ret;
if(cljs.core.truth_(and__3938__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__3938__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async27341.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27341.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async27341.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta27342], null);
});

cljs.core.async.t_cljs$core$async27341.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27341.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27341";

cljs.core.async.t_cljs$core$async27341.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async27341");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27341.
 */
cljs.core.async.__GT_t_cljs$core$async27341 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async27341(f__$1,ch__$1,meta27342){
return (new cljs.core.async.t_cljs$core$async27341(f__$1,ch__$1,meta27342));
});

}

return (new cljs.core.async.t_cljs$core$async27341(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27347 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27347 = (function (f,ch,meta27348){
this.f = f;
this.ch = ch;
this.meta27348 = meta27348;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27347.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27349,meta27348__$1){
var self__ = this;
var _27349__$1 = this;
return (new cljs.core.async.t_cljs$core$async27347(self__.f,self__.ch,meta27348__$1));
});

cljs.core.async.t_cljs$core$async27347.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27349){
var self__ = this;
var _27349__$1 = this;
return self__.meta27348;
});

cljs.core.async.t_cljs$core$async27347.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27347.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async27347.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27347.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async27347.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27347.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async27347.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta27348], null);
});

cljs.core.async.t_cljs$core$async27347.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27347.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27347";

cljs.core.async.t_cljs$core$async27347.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async27347");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27347.
 */
cljs.core.async.__GT_t_cljs$core$async27347 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async27347(f__$1,ch__$1,meta27348){
return (new cljs.core.async.t_cljs$core$async27347(f__$1,ch__$1,meta27348));
});

}

return (new cljs.core.async.t_cljs$core$async27347(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27350 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27350 = (function (p,ch,meta27351){
this.p = p;
this.ch = ch;
this.meta27351 = meta27351;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27350.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27352,meta27351__$1){
var self__ = this;
var _27352__$1 = this;
return (new cljs.core.async.t_cljs$core$async27350(self__.p,self__.ch,meta27351__$1));
});

cljs.core.async.t_cljs$core$async27350.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27352){
var self__ = this;
var _27352__$1 = this;
return self__.meta27351;
});

cljs.core.async.t_cljs$core$async27350.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27350.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async27350.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async27350.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27350.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async27350.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27350.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async27350.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta27351], null);
});

cljs.core.async.t_cljs$core$async27350.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27350.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27350";

cljs.core.async.t_cljs$core$async27350.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async27350");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27350.
 */
cljs.core.async.__GT_t_cljs$core$async27350 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async27350(p__$1,ch__$1,meta27351){
return (new cljs.core.async.t_cljs$core$async27350(p__$1,ch__$1,meta27351));
});

}

return (new cljs.core.async.t_cljs$core$async27350(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__27354 = arguments.length;
switch (G__27354) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25854__auto___27394 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___27394,out){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___27394,out){
return (function (state_27375){
var state_val_27376 = (state_27375[(1)]);
if((state_val_27376 === (7))){
var inst_27371 = (state_27375[(2)]);
var state_27375__$1 = state_27375;
var statearr_27377_27395 = state_27375__$1;
(statearr_27377_27395[(2)] = inst_27371);

(statearr_27377_27395[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27376 === (1))){
var state_27375__$1 = state_27375;
var statearr_27378_27396 = state_27375__$1;
(statearr_27378_27396[(2)] = null);

(statearr_27378_27396[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27376 === (4))){
var inst_27357 = (state_27375[(7)]);
var inst_27357__$1 = (state_27375[(2)]);
var inst_27358 = (inst_27357__$1 == null);
var state_27375__$1 = (function (){var statearr_27379 = state_27375;
(statearr_27379[(7)] = inst_27357__$1);

return statearr_27379;
})();
if(cljs.core.truth_(inst_27358)){
var statearr_27380_27397 = state_27375__$1;
(statearr_27380_27397[(1)] = (5));

} else {
var statearr_27381_27398 = state_27375__$1;
(statearr_27381_27398[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27376 === (6))){
var inst_27357 = (state_27375[(7)]);
var inst_27362 = p.call(null,inst_27357);
var state_27375__$1 = state_27375;
if(cljs.core.truth_(inst_27362)){
var statearr_27382_27399 = state_27375__$1;
(statearr_27382_27399[(1)] = (8));

} else {
var statearr_27383_27400 = state_27375__$1;
(statearr_27383_27400[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27376 === (3))){
var inst_27373 = (state_27375[(2)]);
var state_27375__$1 = state_27375;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27375__$1,inst_27373);
} else {
if((state_val_27376 === (2))){
var state_27375__$1 = state_27375;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27375__$1,(4),ch);
} else {
if((state_val_27376 === (11))){
var inst_27365 = (state_27375[(2)]);
var state_27375__$1 = state_27375;
var statearr_27384_27401 = state_27375__$1;
(statearr_27384_27401[(2)] = inst_27365);

(statearr_27384_27401[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27376 === (9))){
var state_27375__$1 = state_27375;
var statearr_27385_27402 = state_27375__$1;
(statearr_27385_27402[(2)] = null);

(statearr_27385_27402[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27376 === (5))){
var inst_27360 = cljs.core.async.close_BANG_.call(null,out);
var state_27375__$1 = state_27375;
var statearr_27386_27403 = state_27375__$1;
(statearr_27386_27403[(2)] = inst_27360);

(statearr_27386_27403[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27376 === (10))){
var inst_27368 = (state_27375[(2)]);
var state_27375__$1 = (function (){var statearr_27387 = state_27375;
(statearr_27387[(8)] = inst_27368);

return statearr_27387;
})();
var statearr_27388_27404 = state_27375__$1;
(statearr_27388_27404[(2)] = null);

(statearr_27388_27404[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27376 === (8))){
var inst_27357 = (state_27375[(7)]);
var state_27375__$1 = state_27375;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27375__$1,(11),out,inst_27357);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto___27394,out))
;
return ((function (switch__25763__auto__,c__25854__auto___27394,out){
return (function() {
var cljs$core$async$state_machine__25764__auto__ = null;
var cljs$core$async$state_machine__25764__auto____0 = (function (){
var statearr_27389 = [null,null,null,null,null,null,null,null,null];
(statearr_27389[(0)] = cljs$core$async$state_machine__25764__auto__);

(statearr_27389[(1)] = (1));

return statearr_27389;
});
var cljs$core$async$state_machine__25764__auto____1 = (function (state_27375){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_27375);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e27390){if((e27390 instanceof Object)){
var ex__25767__auto__ = e27390;
var statearr_27391_27405 = state_27375;
(statearr_27391_27405[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27375);

return cljs.core.cst$kw$recur;
} else {
throw e27390;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__27406 = state_27375;
state_27375 = G__27406;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$state_machine__25764__auto__ = function(state_27375){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25764__auto____1.call(this,state_27375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25764__auto____0;
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25764__auto____1;
return cljs$core$async$state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___27394,out))
})();
var state__25856__auto__ = (function (){var statearr_27392 = f__25855__auto__.call(null);
(statearr_27392[(6)] = c__25854__auto___27394);

return statearr_27392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___27394,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__27408 = arguments.length;
switch (G__27408) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__25854__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto__){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto__){
return (function (state_27471){
var state_val_27472 = (state_27471[(1)]);
if((state_val_27472 === (7))){
var inst_27467 = (state_27471[(2)]);
var state_27471__$1 = state_27471;
var statearr_27473_27511 = state_27471__$1;
(statearr_27473_27511[(2)] = inst_27467);

(statearr_27473_27511[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (20))){
var inst_27437 = (state_27471[(7)]);
var inst_27448 = (state_27471[(2)]);
var inst_27449 = cljs.core.next.call(null,inst_27437);
var inst_27423 = inst_27449;
var inst_27424 = null;
var inst_27425 = (0);
var inst_27426 = (0);
var state_27471__$1 = (function (){var statearr_27474 = state_27471;
(statearr_27474[(8)] = inst_27423);

(statearr_27474[(9)] = inst_27426);

(statearr_27474[(10)] = inst_27448);

(statearr_27474[(11)] = inst_27425);

(statearr_27474[(12)] = inst_27424);

return statearr_27474;
})();
var statearr_27475_27512 = state_27471__$1;
(statearr_27475_27512[(2)] = null);

(statearr_27475_27512[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (1))){
var state_27471__$1 = state_27471;
var statearr_27476_27513 = state_27471__$1;
(statearr_27476_27513[(2)] = null);

(statearr_27476_27513[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (4))){
var inst_27412 = (state_27471[(13)]);
var inst_27412__$1 = (state_27471[(2)]);
var inst_27413 = (inst_27412__$1 == null);
var state_27471__$1 = (function (){var statearr_27477 = state_27471;
(statearr_27477[(13)] = inst_27412__$1);

return statearr_27477;
})();
if(cljs.core.truth_(inst_27413)){
var statearr_27478_27514 = state_27471__$1;
(statearr_27478_27514[(1)] = (5));

} else {
var statearr_27479_27515 = state_27471__$1;
(statearr_27479_27515[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (15))){
var state_27471__$1 = state_27471;
var statearr_27483_27516 = state_27471__$1;
(statearr_27483_27516[(2)] = null);

(statearr_27483_27516[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (21))){
var state_27471__$1 = state_27471;
var statearr_27484_27517 = state_27471__$1;
(statearr_27484_27517[(2)] = null);

(statearr_27484_27517[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (13))){
var inst_27423 = (state_27471[(8)]);
var inst_27426 = (state_27471[(9)]);
var inst_27425 = (state_27471[(11)]);
var inst_27424 = (state_27471[(12)]);
var inst_27433 = (state_27471[(2)]);
var inst_27434 = (inst_27426 + (1));
var tmp27480 = inst_27423;
var tmp27481 = inst_27425;
var tmp27482 = inst_27424;
var inst_27423__$1 = tmp27480;
var inst_27424__$1 = tmp27482;
var inst_27425__$1 = tmp27481;
var inst_27426__$1 = inst_27434;
var state_27471__$1 = (function (){var statearr_27485 = state_27471;
(statearr_27485[(8)] = inst_27423__$1);

(statearr_27485[(9)] = inst_27426__$1);

(statearr_27485[(14)] = inst_27433);

(statearr_27485[(11)] = inst_27425__$1);

(statearr_27485[(12)] = inst_27424__$1);

return statearr_27485;
})();
var statearr_27486_27518 = state_27471__$1;
(statearr_27486_27518[(2)] = null);

(statearr_27486_27518[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (22))){
var state_27471__$1 = state_27471;
var statearr_27487_27519 = state_27471__$1;
(statearr_27487_27519[(2)] = null);

(statearr_27487_27519[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (6))){
var inst_27412 = (state_27471[(13)]);
var inst_27421 = f.call(null,inst_27412);
var inst_27422 = cljs.core.seq.call(null,inst_27421);
var inst_27423 = inst_27422;
var inst_27424 = null;
var inst_27425 = (0);
var inst_27426 = (0);
var state_27471__$1 = (function (){var statearr_27488 = state_27471;
(statearr_27488[(8)] = inst_27423);

(statearr_27488[(9)] = inst_27426);

(statearr_27488[(11)] = inst_27425);

(statearr_27488[(12)] = inst_27424);

return statearr_27488;
})();
var statearr_27489_27520 = state_27471__$1;
(statearr_27489_27520[(2)] = null);

(statearr_27489_27520[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (17))){
var inst_27437 = (state_27471[(7)]);
var inst_27441 = cljs.core.chunk_first.call(null,inst_27437);
var inst_27442 = cljs.core.chunk_rest.call(null,inst_27437);
var inst_27443 = cljs.core.count.call(null,inst_27441);
var inst_27423 = inst_27442;
var inst_27424 = inst_27441;
var inst_27425 = inst_27443;
var inst_27426 = (0);
var state_27471__$1 = (function (){var statearr_27490 = state_27471;
(statearr_27490[(8)] = inst_27423);

(statearr_27490[(9)] = inst_27426);

(statearr_27490[(11)] = inst_27425);

(statearr_27490[(12)] = inst_27424);

return statearr_27490;
})();
var statearr_27491_27521 = state_27471__$1;
(statearr_27491_27521[(2)] = null);

(statearr_27491_27521[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (3))){
var inst_27469 = (state_27471[(2)]);
var state_27471__$1 = state_27471;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27471__$1,inst_27469);
} else {
if((state_val_27472 === (12))){
var inst_27457 = (state_27471[(2)]);
var state_27471__$1 = state_27471;
var statearr_27492_27522 = state_27471__$1;
(statearr_27492_27522[(2)] = inst_27457);

(statearr_27492_27522[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (2))){
var state_27471__$1 = state_27471;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27471__$1,(4),in$);
} else {
if((state_val_27472 === (23))){
var inst_27465 = (state_27471[(2)]);
var state_27471__$1 = state_27471;
var statearr_27493_27523 = state_27471__$1;
(statearr_27493_27523[(2)] = inst_27465);

(statearr_27493_27523[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (19))){
var inst_27452 = (state_27471[(2)]);
var state_27471__$1 = state_27471;
var statearr_27494_27524 = state_27471__$1;
(statearr_27494_27524[(2)] = inst_27452);

(statearr_27494_27524[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (11))){
var inst_27423 = (state_27471[(8)]);
var inst_27437 = (state_27471[(7)]);
var inst_27437__$1 = cljs.core.seq.call(null,inst_27423);
var state_27471__$1 = (function (){var statearr_27495 = state_27471;
(statearr_27495[(7)] = inst_27437__$1);

return statearr_27495;
})();
if(inst_27437__$1){
var statearr_27496_27525 = state_27471__$1;
(statearr_27496_27525[(1)] = (14));

} else {
var statearr_27497_27526 = state_27471__$1;
(statearr_27497_27526[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (9))){
var inst_27459 = (state_27471[(2)]);
var inst_27460 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_27471__$1 = (function (){var statearr_27498 = state_27471;
(statearr_27498[(15)] = inst_27459);

return statearr_27498;
})();
if(cljs.core.truth_(inst_27460)){
var statearr_27499_27527 = state_27471__$1;
(statearr_27499_27527[(1)] = (21));

} else {
var statearr_27500_27528 = state_27471__$1;
(statearr_27500_27528[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (5))){
var inst_27415 = cljs.core.async.close_BANG_.call(null,out);
var state_27471__$1 = state_27471;
var statearr_27501_27529 = state_27471__$1;
(statearr_27501_27529[(2)] = inst_27415);

(statearr_27501_27529[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (14))){
var inst_27437 = (state_27471[(7)]);
var inst_27439 = cljs.core.chunked_seq_QMARK_.call(null,inst_27437);
var state_27471__$1 = state_27471;
if(inst_27439){
var statearr_27502_27530 = state_27471__$1;
(statearr_27502_27530[(1)] = (17));

} else {
var statearr_27503_27531 = state_27471__$1;
(statearr_27503_27531[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (16))){
var inst_27455 = (state_27471[(2)]);
var state_27471__$1 = state_27471;
var statearr_27504_27532 = state_27471__$1;
(statearr_27504_27532[(2)] = inst_27455);

(statearr_27504_27532[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27472 === (10))){
var inst_27426 = (state_27471[(9)]);
var inst_27424 = (state_27471[(12)]);
var inst_27431 = cljs.core._nth.call(null,inst_27424,inst_27426);
var state_27471__$1 = state_27471;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27471__$1,(13),out,inst_27431);
} else {
if((state_val_27472 === (18))){
var inst_27437 = (state_27471[(7)]);
var inst_27446 = cljs.core.first.call(null,inst_27437);
var state_27471__$1 = state_27471;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27471__$1,(20),out,inst_27446);
} else {
if((state_val_27472 === (8))){
var inst_27426 = (state_27471[(9)]);
var inst_27425 = (state_27471[(11)]);
var inst_27428 = (inst_27426 < inst_27425);
var inst_27429 = inst_27428;
var state_27471__$1 = state_27471;
if(cljs.core.truth_(inst_27429)){
var statearr_27505_27533 = state_27471__$1;
(statearr_27505_27533[(1)] = (10));

} else {
var statearr_27506_27534 = state_27471__$1;
(statearr_27506_27534[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto__))
;
return ((function (switch__25763__auto__,c__25854__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__25764__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__25764__auto____0 = (function (){
var statearr_27507 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27507[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__25764__auto__);

(statearr_27507[(1)] = (1));

return statearr_27507;
});
var cljs$core$async$mapcat_STAR__$_state_machine__25764__auto____1 = (function (state_27471){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_27471);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e27508){if((e27508 instanceof Object)){
var ex__25767__auto__ = e27508;
var statearr_27509_27535 = state_27471;
(statearr_27509_27535[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27471);

return cljs.core.cst$kw$recur;
} else {
throw e27508;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__27536 = state_27471;
state_27471 = G__27536;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__25764__auto__ = function(state_27471){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__25764__auto____1.call(this,state_27471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__25764__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__25764__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto__))
})();
var state__25856__auto__ = (function (){var statearr_27510 = f__25855__auto__.call(null);
(statearr_27510[(6)] = c__25854__auto__);

return statearr_27510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto__))
);

return c__25854__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__27538 = arguments.length;
switch (G__27538) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__27541 = arguments.length;
switch (G__27541) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__27544 = arguments.length;
switch (G__27544) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25854__auto___27591 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___27591,out){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___27591,out){
return (function (state_27568){
var state_val_27569 = (state_27568[(1)]);
if((state_val_27569 === (7))){
var inst_27563 = (state_27568[(2)]);
var state_27568__$1 = state_27568;
var statearr_27570_27592 = state_27568__$1;
(statearr_27570_27592[(2)] = inst_27563);

(statearr_27570_27592[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27569 === (1))){
var inst_27545 = null;
var state_27568__$1 = (function (){var statearr_27571 = state_27568;
(statearr_27571[(7)] = inst_27545);

return statearr_27571;
})();
var statearr_27572_27593 = state_27568__$1;
(statearr_27572_27593[(2)] = null);

(statearr_27572_27593[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27569 === (4))){
var inst_27548 = (state_27568[(8)]);
var inst_27548__$1 = (state_27568[(2)]);
var inst_27549 = (inst_27548__$1 == null);
var inst_27550 = cljs.core.not.call(null,inst_27549);
var state_27568__$1 = (function (){var statearr_27573 = state_27568;
(statearr_27573[(8)] = inst_27548__$1);

return statearr_27573;
})();
if(inst_27550){
var statearr_27574_27594 = state_27568__$1;
(statearr_27574_27594[(1)] = (5));

} else {
var statearr_27575_27595 = state_27568__$1;
(statearr_27575_27595[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27569 === (6))){
var state_27568__$1 = state_27568;
var statearr_27576_27596 = state_27568__$1;
(statearr_27576_27596[(2)] = null);

(statearr_27576_27596[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27569 === (3))){
var inst_27565 = (state_27568[(2)]);
var inst_27566 = cljs.core.async.close_BANG_.call(null,out);
var state_27568__$1 = (function (){var statearr_27577 = state_27568;
(statearr_27577[(9)] = inst_27565);

return statearr_27577;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27568__$1,inst_27566);
} else {
if((state_val_27569 === (2))){
var state_27568__$1 = state_27568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27568__$1,(4),ch);
} else {
if((state_val_27569 === (11))){
var inst_27548 = (state_27568[(8)]);
var inst_27557 = (state_27568[(2)]);
var inst_27545 = inst_27548;
var state_27568__$1 = (function (){var statearr_27578 = state_27568;
(statearr_27578[(10)] = inst_27557);

(statearr_27578[(7)] = inst_27545);

return statearr_27578;
})();
var statearr_27579_27597 = state_27568__$1;
(statearr_27579_27597[(2)] = null);

(statearr_27579_27597[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27569 === (9))){
var inst_27548 = (state_27568[(8)]);
var state_27568__$1 = state_27568;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27568__$1,(11),out,inst_27548);
} else {
if((state_val_27569 === (5))){
var inst_27548 = (state_27568[(8)]);
var inst_27545 = (state_27568[(7)]);
var inst_27552 = cljs.core._EQ_.call(null,inst_27548,inst_27545);
var state_27568__$1 = state_27568;
if(inst_27552){
var statearr_27581_27598 = state_27568__$1;
(statearr_27581_27598[(1)] = (8));

} else {
var statearr_27582_27599 = state_27568__$1;
(statearr_27582_27599[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27569 === (10))){
var inst_27560 = (state_27568[(2)]);
var state_27568__$1 = state_27568;
var statearr_27583_27600 = state_27568__$1;
(statearr_27583_27600[(2)] = inst_27560);

(statearr_27583_27600[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27569 === (8))){
var inst_27545 = (state_27568[(7)]);
var tmp27580 = inst_27545;
var inst_27545__$1 = tmp27580;
var state_27568__$1 = (function (){var statearr_27584 = state_27568;
(statearr_27584[(7)] = inst_27545__$1);

return statearr_27584;
})();
var statearr_27585_27601 = state_27568__$1;
(statearr_27585_27601[(2)] = null);

(statearr_27585_27601[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto___27591,out))
;
return ((function (switch__25763__auto__,c__25854__auto___27591,out){
return (function() {
var cljs$core$async$state_machine__25764__auto__ = null;
var cljs$core$async$state_machine__25764__auto____0 = (function (){
var statearr_27586 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27586[(0)] = cljs$core$async$state_machine__25764__auto__);

(statearr_27586[(1)] = (1));

return statearr_27586;
});
var cljs$core$async$state_machine__25764__auto____1 = (function (state_27568){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_27568);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e27587){if((e27587 instanceof Object)){
var ex__25767__auto__ = e27587;
var statearr_27588_27602 = state_27568;
(statearr_27588_27602[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27568);

return cljs.core.cst$kw$recur;
} else {
throw e27587;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__27603 = state_27568;
state_27568 = G__27603;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$state_machine__25764__auto__ = function(state_27568){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25764__auto____1.call(this,state_27568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25764__auto____0;
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25764__auto____1;
return cljs$core$async$state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___27591,out))
})();
var state__25856__auto__ = (function (){var statearr_27589 = f__25855__auto__.call(null);
(statearr_27589[(6)] = c__25854__auto___27591);

return statearr_27589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___27591,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__27605 = arguments.length;
switch (G__27605) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25854__auto___27671 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___27671,out){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___27671,out){
return (function (state_27643){
var state_val_27644 = (state_27643[(1)]);
if((state_val_27644 === (7))){
var inst_27639 = (state_27643[(2)]);
var state_27643__$1 = state_27643;
var statearr_27645_27672 = state_27643__$1;
(statearr_27645_27672[(2)] = inst_27639);

(statearr_27645_27672[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27644 === (1))){
var inst_27606 = (new Array(n));
var inst_27607 = inst_27606;
var inst_27608 = (0);
var state_27643__$1 = (function (){var statearr_27646 = state_27643;
(statearr_27646[(7)] = inst_27608);

(statearr_27646[(8)] = inst_27607);

return statearr_27646;
})();
var statearr_27647_27673 = state_27643__$1;
(statearr_27647_27673[(2)] = null);

(statearr_27647_27673[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27644 === (4))){
var inst_27611 = (state_27643[(9)]);
var inst_27611__$1 = (state_27643[(2)]);
var inst_27612 = (inst_27611__$1 == null);
var inst_27613 = cljs.core.not.call(null,inst_27612);
var state_27643__$1 = (function (){var statearr_27648 = state_27643;
(statearr_27648[(9)] = inst_27611__$1);

return statearr_27648;
})();
if(inst_27613){
var statearr_27649_27674 = state_27643__$1;
(statearr_27649_27674[(1)] = (5));

} else {
var statearr_27650_27675 = state_27643__$1;
(statearr_27650_27675[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27644 === (15))){
var inst_27633 = (state_27643[(2)]);
var state_27643__$1 = state_27643;
var statearr_27651_27676 = state_27643__$1;
(statearr_27651_27676[(2)] = inst_27633);

(statearr_27651_27676[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27644 === (13))){
var state_27643__$1 = state_27643;
var statearr_27652_27677 = state_27643__$1;
(statearr_27652_27677[(2)] = null);

(statearr_27652_27677[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27644 === (6))){
var inst_27608 = (state_27643[(7)]);
var inst_27629 = (inst_27608 > (0));
var state_27643__$1 = state_27643;
if(cljs.core.truth_(inst_27629)){
var statearr_27653_27678 = state_27643__$1;
(statearr_27653_27678[(1)] = (12));

} else {
var statearr_27654_27679 = state_27643__$1;
(statearr_27654_27679[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27644 === (3))){
var inst_27641 = (state_27643[(2)]);
var state_27643__$1 = state_27643;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27643__$1,inst_27641);
} else {
if((state_val_27644 === (12))){
var inst_27607 = (state_27643[(8)]);
var inst_27631 = cljs.core.vec.call(null,inst_27607);
var state_27643__$1 = state_27643;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27643__$1,(15),out,inst_27631);
} else {
if((state_val_27644 === (2))){
var state_27643__$1 = state_27643;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27643__$1,(4),ch);
} else {
if((state_val_27644 === (11))){
var inst_27623 = (state_27643[(2)]);
var inst_27624 = (new Array(n));
var inst_27607 = inst_27624;
var inst_27608 = (0);
var state_27643__$1 = (function (){var statearr_27655 = state_27643;
(statearr_27655[(7)] = inst_27608);

(statearr_27655[(8)] = inst_27607);

(statearr_27655[(10)] = inst_27623);

return statearr_27655;
})();
var statearr_27656_27680 = state_27643__$1;
(statearr_27656_27680[(2)] = null);

(statearr_27656_27680[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27644 === (9))){
var inst_27607 = (state_27643[(8)]);
var inst_27621 = cljs.core.vec.call(null,inst_27607);
var state_27643__$1 = state_27643;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27643__$1,(11),out,inst_27621);
} else {
if((state_val_27644 === (5))){
var inst_27608 = (state_27643[(7)]);
var inst_27607 = (state_27643[(8)]);
var inst_27616 = (state_27643[(11)]);
var inst_27611 = (state_27643[(9)]);
var inst_27615 = (inst_27607[inst_27608] = inst_27611);
var inst_27616__$1 = (inst_27608 + (1));
var inst_27617 = (inst_27616__$1 < n);
var state_27643__$1 = (function (){var statearr_27657 = state_27643;
(statearr_27657[(11)] = inst_27616__$1);

(statearr_27657[(12)] = inst_27615);

return statearr_27657;
})();
if(cljs.core.truth_(inst_27617)){
var statearr_27658_27681 = state_27643__$1;
(statearr_27658_27681[(1)] = (8));

} else {
var statearr_27659_27682 = state_27643__$1;
(statearr_27659_27682[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27644 === (14))){
var inst_27636 = (state_27643[(2)]);
var inst_27637 = cljs.core.async.close_BANG_.call(null,out);
var state_27643__$1 = (function (){var statearr_27661 = state_27643;
(statearr_27661[(13)] = inst_27636);

return statearr_27661;
})();
var statearr_27662_27683 = state_27643__$1;
(statearr_27662_27683[(2)] = inst_27637);

(statearr_27662_27683[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27644 === (10))){
var inst_27627 = (state_27643[(2)]);
var state_27643__$1 = state_27643;
var statearr_27663_27684 = state_27643__$1;
(statearr_27663_27684[(2)] = inst_27627);

(statearr_27663_27684[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27644 === (8))){
var inst_27607 = (state_27643[(8)]);
var inst_27616 = (state_27643[(11)]);
var tmp27660 = inst_27607;
var inst_27607__$1 = tmp27660;
var inst_27608 = inst_27616;
var state_27643__$1 = (function (){var statearr_27664 = state_27643;
(statearr_27664[(7)] = inst_27608);

(statearr_27664[(8)] = inst_27607__$1);

return statearr_27664;
})();
var statearr_27665_27685 = state_27643__$1;
(statearr_27665_27685[(2)] = null);

(statearr_27665_27685[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto___27671,out))
;
return ((function (switch__25763__auto__,c__25854__auto___27671,out){
return (function() {
var cljs$core$async$state_machine__25764__auto__ = null;
var cljs$core$async$state_machine__25764__auto____0 = (function (){
var statearr_27666 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27666[(0)] = cljs$core$async$state_machine__25764__auto__);

(statearr_27666[(1)] = (1));

return statearr_27666;
});
var cljs$core$async$state_machine__25764__auto____1 = (function (state_27643){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_27643);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e27667){if((e27667 instanceof Object)){
var ex__25767__auto__ = e27667;
var statearr_27668_27686 = state_27643;
(statearr_27668_27686[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27643);

return cljs.core.cst$kw$recur;
} else {
throw e27667;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__27687 = state_27643;
state_27643 = G__27687;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$state_machine__25764__auto__ = function(state_27643){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25764__auto____1.call(this,state_27643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25764__auto____0;
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25764__auto____1;
return cljs$core$async$state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___27671,out))
})();
var state__25856__auto__ = (function (){var statearr_27669 = f__25855__auto__.call(null);
(statearr_27669[(6)] = c__25854__auto___27671);

return statearr_27669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___27671,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__27689 = arguments.length;
switch (G__27689) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25854__auto___27759 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25854__auto___27759,out){
return (function (){
var f__25855__auto__ = (function (){var switch__25763__auto__ = ((function (c__25854__auto___27759,out){
return (function (state_27731){
var state_val_27732 = (state_27731[(1)]);
if((state_val_27732 === (7))){
var inst_27727 = (state_27731[(2)]);
var state_27731__$1 = state_27731;
var statearr_27733_27760 = state_27731__$1;
(statearr_27733_27760[(2)] = inst_27727);

(statearr_27733_27760[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27732 === (1))){
var inst_27690 = [];
var inst_27691 = inst_27690;
var inst_27692 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_27731__$1 = (function (){var statearr_27734 = state_27731;
(statearr_27734[(7)] = inst_27691);

(statearr_27734[(8)] = inst_27692);

return statearr_27734;
})();
var statearr_27735_27761 = state_27731__$1;
(statearr_27735_27761[(2)] = null);

(statearr_27735_27761[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27732 === (4))){
var inst_27695 = (state_27731[(9)]);
var inst_27695__$1 = (state_27731[(2)]);
var inst_27696 = (inst_27695__$1 == null);
var inst_27697 = cljs.core.not.call(null,inst_27696);
var state_27731__$1 = (function (){var statearr_27736 = state_27731;
(statearr_27736[(9)] = inst_27695__$1);

return statearr_27736;
})();
if(inst_27697){
var statearr_27737_27762 = state_27731__$1;
(statearr_27737_27762[(1)] = (5));

} else {
var statearr_27738_27763 = state_27731__$1;
(statearr_27738_27763[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27732 === (15))){
var inst_27721 = (state_27731[(2)]);
var state_27731__$1 = state_27731;
var statearr_27739_27764 = state_27731__$1;
(statearr_27739_27764[(2)] = inst_27721);

(statearr_27739_27764[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27732 === (13))){
var state_27731__$1 = state_27731;
var statearr_27740_27765 = state_27731__$1;
(statearr_27740_27765[(2)] = null);

(statearr_27740_27765[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27732 === (6))){
var inst_27691 = (state_27731[(7)]);
var inst_27716 = inst_27691.length;
var inst_27717 = (inst_27716 > (0));
var state_27731__$1 = state_27731;
if(cljs.core.truth_(inst_27717)){
var statearr_27741_27766 = state_27731__$1;
(statearr_27741_27766[(1)] = (12));

} else {
var statearr_27742_27767 = state_27731__$1;
(statearr_27742_27767[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27732 === (3))){
var inst_27729 = (state_27731[(2)]);
var state_27731__$1 = state_27731;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27731__$1,inst_27729);
} else {
if((state_val_27732 === (12))){
var inst_27691 = (state_27731[(7)]);
var inst_27719 = cljs.core.vec.call(null,inst_27691);
var state_27731__$1 = state_27731;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27731__$1,(15),out,inst_27719);
} else {
if((state_val_27732 === (2))){
var state_27731__$1 = state_27731;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27731__$1,(4),ch);
} else {
if((state_val_27732 === (11))){
var inst_27699 = (state_27731[(10)]);
var inst_27695 = (state_27731[(9)]);
var inst_27709 = (state_27731[(2)]);
var inst_27710 = [];
var inst_27711 = inst_27710.push(inst_27695);
var inst_27691 = inst_27710;
var inst_27692 = inst_27699;
var state_27731__$1 = (function (){var statearr_27743 = state_27731;
(statearr_27743[(7)] = inst_27691);

(statearr_27743[(11)] = inst_27711);

(statearr_27743[(8)] = inst_27692);

(statearr_27743[(12)] = inst_27709);

return statearr_27743;
})();
var statearr_27744_27768 = state_27731__$1;
(statearr_27744_27768[(2)] = null);

(statearr_27744_27768[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27732 === (9))){
var inst_27691 = (state_27731[(7)]);
var inst_27707 = cljs.core.vec.call(null,inst_27691);
var state_27731__$1 = state_27731;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27731__$1,(11),out,inst_27707);
} else {
if((state_val_27732 === (5))){
var inst_27699 = (state_27731[(10)]);
var inst_27692 = (state_27731[(8)]);
var inst_27695 = (state_27731[(9)]);
var inst_27699__$1 = f.call(null,inst_27695);
var inst_27700 = cljs.core._EQ_.call(null,inst_27699__$1,inst_27692);
var inst_27701 = cljs.core.keyword_identical_QMARK_.call(null,inst_27692,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_27702 = ((inst_27700) || (inst_27701));
var state_27731__$1 = (function (){var statearr_27745 = state_27731;
(statearr_27745[(10)] = inst_27699__$1);

return statearr_27745;
})();
if(cljs.core.truth_(inst_27702)){
var statearr_27746_27769 = state_27731__$1;
(statearr_27746_27769[(1)] = (8));

} else {
var statearr_27747_27770 = state_27731__$1;
(statearr_27747_27770[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27732 === (14))){
var inst_27724 = (state_27731[(2)]);
var inst_27725 = cljs.core.async.close_BANG_.call(null,out);
var state_27731__$1 = (function (){var statearr_27749 = state_27731;
(statearr_27749[(13)] = inst_27724);

return statearr_27749;
})();
var statearr_27750_27771 = state_27731__$1;
(statearr_27750_27771[(2)] = inst_27725);

(statearr_27750_27771[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27732 === (10))){
var inst_27714 = (state_27731[(2)]);
var state_27731__$1 = state_27731;
var statearr_27751_27772 = state_27731__$1;
(statearr_27751_27772[(2)] = inst_27714);

(statearr_27751_27772[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27732 === (8))){
var inst_27691 = (state_27731[(7)]);
var inst_27699 = (state_27731[(10)]);
var inst_27695 = (state_27731[(9)]);
var inst_27704 = inst_27691.push(inst_27695);
var tmp27748 = inst_27691;
var inst_27691__$1 = tmp27748;
var inst_27692 = inst_27699;
var state_27731__$1 = (function (){var statearr_27752 = state_27731;
(statearr_27752[(7)] = inst_27691__$1);

(statearr_27752[(8)] = inst_27692);

(statearr_27752[(14)] = inst_27704);

return statearr_27752;
})();
var statearr_27753_27773 = state_27731__$1;
(statearr_27753_27773[(2)] = null);

(statearr_27753_27773[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25854__auto___27759,out))
;
return ((function (switch__25763__auto__,c__25854__auto___27759,out){
return (function() {
var cljs$core$async$state_machine__25764__auto__ = null;
var cljs$core$async$state_machine__25764__auto____0 = (function (){
var statearr_27754 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27754[(0)] = cljs$core$async$state_machine__25764__auto__);

(statearr_27754[(1)] = (1));

return statearr_27754;
});
var cljs$core$async$state_machine__25764__auto____1 = (function (state_27731){
while(true){
var ret_value__25765__auto__ = (function (){try{while(true){
var result__25766__auto__ = switch__25763__auto__.call(null,state_27731);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25766__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25766__auto__;
}
break;
}
}catch (e27755){if((e27755 instanceof Object)){
var ex__25767__auto__ = e27755;
var statearr_27756_27774 = state_27731;
(statearr_27756_27774[(5)] = ex__25767__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27731);

return cljs.core.cst$kw$recur;
} else {
throw e27755;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25765__auto__,cljs.core.cst$kw$recur)){
var G__27775 = state_27731;
state_27731 = G__27775;
continue;
} else {
return ret_value__25765__auto__;
}
break;
}
});
cljs$core$async$state_machine__25764__auto__ = function(state_27731){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25764__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25764__auto____1.call(this,state_27731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25764__auto____0;
cljs$core$async$state_machine__25764__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25764__auto____1;
return cljs$core$async$state_machine__25764__auto__;
})()
;})(switch__25763__auto__,c__25854__auto___27759,out))
})();
var state__25856__auto__ = (function (){var statearr_27757 = f__25855__auto__.call(null);
(statearr_27757[(6)] = c__25854__auto___27759);

return statearr_27757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25856__auto__);
});})(c__25854__auto___27759,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1535482702006
