(ns ^{:doc "Function "}
    kolko.helpers.config
  (:require [clojure.spec.alpha :as s]
            [clojure.string :as str]
            [clojure.test :refer [function?]]
            [clojure.core :refer [ex-info]]))

(s/def ::var-name string?)
(s/def ::read-fn function?)

(s/def ::var-struct (s/keys :req [::var-name ::read-fn]))
(s/def ::var-map (s/map-of keyword? ::var-struct))

(s/fdef read-var
  :args (s/cat :var-struct ::var-struct))
(defn- read-var [{:keys [::var-name ::read-fn]}]
  (if-let [result (System/getenv var-name)]
    (read-fn result)
    (throw (ex-info (str "Environment var not set: " var-name) {:env-var var-name}))))

(s/fdef load-env-vars
  :arg (s/cat :var-list ::var-map))
(defn load-env-vars
  "loads environment variables from a map. Map structure is defined as ::var-map spec."
  [var-map]
  (->> (for [[k v] var-map] [k (read-var v)])
       (into {})))
