(ns {{ns-name}}.components.common
  (:require [cljsjs.material-ui]
    
    [reagent.session :as session]
    [cljs-react-material-ui.core :refer [get-mui-theme color]]
    [cljs-react-material-ui.reagent :as ui]
    
    [cljs-react-material-ui.icons :as ic]
    [reagent.core :as r]
    [framework.api :as api]
    [framework.storage :as store]))



(defn logout
  []
  (session/put! :sidebar-drawer false)
  (store/remove! :token)
  (session/put! :token nil))

(defn change-current-page
  [to & drawer-close]
  (session/put! :display-current-page to)
  (if (first drawer-close)
    (session/put! :sidebar-drawer false)))

(defn sidebar-drawer
  []
  [ui/drawer
       {:open (session/get :sidebar-drawer false)}
       [ui/menu-item
        {:on-touch-tap #(change-current-page :home-page true)}
         "Home"]
       [ui/menu-item
        {:on-touch-tap #(session/put! :sidebar-drawer false)}
         "Close"]
       [ui/menu-item
        {:on-touch-tap #(logout)}
         "Logout"]])


(defn app-header
  []
  [ui/app-bar {:title  (str "Welcome to {{ns-name}} " (session/get :user-email ""))
                   :show-menu-icon-button true
                   :on-left-icon-button-touch-tap #(session/put! :sidebar-drawer true)
                   :on-title-touch-tap #(show-intro-box)}
   [:div 
    [:h1 "Hello"]
    [:p "You are always welcomed!"]]])
