(ns framework.helper
  )

(defn refit [x]
  (try (let [_ (deref x)] x) 
    (catch js/Error e 
      (atom x))))

(defn change-in [an-atom where value]
  (swap! an-atom update-in
         where
         (fn [a b]
           b)
         value))

(defn multi-change-in 
  "changes "
  [in-a-map know-how]
  (reduce (fn [current-value [where value]]
            (update-in current-value where
                       (fn [a b] b) value))
          in-a-map
          know-how))
(defn classpend [classs to & position]
  (update-in to [1 :class] (fn [current-class]
                          (if (nil? (first position))
                            (str current-class " " classs)
                            (str classs " " current-class )))))

(defn stylepend [style to]
  (update-in to [1 :style] (fn [current-style ]
                          (merge current-style style))))

(defn wrap-in-div [& content]
  (into [:div {:class ""}]
          content))

