(defproject {{ns-name}} "0.1.0"
  :description "FIXME: write description"
  :url "http://example.com/FIXME"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}

  :dependencies [[org.clojure/clojure "1.8.0"]
                 [ring-server "0.4.0"]
                 [reagent "0.6.0"]
                 [reagent-utils "0.2.0"]
                 [ring "1.5.0"]
                 [ring/ring-defaults "0.2.1"]
                 [compojure "1.5.1"]
                 [hiccup "1.0.5"]
                 [yogthos/config "0.8"]
                 [org.clojure/clojurescript "1.9.293"
                  :scope "provided"]
                 [secretary "1.2.3"]
                 [venantius/accountant "0.1.7"
                  :exclusions [org.clojure/tools.reader]]
                 [cljs-uuid "0.0.4"]
                 [cljs-ajax "0.5.3"]
                 
                 [org.clojure/math.combinatorics "0.1.3"]
                 
                 [clj-btc "0.11.2"]
                 
                 [org.clojure/data.json "0.2.6"]
                 [org.clojure/data.xml "0.0.8"]
                 ;;whenever http-kit client isn't the fastest way
                 [clj-http "2.2.0"]
                 [crypto-password "0.2.0"] 
                 [digest "1.4.4"]
                 [clj-time "0.12.0"]
                 
                 [org.clojars.kokos/clj-sockets "0.1.1"]
                 [com.brweber2/clj-dns "0.0.2"]
                 [org.clojure/data.csv "0.1.3"]
                 [mvxcvi/clj-pgp "0.8.3"]
                 [com.cemerick/piggieback "0.2.1"]
                  [org.clojure/tools.nrepl "0.2.10"]
                
                [org.clojure/tools.logging "0.2.4"]
                 [org.slf4j/slf4j-log4j12 "1.7.1"]
                 [log4j/log4j "1.2.17" :exclusions [javax.mail/mail
                                                    javax.jms/jms
                                                    com.sun.jmdk/jmxtools
                                                    com.sun.jmx/jmxri]]
                 ;; trying aleph .. again
                 [aleph "0.4.2-alpha8"]
                 [gloss "0.2.5"]
                 
                 [com.draines/postal "2.0.2"]
                 [thi.ng/crypto "0.1.0-SNAPSHOT"]
                 [cljs-react-material-ui "0.2.30"]
                  [reagent "0.6.0-alpha" :exclusions [org.clojure/tools.reader cljsjs/react]]
                  
                  [ring/ring-core "1.5.0"]
                  [slingshot "0.12.2"]]

  :plugins [[lein-environ "1.0.2"]
            [lein-cljsbuild "1.1.1"]
            [lein-asset-minifier "0.2.7"
             :exclusions [org.clojure/clojure]]]
:template-additions [".gitignore" "README.md"
                      "system.properties" "Procfile" ".lein-env"
                      "configuration/elastic.json" "configuration/oanda.json" "configuration/bitcoin.json" 
                      "configuration/cryptog.json"
                      "env/dev/cljs/kokos_web/dev.cljs"
                      "env/prod/cljs/kokos_web/prod.cljs"
                      "env/prod/clj/kokos_web/middleware.clj"
                      "src/cljs/framework/data/holder.cljs"
                      "src/cljs/framework/data/network.cljs"
                      "src/cljs/framework/api.cljs"
                      "src/cljs/framework/easy.cljs"
                      "src/cljs/framework/helper.cljs"
                      "src/cljs/framework/storage.cljs"
                      "src/cljs/kokos_web/components/common.cljs"
                      "src/cljs/kokos_web/components/core.cljs"
                      "src/cljs/kokos_web/components/home.cljs"
                      "src/cljs/kokos_web/components/login.cljs"
                      "src/cljs/kokos_web/core.cljs"]
  :ring {:handler {{ns-name}}.handler/app
         :uberwar-name "{{ns-name}}.war"}

  :min-lein-version "2.5.0"

  :uberjar-name "{{ns-name}}.jar"

  :main {{ns-name}}.server

  :clean-targets ^{:protect false}
  [:target-path
   [:cljsbuild :builds :app :compiler :output-dir]
   [:cljsbuild :builds :app :compiler :output-to]]

  :source-paths ["src/clj" "src/cljc" ]
  :resource-paths ["resources" "target/cljsbuild"]

  :minify-assets
  {:assets
   {"resources/public/css/site.min.css" "resources/public/css/site.css"}}

  :cljsbuild
  {:builds {:min
            {:source-paths ["src/cljs" "src/cljc" "env/prod/cljs"]
             :compiler
             {:output-to "target/cljsbuild/public/js/app.js"
              :output-dir "target/uberjar"
              :optimizations :advanced
              :pretty-print  false}}
            :app
            {:source-paths ["src/cljs" "src/cljc" "env/dev/cljs"]
             :compiler
             {:main "{{ns-name}}.dev"
              :asset-path "/js/out"
              :output-to "target/cljsbuild/public/js/app.js"
              :output-dir "target/cljsbuild/public/js/out"
              :source-map true
              :optimizations :none
              :pretty-print  true}}



            }
   }


  :figwheel
  {:http-server-root "public"
   :server-port 3449
   :nrepl-port 7002
   :nrepl-middleware ["cemerick.piggieback/wrap-cljs-repl"
                      ]
   :css-dirs ["resources/public/css"]
   :ring-handler {{ns-name}}.handler/app}



  :profiles {:dev {:repl-options {:init-ns {{ns-name}}.repl
                                  :nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}

                   :dependencies [[ring/ring-mock "0.3.0"]
                                  [ring/ring-devel "1.5.0"]
                                  [prone "1.1.4"]
                                  [figwheel-sidecar "0.5.8"]
                                  [org.clojure/tools.nrepl "0.2.12"]
                                  [com.cemerick/piggieback "0.2.2-SNAPSHOT"]
                                  [pjstadig/humane-test-output "0.8.1"]
                                  ]

                   :source-paths ["env/dev/clj"]
                   :plugins [[lein-figwheel "0.5.8"]
                             ]

                   :injections [(require 'pjstadig.humane-test-output)
                                (pjstadig.humane-test-output/activate!)]

                   :env {:dev true}}

             :uberjar {:hooks [minify-assets.plugin/hooks]
                       :source-paths ["env/prod/clj"]
                       :prep-tasks ["compile" ["cljsbuild" "once" "min"]]
                       :env {:production true}
                       :aot :all
                       :omit-source true}})
