(ns {{ns-name}}.middleware
  (:require [ring.middleware.defaults :refer [site-defaults wrap-defaults]]
            [ring.middleware.defaults :refer [site-defaults wrap-defaults]]
            [prone.middleware :refer [wrap-exceptions]]
            [ring.middleware.reload :refer [wrap-reload]]
            [ring.util.request]))

(defn wrap-middleware [handler]
  (wrap-defaults handler site-defaults))


(defn wrap-body-string [handler]
  (fn [request]
    (let [body-str (ring.util.request/body-string request)]
      (handler (assoc request :body-as-string body-str)))))

(defn wrap-middleware [handler]
  (-> handler
      (wrap-defaults site-defaults)
      (wrap-body-string)
      wrap-exceptions
      wrap-reload))
