(ns framework.storage
  (:refer-clojure :exclude [get]))

(defn put!
  [key val]
  (.setItem (.-localStorage js/window) (name key) val))


(defn get
  [key & default]
  (let [v (.getItem (.-localStorage js/window) (name key))]
    (if-not (nil? v)
      v
      (first default))))

(defn remove!
  [key]
  (.removeItem (.-localStorage js/window) (name key)))