(ns leiningen.new.kokos-web-all
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "kokos-web-all"))

(defn kokos-web-all
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data ["src/clj/api/cryptog.clj" (render "src/clj/api/cryptog.clj" data)]
["env/prod/cljs/{{sanitized}}/prod.cljs" (render "env/prod/cljs/kokos_web/prod.cljs" data)]
["src/clj/connector/elastic.clj" (render "src/clj/connector/elastic.clj" data)]
["src/cljs/framework/data/holder.cljs" (render "src/cljs/framework/data/holder.cljs" data)]
["project.clj" (render "project.clj" data)]
["env/dev/clj/{{sanitized}}/repl.clj" (render "env/dev/clj/kokos_web/repl.clj" data)]
["src/cljs/framework/data/network.cljs" (render "src/cljs/framework/data/network.cljs" data)]
["src/clj/connector/oanda.clj" (render "src/clj/connector/oanda.clj" data)]
["src/clj/web/authenticate.clj" (render "src/clj/web/authenticate.clj" data)]
["src/clj/{{sanitized}}/server.clj" (render "src/clj/kokos_web/server.clj" data)]
["env/dev/clj/{{sanitized}}/middleware.clj" (render "env/dev/clj/kokos_web/middleware.clj" data)]
["env/dev/cljs/{{sanitized}}/dev.cljs" (render "env/dev/cljs/kokos_web/dev.cljs" data)]
["src/clj/{{sanitized}}/handler.clj" (render "src/clj/kokos_web/handler.clj" data)]
["src/cljs/framework/easy.cljs" (render "src/cljs/framework/easy.cljs" data)]
["src/cljs/{{sanitized}}/components/common.cljs" (render "src/cljs/kokos_web/components/common.cljs" data)]
["src/clj/connector/bitcoin.clj" (render "src/clj/connector/bitcoin.clj" data)]
["src/clj/web/api.clj" (render "src/clj/web/api.clj" data)]
["src/cljs/{{sanitized}}/core.cljs" (render "src/cljs/kokos_web/core.cljs" data)]
["src/clj/connector/cryptog.clj" (render "src/clj/connector/cryptog.clj" data)]
["src/clj/api/token.clj" (render "src/clj/api/token.clj" data)]
["src/cljs/{{sanitized}}/components/home.cljs" (render "src/cljs/kokos_web/components/home.cljs" data)]
["src/clj/api/resource.clj" (render "src/clj/api/resource.clj" data)]
["src/cljs/{{sanitized}}/components/core.cljs" (render "src/cljs/kokos_web/components/core.cljs" data)]
["src/cljs/framework/api.cljs" (render "src/cljs/framework/api.cljs" data)]
["src/cljs/framework/storage.cljs" (render "src/cljs/framework/storage.cljs" data)]
["src/clj/api/uauth.clj" (render "src/clj/api/uauth.clj" data)]
["src/cljs/framework/helper.cljs" (render "src/cljs/framework/helper.cljs" data)]
["src/cljs/{{sanitized}}/components/login.cljs" (render "src/cljs/kokos_web/components/login.cljs" data)]
["configuration/bitcoin.json" (render "configuration/bitcoin.json")]
["Procfile" (render "Procfile")]
["system.properties" (render "system.properties")]
["src/cljc/{{sanitized}}/util.cljc" (render "src/cljc/kokos_web/util.cljc")]
["README.md" (render "README.md")]
[".gitignore" (render ".gitignore")]
["configuration/oanda.json" (render "configuration/oanda.json")]
["configuration/elastic.json" (render "configuration/elastic.json")]
["configuration/cryptog.json" (render "configuration/cryptog.json")]
["resources/public/css/site.css" (render "resources/public/css/site.css")]
[".lein-env" (render ".lein-env")]
)))