(ns api.cryptog
  (:require 
    ;[web.authenticate :refer [load-by-token]]
    [web.authenticate]
    [connector.cryptog :as cg]
    [cryptog.core :as cryptog]
    [clojure.tools.logging :as log])
  (:gen-class))

(defn api []
  :api)

(defn balance 
  [[token shared-mem] data]
  (web.authenticate/with-token 
    token user
    (let [coin (or (:coin data) :btc)]
      (assoc (cg/balance coin (-> user :_source :cgtoken))
        :session-stats
        (get (get @shared-mem :session-stats)
             (-> user :_id))
        :session (get (get @shared-mem :session)
             (-> user :_id))))))

(defn get-session-stats
  [[token shared-mem] data]
  (web.authenticate/with-token
    token user
    {:session-stats
     (get (get @shared-mem :session-stats)
             (-> user :_id))}))

(defn pow [x n]
  (loop [acc 1 n n]
    (if (zero? n) acc
        (recur (* x acc) (dec n)))))

(defn calculate-max-loss-turns
  [[token shared-mem] data]
  (web.authenticate/with-token
    token user
    (let [current-balance (:Balance (cg/balance :BTC (-> user :_source :cgtoken)))
          payout-multiplier (if (string? (:payout-multiplier data))
                              (read-string (:payout-multiplier data))
                              (:payout-multiplier data))
          desired-profit (if (string? (:desired-profit data))
                           (read-string (:desired-profit data))
                           (:desired-profit data))
          balance (if (and
                        (not (nil? (:balance data))) 
                        (string? (:balance data))
                           (not (= "" (:balance data))))
                    (read-string (:balance data))
                    (if (or (not (contains? data :balance))
                            (nil? (:balance data))
                            (= "" (:balance data)))
                      current-balance
                      (:balance data)))
          incremental (if (nil? (:incremental data))
                        1.1
                        (if (string? (:incremental data))
                          (read-string (:incremental data))
                          (:incremental data)))]
      (cryptog/create-incremental-gameplay :balance balance
                                           :multiplier payout-multiplier
                                           :start-from desired-profit
                                           :incremental incremental))))


(defn start-incremental-session
  [[token shared-mem] data]
  (web.authenticate/with-token
    token user
    (let [current-balance (:Balance (cg/balance :BTC (-> user :_source :cgtoken)))
          payout-multiplier (if (string? (:payout-multiplier data))
                              (read-string (:payout-multiplier data))
                              (:payout-multiplier data))
          desired-profit (if (string? (:desired-profit data))
                           (read-string (:desired-profit data))
                           (:desired-profit data))
          balance (if (and
                        (not (nil? (:balance data))) 
                        (string? (:balance data))
                           (not (= "" (:balance data))))
                    (read-string (:balance data))
                    (if (or (not (contains? data :balance))
                            (nil? (:balance data))
                            (= "" (:balance data)))
                      current-balance
                      (:balance data)))
          incremental (if (nil? (:incremental data))
                        1.1
                        (if (string? (:incremental data))
                          (read-string (:incremental data))
                          (:incremental data)))
          can-start? (and (not (= :start (get (:session @shared-mem) (:_id user))))
                          (not (nil? incremental))
                          (not (nil? balance))
                          (not (nil? desired-profit))
                          (not (nil? payout-multiplier)))]
      (if can-start?
              (do
                (future 
        (cryptog/incremental-start shared-mem user
                                   :use-balance balance
                                   :multiplier payout-multiplier
                                   :start-from desired-profit
                                   :incremental incremental))
                {:sessiont "started"})
              {:error "can't start"}))))

(defn start-session
  [[token shared-mem] data]
  (web.authenticate/with-token 
    token user
    (let [game (:game data)
          bet-amount (if-not (nil? (:bet-amount data))
                       (if (string? (:bet-amount data))
                         (read-string (:bet-amount data))
                         (:bet-amount data)))
          chain-length (if-not (nil? (:chain-length data))
                         (if (string? (:chain-length data))
                           (int (read-string (:chain-length data)))
                           (int (:chain-length data))))
          memory (:memory data)
          can-start? (and (not (= :start (get (:session @shared-mem) (:_id user))))
                          (not (nil? game))
                          (not (nil? chain-length))
                          (not (nil? bet-amount)))
          _ (if can-start?
              (cryptog/session-start shared-mem user 
                                     :game game
                                     :init? (= "forget" memory)
                                      :chain-length chain-length
                                      :bet-amount bet-amount))]
      (if can-start?
        {:session "started"}
        (if (or (nil? game)
                (nil? bet-amount)
                (nil? chain-length))
          {:error "Please select your game, chain length and bet amount!"}
          {:error "session in progress"})))))




(defn stop-session
  [[token shared-mem] data]
  (web.authenticate/with-token
    token user
    (let [_ (cryptog/session-stop shared-mem user)]
      {:session "stopped"})))
(defn force-stop-session
  [[token shared-mem] data]
  (web.authenticate/with-token
    token user
    (let [_ (cryptog/session-force-stop shared-mem user)]
      {:session "forced stopped"})))




