(ns omg-deutsch.core
  (:require [clj-http.client :as client])
  (:use [clojure.data.json :only (read-json)]))

(def ^:dynamic *google-key* nil)

(defn translate [source target query]
  (:translatedText
   (first
    (:translations
     (:data
      (read-json
       (:body
        (client/get
         "https://www.googleapis.com/language/translate/v2"
         {:query-params
          {"q" query
           "key" *google-key*
           "source" source
           "target" target}}))))))))
