(defproject kleene_ai/mold-http "0.0.2"
  :description "Mold http"
  :url "https://github.com/Minoro-Ltd/mold-http"
  :license {:name "GPL-3.0"}
  :min-lein-version "2.0.0"

  :dependencies [[org.clojure/clojure "1.10.1" :scope "provided"]
                 [org.clojure/clojurescript "1.10.597" :scope "provided"
                  :exclusions [com.google.javascript/closure-compiler-unshaded
                               org.clojure/google-closure-library
                               org.clojure/google-closure-library-third-party]]
                 [thheller/shadow-cljs "2.8.64" :scope "provided"]
                 [datascript "0.18.7"]
                 [re-posh "0.3.1"]
                 [day8.re-frame/http-fx "0.1.6"]
                 [kleene_ai/mold "0.0.1"]
                 [day8.re-frame/test "0.1.5"]
                 [binaryage/devtools "0.9.10"]]

  :source-paths ["src"]
  :test-paths ["test"]
  :clean-targets [:target-path "compiled"]

  :plugins [[lein-shadow "0.1.7"]
            [lein-shell "0.5.0"]
            [lein-ancient "0.6.15"]]

  :shell {:commands {"open" {:windows ["cmd" "/c" "start"]
                             :macosx  "open"
                             :linux   "xdg-open"}}}

  :shadow-cljs {:nrepl  {:port 8777}
                :builds {:browser-test
                         {:target           :browser-test
                          :test-dir         "compiled/test/browser"
                          :compiler-options {:pretty-print    true
                                             :external-config {:devtools/config {:features-to-install [:formatters :hints]}}}
                          :devtools         {:http-port 3449
                                             :http-root "compiled/test/browser"
                                             :preloads  [devtools.preload]}}

                         :karma-test
                         {:target           :karma
                          :output-to        "compiled/test/karma/test.js"
                          :compiler-options {:pretty-print true}}}}

  :aliases {"test-once"  ["do" "clean," "shadow" "compile" "browser-test," "shell" "open" "compiled/test/browser/index.html"]
            "test-auto"  ["do" "clean," "shadow" "watch" "browser-test"]
            "karma-once" ["do"
                          ["clean"]
                          ["shadow" "compile" "karma-test"]
                          ["shell" "karma" "start" "--single-run" "--reporters" "junit,dots"]]
            "karma-auto" ["do" "clean," "shadow" "watch" "karma-test"]}

  :deploy-repositories [["clojars" {:sign-releases false
                                    :url           "https://clojars.org/repo"
                                    :username      :env/CLOJARS_USERNAME
                                    :password      :env/CLOJARS_PASSWORD}]]

  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "--no-sign"]
                  ["deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]])

