;
; Copyright (c) 2017. qlaro, Inc.
;
; Proprietary and Confidential
;
; Unauthorized copying of this project or any files within this project, via any
; medium, is strictly prohibited
;

(ns dev
  (:require [com.stuartsierra.component :as component]
            [clojure.tools.namespace.repl :refer [refresh]]

            [h2e.system :as sys]))

(defn system
  []
  sys/dev-system)

(defn semantic-db
  []
  (:semantic-db (system)))

(defn datomic
  []
  (:datomic (semantic-db)))

(defn conn
  []
  (:connection (datomic)))

(defn db
  []
  (d/db (conn)))

(defn init
  []
  (alter-var-root #'sys/dev-system (constantly (sys/get-system :dev))))

(defn start
  []
  (alter-var-root #'sys/dev-system component/start))

(defn stop
  []
  (alter-var-root #'sys/dev-system component/stop))

(defn go
  []
  (init)
  (start)
  :ready)

(defn reset
  []
  (stop)
  (refresh :after 'user/go))