;
; Copyright (c) 2017. qlaro, Inc.
;
; Proprietary and Confidential
;
; Unauthorized copying of this project or any files within this project, via any
; medium, is strictly prohibited
;

(defproject klarahealth/h2e "0.1.0-SNAPSHOT"
  :description "Healthcare Harmonization Engine: Combination of Semantic Graph
  DB and Ontology/Knowledge Management System"

  :url "https://bitbucket.org/klarahealth/h2e"

  :license {:name "Copyright 2016, klaraHealth, Inc."
            :url  "https://www.klarahealth.com"}

  :dependencies [[org.clojure/clojure "1.9.0"]

                 ; advanced pattern matching
                 [org.clojure/core.match "0.3.0-alpha4" :exclusions [org.clojure/tools.analyzer.jvm]]

                 ; for 'reloaded' workflow
                 [org.clojure/tools.namespace "0.2.11"]

                 ; several others need this
                 [org.clojure/tools.reader "1.0.0-beta4"]

                 ; cassandra CQL3 client wrapping datastax java driver
                 [cc.qbits/alia-all "3.3.0" :exclusions [org.clojure/tools.reader]]

                 ; simplifies working with URI's
                 [clojurewerkz/urly "1.0.0" :exclusions [com.google.guava/guava]]

                 ; this is the latest available version using Pro Starter License
                 ; and doesn't include HA or memcache functionality until we
                 ; buy a new license
                 ; datomic peer library
                 [com.datomic/datomic-pro "0.9.5544" :exclusions [commons-codec
                                                                  org.slf4j/slf4j-api]]

                 ; manages retries
                 [com.grammarly/perseverance "0.1.2"]

                 ; logging API
                 [com.taoensso/timbre "4.8.0" :exclusions [org.clojure/tools.reader]]

                 ; needed by Datomic, conformity
                 [commons-codec "1.9"]

                 ; idempotent schema migrations for Datomic
                 [io.rkn/conformity "0.4.0"]

                 ; for easier management of vars across namespaces
                 [potemkin "0.4.3"]

                 ; won't be integrating TitanDB for a while and per the Google group,
                 ; the project is currently being forked into a Linux Foundation
                 ; project so will likely have a different name (as of Dec 2016)
                 ;; titan db core libs
                 ;[com.thinkaurelius.titan/titan-core "1.1.0-SNAPSHOT"]
                 ;;[com.thinkaurelius.titan/titan-core "1.1.0-SNAPSHOT" :exclusions [com.codahale.metrics/metrics-core
                 ;;                                                                  com.fasterxml.jackson.core/jackson-core
                 ;;                                                                  commons-io
                 ;;                                                                  org.javassist/javassist
                 ;;                                                                  org.slf4j/slf4j-log4j12]]
                 ;
                 ;; berkeleyje makes it easier for testing high-level functionality
                 ;; without needing a cassandra instance
                 ;[com.thinkaurelius.titan/titan-berkeleyje "1.1.0-SNAPSHOT"]
                 ;
                 ;; cassandra is our "real" underlying datastore
                 ;[com.thinkaurelius.titan/titan-cassandra "1.1.0-SNAPSHOT"]
                 ;;[com.thinkaurelius.titan/titan-cassandra "1.1.0-SNAPSHOT" :exclusions [ch.qos.logback/logback-classic
                 ;;                                                                       ch.qos.logback/logback-core
                 ;;                                                                       ; conflicts with io.dropwizard.metrics/metrics-core
                 ;;                                                                       ; since the groupId changed - may cause major RuntimeException
                 ;;                                                                       ; if there were other breaking changes
                 ;;                                                                       com.codahale.metrics/metrics-core
                 ;;                                                                       com.eaio.uuid/uuid
                 ;;                                                                       commons-lang]]
                 ;
                 ;; FIXME - consider this as a separate tool altogether - shared over all datastores
                 ;; provides full-text indexing within Titan
                 ;[com.thinkaurelius.titan/titan-lucene "1.1.0-SNAPSHOT"]

                 ]

  :repl-options {:init-ns user}

  :profiles {:dev {; enables markdown in clojure docstrings
                   :codox        {:metadata {:doc/format :markdown}}

                   :dependencies [
                                  ; management of stateful objects (e.g., DB connections)
                                  [com.stuartsierra/component "0.3.2"]

                                  ; provides debugging visualization of data structures
                                  [walmartlabs/datascope "0.1.1"]]
                   :plugins      [; autorun clojure.test
                                  [com.jakemccrary/lein-test-refresh "0.18.1"]
                                  ; autogeneration of HTML-based docs from docstrings
                                  [lein-codox "0.10.1"]
                                  ; autorunning of expectations
                                  [lein-autoexpect "1.9.0"]
                                  ; running expectation from lein
                                  ;[lein-expectations "0.0.8"]
                                  ; colorize REPL and better clojure.test msgs
                                  [venantius/ultra "0.5.0"]
                                  ]}}

  :repositories {"myget"          {:url      "https://www.myget.org/F/qlaro/maven"
                                   :username :env/MYGET_USERNAME
                                   :password :env/MYGET_PASSWORD}
                 "my.datomic.com" {:url      "https://my.datomic.com/repo"
                                   :username :env/DATOMIC_USERNAME
                                   :password :env/DATOMIC_PASSWORD}}
  )
