package kixipipe.ioplus;

import java.io.InputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class CharacterFilterInputStream extends FilterInputStream {

    private char[] toFilter;

    public CharacterFilterInputStream(InputStream in, char[] toFilter) {
        super(in);
        this.toFilter = toFilter;
    }

    protected boolean filtered(int c) {
        for(char f : toFilter) {
            if (f == c) { return true; }
        }
        return false;
    }

    @Override
    public int read() throws IOException {
        int b;
        do {
            b = super.read();
        } while(filtered(b));
        return b;
    }


    // No need to override this, since the super class specifies that
    // it delegates to read(b,0,b.length)
    // See https://docs.oracle.com/javase/7/docs/api/java/io/FilterInputStream.html#read(byte[])
    //
    // @Override
    // public int read(byte[] b) throws IOException;


    @Override
    public int read(byte[] b, int off, int len) throws IOException{
        int read = super.read(b, off, len);

        if (read == -1) {
            return -1;
        }

        int pos = off - 1;
        for (int readPos = off; readPos < off + read; readPos++) {
            if (filtered(b[readPos])) {
                continue;
            } else {
                pos++;
            }

            if (pos < readPos) {
                b[pos] = b[readPos];
            }
        }
        return pos - off + 1;
    }

}
