(def slf4j-version "1.7.5")
(defproject kixi/pipe "0.17.4"
  :description "Provides the building blocks for Kixi's pipeline abstraction"
  :url "https://github.com/MastodonC/kixi.pipe"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure        "1.5.1"]
                 [org.clojure/core.match     "0.2.1"]
                 [org.clojure/data.csv       "0.1.2"]
                 [org.clojure/tools.macro    "0.1.5"]
                 [clj-aws-s3                 "0.3.9"]
                 [clj-ssh                    "0.5.10"]
                 [clj-time                   "0.7.0"]
                 [org.clojure/tools.cli      "0.3.1"]
                 [clojurewerkz/quartzite     "1.2.0"]
                 [pipejine                   "0.1.3" :exclusions [org.slf4j/slf4j-simple]]
                 [cheshire                   "5.3.1"]
                 [org.clojure/java.jdbc      "0.3.3"]
                 [kixi/postgresql  "8.4-703.jdbc4"]; required version for redshift
                 [org.clojure/core.async     "0.1.222.0-83d0c2-alpha"]
                 [prismatic/schema           "0.2.3"]
                 [com.stuartsierra/component "0.2.1"]
                 [potemkin                   "0.3.4"]
                 [com.velisco/clj-ftp        "0.3.0"]

                 ;; Logging
                 [org.clojure/tools.logging  "0.3.0"]
                 [org.slf4j/slf4j-api        "1.7.7"]

                 ;; REPL
                 [org.clojure/tools.nrepl    "0.2.3"]
                 [clojure-complete           "0.2.3"]
                 ]
     :plugins [ [lein-tar "2.0.0"]
               [s3-wagon-private "1.1.2"] ]
     :repositories [["releases" {:url "https://clojars.org/repo" :username :env/clojars_username :password :env/clojars_password}]
                    ["snapshots" {:url "s3p://mc-maven-repo/snapshots" :username :env/mc_aws_username :passphrase :env/mc_aws_passphrase}]]
     :profiles {:dev {:dependencies [[org.apache.sshd/sshd-core  "0.11.0"]
                                     [org.apache.ftpserver/ftpserver-core "1.0.6"]
                                     [org.clojure/tools.logging      "0.3.0"]
                                     [ch.qos.logback/logback-classic "1.1.2"]
                                     [org.slf4j/jul-to-slf4j         "1.7.7"]
                                     [org.slf4j/jcl-over-slf4j       "1.7.7"]
                                     [org.slf4j/log4j-over-slf4j     "1.7.7"]
                                     ]}}
     )
