(def slf4j-version "1.7.10")
(def cider-nrepl-version "0.9.1")
(def fasterxml-jackson-version "2.5.3" )
(defproject kixi/pipe "0.17.24"
  :description "Provides the building blocks for Kixi's pipeline abstraction"
  :url "https://github.com/MastodonC/kixi.pipe"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [
                 [com.fasterxml.jackson.core/jackson-databind ~fasterxml-jackson-version] 
                 [com.fasterxml.jackson.core/jackson-core ~fasterxml-jackson-version]
                 [com.fasterxml.jackson.core/jackson-annotations ~fasterxml-jackson-version]

                 [org.clojure/clojure        "1.7.0"]
                 [org.clojure/core.match     "0.2.2"]
                 [org.clojure/data.csv       "0.1.2"]
                 [org.clojure/tools.macro    "0.1.5"]
                 [clj-ssh                    "0.5.11"]
                 [clj-time                   "0.9.0"]
                 [com.amazonaws/aws-java-sdk-s3 "1.10.27" :exclusions [joda-time]]
                 [clj-aws-s3                 "0.3.10" :exclusions [joda-time com.amazonaws/aws-java-sdk]]
                 [org.clojure/tools.cli      "0.3.1"]
                 [clojurewerkz/quartzite     "1.3.0"]
                 [pipejine                   "0.1.3" :exclusions [org.slf4j/slf4j-simple]]
                 [cheshire                   "5.4.0"]
                 [org.clojure/java.jdbc      "0.3.6"]
                 [kixi/postgresql            "8.4-703.jdbc4"]; required version for redshift
                 [org.clojure/core.async     "0.1.346.0-17112a-alpha"]
                 [prismatic/schema           "0.3.7"]
                 [com.stuartsierra/component "0.2.2"]
                 [potemkin                   "0.3.11"]
                 [com.velisco/clj-ftp        "0.3.3"]
                 [com.novemberain/pantomime  "2.4.0"]

                 ;; Logging
                 [org.clojure/tools.logging  "0.3.1"]
                 [org.slf4j/slf4j-api        ~slf4j-version]

                 [clojure-complete           "0.2.4"]]
     :exclusions [com.fasterxml.jackson.core/jackson-core com.fasterxml.jackson.core/jackson-databind com.fasterxml.jackson.core/jackson-annotations] 
     :plugins [ [lein-tar "3.3.0"]
                [s3-wagon-private "1.1.2"] ]
     ;; You need to arrange for the environment variables:
     ;;   CLOJARS_USERNAME to be your clojars username
     ;;   CLOJARS_PASSWORD to be your clojars password.
     ;; there is a sample.lein-credentials file which you can fill in and
     ;; source from your shell

     :repositories [["releases" {:url "https://clojars.org/repo" :username :env/clojars_username :password :env/clojars_password}]
                    ["snapshots" {:url "s3p://mc-maven-repo/snapshots" :username :env/mc_aws_username :passphrase :env/mc_aws_passphrase}]]
     :profiles {:dev {:dependencies [[org.apache.sshd/sshd-core  "0.13.0"]
                                     [org.apache.ftpserver/ftpserver-core "1.0.6"]
                                     [org.clojure/tools.logging      "0.3.1"]
                                     [ch.qos.logback/logback-classic "1.1.2"]
                                     [org.slf4j/jul-to-slf4j         ~slf4j-version]
                                     [org.slf4j/jcl-over-slf4j       ~slf4j-version]
                                     [org.slf4j/log4j-over-slf4j     ~slf4j-version]
                                     ]}}
     )
