(ns kixipipe.storage.s3.report
  "reports on what's happenning in s3"
  (:require [kixipipe.storage    :as storage]
            [kixipipe.storage.s3 :as s3]
            [clojure.string      :as str]
            [clojure.data.csv    :as csv]
            [clojure.java.io     :as io]))


(defn get-object-as-tsv [session o]
  (with-open [in (io/reader (s3/get-object-by-metadata session o))]
    (doall (csv/read-csv in :separator \tab))))

(defn details-by-feed [session src-name feed-name]
  (let [objs (s3/list-objects-seq session {:prefix (str src-name \/ feed-name "-report" )})]
    (mapcat (partial get-object-as-tsv session) objs)))
