(ns kixipipe.application
  "Holder for an application instance."
  (:require [clojure.tools.logging  :as log]))

;; holder for a single instance of the application.
;; We create this here to allow reference from a cider(emacs) repl or a repl
;; started from a main method.
;;
;; See https://github.com/stuartsierra/component
(def system)

;; See http://stuartsierra.com/2015/05/27/clojure-uncaught-exceptions
(defn install-default-exception-handler []
  (Thread/setDefaultUncaughtExceptionHandler
   (reify Thread$UncaughtExceptionHandler
     (uncaughtException [_ thread ex]
       (log/error ex "Uncaught exception on " (.getName thread))))))
